/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.Tree;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;

public class EdgeTree {
    private Tree nodeTree;
    private EdgeSet contain;

    public EdgeTree(EdgeSet edgeSet) {
        this.contain = edgeSet;
    }

    private void init(EdgeSet edgeSet) {
        this.nodeTree = new Tree(edgeSet);
        this.nodeTree.setLevels();
    }

    private int findCommonAncestor(int n, int n2) {
        int n3;
        if (n == n2) {
            return this.nodeTree.getParent(n);
        }
        Tree.Entry entry = this.nodeTree.getEntry(n);
        Tree.Entry entry2 = this.nodeTree.getEntry(n2);
        int n4 = n;
        int n5 = n2;
        int n6 = entry.level;
        int n7 = entry2.level;
        int n8 = 0;
        if (n6 > n7) {
            n8 = n6 - n7;
            for (n3 = 0; n3 < n8; ++n3) {
                n4 = this.nodeTree.getParent(n4);
            }
        } else if (n6 < n7) {
            n8 = n7 - n6;
            for (n3 = 0; n3 < n8; ++n3) {
                n5 = this.nodeTree.getParent(n5);
            }
        }
        while (n4 > -1 || n5 > -1) {
            if (n4 == n5) {
                return n4;
            }
            n4 = this.nodeTree.getParent(n4);
            n5 = this.nodeTree.getParent(n5);
        }
        return -1;
    }

    private int computeDistance(int n, int n2) {
        int n3;
        if (n == n2) {
            return 0;
        }
        Tree.Entry entry = this.nodeTree.getEntry(n);
        Tree.Entry entry2 = this.nodeTree.getEntry(n2);
        int n4 = n;
        int n5 = n2;
        int n6 = entry.level;
        int n7 = entry2.level;
        int n8 = 0;
        if (n6 > n7) {
            n8 = n6 - n7;
            for (n3 = 0; n3 < n8; ++n3) {
                n4 = this.nodeTree.getParent(n4);
            }
        } else if (n6 < n7) {
            n8 = n7 - n6;
            for (n3 = 0; n3 < n8; ++n3) {
                n5 = this.nodeTree.getParent(n5);
            }
        }
        n3 = n8;
        while ((n4 > -1 || n5 > -1) && n4 != n5) {
            n4 = this.nodeTree.getParent(n4);
            n5 = this.nodeTree.getParent(n5);
            n3 += 2;
        }
        return n3;
    }

    public EdgeSet getEdgeTree(EdgeSet edgeSet) {
        int n;
        boolean bl;
        NodeSet nodeSet = AlgebraOperation.domainOf(this.contain);
        NodeSet nodeSet2 = AlgebraOperation.rangeOf(this.contain);
        NodeSet nodeSet3 = AlgebraOperation.entityOf(this.contain);
        NodeSet nodeSet4 = AlgebraOperation.difference(nodeSet, nodeSet2);
        if (nodeSet4.size() == 0) {
            return new EdgeSet();
        }
        EdgeSet edgeSet2 = AlgebraOperation.composition(nodeSet3, edgeSet);
        edgeSet2 = AlgebraOperation.composition(edgeSet2, nodeSet3);
        EdgeSet edgeSet3 = this.contain;
        if (nodeSet4.size() > 1) {
            bl = true;
            n = IDManager.getID(0, 0, 0);
            edgeSet3 = AlgebraOperation.crossProduct(NodeSet.singleton(n), nodeSet4);
            edgeSet3 = AlgebraOperation.union(this.contain, edgeSet3);
        } else {
            bl = false;
            n = nodeSet4.getTupleList().get(0).getDom();
        }
        this.init(edgeSet3);
        TupleList tupleList = edgeSet2.data;
        EdgeSet edgeSet4 = new EdgeSet();
        for (int i = 0; i < tupleList.size(); ++i) {
            Tuple tuple = tupleList.get(i);
            int n2 = IDManager.getID(tuple.getDom(), tuple.getRng());
            int n3 = this.findCommonAncestor(tuple.getDom(), tuple.getRng());
            if (bl && n3 == n || n3 <= -1) continue;
            edgeSet4.add(n3, n2);
            n2 = n3;
            while (n2 != n && (n3 = this.nodeTree.getParent(n2)) > -1) {
                edgeSet4.add(n3, n2);
                n2 = n3;
            }
        }
        edgeSet4.removeDuplicates();
        return edgeSet4;
    }

    public EdgeSet getEdgeDistance(EdgeSet edgeSet) {
        NodeSet nodeSet = AlgebraOperation.domainOf(this.contain);
        NodeSet nodeSet2 = AlgebraOperation.rangeOf(this.contain);
        NodeSet nodeSet3 = AlgebraOperation.entityOf(this.contain);
        NodeSet nodeSet4 = AlgebraOperation.difference(nodeSet, nodeSet2);
        if (nodeSet4.size() == 0) {
            return new EdgeSet();
        }
        EdgeSet edgeSet2 = AlgebraOperation.composition(nodeSet3, edgeSet);
        edgeSet2 = AlgebraOperation.composition(edgeSet2, nodeSet3);
        EdgeSet edgeSet3 = this.contain;
        if (nodeSet4.size() > 1) {
            int n = IDManager.getID(0, 0, 0);
            edgeSet3 = AlgebraOperation.crossProduct(NodeSet.singleton(n), nodeSet4);
            edgeSet3 = AlgebraOperation.union(this.contain, edgeSet3);
        }
        this.init(edgeSet3);
        TupleList tupleList = edgeSet2.data;
        EdgeSet edgeSet4 = new EdgeSet();
        for (int i = 0; i < tupleList.size(); ++i) {
            Tuple tuple = tupleList.get(i);
            int n = IDManager.getID(tuple.getDom(), tuple.getRng());
            int n2 = this.computeDistance(tuple.getDom(), tuple.getRng());
            edgeSet4.add(n, IDManager.getID(n2 + ""));
        }
        edgeSet4.removeDuplicates();
        return edgeSet4;
    }
}

