/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.Edge;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Edge;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleListFactory;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class EdgeSet
extends TupleSet {
    public EdgeSet() {
        this.data = TupleListFactory.newEdgeList();
    }

    public EdgeSet(String string) {
        super(string);
        this.data = TupleListFactory.newEdgeList();
    }

    public EdgeSet(int n) {
        this.data = TupleListFactory.newEdgeList(n);
    }

    public void add(String string, String string2) {
        int n = IDManager.getID(string);
        int n2 = IDManager.getID(string2);
        this.data.add(new Tuple4Edge(n, n2));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public void add(int n, int n2) {
        this.data.add(new Tuple4Edge(n, n2));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public int getAttributeID(int n) {
        this.trySort(0);
        int n2 = BinarySearch.search(this.data, n, 0);
        if (n2 < 0) {
            return -1;
        }
        return this.data.get(n2).getRng();
    }

    public String getAttribute(int n) {
        this.trySort(0);
        int n2 = BinarySearch.search(this.data, n, 0);
        if (n2 < 0) {
            return null;
        }
        return IDManager.get(this.data.get(n2).getRng());
    }

    public Edge[] getAllEdges() {
        int n = this.data.size();
        Edge[] edgeArray = new Edge[n];
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            edgeArray[i] = new Edge(tuple.getDom(), tuple.getRng());
        }
        return edgeArray;
    }

    public TupleSet newSet() {
        return new EdgeSet();
    }

    public void printTA(OutputStream outputStream) {
        String string = this.getName();
        if (string.charAt(0) != '@') {
            super.printTA(outputStream);
            return;
        }
        string = string.substring(1);
        StringBuffer stringBuffer = new StringBuffer();
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n = this.data.size();
        int n2 = string.length();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(IDManager.get(tuple.getDom()));
            stringBuffer.append(' ');
            stringBuffer.append("{ ");
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(IDManager.get(tuple.getRng()));
            stringBuffer.append(" }");
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
    }

    public void appendTA(String string) throws IOException {
        String string2 = this.getName();
        if (string2.charAt(0) != '@') {
            super.appendTA(string);
            return;
        }
        string2 = string2.substring(1);
        StringBuffer stringBuffer = new StringBuffer(string2);
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
        randomAccessFile.seek(randomAccessFile.length());
        int n = this.data.size();
        int n2 = string2.length();
        if (n > 0) {
            randomAccessFile.writeBytes("FACT ATTRIBUTE :\n");
        }
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(IDManager.get(tuple.getDom()));
            stringBuffer.append(' ');
            stringBuffer.append("{ ");
            stringBuffer.append(string2);
            stringBuffer.append(" = ");
            stringBuffer.append(IDManager.get(tuple.getRng()));
            stringBuffer.append(" }");
            randomAccessFile.writeBytes(stringBuffer + "\n");
        }
        randomAccessFile.close();
    }

    public void printRSF(OutputStream outputStream) {
        super.printTA(outputStream);
    }

    public void appendRSF(String string) throws IOException {
        super.appendTA(string);
    }

    protected void sort() {
        this.trySort(2);
    }

    protected void sortDom() {
        this.trySort(0);
    }

    protected void sortRng() {
        this.trySort(1);
    }

    protected void trySort(int n) {
        int n2 = 0;
        int n3 = 1;
        switch (n) {
            case 0: {
                if (this.sortLevel < 0) {
                    TupleList tupleList = TupleListFactory.newEdgeList(this.data.size());
                    RadixSorter.sort(this.data, n2, tupleList);
                    this.data.setList(tupleList.getList());
                    this.sortLevel = 0;
                    break;
                }
                if (this.sortLevel != 1) break;
                TupleList tupleList = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, n2, tupleList);
                this.data.setList(tupleList.getList());
                this.sortLevel = 2;
                break;
            }
            case 1: {
                if (this.sortLevel == 1) break;
                TupleList tupleList = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, n3, tupleList);
                this.data.setList(tupleList.getList());
                this.sortLevel = 1;
                break;
            }
            case 2: {
                if (this.sortLevel == 1) {
                    TupleList tupleList = TupleListFactory.newEdgeList(this.data.size());
                    RadixSorter.sort(this.data, n2, tupleList);
                    this.data.setList(tupleList.getList());
                    this.sortLevel = 2;
                    break;
                }
                if (this.sortLevel >= 1) break;
                TupleList tupleList = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, n3, tupleList);
                TupleList tupleList2 = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(tupleList, n2, tupleList2);
                this.data.setList(tupleList2.getList());
                this.sortLevel = 2;
                break;
            }
            default: {
                if (n < 0) {
                    this.trySort(0);
                }
                if (n <= 2) break;
                this.trySort(2);
            }
        }
    }

    protected TupleList shadow() {
        TupleList tupleList;
        if (this.sortLevel < 0) {
            this.trySort(1);
            tupleList = new TupleList(this.size());
            tupleList.getList().addAll(this.data.getList());
        } else if (this.sortLevel == 1) {
            tupleList = new TupleList(this.size());
            tupleList.getList().addAll(this.data.getList());
        } else {
            tupleList = new TupleList(this.size());
            RadixSorter.sort(this.data, 1, tupleList);
        }
        return tupleList;
    }
}

