/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.SpecialOperation;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleFactory;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.ArrayList;

public class ConceptEngine {
    TupleList data = new TupleList();
    TupleList shadow = new TupleList();
    EdgeSet hasFeature = new EdgeSet();
    EdgeSet curFeature;
    EdgeSet allConcepts;

    public void compute(EdgeSet edgeSet) {
        if (this.hasFeature != edgeSet) {
            this.hasFeature = edgeSet;
            EdgeSet edgeSet2 = new EdgeSet(100);
            EdgeSet edgeSet3 = new EdgeSet(100);
            this.initialize1();
            this.computeConcepts(edgeSet2);
            this.initialize2();
            this.computeConcepts(edgeSet3);
            edgeSet3 = AlgebraOperation.inverse(edgeSet3);
            this.allConcepts = AlgebraOperation.union(edgeSet2, edgeSet3);
        }
    }

    public EdgeSet getConcepts() {
        return this.allConcepts;
    }

    private void initialize1() {
        if (this.hasFeature == null || this.hasFeature.size() == 0) {
            this.data = new TupleList();
            this.shadow = new TupleList();
            this.curFeature = new EdgeSet();
            this.allConcepts = new EdgeSet();
            return;
        }
        this.curFeature = this.hasFeature;
        this.allConcepts = new EdgeSet();
        int n = this.curFeature.size();
        TupleList tupleList = this.curFeature.getTupleList();
        this.data = new TupleList(n);
        int[] nArray = new int[3];
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            nArray[0] = tuple.getDom();
            nArray[1] = tuple.getRng();
            nArray[2] = 0;
            this.data.add(TupleFactory.create(nArray));
        }
        this.shadow = new TupleList(n);
        RadixSorter.sort(this.data, 1, this.shadow);
        this.data = new TupleList(n);
        RadixSorter.sort(this.shadow, 0, this.data);
    }

    private void initialize2() {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            int n2 = tuple.get(0);
            tuple.set(0, tuple.get(1));
            tuple.set(1, n2);
        }
        this.shadow = this.data;
        this.data = new TupleList(n);
        RadixSorter.sort(this.shadow, 0, this.data);
        this.curFeature = AlgebraOperation.inverse(this.curFeature);
    }

    private void computeConcepts(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = SpecialOperation.basket(this.curFeature);
        edgeSet2 = AlgebraOperation.inverse(edgeSet2);
        edgeSet2 = SpecialOperation.basket(edgeSet2);
        edgeSet2 = AlgebraOperation.inverse(edgeSet2);
        int n = edgeSet2.size();
        TupleList tupleList = edgeSet2.getTupleList();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            int n2 = tuple.getDom();
            int n3 = tuple.getRng();
            int[] nArray = IDManager.parse(n2);
            int[] nArray2 = IDManager.parse(n3);
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = BinarySearch.search(this.shadow, nArray2[j], 1); k < this.shadow.size() && this.shadow.get(k).get(1) == nArray2[j]; ++k) {
                    this.shadow.get(k).set(2, 1);
                }
            }
            int[] nArray3 = this.collectObjects(nArray2.length);
            if (nArray.length == nArray3.length) {
                edgeSet.add(tuple);
                continue;
            }
            n2 = IDManager.getID(nArray3);
            edgeSet.add(n2, n3);
        }
    }

    private int[] collectObjects(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        int n2 = this.data.size();
        if (n2 > 0) {
            Tuple tuple = this.data.get(0);
            int n3 = 0;
            int n4 = tuple.getDom();
            if (tuple.get(2) == 1) {
                ++n3;
                tuple.set(2, 0);
            }
            for (int i = 1; i < n2; ++i) {
                tuple = this.data.get(i);
                int n5 = tuple.getDom();
                if (n4 == n5) {
                    if (tuple.get(2) != 1) continue;
                    ++n3;
                    tuple.set(2, 0);
                    continue;
                }
                if (n3 == n) {
                    arrayList.add(new Integer(n4));
                }
                n3 = 0;
                n4 = n5;
                if (tuple.get(2) != 1) continue;
                ++n3;
                tuple.set(2, 0);
            }
            if (n3 == n) {
                arrayList.add(new Integer(n4));
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }
}

