/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.Operation;
import ca.uwaterloo.cs.ql.fb.OperationRel;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleSet;

public class AlgebraOperation {
    public static TupleSet append(TupleSet tupleSet, TupleSet tupleSet2) {
        TupleSet tupleSet3;
        if (tupleSet.columns() == tupleSet2.columns()) {
            tupleSet3 = tupleSet.newSet();
            tupleSet.data.addAll(tupleSet2.data);
            tupleSet3.data = tupleSet.data;
            tupleSet3.setHasDuplicates(true);
            tupleSet3.sortLevel = -1;
        } else {
            tupleSet3 = new TupleSet();
            tupleSet.data.addAll(tupleSet2.data);
            tupleSet3.data = tupleSet.data;
            tupleSet3.setHasDuplicates(true);
            tupleSet3.sortLevel = -1;
        }
        return tupleSet3;
    }

    public static TupleSet inverse(TupleSet tupleSet) {
        TupleSet tupleSet2;
        if (tupleSet instanceof NodeSet) {
            tupleSet2 = (TupleSet)tupleSet.clone();
        } else {
            tupleSet2 = tupleSet.newSet();
            tupleSet2.data = Operation.inverse(tupleSet.data);
        }
        tupleSet2.setHasDuplicates(tupleSet.hasDuplicates());
        return tupleSet2;
    }

    public static TupleSet union(TupleSet tupleSet, TupleSet tupleSet2) {
        TupleSet tupleSet3;
        if (tupleSet.size() == 0) {
            return (TupleSet)tupleSet2.clone();
        }
        if (tupleSet2.size() == 0) {
            return (TupleSet)tupleSet.clone();
        }
        if (tupleSet.columns() == tupleSet2.columns()) {
            tupleSet3 = tupleSet.newSet();
            tupleSet3.data = Operation.union(tupleSet.data, tupleSet2.data);
            tupleSet3.data.sort_removeDuplicates();
            tupleSet3.setHasDuplicates(false);
            tupleSet3.sortLevel = 0;
        } else {
            tupleSet3 = (TupleSet)tupleSet.clone();
        }
        return tupleSet3;
    }

    public static TupleSet difference(TupleSet tupleSet, TupleSet tupleSet2) {
        TupleSet tupleSet3;
        if (tupleSet.size() == 0) {
            return new TupleSet();
        }
        if (tupleSet2.size() == 0) {
            return (TupleSet)tupleSet.clone();
        }
        if (tupleSet.columns() == tupleSet2.columns()) {
            tupleSet3 = tupleSet.newSet();
            tupleSet.sort();
            tupleSet2.sort();
            tupleSet3.data = Operation.difference(tupleSet.data, tupleSet2.data);
            tupleSet3.data.sort_removeDuplicates();
            tupleSet3.setHasDuplicates(false);
            tupleSet3.sortLevel = 0;
        } else {
            tupleSet3 = (TupleSet)tupleSet.clone();
        }
        return tupleSet3;
    }

    public static TupleSet intersection(TupleSet tupleSet, TupleSet tupleSet2) {
        if (tupleSet.size() == 0) {
            return new TupleSet();
        }
        if (tupleSet2.size() == 0) {
            return new TupleSet();
        }
        TupleSet tupleSet3 = tupleSet.newSet();
        if (tupleSet.columns() == tupleSet2.columns()) {
            tupleSet.sort();
            tupleSet2.sort();
            tupleSet3.data = Operation.intersection(tupleSet.data, tupleSet2.data);
            tupleSet3.data.sort_removeDuplicates();
            tupleSet3.setHasDuplicates(false);
            tupleSet3.sortLevel = 0;
        }
        return tupleSet3;
    }

    public static NodeSet union(NodeSet nodeSet, NodeSet nodeSet2) {
        NodeSet nodeSet3 = new NodeSet();
        nodeSet3.data = Operation.union(nodeSet.data, nodeSet2.data);
        nodeSet3.data.sort_removeDuplicates();
        nodeSet3.setHasDuplicates(false);
        nodeSet3.sortLevel = 0;
        return nodeSet3;
    }

    public static EdgeSet union(EdgeSet edgeSet, EdgeSet edgeSet2) {
        EdgeSet edgeSet3 = new EdgeSet();
        edgeSet3.data = Operation.union(edgeSet.data, edgeSet2.data);
        edgeSet3.data.sort_removeDuplicates();
        edgeSet3.setHasDuplicates(false);
        edgeSet3.sortLevel = 2;
        return edgeSet3;
    }

    public static NodeSet difference(NodeSet nodeSet, NodeSet nodeSet2) {
        nodeSet.trySort(0);
        nodeSet2.trySort(0);
        NodeSet nodeSet3 = new NodeSet();
        nodeSet3.data = Operation.difference(nodeSet.data, nodeSet2.data);
        nodeSet3.sortLevel = 0;
        if (!nodeSet.hasDuplicates()) {
            nodeSet3.setHasDuplicates(false);
        }
        return nodeSet3;
    }

    public static EdgeSet difference(EdgeSet edgeSet, EdgeSet edgeSet2) {
        edgeSet.trySort(2);
        edgeSet2.trySort(2);
        EdgeSet edgeSet3 = new EdgeSet();
        edgeSet3.data = Operation.difference(edgeSet.data, edgeSet2.data);
        edgeSet3.sortLevel = 2;
        if (!edgeSet.hasDuplicates()) {
            edgeSet3.setHasDuplicates(false);
        }
        return edgeSet3;
    }

    public static NodeSet intersection(NodeSet nodeSet, NodeSet nodeSet2) {
        NodeSet nodeSet3 = new NodeSet();
        nodeSet.trySort(0);
        nodeSet2.trySort(0);
        nodeSet3.data = Operation.intersection(nodeSet.data, nodeSet2.data);
        nodeSet3.sortLevel = 0;
        if (!nodeSet.hasDuplicates() || !nodeSet2.hasDuplicates()) {
            nodeSet3.setHasDuplicates(false);
        }
        return nodeSet3;
    }

    public static EdgeSet intersection(EdgeSet edgeSet, EdgeSet edgeSet2) {
        EdgeSet edgeSet3 = new EdgeSet();
        edgeSet.trySort(2);
        edgeSet2.trySort(2);
        edgeSet3.data = Operation.intersection(edgeSet.data, edgeSet2.data);
        edgeSet3.sortLevel = 2;
        if (!edgeSet.hasDuplicates() || !edgeSet2.hasDuplicates()) {
            edgeSet3.setHasDuplicates(false);
        }
        return edgeSet3;
    }

    public static NodeSet project(NodeSet nodeSet, EdgeSet edgeSet) {
        nodeSet.trySort(0);
        edgeSet.trySort(0);
        NodeSet nodeSet2 = new NodeSet();
        nodeSet2.data = Operation.forwardProjection(nodeSet.data, edgeSet.data);
        nodeSet2.setHasDuplicates(false);
        nodeSet2.sortLevel = 0;
        return nodeSet2;
    }

    public static NodeSet project(EdgeSet edgeSet, NodeSet nodeSet) {
        nodeSet.trySort(0);
        NodeSet nodeSet2 = new NodeSet();
        nodeSet2.data = edgeSet.sortLevel == 1 ? Operation.backwardProjection(edgeSet.data, nodeSet.data) : Operation.backwardProjection(edgeSet.shadow(), nodeSet.data);
        nodeSet2.sortLevel = 0;
        nodeSet2.setHasDuplicates(false);
        return nodeSet2;
    }

    public static TupleSet project(NodeSet nodeSet, TupleSet tupleSet) {
        TupleSet tupleSet2 = tupleSet.columns() == 3 ? new EdgeSet() : new TupleSet();
        nodeSet.trySort(0);
        tupleSet.trySort(0);
        tupleSet2.data = OperationRel.forwardProjection(nodeSet.data, tupleSet.data);
        tupleSet2.sortLevel = 0;
        tupleSet2.setHasDuplicates(false);
        return tupleSet2;
    }

    public static TupleSet project(TupleSet tupleSet, NodeSet nodeSet) {
        TupleSet tupleSet2 = tupleSet.columns() == 3 ? new EdgeSet() : new TupleSet();
        nodeSet.trySort(0);
        tupleSet.trySort(tupleSet.columns() - 1);
        tupleSet2.data = OperationRel.backwardProjection(tupleSet.data, nodeSet.data);
        tupleSet2.sortLevel = 0;
        tupleSet2.setHasDuplicates(false);
        return tupleSet2;
    }

    public static EdgeSet id(TupleSet tupleSet) {
        EdgeSet edgeSet = new EdgeSet();
        edgeSet.data = Operation.id(tupleSet.data);
        edgeSet.setHasDuplicates(false);
        edgeSet.sortLevel = 2;
        return edgeSet;
    }

    public static NodeSet entityOf(TupleSet tupleSet) {
        NodeSet nodeSet;
        if (tupleSet instanceof NodeSet) {
            nodeSet = (NodeSet)tupleSet.clone();
            nodeSet.trySort(0);
            nodeSet.removeDuplicates();
        } else {
            nodeSet = new NodeSet();
            nodeSet.data = Operation.entityOf(tupleSet.data);
        }
        nodeSet.setHasDuplicates(false);
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static NodeSet domainOf(TupleSet tupleSet) {
        tupleSet.trySort(0);
        NodeSet nodeSet = new NodeSet();
        nodeSet.data = Operation.domainOf(tupleSet.data);
        nodeSet.setHasDuplicates(false);
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static NodeSet rangeOf(TupleSet tupleSet) {
        tupleSet.sortRng();
        NodeSet nodeSet = new NodeSet();
        nodeSet.data = Operation.rangeOf(tupleSet.data);
        nodeSet.setHasDuplicates(false);
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static EdgeSet crossProduct(NodeSet nodeSet, NodeSet nodeSet2) {
        nodeSet.trySort(0);
        if (nodeSet.hasDuplicates()) {
            nodeSet.data.removeDuplicates();
        }
        if (nodeSet != nodeSet2) {
            nodeSet2.trySort(0);
            if (nodeSet2.hasDuplicates()) {
                nodeSet2.data.removeDuplicates();
            }
        }
        EdgeSet edgeSet = new EdgeSet();
        edgeSet.data = Operation.crossProduct(nodeSet.data, nodeSet2.data);
        edgeSet.setHasDuplicates(false);
        edgeSet.sortLevel = 0;
        return edgeSet;
    }

    public static EdgeSet composition(EdgeSet edgeSet, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Argument: pow = " + n);
        }
        if (n == 0) {
            return AlgebraOperation.id(AlgebraOperation.entityOf(edgeSet));
        }
        if (n == 1) {
            return (EdgeSet)edgeSet.clone();
        }
        EdgeSet edgeSet2 = edgeSet;
        for (int i = 1; i < n; ++i) {
            edgeSet2 = AlgebraOperation.composition(edgeSet2, edgeSet);
        }
        edgeSet2.setHasDuplicates(false);
        return edgeSet2;
    }

    public static EdgeSet composition(NodeSet nodeSet, EdgeSet edgeSet) {
        nodeSet.trySort(0);
        edgeSet.trySort(0);
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.composition(nodeSet.data, edgeSet.data);
        edgeSet2.trySort(2);
        edgeSet2.data.removeDuplicates();
        edgeSet2.setHasDuplicates(false);
        return edgeSet2;
    }

    public static EdgeSet composition(EdgeSet edgeSet, NodeSet nodeSet) {
        nodeSet.trySort(0);
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = edgeSet.sortLevel == 1 ? Operation.composition(edgeSet.data, nodeSet.data) : Operation.composition(edgeSet.shadow(), nodeSet.data);
        edgeSet2.trySort(2);
        edgeSet2.data.removeDuplicates();
        edgeSet2.setHasDuplicates(false);
        return edgeSet2;
    }

    public static EdgeSet composition(EdgeSet edgeSet, EdgeSet edgeSet2) {
        EdgeSet edgeSet3 = new EdgeSet();
        if (edgeSet.data == edgeSet2.data) {
            TupleList tupleList = edgeSet.shadow();
            edgeSet.trySort(0);
            edgeSet3.data = Operation.composition(tupleList, edgeSet.data);
        } else {
            edgeSet.trySort(1);
            edgeSet2.trySort(0);
            edgeSet3.data = Operation.composition(edgeSet.data, edgeSet2.data);
        }
        edgeSet3.trySort(2);
        edgeSet3.data.removeDuplicates();
        edgeSet3.setHasDuplicates(false);
        return edgeSet3;
    }

    public static TupleSet composition(TupleSet tupleSet, NodeSet nodeSet) {
        return AlgebraOperation.compositionRel(tupleSet, nodeSet);
    }

    public static TupleSet composition(NodeSet nodeSet, TupleSet tupleSet) {
        return AlgebraOperation.compositionRel(nodeSet, tupleSet);
    }

    public static TupleSet composition(TupleSet tupleSet, EdgeSet edgeSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (tupleSet.size() > 0 && edgeSet.size() > 0) {
            int n = tupleSet.columns() - 1;
            int n2 = 0;
            tupleSet.trySort(n);
            edgeSet.trySort(n2);
            tupleSet2.data = OperationRel.composition(tupleSet.data, n, true, edgeSet.data, n2, true);
        }
        return tupleSet2;
    }

    public static TupleSet composition(EdgeSet edgeSet, TupleSet tupleSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (edgeSet.size() > 0 && tupleSet.size() > 0) {
            int n = 1;
            int n2 = 0;
            edgeSet.trySort(n);
            tupleSet.trySort(n2);
            tupleSet2.data = OperationRel.composition(edgeSet.data, n, true, tupleSet.data, n2, true);
        }
        return tupleSet2;
    }

    public static TupleSet composition(TupleSet tupleSet, TupleSet tupleSet2) {
        TupleSet tupleSet3 = new TupleSet();
        if (tupleSet.size() > 0 && tupleSet2.size() > 0) {
            int n = tupleSet.columns() - 1;
            int n2 = 0;
            tupleSet.trySort(n);
            tupleSet2.trySort(n2);
            tupleSet3.data = OperationRel.composition(tupleSet.data, n, true, tupleSet2.data, n2, true);
        }
        return tupleSet3;
    }

    public static TupleSet compositionRel(EdgeSet edgeSet, EdgeSet edgeSet2) {
        TupleSet tupleSet = new TupleSet();
        if (edgeSet.data == edgeSet2.data) {
            TupleList tupleList = edgeSet.shadow();
            edgeSet.trySort(0);
            tupleSet.data = OperationRel.compositionRel(tupleList, 1, true, edgeSet.data, 0, true);
        } else {
            edgeSet.trySort(1);
            edgeSet2.trySort(0);
            tupleSet.data = OperationRel.compositionRel(edgeSet.data, 1, true, edgeSet2.data, 0, true);
        }
        return tupleSet;
    }

    public static TupleSet compositionRel(TupleSet tupleSet, NodeSet nodeSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (tupleSet.size() > 0 && nodeSet.size() > 0) {
            int n = tupleSet.columns() - 1;
            int n2 = 0;
            tupleSet.trySort(n);
            nodeSet.trySort(n2);
            tupleSet2.data = OperationRel.compositionRel(tupleSet.data, n, true, nodeSet.data, n2, true);
        }
        return tupleSet2;
    }

    public static TupleSet compositionRel(NodeSet nodeSet, TupleSet tupleSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (nodeSet.size() > 0 && tupleSet.size() > 0) {
            nodeSet.trySort(0);
            tupleSet.trySort(0);
            tupleSet2.data = OperationRel.compositionRel(nodeSet.data, 0, true, tupleSet.data, 0, true);
        }
        return tupleSet2;
    }

    public static TupleSet compositionRel(TupleSet tupleSet, EdgeSet edgeSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (tupleSet.size() > 0 && edgeSet.size() > 0) {
            int n = tupleSet.columns() - 1;
            int n2 = 0;
            tupleSet.trySort(n);
            edgeSet.trySort(n2);
            tupleSet2.data = OperationRel.compositionRel(tupleSet.data, n, true, edgeSet.data, n2, true);
        }
        return tupleSet2;
    }

    public static TupleSet compositionRel(EdgeSet edgeSet, TupleSet tupleSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (edgeSet.size() > 0 && tupleSet.size() > 0) {
            int n = 1;
            int n2 = 0;
            edgeSet.trySort(n);
            tupleSet.trySort(n2);
            tupleSet2.data = OperationRel.compositionRel(edgeSet.data, n, true, tupleSet.data, n2, true);
        }
        return tupleSet2;
    }

    public static TupleSet compositionRel(TupleSet tupleSet, TupleSet tupleSet2) {
        TupleSet tupleSet3 = new TupleSet();
        if (tupleSet.size() > 0 && tupleSet2.size() > 0) {
            int n = tupleSet.columns() - 1;
            int n2 = 0;
            tupleSet.trySort(n);
            tupleSet2.trySort(n2);
            tupleSet3.data = OperationRel.compositionRel(tupleSet.data, n, true, tupleSet2.data, n2, true);
        }
        return tupleSet3;
    }

    public static TupleSet compositionRel(TupleSet tupleSet, int n, NodeSet nodeSet) {
        TupleSet tupleSet2 = new TupleSet();
        if (tupleSet.size() > 0 && nodeSet.size() > 0) {
            int n2 = n;
            int n3 = 0;
            tupleSet.trySort(n2);
            nodeSet.trySort(n3);
            tupleSet2.data = OperationRel.compositionRel(tupleSet.data, n2, true, nodeSet.data, n3, true);
        }
        return tupleSet2;
    }

    public static EdgeSet unclosure(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.unclosure(edgeSet.data);
        edgeSet2.setHasDuplicates(false);
        edgeSet2.sortLevel = 2;
        return edgeSet2;
    }

    public static EdgeSet transitiveClosure(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.closure(edgeSet.data, false);
        edgeSet2.setHasDuplicates(false);
        edgeSet2.sortLevel = 2;
        return edgeSet2;
    }

    public static EdgeSet reflectiveClosure(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.closure(edgeSet.data, true);
        edgeSet2.setHasDuplicates(false);
        edgeSet2.sortLevel = 2;
        return edgeSet2;
    }

    public static EdgeSet symmetricClousre(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.symmetricClosure(edgeSet.data);
        edgeSet2.setHasDuplicates(false);
        edgeSet2.sortLevel = 2;
        return edgeSet2;
    }

    public static EdgeSet inverse(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet2.data = Operation.inverse(edgeSet.data);
        edgeSet2.setHasDuplicates(edgeSet.hasDuplicates());
        switch (edgeSet.sortLevel) {
            case 0: {
                edgeSet2.sortLevel = 1;
                break;
            }
            case 1: {
                edgeSet2.sortLevel = 0;
                break;
            }
            case 2: {
                edgeSet2.sortLevel = 1;
            }
        }
        return edgeSet2;
    }
}

