/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql;

import ca.uwaterloo.cs.ql.ShellCompleter;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Interp;
import ca.uwaterloo.cs.ql.interp.ParseException;
import ca.uwaterloo.cs.ql.interp.QdbCode;
import ca.uwaterloo.cs.ql.interp.ScriptUnitNode;
import ca.uwaterloo.cs.ql.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.ql.interp.TokenMgrError;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.util.Timing;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineLibrary;

public class Shell {
    private Env env;
    private Timing timing;
    private Interp interp;
    private StringBuffer buffer;
    private ByteArrayInputStream byteStream;
    private Value value;
    private ScriptUnitNode unit;
    private SyntaxTreeNode node;

    Shell() {
    }

    void debugEvaluate(String[] stringArray) {
        this.initEnv(stringArray);
        try {
            this.unit.debugEvaluate(this.env, 1);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(0);
        }
        if (this.initReadline()) {
            block11: while (true) {
                try {
                    while (true) {
                        String string;
                        if ((string = Readline.readline((String)">> ")) == null) {
                            continue;
                        }
                        if (this.isKeyword(string)) {
                            this.qdbHelp(string);
                            continue;
                        }
                        int n = QdbCode.get(string);
                        if (n >= 0) {
                            try {
                                this.unit.debugEvaluate(this.env, n);
                                continue block11;
                            }
                            catch (Exception exception) {
                                System.err.println(exception.getMessage());
                                System.exit(0);
                                continue;
                            }
                        }
                        this.evaluate(string);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.env.out.println("Exception: " + unsupportedEncodingException.getMessage());
                    continue;
                }
                catch (IOException iOException) {
                }
                break;
            }
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(this.env.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (true) {
                this.env.out.print(">> ");
                try {
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        this.env.out.println();
                        continue;
                    }
                    if (this.isKeyword(string)) {
                        this.qdbHelp(string);
                        continue;
                    }
                    int n = QdbCode.get(string);
                    if (n >= 0) {
                        try {
                            this.unit.debugEvaluate(this.env, n);
                        }
                        catch (Exception exception) {
                            System.err.println(exception.getMessage());
                            System.exit(0);
                        }
                        continue;
                    }
                    this.evaluate(string);
                }
                catch (IOException iOException) {}
            }
        }
        this.env.out.println();
        Readline.cleanup();
        this.freeEnv();
    }

    void shellEvaluate() {
        this.initEnv();
        if (this.initReadline()) {
            while (true) {
                try {
                    while (true) {
                        String string;
                        if ((string = Readline.readline((String)">> ")) == null || this.isKeyword(string)) {
                            continue;
                        }
                        this.evaluate(string);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.env.out.println("Exception: " + unsupportedEncodingException.getMessage());
                    continue;
                }
                catch (IOException iOException) {
                }
                break;
            }
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(this.env.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (true) {
                this.env.out.print(">> ");
                try {
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        this.env.out.println();
                        continue;
                    }
                    if (this.isKeyword(string)) continue;
                    this.evaluate(string);
                }
                catch (IOException iOException) {}
            }
        }
        this.env.out.println();
        Readline.cleanup();
        this.freeEnv();
    }

    private void initEnv(String[] stringArray) {
        this.env = new Env();
        File file = new File(stringArray[0]);
        try {
            this.interp = new Interp(file);
            this.unit = this.interp.parse();
            if (this.unit == null) {
                System.exit(0);
            }
            this.env.setMainUnit(this.unit);
            this.env.pushScope(this.unit);
            Variable variable = new Variable(this.unit, "$#", new Value(stringArray.length - 1));
            this.unit.addVariable(variable);
            for (int i = 0; i < stringArray.length; ++i) {
                variable = new Variable(this.unit, "$" + i, new Value(stringArray[i]));
                this.unit.addVariable(variable);
            }
            this.timing = null;
            this.buffer = new StringBuffer();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("No such a file " + file + " exists");
            System.exit(0);
        }
    }

    private void initEnv() {
        this.env = new Env();
        this.unit = new ScriptUnitNode();
        this.env.setMainUnit(this.unit);
        this.env.pushScope(this.unit);
        this.timing = null;
        this.interp = new Interp();
        this.buffer = new StringBuffer();
    }

    private void freeEnv() {
        this.env.popScope();
    }

    private boolean initReadline() {
        try {
            Readline.load((ReadlineLibrary)ReadlineLibrary.GnuReadline);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                Readline.load((ReadlineLibrary)ReadlineLibrary.Editline);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                System.err.println("Unable to load readline lib. Using stdin.");
            }
        }
        Readline.initReadline((String)"QL Shell");
        Readline.parseAndBind((String)"\"\\e[18~\":\t\"Function key F7\"");
        Readline.parseAndBind((String)"\"\\e[19~\":\t\"Function key F8\"");
        try {
            Readline.setWordBreakCharacters((String)" \t;");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Unable to set word break characters");
            return false;
        }
        Readline.setCompleter((ReadlineCompleter)new ShellCompleter());
        return true;
    }

    private boolean isKeyword(String string) {
        return string.equals("?") || string.equals("help") || string.equals("print") || string.equals("delete");
    }

    private void qdbHelp(String string) {
        if (string.equals("?") || string.equals("help")) {
            System.out.println("qdb:");
            System.out.println("    x - Continue to finish");
            System.out.println("    c - Continue to next pause");
            System.out.println("    l - Display next statement");
            System.out.println("    n - Execute next statement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(String string) {
        try {
            string = string.trim();
            if (string.startsWith("%") || string.startsWith("//")) {
                string = "";
            }
            if (string.endsWith("\\")) {
                while (string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1);
                    string = string.trim();
                }
                if (string.length() > 0) {
                    this.buffer.append(" ");
                    this.buffer.append(string);
                }
                return;
            }
            if (string.length() > 0) {
                this.buffer.append(" ");
                this.buffer.append(string);
            }
            if (this.buffer.length() == 0) {
                return;
            }
            this.byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
            Interp.ReInit(this.byteStream);
            try {
                Shell shell = this;
                this.node = shell.interp.Statement();
            }
            catch (ParseException parseException) {
                this.byteStream.close();
                this.byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
                Interp.ReInit(this.byteStream);
                Shell shell = this;
                this.node = shell.interp.Expression();
            }
            if (this.unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                }
                this.timing.start();
            }
            this.value = this.node.evaluate(this.env);
            if (this.node instanceof ExpressionNode) {
                this.value.print(this.env.out);
            }
            if (this.unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                } else {
                    this.timing.stop();
                    this.env.out.println("time:");
                    this.env.out.println("\t" + this.timing.getTime());
                }
            }
            if (this.unit.isEchoOn()) {
                this.env.out.println("echo:");
                this.env.out.println(this.node.toString());
            }
            this.byteStream.close();
            this.byteStream = null;
            this.buffer.delete(0, this.buffer.length());
        }
        catch (IOException iOException) {
            this.env.out.println("Exception: " + iOException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            this.env.out.println("Exception: " + tokenMgrError.getMessage());
        }
        catch (ParseException parseException) {
            this.env.out.println("Exception: unable to parse " + this.buffer);
        }
        catch (EvaluationException evaluationException) {
            this.env.out.println("Exception: " + evaluationException.getMessage());
        }
        finally {
            this.buffer.delete(0, this.buffer.length());
        }
    }
}

