/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Interp;
import ca.uwaterloo.cs.ql.interp.ParseException;
import ca.uwaterloo.cs.ql.interp.ScriptUnitNode;
import ca.uwaterloo.cs.ql.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.ql.interp.TokenMgrError;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.util.History;
import ca.uwaterloo.cs.ql.util.Timing;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LineInterp {
    private Timing timing;
    private Interp interp;
    private History history = new History();
    private boolean keepHistory = true;
    private StringBuffer buffer;

    public LineInterp() {
        this.interp = Interp.instance();
        this.buffer = new StringBuffer();
    }

    public LineInterp(boolean bl) {
        this.interp = Interp.instance();
        this.buffer = new StringBuffer();
        this.keepHistory = bl;
    }

    public History getHistory() {
        return this.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(Env env, String string) {
        if (env == null) {
            return;
        }
        ScriptUnitNode scriptUnitNode = env.getMainUnit();
        try {
            SyntaxTreeNode syntaxTreeNode;
            string = string.trim();
            if (string.startsWith("%") || string.startsWith("//")) {
                string = "";
            }
            if (string.endsWith("\\")) {
                while (string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1);
                    string = string.trim();
                }
                if (string.length() > 0) {
                    this.buffer.append(" ");
                    this.buffer.append(string);
                }
                return;
            }
            if (string.length() > 0) {
                this.buffer.append(" ");
                this.buffer.append(string);
            }
            if (this.buffer.length() == 0) {
                return;
            }
            if (this.keepHistory) {
                this.history.add(this.buffer.toString());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
            Interp.ReInit(byteArrayInputStream);
            try {
                LineInterp lineInterp = this;
                syntaxTreeNode = lineInterp.interp.Statement();
            }
            catch (ParseException parseException) {
                byteArrayInputStream.close();
                byteArrayInputStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
                Interp.ReInit(byteArrayInputStream);
                LineInterp lineInterp = this;
                syntaxTreeNode = lineInterp.interp.Expression();
            }
            if (scriptUnitNode.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                }
                this.timing.start();
            }
            Value value = syntaxTreeNode.evaluate(env);
            if (syntaxTreeNode instanceof ExpressionNode) {
                value.print(env.out);
            }
            if (scriptUnitNode.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                } else {
                    this.timing.stop();
                    env.out.println("time:");
                    env.out.println("\t" + this.timing.getTime());
                }
            }
            if (scriptUnitNode.isEchoOn()) {
                env.out.println("echo:");
                env.out.println(syntaxTreeNode.toString());
            }
            byteArrayInputStream.close();
            byteArrayInputStream = null;
            this.buffer.delete(0, this.buffer.length());
        }
        catch (IOException iOException) {
            env.out.println("Exception: " + iOException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            env.out.println("Exception: " + tokenMgrError.getMessage());
        }
        catch (ParseException parseException) {
            env.out.println("Exception: unable to parse " + this.buffer);
        }
        catch (EvaluationException evaluationException) {
            env.out.println("Exception: " + evaluationException.getMessage());
        }
        finally {
            this.buffer.delete(0, this.buffer.length());
        }
    }
}

