/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Add;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.LandscapeEditorCore;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.TaListener;
import lsedit.TabBox;
import lsedit.View;

public class ViewBox
extends TabBox
implements ChangeListener,
TaListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static Font m_textFont = null;
    public static final String m_helpStr = "This box shows available views for the diagram";
    public Add m_add = null;

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public ViewBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Views", m_helpStr);
        this.setBounds(0, 0, tabbedPane.getWidth(), tabbedPane.getHeight());
        this.m_add = new Add(ls);
        tabbedPane.addChangeListener(this);
    }

    @Override
    public void validate() {
        int cnt = this.getComponentCount();
        int width1 = this.getWidth() - 5;
        int depth = 0;
        int i = 0;
        while (i < cnt) {
            Component c = this.getComponent(i);
            Dimension d = c.getPreferredSize();
            int height1 = d.height;
            c.setBounds(5, depth, width1, height1);
            depth += height1 + 5;
            ++i;
        }
    }

    public void fill() {
        LandscapeEditorCore ls;
        Diagram diagram;
        Insets insets = this.m_scrollPane.getInsets();
        int width = this.m_scrollPane.getWidth() - insets.left - insets.right;
        int height = this.m_scrollPane.getHeight() - insets.top - insets.bottom;
        this.removeAll();
        if (this.isActive() && (diagram = (ls = this.getLs()).getDiagram()) != null) {
            Font textFont = m_textFont;
            if (textFont == null) {
                m_textFont = textFont = Options.getTargetFont(14);
            }
            this.m_add.setFont(textFont);
            Dimension d = this.m_add.getPreferredSize();
            int width2 = d.width;
            int height1 = d.height + 5;
            this.add(this.m_add);
            Vector views = diagram.getViews();
            if (views != null) {
                int size = views.size();
                int i = 0;
                while (i < size) {
                    View view = (View)views.elementAt(i);
                    view.setFont(textFont);
                    d = view.getPreferredSize();
                    int width1 = d.width;
                    if (width1 < width2) {
                        width2 = width1;
                    }
                    height1 += d.height + 5;
                    view.setFont(textFont);
                    this.add(view);
                    ++i;
                }
            }
            if (width < (width2 += 5)) {
                width = width2;
            }
        }
        if (this.getWidth() != width || this.getHeight() != height) {
            this.setBounds(0, 0, width, height);
        }
        this.validate();
        this.repaint();
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        ViewBox.setTextFont(font);
        this.fill();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        if (signal == 44) {
            this.fill();
        }
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
    }
}

