/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import lsedit.EditableTa;
import lsedit.MyCompoundEdit;
import lsedit.MyUndoManager;
import lsedit.TaFeedback;
import lsedit.UndoListener;

public class UndoableTa
extends EditableTa
implements UndoableEditListener {
    protected MyUndoManager m_undoManager = new MyUndoManager();
    protected String m_compoundEditName = null;
    protected MyCompoundEdit m_compoundEdit = null;
    protected int m_compoundEditCnt = -1;
    protected boolean m_useCompoundEdit = true;
    protected UndoListener m_undoListener = null;

    protected void updateMenu() {
        if (this.m_undoListener != null) {
            this.m_undoListener.setEnabledRedo(this.m_undoManager.canRedo());
            this.m_undoListener.setEnabledUndo(this.m_undoManager.canUndo());
        }
    }

    public UndoableTa(TaFeedback taFeedback) {
        super(taFeedback);
        this.setUndoEnabled(true);
    }

    public void setUndoListener(UndoListener undoListener) {
        this.m_undoListener = undoListener;
    }

    public void setUndoEnabled(boolean value) {
        this.m_undoEnabled = value;
    }

    public boolean useCompoundEdit() {
        return this.m_useCompoundEdit;
    }

    public void setUseCompoundEdit(boolean value) {
        this.m_useCompoundEdit = value;
    }

    public int getLimit() {
        return this.m_undoManager.getLimit();
    }

    public void setLimit(int limit) {
        this.m_undoManager.setLimit(limit);
    }

    public Vector getEdits() {
        return this.m_undoManager.getEdits();
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_undoManager.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_undoManager.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean redo) {
        this.beginUpdates();
        this.m_undoManager.massChange(undoableEdit, redo);
        this.endUpdates();
    }

    public void discardAllEdits() {
        this.m_undoManager.discardAllEdits();
    }

    public boolean addEditToManager(UndoableEdit lastEdit) {
        boolean ret = this.m_undoManager.addEdit(lastEdit);
        if (ret && this.m_undoListener != null) {
            this.m_undoListener.setPreferredSizeUndo(this.getEdits(), lastEdit);
        }
        return ret;
    }

    public void beginUndoRedo(String name) {
        if (this.m_useCompoundEdit) {
            this.m_compoundEditName = name;
            this.m_compoundEdit = null;
            this.m_compoundEditCnt = 0;
        }
        this.beginUpdates();
    }

    public void endUndoRedo() {
        if (this.m_compoundEdit != null) {
            this.m_compoundEdit.end();
            this.m_compoundEdit = null;
        }
        this.m_compoundEditName = null;
        this.m_compoundEditCnt = -1;
        this.endUpdates();
    }

    public boolean logEdit(UndoableEdit anEdit) {
        boolean ret;
        this.m_changedFlag = true;
        if (this.m_compoundEditCnt < 0) {
            ret = this.addEditToManager(anEdit);
        } else {
            switch (this.m_compoundEditCnt) {
                case 0: {
                    ret = this.addEditToManager(anEdit);
                    break;
                }
                case 1: {
                    this.m_compoundEdit = new MyCompoundEdit(this.m_compoundEditName);
                    ret = this.m_compoundEdit.addEdit(anEdit);
                    ret = this.addEditToManager(this.m_compoundEdit);
                    break;
                }
                default: {
                    ret = this.m_compoundEdit.addEdit(anEdit);
                }
            }
            ++this.m_compoundEditCnt;
        }
        this.updateMenu();
        if (!ret) {
            this.error("logEdit failed");
        }
        return ret;
    }

    public void undo() {
        String s;
        if (!this.m_undoManager.canUndo()) {
            s = "Nothing to undo";
        } else {
            this.beginUpdates();
            this.m_undoManager.undo();
            this.endUpdates();
            this.updateMenu();
            s = "Undo done";
        }
        if (this.m_undoListener != null) {
            this.m_undoListener.undoHistoryChanged();
        }
        this.doFeedback(s);
    }

    public void redo() {
        String s;
        if (!this.m_undoManager.canRedo()) {
            s = "Nothing to redo";
        } else {
            this.beginUpdates();
            this.m_undoManager.redo();
            this.endUpdates();
            this.doFeedback("Redo done");
            this.updateMenu();
            s = "Redo done";
        }
        if (this.m_undoListener != null) {
            this.m_undoListener.undoHistoryChanged();
        }
        this.doFeedback(s);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.m_undoManager.undoableEditHappened(e);
        this.updateMenu();
    }
}

