/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lsedit.Clipboard;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.MyTreeCellRenderer;
import lsedit.MyTreePath;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.TaListener;

public final class TocBox
extends JTree
implements Scrollable,
ChangeListener,
TaListener,
TreeModel,
TreeExpansionListener,
MouseListener,
MouseMotionListener {
    public static final String m_helpStr = "Right click for menu.";
    protected MyTreeCellRenderer m_renderer;
    protected static Font m_textFont = null;
    protected EntityInstance m_childrensParent;
    protected Vector m_children;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected Vector m_treeModelListeners;
    protected EntityInstance m_hover;

    @Override
    public String toString() {
        return "TocBox";
    }

    @Override
    public String convertValueToText(Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String ret;
        if (value instanceof EntityInstance) {
            EntityInstance e = (EntityInstance)value;
            int cnt = e.numChildren();
            ret = e.getEntityLabel();
            if (cnt > 1) {
                ret = String.valueOf(ret) + " (" + cnt + ")";
            }
        } else {
            ret = value.toString();
        }
        return ret;
    }

    @Override
    protected boolean removeDescendantSelectedPaths(TreePath path, boolean includePath) {
        super.removeDescendantSelectedPaths(path, includePath);
        return false;
    }

    protected void setRowHeight() {
        FontMetrics fm = this.getFontMetrics(m_textFont);
        int height = fm.getHeight();
        if (height < 18) {
            height = 18;
        }
        this.setRowHeight(height);
    }

    public TocBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        MyTreeCellRenderer renderer;
        Insets insets = tabbedPane.getInsets();
        int width = tabbedPane.getWidth() - insets.left - insets.right;
        int height = tabbedPane.getHeight() - insets.top - insets.bottom;
        Font textFont = m_textFont;
        if (textFont == null) {
            m_textFont = textFont = Options.getTargetFont(12);
        }
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_children = new Vector();
        this.setBackground(Diagram.boxColor);
        this.setFont(textFont);
        this.setEditable(false);
        this.setShowsRootHandles(true);
        this.m_renderer = renderer = new MyTreeCellRenderer(textFont);
        renderer.setBackgroundNonSelectionColor(Diagram.boxColor);
        this.setCellRenderer(renderer);
        this.setDragEnabled(true);
        this.setToolTipText(m_helpStr);
        this.setRowHeight();
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, width, height);
        this.setSize(width, height);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("TOC", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
        tabbedPane.addChangeListener(this);
    }

    public void treeSizeChanged() {
        Dimension d = this.getPreferredSize();
        int height = (this.getRowCount() + 1) * this.getRowHeight();
        if (d.height != height) {
            d.height = height;
            this.setPreferredSize(d);
            this.treeDidChange();
        }
    }

    public void textFontChanged(Font font) {
        m_textFont = font;
        this.m_renderer.setFont(font);
        this.setFont(font);
        this.setRowHeight();
        this.fill();
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return this.m_scrollPane == active;
    }

    protected JPopupMenu buildPopup(EntityInstance e) {
        LandscapeEditorCore ls = this.m_ls;
        Diagram diagram = ls.getDiagram();
        JPopupMenu m = new JPopupMenu("TOC options");
        if (e != null) {
            Do.navigateMenuItem(m, ls, e);
            Do.editAttributesMenuItem(m, ls, e);
            Do.editElisionsMenuItem(m, ls, e);
        }
        if (diagram != null) {
            MyMenuItem m1;
            Clipboard clipboard = diagram.getClipboard();
            TreePath[] paths = this.getSelectionPaths();
            if (paths != null && paths.length > 0) {
                m1 = Do.cutMenuItem(m, ls);
                m1.setObject(this);
            }
            if (clipboard != null && !clipboard.isEmpty() && paths != null && paths.length == 1) {
                m1 = Do.pasteMenuItem(m, ls);
                m1.setObject(this);
            }
        }
        Do.openCloseTOCMenuItem(m, ls);
        Do.alignTOCMenuItem(m, ls);
        FontCache.setMenuTreeFont(m);
        return m;
    }

    public Vector getTocGroupedEntities() {
        int cnt;
        Vector<EntityInstance> ret = null;
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && (cnt = paths.length) > 0) {
            ret = new Vector<EntityInstance>(cnt);
            int i = 0;
            while (i < cnt) {
                EntityInstance e = (EntityInstance)paths[i].getLastPathComponent();
                ret.add(e);
                ++i;
            }
        }
        return ret;
    }

    public EntityInstance targetEntity() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length == 1) {
            EntityInstance e = (EntityInstance)paths[0].getLastPathComponent();
            return e;
        }
        return null;
    }

    public void fill() {
        Diagram diagram = this.m_ls.getDiagram();
        this.m_childrensParent = null;
        this.setModel(null);
        if (diagram == null || !this.isActive()) {
            return;
        }
        EntityInstance root = diagram.getRootInstance();
        if (root == null) {
            return;
        }
        this.removeTreeExpansionListener(this);
        this.m_treeModelListeners = null;
        this.setModel(this);
        this.addTreeExpansionListener(this);
        this.treeSizeChanged();
    }

    public MyTreePath getTreePath(EntityInstance e) {
        return new MyTreePath(e);
    }

    private void insertTOC(EntityInstance e, EntityInstance parent) {
        if (this.isActive() && parent != null) {
            this.m_childrensParent = null;
            MyTreePath path = this.getTreePath(parent);
            if (path != null) {
                int[] indices = new int[]{this.getIndexOfChild(parent, e)};
                Object[] objects = new Object[]{e};
                TreeModelEvent event = new TreeModelEvent((Object)this, path, indices, objects);
                int i = this.m_treeModelListeners.size();
                while (i > 0) {
                    TreeModelListener listener = (TreeModelListener)this.m_treeModelListeners.elementAt(--i);
                    listener.treeNodesInserted(event);
                }
            }
        }
    }

    private void deleteTOC(EntityInstance e, EntityInstance parent) {
        if (this.isActive() && parent != null) {
            this.m_childrensParent = null;
            MyTreePath path = this.getTreePath(parent);
            if (path != null) {
                int[] indices = new int[]{this.getIndexOfChild(parent, e)};
                Object[] objects = new Object[]{e};
                TreeModelEvent event = new TreeModelEvent((Object)this, path, indices, objects);
                int i = this.m_treeModelListeners.size();
                while (i > 0) {
                    TreeModelListener listener = (TreeModelListener)this.m_treeModelListeners.elementAt(--i);
                    listener.treeNodesRemoved(event);
                }
            }
        }
    }

    protected void closeAll() {
        int cnt;
        this.removeTreeExpansionListener(this);
        int i = cnt = this.getRowCount();
        while (i > 0) {
            this.collapseRow(--i);
        }
        this.addTreeExpansionListener(this);
        this.treeSizeChanged();
    }

    protected void expandTo(EntityInstance e) {
        this.removeTreeExpansionListener(this);
        this.closeAll();
        this.clearSelection();
        if (e != null) {
            int cnt = 0;
            while (cnt < this.getRowCount()) {
                TreePath path = this.getPathForRow(cnt);
                EntityInstance e1 = (EntityInstance)path.getLastPathComponent();
                if (e1 != null) {
                    if (e1 == e) {
                        this.setSelectionRow(cnt);
                        this.scrollRowToVisible(cnt);
                        this.expandRow(cnt);
                        break;
                    }
                    if (e1.hasDescendant(e)) {
                        this.expandRow(cnt);
                    }
                }
                ++cnt;
            }
        }
        this.addTreeExpansionListener(this);
        this.treeSizeChanged();
    }

    protected void expandAll() {
        this.removeTreeExpansionListener(this);
        int cnt = 0;
        while (cnt < this.getRowCount()) {
            this.expandRow(cnt);
            ++cnt;
        }
        this.addTreeExpansionListener(this);
        this.treeSizeChanged();
    }

    public void toc_path() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            this.activate();
            EntityInstance e = diagram.getDrawRoot();
            this.expandTo(e);
        }
    }

    public void switch_TOC() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            this.activate();
            int cnt = this.getRowCount();
            if (cnt > 1) {
                this.closeAll();
            } else {
                this.expandAll();
            }
        }
    }

    protected void doRightPopup(MouseEvent ev, EntityInstance e) {
        int x = ev.getX();
        int y = ev.getY();
        JPopupMenu popupMenu = this.buildPopup(e);
        this.add(popupMenu);
        popupMenu.show(this, x, y);
        this.remove(popupMenu);
    }

    protected Vector sortedChildren(EntityInstance e) {
        Vector children = this.m_children;
        if (e != this.m_childrensParent) {
            children.clear();
            e.addChildren(children);
            SortVector.byString(children, true);
            this.m_childrensParent = e;
        }
        return children;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this.m_treeModelListeners == null) {
            this.m_treeModelListeners = new Vector();
        }
        this.m_treeModelListeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        EntityInstance e = (EntityInstance)parent;
        if (!Options.getDiagramOptions().isSortTOC()) {
            return e.getChild(index);
        }
        Vector children = this.sortedChildren(e);
        return children.elementAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((EntityInstance)parent).numChildren();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent != null) {
            EntityInstance e = (EntityInstance)parent;
            if (!Options.getDiagramOptions().isSortTOC()) {
                return e.getIndexOfChild(child);
            }
            Vector children = this.sortedChildren(e);
            int index = children.size();
            while (index > 0) {
                if ((e = (EntityInstance)children.elementAt(--index)) != child) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            return null;
        }
        return diagram.getRootInstance();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (this.m_treeModelListeners != null) {
            this.m_treeModelListeners.remove(l);
            if (this.m_treeModelListeners.isEmpty()) {
                this.m_treeModelListeners = null;
            }
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private void containerCut(EntityInstance e, EntityInstance parent) {
        if (this.isActive() && parent != null) {
            this.m_childrensParent = null;
            MyTreePath path = this.getTreePath(parent);
            if (path != null) {
                TreeModelEvent event = new TreeModelEvent((Object)this, path);
                int i = this.m_treeModelListeners.size();
                while (i > 0) {
                    TreeModelListener listener = (TreeModelListener)this.m_treeModelListeners.elementAt(--i);
                    listener.treeStructureChanged(event);
                }
            }
        }
    }

    private void containerUncut(EntityInstance e, EntityInstance parent) {
        this.containerCut(e, parent);
    }

    public EntityInstance entityClicked(MouseEvent ev) {
        int y;
        int x = ev.getX();
        TreePath selPath = this.getPathForLocation(x, y = ev.getY());
        EntityInstance e = selPath == null ? null : (EntityInstance)selPath.getLastPathComponent();
        return e;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        this.fill();
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
        switch (signal) {
            case 30: 
            case 33: 
            case 35: 
            case 41: 
            case 42: 
            case 43: {
                this.fill();
            }
        }
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
        switch (signal) {
            case 8: {
                this.fill();
            }
        }
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        switch (signal) {
            case 11: 
            case 17: {
                this.deleteTOC(e, parent);
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                this.insertTOC(e, parent);
                break;
            }
            case 15: {
                this.containerCut(e, parent);
                break;
            }
            case 16: {
                this.containerUncut(e, parent);
            }
        }
    }

    @Override
    public void relationParentChanged(RelationInstance ri, int signal) {
    }

    @Override
    public void entityInstanceChanged(EntityInstance e, int signal) {
    }

    @Override
    public void relationInstanceChanged(RelationInstance ri, int signal) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.treeSizeChanged();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.treeSizeChanged();
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.isMetaDown() && !ev.isAltDown()) {
            EntityInstance e = this.entityClicked(ev);
            this.doRightPopup(ev, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isAltDown()) {
            EntityInstance e;
            this.m_hover = e = this.entityClicked(ev);
            e.startHover();
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.m_hover != null) {
            this.m_hover.endHover();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }
}

