/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.Clipboard;
import lsedit.ClusterEntity;
import lsedit.CutClipboard;
import lsedit.CutEntity;
import lsedit.DeleteEdge;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.LiftEntityEdges;
import lsedit.MoveEntityContainment;
import lsedit.MyUndoableEdit;
import lsedit.NewEntity;
import lsedit.NewEntityClass;
import lsedit.NewRelation;
import lsedit.NewRelationClass;
import lsedit.ParseAttributeValue;
import lsedit.PasteClipboard;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.RemoveEntityClass;
import lsedit.RemoveRelationClass;
import lsedit.SetAngle;
import lsedit.SetArrowColor;
import lsedit.SetAttributeName;
import lsedit.SetAttributeValue;
import lsedit.SetColorWhenOpen;
import lsedit.SetDescription;
import lsedit.SetFontDelta;
import lsedit.SetHeightRelLocal;
import lsedit.SetIOfactor;
import lsedit.SetImage;
import lsedit.SetInherits;
import lsedit.SetLabel;
import lsedit.SetLabelColor;
import lsedit.SetLocationRelLocal;
import lsedit.SetObjectColor;
import lsedit.SetParentClass;
import lsedit.SetRelLocal;
import lsedit.SetReversedLabel;
import lsedit.SetSizeRelLocal;
import lsedit.SetStyle;
import lsedit.SetUnscaledIconFile;
import lsedit.SetWidthRelLocal;
import lsedit.SetXRelLocal;
import lsedit.SetYRelLocal;
import lsedit.StringCache;
import lsedit.SwitchContainsClasses;
import lsedit.TaFeedback;
import lsedit.UndoableTa;
import lsedit.UpdateDeleteContainer;
import lsedit.Util;

public class TemporalTa
extends UndoableTa {
    public TemporalTa(TaFeedback taFeedback) {
        super(taFeedback);
    }

    public void updateParentClass(LandscapeObject object, LandscapeClassObject value) {
        LandscapeClassObject old = object.getParentClass();
        if (value != old) {
            this.setParentClass(object, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetParentClass(object, old, value));
            }
        }
    }

    public void updateStyle(LandscapeObject object, int value) {
        int old = object.getStyle();
        if (value != old) {
            this.setStyle(object, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetStyle(object, old, value));
            }
        }
    }

    public void updateObjectColor(LandscapeObject object, Color value) {
        Color old = object.getObjectColor();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setObjectColor(object, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetObjectColor(object, old, value));
        }
    }

    public boolean updateAttributeNameAt(LandscapeObject object, int index, Object value) {
        int primary = object.getPrimaryAttributeCount();
        if (index < primary) {
            return false;
        }
        String name = StringCache.get((String)value);
        if ((index -= primary) == object.getLsAttributesSize()) {
            if (name == null || name.equals("")) {
                return false;
            }
            if (!object.unknownAttributeName(name)) {
                return false;
            }
            this.setAttributeName(object, null, name);
            if (this.undoEnabled()) {
                this.logEdit(new SetAttributeName(object, null, name));
            }
            return true;
        }
        Attribute attribute = object.getLsAttributeAt(index);
        if (attribute == null) {
            return false;
        }
        String oldname = attribute.m_id;
        if (name.equals("")) {
            this.setAttributeName(object, oldname, null);
            if (this.undoEnabled()) {
                this.logEdit(new SetAttributeName(object, oldname, null));
            }
            return true;
        }
        if (name.equals(oldname)) {
            return false;
        }
        if (!object.unknownAttributeName(name)) {
            return false;
        }
        this.setAttributeName(object, oldname, name);
        if (this.undoEnabled()) {
            this.logEdit(new SetAttributeName(object, oldname, name));
        }
        return true;
    }

    public void updateAttributeValueAt(LandscapeObject object, int index, Object value) {
        Attribute attr = object.getLsAttributeAt(index -= object.getPrimaryAttributeCount());
        if (attr == null) {
            return;
        }
        String oldAvi = attr.externalString();
        String newAvi = (String)value;
        if (newAvi != null && (newAvi = StringCache.get(newAvi.trim())).length() == 0) {
            newAvi = null;
        }
        if (newAvi == null) {
            if (oldAvi == null) {
                return;
            }
        } else {
            if (newAvi.equals(oldAvi)) {
                return;
            }
            ParseAttributeValue parseAttributeValue = new ParseAttributeValue(newAvi);
            if ((newAvi = parseAttributeValue.result()) == null) {
                System.out.println("Can't parse '" + newAvi + "' as attribute value");
                return;
            }
            if (newAvi.equals(oldAvi)) {
                return;
            }
        }
        String id = attr.m_id;
        this.addAttribute(object, id, newAvi);
        if (this.undoEnabled()) {
            this.logEdit(new SetAttributeValue(object, id, oldAvi, newAvi));
        }
    }

    public RelationInstance updateNewRelation(RelationClass rc, EntityInstance from, EntityInstance to) {
        RelationInstance ri = this.getNewRelation(rc, from, to);
        if (this.undoEnabled()) {
            this.logEdit(new NewRelation(ri));
        }
        return ri;
    }

    public void updateDeleteEdge(RelationInstance ri) {
        this.cutRelation(ri);
        if (this.undoEnabled()) {
            this.logEdit(new DeleteEdge(ri));
        }
    }

    public void updateLabel(LandscapeObject3D object, String value) {
        String old = object.getLabel();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setLabel(object, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetLabel(object, old, value));
        }
    }

    public void updateReversedLabel(RelationClass rc, String value) {
        String old = rc.getReversedLabel();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setReversedLabel(rc, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetReversedLabel(rc, old, value));
        }
    }

    public void updateDescription(LandscapeObject3D object, String value) {
        String old = object.getDescription();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setDescription(object, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetDescription(object, old, value));
        }
    }

    public void updateLabelColor(LandscapeObject3D object, Color value) {
        Color old = object.getLabelColor();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setLabelColor(object, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetLabelColor(object, old, value));
        }
    }

    public void updateColorWhenOpen(LandscapeObject3D object, Color value) {
        Color old = object.getColorWhenOpen();
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setColorWhenOpen(object, value);
        if (this.undoEnabled()) {
            this.logEdit(new SetColorWhenOpen(object, old, value));
        }
    }

    public EntityInstance updateNewEntity(EntityClass ec, EntityInstance container) {
        EntityInstance e = this.getNewEntity(ec, container);
        if (this.undoEnabled()) {
            this.logEdit(new NewEntity(container, e));
        }
        return e;
    }

    public void updateFontDelta(EntityInstance e, int value) {
        int old = e.getFontDelta();
        if (old != value) {
            this.setFontDelta(e, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetFontDelta(e, old, value));
            }
        }
    }

    public void shiftDeltaFont(EntityInstance e, int delta) {
        this.updateFontDelta(e, e.getFontDelta() + delta);
    }

    public void updateXRelLocal(EntityInstance e, double value) {
        double old = e.xRelLocal();
        if (value < 0.0) {
            value = 0.0;
        }
        if (value != old) {
            this.setXRelLocal(e, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetXRelLocal(e, old, value));
            }
        }
    }

    public void updateYRelLocal(EntityInstance e, double value) {
        double old = e.yRelLocal();
        if (value < 0.0) {
            value = 0.0;
        }
        if (value != old) {
            this.setYRelLocal(e, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetYRelLocal(e, old, value));
            }
        }
    }

    public void updateWidthRelLocal(EntityInstance e, double value) {
        double old = e.widthRelLocal();
        if (value > 1.0) {
            value = 1.0;
        }
        if (e.xRelLocal() + value > 1.0) {
            this.updateRelLocal(e, 1.0 - value, e.yRelLocal(), value, e.heightRelLocal());
            return;
        }
        if (value != old) {
            this.setWidthRelLocal(e, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetWidthRelLocal(e, old, value));
            }
        }
    }

    public void updateHeightRelLocal(EntityInstance e, double value) {
        double old = e.heightRelLocal();
        if (value > 1.0) {
            value = 1.0;
        }
        if (e.yRelLocal() + value > 1.0) {
            this.updateRelLocal(e, e.xRelLocal(), 1.0 - value, e.widthRelLocal(), value);
            return;
        }
        if (value != old) {
            this.setHeightRelLocal(e, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetHeightRelLocal(e, old, value));
            }
        }
    }

    public void updateSizeRelLocal(EntityInstance e, double widthRelLocal, double heightRelLocal) {
        double oldWidthRelLocal = e.widthRelLocal();
        double oldHeightRelLocal = e.heightRelLocal();
        boolean shifted = false;
        if (widthRelLocal > 1.0) {
            widthRelLocal = 1.0;
        }
        if (heightRelLocal > 1.0) {
            heightRelLocal = 1.0;
        }
        if (oldWidthRelLocal == widthRelLocal) {
            this.updateHeightRelLocal(e, heightRelLocal);
            return;
        }
        if (oldHeightRelLocal == heightRelLocal) {
            this.updateWidthRelLocal(e, widthRelLocal);
            return;
        }
        double xRelLocal = e.xRelLocal();
        double yRelLocal = e.yRelLocal();
        if (xRelLocal + widthRelLocal > 1.0) {
            xRelLocal = 1.0 - widthRelLocal;
            shifted = true;
        }
        if (yRelLocal + heightRelLocal > 1.0) {
            yRelLocal = 1.0 - heightRelLocal;
            shifted = true;
        }
        if (shifted) {
            this.updateRelLocal(e, xRelLocal, yRelLocal, widthRelLocal, heightRelLocal);
            return;
        }
        this.setSizeRelLocal(e, widthRelLocal, heightRelLocal);
        if (this.undoEnabled()) {
            this.logEdit(new SetSizeRelLocal(e, oldWidthRelLocal, oldHeightRelLocal, widthRelLocal, heightRelLocal));
        }
    }

    public void updateLocationRelLocal(EntityInstance e, double xRelLocal, double yRelLocal) {
        double oldXRelLocal = e.xRelLocal();
        double oldYRelLocal = e.yRelLocal();
        if (xRelLocal < 0.0) {
            xRelLocal = 0.0;
        }
        if (yRelLocal < 0.0) {
            yRelLocal = 0.0;
        }
        if (xRelLocal == oldXRelLocal) {
            this.updateYRelLocal(e, yRelLocal);
            return;
        }
        if (yRelLocal == oldYRelLocal) {
            this.updateXRelLocal(e, xRelLocal);
            return;
        }
        this.setLocationRelLocal(e, xRelLocal, yRelLocal);
        if (this.undoEnabled()) {
            this.logEdit(new SetLocationRelLocal(e, oldXRelLocal, oldYRelLocal, xRelLocal, yRelLocal));
        }
    }

    public void updateRelLocal(EntityInstance e, double xRelLocal, double yRelLocal, double widthRelLocal, double heightRelLocal) {
        double oldXRelLocal = e.xRelLocal();
        double oldYRelLocal = e.yRelLocal();
        double oldWidthRelLocal = e.widthRelLocal();
        double oldHeightRelLocal = e.heightRelLocal();
        if (xRelLocal < 0.0) {
            xRelLocal = 0.0;
        }
        if (yRelLocal < 0.0) {
            yRelLocal = 0.0;
        }
        if (widthRelLocal > 1.0) {
            widthRelLocal = 1.0;
        }
        if (heightRelLocal > 1.0) {
            heightRelLocal = 1.0;
        }
        if (xRelLocal + widthRelLocal > 1.0) {
            xRelLocal = 1.0 - widthRelLocal;
        }
        if (yRelLocal + heightRelLocal > 1.0) {
            yRelLocal = 1.0 - heightRelLocal;
        }
        if (oldXRelLocal == xRelLocal && oldYRelLocal == yRelLocal) {
            this.updateSizeRelLocal(e, widthRelLocal, heightRelLocal);
            return;
        }
        if (oldWidthRelLocal == widthRelLocal && oldHeightRelLocal == heightRelLocal) {
            this.updateLocationRelLocal(e, xRelLocal, yRelLocal);
            return;
        }
        this.setRelLocal(e, xRelLocal, yRelLocal, widthRelLocal, heightRelLocal);
        if (this.undoEnabled()) {
            this.logEdit(new SetRelLocal(e, oldXRelLocal, oldYRelLocal, oldWidthRelLocal, oldHeightRelLocal, xRelLocal, yRelLocal, widthRelLocal, heightRelLocal));
        }
    }

    public void updateLiftEntityEdges(EntityInstance e) {
        EntityInstance parent = e.getContainedBy();
        if (parent == null || parent == this.m_rootInstance) {
            return;
        }
        if (this.undoEnabled()) {
            this.logEdit(new LiftEntityEdges(e));
        }
        this.liftRelations(e, parent);
    }

    public void updateLiftEdges(EntityInstance rootedAt) {
        if (rootedAt.getEntityClass().isActive()) {
            this.updateLiftEntityEdges(rootedAt);
        }
        Enumeration en = rootedAt.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            this.updateLiftEdges(child);
        }
    }

    public boolean updateCutEntity(EntityInstance e) {
        boolean ret = this.cutEntity(e);
        if (ret && this.undoEnabled()) {
            this.logEdit(new CutEntity(e));
        }
        return ret;
    }

    public void updateDeleteActiveEntities(EntityInstance rootedAt) {
        if (!rootedAt.isMarked(16) && rootedAt.getEntityClass().isActive()) {
            this.updateCutEntity(rootedAt);
            return;
        }
        Vector srcRelList = rootedAt.getSrcRelList();
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                this.updateDeleteActiveEntities(ri.getDst());
            }
        }
    }

    public void updateDeleteActiveEdges(EntityInstance rootedAt) {
        EntityClass ec;
        Vector dstRelList = rootedAt.getDstRelList();
        if (dstRelList != null && (ec = rootedAt.getEntityClass()).isActive()) {
            int i = dstRelList.size();
            while (i > 0) {
                RelationInstance ri;
                if (!(ri = (RelationInstance)dstRelList.elementAt(--i)).getRelationClass().isActive()) continue;
                this.updateDeleteEdge(ri);
            }
        }
        Enumeration en = rootedAt.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            this.updateDeleteActiveEdges(child);
        }
    }

    public void updateMoveEntityContainment(EntityInstance newContainer, EntityInstance me) {
        EntityInstance oldContainer = me.getContainedBy();
        if (this.moveEntityContainment(newContainer, me) && this.undoEnabled()) {
            this.logEdit(new MoveEntityContainment(me, oldContainer, newContainer));
        }
    }

    public void updateMovePlaceEntityContainment(EntityInstance newContainer, EntityInstance me) {
        double xrel1 = me.xRelLocal();
        double yrel1 = me.yRelLocal();
        double widthrel1 = me.widthRelLocal();
        double heightrel1 = me.heightRelLocal();
        me.setInitialLocation(newContainer);
        double xrel2 = me.xRelLocal();
        double yrel2 = me.yRelLocal();
        double widthrel2 = me.widthRelLocal();
        double heightrel2 = me.heightRelLocal();
        me.setRelLocal(xrel1, yrel1, widthrel1, heightrel1);
        this.updateMoveEntityContainment(newContainer, me);
        this.updateRelLocal(me, xrel2, yrel2, widthrel2, heightrel2);
    }

    public boolean updateDeleteContainer(EntityInstance e) {
        boolean ret = this.deleteContainer(e);
        if (ret && this.undoEnabled()) {
            this.logEdit(new UpdateDeleteContainer(e));
        }
        return ret;
    }

    public void updateDeleteActiveContainers(EntityInstance rootedAt) {
        Vector srcRelList = rootedAt.getSrcRelList();
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                this.updateDeleteActiveContainers(ri.getDst());
            }
        }
        if (!rootedAt.isMarked(16) && rootedAt.getEntityClass().isActive()) {
            this.updateDeleteContainer(rootedAt);
        }
    }

    public EntityInstance updateClusterEntity(EntityInstance container, EntityInstance e) {
        EntityInstance ret = this.clusterEntity(container, e);
        if (this.undoEnabled()) {
            this.logEdit(new ClusterEntity(container, ret));
        }
        return ret;
    }

    public EntityInstance updateImportEntity(EntityInstance container, EntityInstance e, EntityInstance match) {
        EntityInstance ret;
        if (!this.undoEnabled()) {
            ret = this.importEntity(container, e, match);
        } else {
            ImportEntity ie = new ImportEntity(container, e, match);
            this.logEdit(ie);
            ret = ie.getEntity();
        }
        return ret;
    }

    public void updateInherits(LandscapeClassObject object, Vector value) {
        Vector old = object.getInheritsFrom();
        if (old.size() != value.size() || !value.containsAll(old)) {
            this.setInherits(object, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetInherits(object, old, value));
            }
        }
    }

    private Vector cacheEntityClassPairs(EntityClass ec) {
        Vector<EntityClassPair> eps = null;
        Enumeration en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            Vector relationList = rc.getRelationList();
            if (relationList == null) continue;
            int i = relationList.size();
            while (i > 0) {
                EntityClassPair ep = (EntityClassPair)relationList.elementAt(--i);
                if (ep.m_entityClass1 != ec && ep.m_entityClass2 != ec) continue;
                if (eps == null) {
                    eps = new Vector<EntityClassPair>();
                }
                eps.addElement(ep);
            }
        }
        return eps;
    }

    public void updateNewEntityClass(String id, EntityClass baseClass) {
        EntityClass ec = this.newEntityClass(id, baseClass);
        if (this.undoEnabled()) {
            this.logEdit(new NewEntityClass(ec, id, baseClass));
        }
    }

    public void updateRemoveEntityClass(EntityClass ec) {
        if (this.undoEnabled()) {
            this.logEdit(new RemoveEntityClass(ec, this.cacheEntityClassPairs(ec), this.m_defaultEntityClass));
        }
        this.removeEntityClass(ec);
    }

    public void updateImage(EntityClass ec, int value) {
        int old = ec.getImage();
        if (old != value) {
            this.setImage(ec, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetImage(ec, old, value));
            }
        }
    }

    public void updateAngle(EntityClass ec, double value) {
        double old = ec.getAngle();
        if (value != old) {
            this.setAngle(ec, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetAngle(ec, old, value));
            }
        }
    }

    public void updateIconFile(EntityClass ec, String value) {
        String old = ec.getUnscaledIconFile();
        if (old != value) {
            this.setUnscaledIconFile(ec, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetUnscaledIconFile(ec, old, value));
            }
        }
    }

    public RelationClass updateNewRelationClass(String id, RelationClass baseClass) {
        RelationClass rc = this.newRelationClass(id, baseClass);
        if (this.undoEnabled()) {
            this.logEdit(new NewRelationClass(rc, id, baseClass));
        }
        return rc;
    }

    public void updateRemoveRelationClass(RelationClass rc) {
        if (this.undoEnabled()) {
            this.logEdit(new RemoveRelationClass(rc, this.m_defaultRelationClass));
        }
        this.removeRelationClass(rc);
    }

    public void updateArrowColor(RelationClass object, Color value) {
        Color old = object.getArrowColor();
        if (old != value) {
            this.setArrowColor(object, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetArrowColor(object, old, value));
            }
        }
    }

    public void updateIOfactor(RelationClass object, short value) {
        short old = object.getIOfactor();
        if (old != value) {
            this.setIOfactor(object, value);
            if (this.undoEnabled()) {
                this.logEdit(new SetIOfactor(object, old, value));
            }
        }
    }

    public void updateSwitchContainsClasses(RelationClass[] newContainsClasses) {
        if (this.undoEnabled()) {
            this.logEdit(new SwitchContainsClasses(newContainsClasses, this.m_containsClasses));
        }
        this.switchContainsClasses(newContainsClasses);
    }

    public void setValueAt(LandscapeObject object, Object value, int row) {
        if (object instanceof EntityInstance) {
            EntityInstance e = (EntityInstance)object;
            switch (row) {
                case 0: {
                    return;
                }
                case 1: {
                    if (value != null) {
                        LandscapeClassObject parentClass = e.getParentClass();
                        String newId = (String)value;
                        if (parentClass == null || !parentClass.getLabelId().equals(newId)) {
                            Enumeration en = this.enumEntityClasses();
                            while (en.hasMoreElements()) {
                                EntityClass ec = (EntityClass)en.nextElement();
                                if (!ec.getLabelId().equals(newId)) continue;
                                this.updateParentClass(e, ec);
                                break;
                            }
                        }
                    }
                    return;
                }
                case 2: {
                    this.updateLabel(e, (String)value);
                    return;
                }
                case 3: {
                    this.updateDescription(e, (String)value);
                    return;
                }
                case 4: {
                    this.updateObjectColor(e, (Color)value);
                    return;
                }
                case 5: {
                    this.updateLabelColor(e, (Color)value);
                    return;
                }
                case 6: {
                    this.updateColorWhenOpen(e, (Color)value);
                    return;
                }
                case 7: {
                    this.updateXRelLocal(e, (Double)value);
                    return;
                }
                case 8: {
                    this.updateYRelLocal(e, (Double)value);
                    return;
                }
                case 9: {
                    this.updateWidthRelLocal(e, (Double)value);
                    return;
                }
                case 10: {
                    this.updateHeightRelLocal(e, (Double)value);
                    return;
                }
                case 11: {
                    this.updateFontDelta(e, (Integer)value);
                    return;
                }
            }
        } else if (object instanceof RelationInstance) {
            RelationInstance ri = (RelationInstance)object;
            switch (row) {
                case 0: {
                    if (value != null) {
                        LandscapeClassObject parentClass = ri.getParentClass();
                        String newId = (String)value;
                        if (parentClass == null || !parentClass.getLabelId().equals(newId)) {
                            Enumeration en = this.enumRelationClasses();
                            while (en.hasMoreElements()) {
                                RelationClass ec = (RelationClass)en.nextElement();
                                if (!ec.getLabelId().equals(newId)) continue;
                                this.updateParentClass(ri, ec);
                                break;
                            }
                        }
                    }
                    return;
                }
                case 1: {
                    this.updateObjectColor(ri, (Color)value);
                    return;
                }
                case 2: {
                    this.updateStyle(ri, (Integer)value);
                    return;
                }
            }
        } else if (object instanceof EntityClass) {
            EntityClass ec = (EntityClass)object;
            switch (row) {
                case 0: {
                    return;
                }
                case 1: {
                    this.updateLabel(ec, (String)value);
                    return;
                }
                case 2: {
                    this.updateDescription(ec, (String)value);
                    return;
                }
                case 3: {
                    this.updateStyle(ec, (Integer)value);
                    return;
                }
                case 4: {
                    this.updateAngle(ec, (Double)value);
                    return;
                }
                case 9: {
                    this.updateIconFile(ec, (String)value);
                    return;
                }
                case 5: {
                    this.updateImage(ec, (Integer)value);
                    return;
                }
                case 6: {
                    this.updateObjectColor(ec, (Color)value);
                    return;
                }
                case 7: {
                    this.updateLabelColor(ec, (Color)value);
                    return;
                }
                case 8: {
                    this.updateColorWhenOpen(ec, (Color)value);
                    return;
                }
            }
        } else if (object instanceof RelationClass) {
            RelationClass rc = (RelationClass)object;
            switch (row) {
                case 0: {
                    return;
                }
                case 1: {
                    this.updateLabel(rc, (String)value);
                    return;
                }
                case 2: {
                    this.updateReversedLabel(rc, (String)value);
                    return;
                }
                case 3: {
                    this.updateDescription(rc, (String)value);
                    return;
                }
                case 4: {
                    this.updateStyle(rc, (Integer)value);
                    return;
                }
                case 5: {
                    this.updateObjectColor(rc, (Color)value);
                    return;
                }
                case 6: {
                    this.updateLabelColor(rc, (Color)value);
                    return;
                }
                case 7: {
                    this.updateIOfactor(rc, Util.relativeToShort((Double)value));
                    return;
                }
                case 8: {
                    this.updateArrowColor(rc, (Color)value);
                    return;
                }
            }
        }
        this.updateAttributeValueAt(object, row, value);
    }

    public boolean updateCutClipboard(Clipboard old_clipboard, Clipboard new_clipboard) {
        boolean ok = this.cutClipboard(new_clipboard);
        if (ok && this.undoEnabled()) {
            this.logEdit(new CutClipboard(this, old_clipboard, new_clipboard));
        }
        return ok;
    }

    public void updatePasteClipboard(Clipboard clipboard, EntityInstance pe) {
        this.pasteClipboard(clipboard, pe);
        if (this.undoEnabled()) {
            this.logEdit(new PasteClipboard(this, clipboard, pe));
        }
    }

    class ImportEntity
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_container;
        EntityInstance m_e;
        EntityInstance m_match;
        EntityInstance m_ret;
        EntityClass m_old_match_parentClass;
        EntityInstance m_old_match_containedBy;
        double m_old_match_x;
        double m_old_match_y;
        double m_old_match_width;
        double m_old_match_height;

        ImportEntity(EntityInstance container, EntityInstance e, EntityInstance match) {
            this.m_container = container;
            this.m_e = e;
            this.m_match = match;
            this.m_old_match_parentClass = (EntityClass)match.getParentClass();
            this.m_old_match_containedBy = match.getContainedBy();
            this.m_old_match_x = match.xRelLocal();
            this.m_old_match_y = match.yRelLocal();
            this.m_old_match_width = match.widthRelLocal();
            this.m_old_match_height = match.heightRelLocal();
            this.m_ret = TemporalTa.this.importEntity(container, e, match);
        }

        public EntityInstance getEntity() {
            return this.m_ret;
        }

        @Override
        public String getPresentationName() {
            return "Import entity " + this.m_e;
        }

        @Override
        public void undo() {
            EntityInstance match = this.m_match;
            match.setRelLocal(this.m_old_match_x, this.m_old_match_y, this.m_old_match_width, this.m_old_match_height);
            TemporalTa.this.moveEntityContainment(this.m_old_match_containedBy, match);
            match.setParentClass(this.m_old_match_parentClass);
        }

        @Override
        public void redo() {
            this.m_ret = TemporalTa.this.importEntity(this.m_container, this.m_e, this.m_match);
        }
    }
}

