/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;

public class TabBox
extends JComponent {
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected String m_tabLabel;

    public TabBox(LandscapeEditorCore ls, JTabbedPane tabbedPane, String tabLabel, String helpString) {
        Insets insets = tabbedPane.getInsets();
        int width = tabbedPane.getWidth() - insets.left - insets.right;
        int height = tabbedPane.getHeight() - insets.top - insets.bottom;
        this.setLayout(null);
        this.setLocation(0, 0);
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_tabLabel = tabLabel;
        this.setBackground(Diagram.boxColor);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setBounds(0, 0, width, height);
        this.setSize(width, height);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab(tabLabel, null, this.m_scrollPane, helpString);
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        return this.m_scrollPane == this.m_tabbedPane.getSelectedComponent();
    }

    public void diagramChanging(Diagram diagram) {
    }

    public void diagramChanged(Diagram diagram, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored diagram change");
    }

    public void updateBegins() {
    }

    public void updateEnds() {
    }

    public void entityClassChanged(EntityClass ec, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored entityClassChanged");
    }

    public void relationClassChanged(RelationClass rc, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored relationClassChanged");
    }

    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored entityParentChanged");
    }

    public void relationParentChanged(RelationInstance ri, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored relationParentChanged");
    }

    public void entityInstanceChanged(EntityInstance e, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored entityInstanceChanged");
    }

    public void relationInstanceChanged(RelationInstance ri, int signal) {
        System.out.println(String.valueOf(this.m_tabLabel) + " TabBox ignored relationInstanceChanged");
    }
}

