/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import lsedit.StringCache;

public class TA_StreamTokenizer {
    private static final byte CT_DELIMIT = 2;
    private static final byte CT_QUOTE = 3;
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -2;
    private Reader m_reader;
    private String m_filename;
    private int m_peekc = 32;
    private boolean m_pushedBack;
    private boolean m_escaped;
    private static char[] m_ctype;
    private int m_buf_size = 20480;
    private char[] m_buf = new char[this.m_buf_size];
    private int m_ttype = 32;
    protected String m_sval;
    public String m_comments = null;

    private void dumpBuf(int lth) {
        System.out.print("(" + lth + ") ");
        int i = 0;
        while (i < lth && i < 30) {
            System.out.print(this.m_buf[i]);
            ++i;
        }
        if (lth > 30) {
            System.out.print(" ... ");
            i = lth - 30;
            if (i < 30) {
                i = 30;
            }
            while (i < lth) {
                System.out.print(this.m_buf[i]);
                ++i;
            }
        }
    }

    private int enlargeBuffer() {
        int buf_size = this.m_buf_size;
        int new_buf_size = buf_size * 2;
        char[] new_buf = new char[new_buf_size];
        System.arraycopy(this.m_buf, 0, new_buf, 0, buf_size);
        this.m_buf_size = new_buf_size;
        this.m_buf = new_buf;
        return new_buf_size;
    }

    protected void close() {
        try {
            this.m_reader.close();
        }
        catch (Exception e) {
            System.out.println("TA_StreamTokenizer::close() " + e.getMessage());
        }
        this.m_reader = null;
    }

    public TA_StreamTokenizer(Reader reader, String filename) {
        if (m_ctype == null) {
            m_ctype = new char[256];
            TA_StreamTokenizer.m_ctype[32] = 2;
            TA_StreamTokenizer.m_ctype[12] = 2;
            TA_StreamTokenizer.m_ctype[9] = 2;
            TA_StreamTokenizer.m_ctype[13] = 2;
            TA_StreamTokenizer.m_ctype[10] = 2;
            TA_StreamTokenizer.m_ctype[61] = 2;
            TA_StreamTokenizer.m_ctype[123] = 2;
            TA_StreamTokenizer.m_ctype[125] = 2;
            TA_StreamTokenizer.m_ctype[40] = 2;
            TA_StreamTokenizer.m_ctype[41] = 2;
        }
        this.m_reader = reader;
        this.m_filename = filename;
    }

    private final int charToken() throws IOException {
        int c = this.m_peekc;
        this.m_peekc = this.m_reader.read();
        switch (c) {
            case 92: {
                switch (this.m_peekc) {
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 101: {
                        c = 27;
                        break;
                    }
                    case 100: {
                        c = 127;
                    }
                    case 92: {
                        this.m_peekc = 32;
                        break;
                    }
                    case 34: {
                        c = 34;
                        this.m_escaped = true;
                        break;
                    }
                    case 39: {
                        c = 39;
                        this.m_escaped = true;
                        break;
                    }
                    default: {
                        c = this.m_peekc;
                    }
                }
                this.charToken();
                break;
            }
            case 34: 
            case 39: {
                this.m_escaped = false;
            }
        }
        return c;
    }

    protected final void pushBack(int ttype) {
        this.m_ttype = ttype;
        this.m_pushedBack = true;
    }

    public String filename() {
        return this.m_filename;
    }

    public int lineno() {
        if (this.m_reader instanceof LineNumberReader) {
            return ((LineNumberReader)this.m_reader).getLineNumber();
        }
        return 0;
    }

    public final int nextToken() throws IOException {
        int c;
        if (this.m_pushedBack) {
            this.m_pushedBack = false;
            return this.m_ttype;
        }
        int buf_size = this.m_buf_size;
        char[] buf = this.m_buf;
        int pos = 0;
        this.m_sval = null;
        block27: while (true) {
            c = this.charToken();
            switch (c) {
                case -1: {
                    this.m_sval = "EOF";
                    return -1;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block27;
                }
                case 34: {
                    block28: while (true) {
                        c = this.charToken();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated \" in input");
                            }
                            case 34: {
                                if (!this.m_escaped) break block28;
                            }
                            default: {
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = (char)c;
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.m_sval = StringCache.get(buf, pos);
                    return -2;
                }
                case 39: {
                    block29: while (true) {
                        c = this.charToken();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated ' in input");
                                break block29;
                            }
                            case 39: {
                                if (!this.m_escaped) break block29;
                            }
                            default: {
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = (char)c;
                                continue block29;
                            }
                        }
                        break;
                    }
                    this.m_sval = StringCache.get(buf, pos);
                    return -2;
                }
                case 47: {
                    switch (this.m_peekc) {
                        case 47: {
                            String comment = this.m_comments == null ? null : "/";
                            block30: while (true) {
                                c = this.charToken();
                                if (comment != null && c != -1) {
                                    comment = String.valueOf(comment) + (char)c;
                                }
                                switch (c) {
                                    case 13: {
                                        if (this.m_peekc != 10) break block30;
                                        continue block30;
                                    }
                                    case -1: 
                                    case 10: {
                                        break block30;
                                    }
                                    default: {
                                        continue block30;
                                    }
                                }
                                break;
                            }
                            if (comment == null) continue block27;
                            this.m_comments = String.valueOf(this.m_comments) + comment;
                            continue block27;
                        }
                        case 42: {
                            String comment = this.m_comments == null ? null : "/*";
                            block31: while (true) {
                                c = this.charToken();
                                if (comment != null && c != -1) {
                                    comment = String.valueOf(comment) + (char)c;
                                }
                                switch (c) {
                                    case 42: {
                                        if (this.m_peekc != 47) continue block31;
                                        c = this.charToken();
                                        if (comment == null) break block31;
                                        comment = String.valueOf(comment) + "/\n";
                                    }
                                    case -1: {
                                        break block31;
                                    }
                                    default: {
                                        continue block31;
                                    }
                                }
                                break;
                            }
                            if (comment == null) continue block27;
                            this.m_comments = String.valueOf(this.m_comments) + comment;
                            continue block27;
                        }
                    }
                }
            }
            break;
        }
        if (c < m_ctype.length && m_ctype[c] == '\u0002') {
            this.m_sval = String.valueOf((char)c);
            return c;
        }
        while (true) {
            if (pos >= buf_size) {
                buf_size = this.enlargeBuffer();
                buf = this.m_buf;
            }
            buf[pos++] = (char)c;
            if (this.m_peekc == -1) break;
            if (c == 92) {
                if (pos >= buf_size) {
                    buf_size = this.enlargeBuffer();
                    buf = this.m_buf;
                }
                buf[pos++] = (char)this.charToken();
            }
            if (c < m_ctype.length && m_ctype[this.m_peekc] != '\u0000') break;
            c = this.charToken();
        }
        this.m_sval = StringCache.get(buf, pos);
        if (pos == 1 && buf[0] == ':') {
            return 58;
        }
        return -2;
    }

    private final int charAVI() throws IOException {
        int c = this.m_peekc;
        this.m_peekc = this.m_reader.read();
        return c;
    }

    public final String nextAVI() throws IOException {
        int depth = 0;
        int buf_size = this.m_buf_size;
        char[] buf = this.m_buf;
        int pos = 0;
        int tokens = 0;
        int startbracket = -1;
        block37: while (true) {
            int c = this.charAVI();
            switch (c) {
                case -1: {
                    return null;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block37;
                }
                case 34: {
                    ++tokens;
                    int start = pos;
                    buf[pos++] = 34;
                    boolean escaped = false;
                    boolean simple = true;
                    block38: while (true) {
                        c = this.charAVI();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated \" in input");
                            }
                            case 92: {
                                boolean bl = escaped = !escaped;
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = 92;
                                simple = false;
                                continue block38;
                            }
                            case 34: {
                                if (!escaped) break block38;
                            }
                            case 39: {
                                simple = false;
                            }
                            default: {
                                if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                                    simple = false;
                                }
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = (char)c;
                                escaped = false;
                                continue block38;
                            }
                        }
                        break;
                    }
                    if (!simple) {
                        if (pos >= buf_size) {
                            buf_size = this.enlargeBuffer();
                            buf = this.m_buf;
                        }
                        buf[pos++] = 34;
                        break;
                    }
                    --pos;
                    while (++start <= pos) {
                        buf[start - 1] = buf[start];
                    }
                    break;
                }
                case 39: {
                    ++tokens;
                    int start = pos;
                    buf[pos++] = 39;
                    boolean escaped = false;
                    boolean simple = true;
                    block40: while (true) {
                        c = this.charAVI();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated ' in input");
                                break block40;
                            }
                            case 92: {
                                boolean bl = escaped = !escaped;
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = 92;
                                simple = false;
                                continue block40;
                            }
                            case 39: {
                                if (!escaped) break block40;
                            }
                            case 34: {
                                simple = false;
                            }
                            default: {
                                if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                                    simple = false;
                                }
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = (char)c;
                                escaped = false;
                                continue block40;
                            }
                        }
                        break;
                    }
                    if (!simple) {
                        if (pos >= buf_size) {
                            buf_size = this.enlargeBuffer();
                            buf = this.m_buf;
                        }
                        buf[pos++] = 39;
                        break;
                    }
                    --pos;
                    while (++start <= pos) {
                        buf[start - 1] = buf[start];
                    }
                    break;
                }
                case 40: {
                    startbracket = pos;
                    if (pos >= buf_size) {
                        buf_size = this.enlargeBuffer();
                        buf = this.m_buf;
                    }
                    buf[pos++] = 40;
                    if (depth != 0) {
                        tokens = 2;
                    }
                    ++depth;
                    continue block37;
                }
                case 41: {
                    int i;
                    if (depth <= 0) {
                        System.out.println("Bad nesting of () at " + this.lineno());
                        return null;
                    }
                    switch (buf[pos - 1]) {
                        case '(': {
                            System.out.println("Empty nesting of () at " + this.lineno());
                            --pos;
                            break;
                        }
                        case ' ': {
                            --pos;
                        }
                        default: {
                            if (tokens != 1) {
                                if (pos >= buf_size) {
                                    buf_size = this.enlargeBuffer();
                                    buf = this.m_buf;
                                }
                                buf[pos++] = 41;
                                break;
                            }
                            --pos;
                            i = startbracket;
                            while (i < pos) {
                                buf[i] = buf[i + 1];
                                ++i;
                            }
                            break block21;
                        }
                    }
                    --depth;
                    break;
                }
                case 47: {
                    switch (this.m_peekc) {
                        case 47: {
                            String comment = this.m_comments == null ? null : "/";
                            block43: while (true) {
                                c = this.charAVI();
                                if (comment != null && c != -1) {
                                    comment = String.valueOf(comment) + (char)c;
                                }
                                switch (c) {
                                    case 13: {
                                        if (this.m_peekc != 10) break block43;
                                        continue block43;
                                    }
                                    case -1: 
                                    case 10: {
                                        break block43;
                                    }
                                    default: {
                                        continue block43;
                                    }
                                }
                                break;
                            }
                            if (comment == null) continue block37;
                            this.m_comments = String.valueOf(this.m_comments) + comment;
                            continue block37;
                        }
                        case 42: {
                            String comment = this.m_comments == null ? null : "/*";
                            block44: while (true) {
                                c = this.charAVI();
                                if (comment != null && c != -1) {
                                    comment = String.valueOf(comment) + (char)c;
                                }
                                switch (c) {
                                    case 42: {
                                        if (this.m_peekc != 47) continue block44;
                                        c = this.charAVI();
                                        if (comment == null) break block44;
                                        comment = String.valueOf(comment) + "/\n";
                                    }
                                    case -1: {
                                        break block44;
                                    }
                                    default: {
                                        continue block44;
                                    }
                                }
                                break;
                            }
                            if (comment == null) continue block37;
                            this.m_comments = String.valueOf(this.m_comments) + comment;
                            continue block37;
                        }
                    }
                }
                default: {
                    if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                        this.pushBack(c);
                        return null;
                    }
                    ++tokens;
                    int start = pos;
                    boolean simple = true;
                    while (true) {
                        if (c == 92) {
                            simple = false;
                        }
                        if (pos >= buf_size) {
                            buf_size = this.enlargeBuffer();
                            buf = this.m_buf;
                        }
                        buf[pos++] = (char)c;
                        if (this.m_peekc == -1 || c < m_ctype.length && m_ctype[this.m_peekc] != '\u0000') break;
                        c = this.charAVI();
                    }
                    if (simple) break;
                    if (pos >= buf_size) {
                        buf_size = this.enlargeBuffer();
                        buf = this.m_buf;
                    }
                    int i = pos;
                    while (i >= start) {
                        buf[i + 1] = buf[i];
                        --i;
                    }
                    buf[start] = 34;
                    if (pos >= buf_size) {
                        buf_size = this.enlargeBuffer();
                        buf = this.m_buf;
                    }
                    buf[pos++] = 34;
                }
            }
            if (depth <= 0) break;
            if (pos >= buf_size) {
                buf_size = this.enlargeBuffer();
                buf = this.m_buf;
            }
            buf[pos++] = 32;
        }
        if (tokens == 0) {
            return null;
        }
        return StringCache.get(buf, pos);
    }
}

