/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.FontMetrics;

public class StringLinizer {
    protected FontMetrics fm;
    protected int width;
    protected String input;
    protected char[] inputchars;
    protected int start;
    protected int lth;
    private static char[] a0;

    static {
        char[] cArray = new char[9];
        cArray[0] = 60;
        cArray[1] = 97;
        cArray[2] = 32;
        cArray[3] = 104;
        cArray[4] = 114;
        cArray[5] = 101;
        cArray[6] = 102;
        cArray[7] = 61;
        a0 = cArray;
    }

    public StringLinizer(String str, FontMetrics fm, int width) {
        this.fm = fm;
        this.width = width;
        this.input = str;
        this.start = 0;
        this.lth = str.length();
        this.inputchars = this.input.toCharArray();
    }

    public boolean hasMoreLines() {
        return this.start < this.lth;
    }

    public int charsWidth(int start, int toend) {
        boolean inText = true;
        int width = 0;
        int i = start;
        while (i < toend) {
            char c = this.inputchars[i];
            switch (c) {
                case '<': {
                    inText = false;
                    break;
                }
                case '>': {
                    if (inText) {
                        width = 0;
                        break;
                    }
                    inText = false;
                    break;
                }
                default: {
                    if (!inText) break;
                    width += this.fm.charWidth((int)c);
                }
            }
            ++i;
        }
        return width;
    }

    public String nextLine() {
        int ind;
        int at;
        int best = this.start;
        while (best < this.lth) {
            if (this.inputchars[best] == '\\' ? this.inputchars[best + 1] == 'n' : this.inputchars[best] == '\n') break;
            ++best;
        }
        if (this.charsWidth(this.start, best) <= this.width) {
            at = best;
        } else {
            int subwidth;
            boolean state = false;
            at = --best;
            block9: while (at > this.start) {
                switch (this.inputchars[--at]) {
                    case '\r': 
                    case '<': {
                        state = true;
                        continue block9;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': 
                    case '\"': 
                    case '-': 
                    case '=': 
                    case '>': {
                        state = true;
                        break;
                    }
                    default: {
                        if (!state) continue block9;
                        state = false;
                    }
                }
                subwidth = this.charsWidth(this.start, at + 1);
                if (subwidth <= this.width) {
                    ++at;
                    break;
                }
                best = at;
            }
            if (at <= this.start) {
                at = best;
                while (--at > this.start) {
                    subwidth = this.charsWidth(this.start, at);
                    if (subwidth <= this.width) break;
                }
            }
            if (at <= this.start) {
                this.start = this.lth;
                return "";
            }
        }
        String rest = this.input.substring(this.start, at);
        this.start = at;
        if (this.start < this.lth) {
            switch (this.inputchars[this.start]) {
                case '\\': {
                    if (this.start >= this.lth - 1 || this.inputchars[this.start + 1] == 'n') break;
                    this.start += 2;
                    break;
                }
                case '\n': {
                    ++this.start;
                }
            }
        }
        while ((ind = rest.indexOf(9)) >= 0) {
            String a = ind != 0 ? rest.substring(0, ind) : "";
            String b = ind < rest.length() - 1 ? rest.substring(ind + 1) : "";
            rest = String.valueOf(a) + "    " + b;
        }
        return rest;
    }
}

