/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationInstance;
import lsedit.SpringNode;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SpringLayout2
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int STIFFNESS = 0;
    protected static final int REPULSION = 1;
    protected static final int ATTRACTION = 2;
    protected static final int CLIENT_WEIGHT = 3;
    protected static final int SUPPLIER_WEIGHT = 4;
    protected static final int GAP = 5;
    protected static final int BORDER = 6;
    protected static final int ITERATIONS = 7;
    protected static final int TIMEOUT = 8;
    protected static final String[] m_textfield_tags = new String[]{"spring2:stiffness", "spring2:repulsion", "spring2:attraction", "spring2:clientweight", "spring2:supplierfactor", "spring2:gap", "spring2:border", "spring2:iterations", "spring2:timeout"};
    protected static final String[] m_textfield_titles = new String[]{"Edge stiffness", "Collision repulsion", "General attraction", "Client weight", "Supplier weight", "Ideal gap", "Border", "Iterations", "Time out"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.075", "0.005", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.075", "0.005", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.075", "0.005", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected double m_stiffness = 0.05;
    protected double m_repulsion = 0.075;
    protected double m_attraction = 0.005;
    protected double m_client_weight = 1.0;
    protected double m_supplier_weight = 1.0;
    protected double m_gap = 0.01;
    protected double m_border = 0.01;
    protected int m_iterations = 1000;
    protected long m_timeout = 300L;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles;
    protected static final String[] m_button_tips;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = "Ok";
        stringArray[1] = "Cancel";
        stringArray[2] = "Help";
        stringArray[4] = "Default";
        stringArray[5] = "Set";
        stringArray[6] = "Reset";
        m_button_titles = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[3] = "Enable/disable undo";
        stringArray2[4] = "Use remembered default";
        stringArray2[5] = "Set default to current";
        stringArray2[6] = "Set default to initial";
        m_button_tips = stringArray2;
    }

    @Override
    public String getTag() {
        return "spring2:";
    }

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            block1 : switch (i) {
                case 7: 
                case 8: {
                    int ival = Integer.parseInt(string);
                    switch (i) {
                        case 7: {
                            this.m_iterations = ival;
                            break;
                        }
                        case 8: {
                            this.m_timeout = ival;
                        }
                    }
                    break;
                }
                default: {
                    double dval = Double.parseDouble(string);
                    switch (i) {
                        case 0: {
                            this.m_stiffness = dval;
                            break block1;
                        }
                        case 1: {
                            this.m_repulsion = dval;
                            break block1;
                        }
                        case 2: {
                            this.m_attraction = dval;
                            break block1;
                        }
                        case 3: {
                            this.m_client_weight = dval;
                            break block1;
                        }
                        case 4: {
                            this.m_supplier_weight = dval;
                            break block1;
                        }
                        case 5: {
                            this.m_gap = dval;
                            break block1;
                        }
                        case 6: {
                            this.m_border = dval;
                        }
                    }
                }
            }
            SpringLayout2.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        int i = 0;
        while (i < textfield_resets.length) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
            ++i;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        int i = 0;
        while (i < textfield_tags.length) {
            if (attribute.equals(textfield_tags[i])) {
                switch (mode) {
                    case 0: {
                        SpringLayout2.m_textfield_defaults[i] = value;
                    }
                    case 1: {
                        this.setParameter(i, value);
                    }
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        String[] emit_strings;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                emit_strings = m_textfield_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                emit_strings = m_textfield_currents;
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < m_textfield_tags.length) {
            String string = emit_strings[i];
            if (!string.equals(prior_strings[i])) {
                ps.println(String.valueOf(m_textfield_tags[i]) + "=" + string);
            }
            ++i;
        }
    }

    public SpringLayout2(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Spring";
    }

    @Override
    public String getMenuLabel() {
        return "Layout using Springs";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        SpringConfigure configure = new SpringConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    public static void fitBorder(SpringNode[] springNodes, double border) {
        SpringNode springNode;
        int size = springNodes.length;
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        int i = 0;
        while (i < size) {
            double y1;
            springNode = springNodes[i];
            EntityInstance e = springNode.m_e;
            double x = springNode.m_x;
            double y = springNode.m_y;
            double width = e.widthRelLocal() / 2.0;
            double height = e.heightRelLocal() / 2.0;
            double x1 = x - width;
            if (x1 < xmin) {
                xmin = x1;
            }
            if ((x1 = x + width) > xmax) {
                xmax = x1;
            }
            if ((y1 = y - height) < ymin) {
                ymin = y1;
            }
            if ((y1 = y + height) > ymax) {
                ymax = y1;
            }
            ++i;
        }
        double mx = (1.0 - 2.0 * border) / (xmax - xmin);
        double cx = border - mx * xmin;
        double my = (1.0 - 2.0 * border) / (ymax - ymin);
        double cy = border - my * ymin;
        i = 0;
        while (i < size) {
            springNode = springNodes[i];
            springNode.m_x = mx * springNode.m_x + cx;
            springNode.m_y = my * springNode.m_y + cy;
            ++i;
        }
    }

    public static void place(SpringNode[] springNodes, boolean[][] related, int iterations, double gap, double border, double stiffness, double repulsion, double attraction, double client_weight, double supplier_weight, long timeout) {
        double height;
        double width;
        double y;
        double x;
        EntityInstance e;
        SpringNode springNode;
        int size = springNodes.length;
        double default_size = -1.0;
        boolean dir = false;
        int cycle = 100;
        repulsion *= -1.0;
        boolean compact_clients = false;
        boolean compact_suppliers = false;
        if (client_weight < 0.0) {
            compact_clients = true;
            client_weight = -client_weight;
        }
        if (supplier_weight < 0.0) {
            compact_suppliers = true;
            supplier_weight = -supplier_weight;
        }
        int i = 0;
        while (i < size) {
            springNode = springNodes[i];
            e = springNode.m_e;
            x = e.xRelLocal();
            y = e.yRelLocal();
            width = e.widthRelLocal();
            height = e.heightRelLocal();
            if (x < 0.0) {
                x = 0.5;
            }
            if (y < 0.0) {
                y = 0.5;
            }
            if (width < 0.0 || height < 0.0) {
                int rows;
                if (default_size < 0.0 && (default_size = ((1.0 - border * 2.0) / (double)(rows = (int)Math.ceil(Math.sqrt(size))) - gap) / 2.0) < 0.0) {
                    gap = 0.0;
                    default_size = (1.0 - border * 2.0) / (double)rows / 2.0;
                }
                if (width < 0.0 && x + (width = default_size) > 1.0) {
                    x = 1.0 - width;
                }
                if (height < 0.0 && y + (height = default_size) > 1.0) {
                    y = 1.0 - height;
                }
                e.setWidthRelLocal(width);
                e.setHeightRelLocal(height);
            }
            springNode.m_x = x + width / 2.0;
            springNode.m_y = y + height / 2.0;
            ++i;
        }
        long timeout1 = System.currentTimeMillis() + timeout * 1000L;
        cycle = 100;
        int iteration = iterations;
        while (iteration > 0) {
            i = 0;
            while (i < size) {
                springNode = springNodes[i];
                springNode.m_xForce = 0.0;
                springNode.m_yForce = 0.0;
                springNode.m_forces = 0;
                ++i;
            }
            boolean change = false;
            i = 0;
            while (i < size) {
                double supplier_weight1;
                double client_weight1;
                springNode = springNodes[i];
                e = springNode.m_e;
                x = springNode.m_x;
                y = springNode.m_y;
                width = e.widthRelLocal();
                height = e.heightRelLocal();
                int j = i + 1;
                while (j < size) {
                    double vgap;
                    SpringNode springNode1 = springNodes[j];
                    EntityInstance e1 = springNode1.m_e;
                    double x1 = springNode1.m_x;
                    double y1 = springNode1.m_y;
                    double width1 = e1.widthRelLocal();
                    double height1 = e1.heightRelLocal();
                    double xdiff = x - x1;
                    double ydiff = y - y1;
                    double hgap = xdiff;
                    if (hgap < 0.0) {
                        hgap = -hgap;
                    }
                    if ((vgap = ydiff) < 0.0) {
                        vgap = -vgap;
                    }
                    double minwidth = (width + width1) / 2.0 + gap;
                    double minheight = (height + height1) / 2.0 + gap;
                    double f = hgap <= minwidth && vgap <= minheight ? repulsion : (related[i][j - i] ? stiffness : attraction);
                    if (f != 0.0) {
                        while (xdiff == 0.0 && ydiff == 0.0) {
                            xdiff = 0.01 * (Math.random() - 0.5);
                            ydiff = 0.01 * (Math.random() - 0.5);
                        }
                        double length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                        double fx = f * xdiff / length;
                        double fy = f * ydiff / length;
                        springNode.m_xForce -= fx;
                        springNode.m_yForce -= fy;
                        springNode1.m_xForce += fx;
                        springNode1.m_yForce += fy;
                        ++springNode.m_forces;
                        ++springNode1.m_forces;
                    }
                    ++j;
                }
                int forces = springNode.m_forces;
                if (forces != 0) {
                    x += springNode.m_xForce / (double)forces;
                    y += springNode.m_yForce / (double)forces;
                    change = true;
                }
                int clients = springNode.m_clients;
                int suppliers = springNode.m_suppliers;
                if (clients != 0 && compact_clients) {
                    clients = 1;
                }
                if (suppliers != 0 && compact_suppliers) {
                    suppliers = 1;
                }
                if ((client_weight1 = client_weight * (double)clients) > (supplier_weight1 = supplier_weight * (double)suppliers)) {
                    y += stiffness * (border + height / 2.0 + (1.0 - client_weight1 / (client_weight1 + supplier_weight1)) - y);
                } else if (client_weight1 < supplier_weight1) {
                    y += stiffness * (1.0 - border - height / 2.0 - client_weight1 / (client_weight1 + supplier_weight1) - y);
                }
                springNode.m_x = x;
                springNode.m_y = y;
                ++i;
            }
            if (!change) break;
            --iteration;
        }
        SpringLayout2.fitBorder(springNodes, border);
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        EntityInstance e;
        SpringNode springNode;
        Option option = Options.getDiagramOptions();
        LandscapeEditorCore ls = this.m_ls;
        Diagram diagram = ls.getDiagram();
        double stiffness = this.m_stiffness;
        double repulsion = this.m_repulsion;
        double attraction = this.m_attraction;
        double client_weight = this.m_client_weight;
        double supplier_weight = this.m_supplier_weight;
        double gap = this.m_gap;
        double border = this.m_border;
        int iterations = this.m_iterations;
        long timeout = this.m_timeout;
        boolean some_edges = false;
        int size = selectedBoxes.size();
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                EntityInstance e2 = (EntityInstance)selectedBoxes.firstElement();
                diagram.updateRelLocal(e2, 0.25, 0.25, 0.5, 0.5);
                return true;
            }
        }
        SpringNode[] springNodes = new SpringNode[size];
        boolean[][] related = new boolean[size][];
        boolean isTopClients = option.isTopClients();
        int i = 0;
        while (i < size) {
            springNodes[i] = springNode = new SpringNode();
            related[i] = new boolean[size - i];
            springNode.m_e = e = (EntityInstance)selectedBoxes.elementAt(i);
            springNode.m_clients = 0;
            springNode.m_suppliers = 0;
            e.orMark(0x4000000);
            ++i;
        }
        i = 0;
        while (i < size) {
            int j;
            EntityInstance e1;
            RelationInstance ri;
            springNode = springNodes[i];
            e = springNode.m_e;
            Enumeration en = e.srcLiftedRelationElements();
            if (en != null) {
                block6: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown()) continue;
                    e1 = ri.getDrawDst();
                    if (e1.isMarked(4)) {
                        some_edges = true;
                        ++springNode.m_suppliers;
                    }
                    if (!e1.isMarked(0x4000000)) continue;
                    some_edges = true;
                    j = i + 1;
                    while (j < size) {
                        if (e1 == springNodes[j].m_e) {
                            some_edges = true;
                            related[i][j - i] = true;
                            continue block6;
                        }
                        ++j;
                    }
                }
            }
            if ((en = e.dstLiftedRelationElements()) != null) {
                block8: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown()) continue;
                    e1 = ri.getDrawSrc();
                    if (e1.isMarked(2) && !e1.isMarked(4)) {
                        some_edges = true;
                        ++springNode.m_clients;
                    }
                    if (!e1.isMarked(0x4000000)) continue;
                    some_edges = true;
                    j = i + 1;
                    while (j < size) {
                        if (e1 == springNodes[j].m_e) {
                            some_edges = true;
                            related[i][j - i] = true;
                            continue block8;
                        }
                        ++j;
                    }
                }
            }
            if (!isTopClients) {
                int temp = springNode.m_clients;
                springNode.m_clients = springNode.m_suppliers;
                springNode.m_suppliers = temp;
            }
            e.nandMark(0x4000000);
            ++i;
        }
        if (!some_edges) {
            System.out.println("No connected edges - using fallback layout");
            return false;
        }
        SpringLayout2.place(springNodes, related, iterations, gap, border, stiffness, repulsion, attraction, client_weight, supplier_weight, timeout);
        i = 0;
        while (i < size) {
            springNode = springNodes[i];
            e = springNode.m_e;
            double width = e.widthRelLocal();
            double height = e.heightRelLocal();
            diagram.updateRelLocal(e, springNode.m_x - width / 2.0, springNode.m_y - height / 2.0, width, height);
            ++i;
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        ls.setLayouter(this);
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Spring layout requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return "Graph redrawn using Spring Layout";
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class SpringConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SpringConfigure() {
            super(SpringLayout2.this.getLs().getFrame(), "Spring Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel1 = new JPanel();
            JPanel valuePanel1 = new JPanel();
            JPanel labelPanel2 = new JPanel();
            JPanel valuePanel2 = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(6, 1, 0, 10);
            labelPanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(6, 1, 0, 10);
            valuePanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(6, 1, 0, 10);
            labelPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(6, 1, 0, 10);
            valuePanel2.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            int i = 0;
            while (i < m_textfield_tags.length) {
                JTextField textfield;
                JPanel valuePanel;
                JPanel labelPanel;
                if (i % 2 == 0) {
                    labelPanel = labelPanel1;
                    valuePanel = valuePanel1;
                } else {
                    labelPanel = labelPanel2;
                    valuePanel = valuePanel2;
                }
                JLabel label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.setFont(font);
                textfield.addActionListener(this);
                valuePanel.add(textfield);
                ++i;
            }
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BorderLayout());
            leftPanel.add("West", labelPanel1);
            leftPanel.add("East", valuePanel1);
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BorderLayout());
            rightPanel.add("West", labelPanel2);
            rightPanel.add("East", valuePanel2);
            topPanel.add("West", leftPanel);
            topPanel.add("East", rightPanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            contentPane.add("Center", this.m_message);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            i = 0;
            while (i < m_button_titles.length) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = SpringLayout2.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
                ++i;
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            int state = -1;
            int i = 0;
            while (i < m_button_titles.length) {
                if (source == this.m_buttons[i]) {
                    state = i;
                    break;
                }
                ++i;
            }
            switch (state) {
                case 6: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        SpringLayout2.m_textfield_defaults[i] = m_textfield_resets[i];
                        ++i;
                    }
                }
                case 4: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                        ++i;
                    }
                    return;
                }
                case 5: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        SpringLayout2.m_textfield_defaults[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = SpringLayout2.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(SpringLayout2.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SpringLayout2.this.m_ls.getFrame(), "Stiffness\n  The stiffness of edges connecting related nodes\n  A larger value increases the force between related nodes\nRepulsive force\n  The repulsive force between overlapping nodes\n  A larger value thrusts overlapping nodes further apart\n  0     => disable collision detection\nAttractive force\n  The attractive force between unconnected entities\n  It's purpose is to create a smaller overall graph in which\n  nodes as a consequence may be larger\nClient and Supplier weight\n  Specifies the significance of edges to clients/suppliers\n  0     => no significance\n  |1.0| => same significance as other edges\n  -ve   => consider all edges to clients/suppliers one edge\nIdeal gap\n  Fractional space between entities\nBorder\n  Fractional space to leave for border of diagram\nIterations\n  Number of times to iterate over the algorithm\nTimeout\n  Maximum number of seconds to spend iterating", "Help", 0);
                    return;
                }
            }
            i = 0;
            while (i < m_textfield_tags.length) {
                JTextField textfield = this.m_textfields[i];
                if (source == textfield || state == 0) {
                    String string = textfield.getText();
                    string = string.trim();
                    String name = m_textfield_titles[i];
                    switch (i) {
                        case 7: 
                        case 8: {
                            try {
                                int ivalue = Integer.parseInt(string);
                                if (ivalue > 0) break;
                                this.m_message.setText(String.valueOf(name) + " must be positive");
                                return;
                            }
                            catch (Throwable exception) {
                                this.m_message.setText(String.valueOf(name) + " not an integer value");
                                return;
                            }
                        }
                        default: {
                            try {
                                Double.parseDouble(string);
                                break;
                            }
                            catch (Throwable exception) {
                                this.m_message.setText(String.valueOf(name) + " not a double precision value");
                                return;
                            }
                        }
                    }
                }
                ++i;
            }
            switch (state) {
                case 0: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        SpringLayout2.this.setParameter(i, this.m_textfields[i].getText());
                        ++i;
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

