/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.ClientSupplierCompareFn;
import lsedit.CompareFn;
import lsedit.DistanceCompareFn;
import lsedit.EntityInstance;
import lsedit.HorizontalCompareFn;
import lsedit.IdCompareFn;
import lsedit.PositionCompareFn;
import lsedit.PreorderCompareFn;
import lsedit.StringCompareFn;
import lsedit.VerticalCompareFn;

public class SortVector {
    static final StringCompareFn m_stringCompareFn = new StringCompareFn();
    static final ClientSupplierCompareFn m_clientSupplierCompareFn = new ClientSupplierCompareFn();
    static final HorizontalCompareFn m_horizontalCompareFn = new HorizontalCompareFn();
    static final VerticalCompareFn m_verticalCompareFn = new VerticalCompareFn();
    static final PreorderCompareFn m_preorderCompareFn = new PreorderCompareFn();
    static final IdCompareFn m_idCompareFn = new IdCompareFn();
    static final PositionCompareFn m_positionCompareFn = new PositionCompareFn();
    static final DistanceCompareFn m_distanceCompareFn = new DistanceCompareFn();

    private static final int partition(Vector v, int l, int r, CompareFn cf, boolean asc) {
        Object p = v.elementAt(l);
        --l;
        ++r;
        while (true) {
            Object q;
            boolean f;
            Object o = v.elementAt(--r);
            if (asc) {
                f = cf.compare(o, p) > 0;
            } else {
                boolean bl = f = cf.compare(o, p) < 0;
            }
            if (f) continue;
            do {
                q = v.elementAt(++l);
                if (asc) {
                    f = cf.compare(q, p) < 0;
                    continue;
                }
                boolean bl = f = cf.compare(q, p) > 0;
            } while (f);
            if (r <= l) {
                return r;
            }
            if (cf.compare(q, o) == 0) continue;
            v.setElementAt(o, l);
            v.setElementAt(q, r);
        }
    }

    private static final void qsort(Vector v, int l, int r, CompareFn cf, boolean asc) {
        if (l < r) {
            int p = SortVector.partition(v, l, r, cf, asc);
            SortVector.qsort(v, l, p, cf, asc);
            SortVector.qsort(v, p + 1, r, cf, asc);
        }
    }

    private static final void sort(Vector v, int l, int r, CompareFn cf, boolean asc) {
        switch (r) {
            case 0: {
                return;
            }
            case 1: {
                Object object0 = v.elementAt(0);
                Object object1 = v.elementAt(1);
                if (cf.compare(object0, object1) == 1) {
                    v.setElementAt(object1, 0);
                    v.setElementAt(object0, 1);
                }
                return;
            }
        }
        SortVector.qsort(v, l, r, cf, asc);
    }

    public static void sortVector(Vector v, CompareFn cf, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, cf, ascending);
    }

    public static void byString(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_stringCompareFn, ascending);
    }

    public static void byString(Vector v) {
        SortVector.byString(v, true);
    }

    public static void byAvgX(Vector v, boolean ascending) {
        if (v != null) {
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.computeAvgX();
            }
            SortVector.sort(v, 0, v.size() - 1, m_clientSupplierCompareFn, ascending);
        }
    }

    public static void byAvgX(Vector v) {
        SortVector.byAvgX(v, true);
    }

    public static void byHorizontalPosition(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_horizontalCompareFn, ascending);
    }

    public static void byHorizontalPosition(Vector v) {
        SortVector.byHorizontalPosition(v, true);
    }

    public static void byVerticalPosition(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_verticalCompareFn, ascending);
    }

    public static void byVerticalPosition(Vector v) {
        SortVector.byVerticalPosition(v, true);
    }

    public static void byPreorder(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_preorderCompareFn, ascending);
    }

    public static void byId(Vector v) {
        SortVector.sort(v, 0, v.size() - 1, m_idCompareFn, true);
    }

    public static void byTreeNode(Vector v) {
        SortVector.sort(v, 0, v.size() - 1, m_stringCompareFn, true);
    }

    public static void byPosition(Vector v) {
        SortVector.sort(v, 0, v.size() - 1, m_positionCompareFn, true);
    }

    public static void byDistance(Vector v) {
        SortVector.sort(v, 0, v.size() - 1, m_distanceCompareFn, true);
    }
}

