/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.Arrow;
import lsedit.CheckRelationAttributes;
import lsedit.CheckRelations;
import lsedit.DeleteRelationClass;
import lsedit.Diagram;
import lsedit.DisplayClassHierarchy;
import lsedit.DisplayEditElisions;
import lsedit.ERBox;
import lsedit.EditRelationClassAttributes;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.SetDefaultRelationClass;
import lsedit.ShowConstraintsClosure;
import lsedit.ShowConstraintsMatrix;
import lsedit.ShowElisionIcons;
import lsedit.ShowValidAttributes;

class ShownRelnChkBox
extends JComponent
implements ItemListener,
MouseListener {
    public static final int GAP = 5;
    public static final int WIDTH = 45;
    public static final int HEIGHT = 20;
    protected ERBox m_erBox;
    protected JCheckBox m_checkbox = null;
    protected RelationClass m_rc;
    protected int m_direction;
    protected int m_index;
    protected JPopupMenu m_popup;

    public ShownRelnChkBox(ERBox erBox, RelationClass rc, int direction, int index, int count, Font font) {
        String labelText;
        this.m_erBox = erBox;
        this.m_rc = rc;
        this.m_direction = direction;
        this.m_index = index;
        Option option = Options.getDiagramOptions();
        FlowLayout flowLayout = new FlowLayout(0);
        this.setLayout(flowLayout);
        if (this.m_index >= 0) {
            JCheckBox checkbox;
            this.m_checkbox = checkbox = new JCheckBox();
            checkbox.setBorderPaintedFlat(false);
            checkbox.setSelected(erBox.getFlag(rc, direction));
            checkbox.setEnabled(true);
            checkbox.setVisible(true);
            this.add(checkbox);
        }
        Arrow arrow = new Arrow(45, 20);
        Color color = rc.getInheritedObjectColor();
        arrow.setForeground(color);
        if (option.isVariableArrowColor()) {
            color = rc.getInheritedArrowColor();
            arrow.setHeadColor(color);
        }
        arrow.setStyle(rc.getInheritedStyle());
        this.add(arrow);
        if (direction == 2) {
            labelText = rc.getReversedLabel();
            if (labelText == null) {
                labelText = String.valueOf(rc.getLabel()) + "(r)";
            }
        } else {
            labelText = rc.getLabel();
        }
        if (index >= 0) {
            labelText = String.valueOf(labelText) + " (" + index + ")";
        }
        if (count >= 0) {
            labelText = String.valueOf(labelText) + " [" + count + "]";
        }
        JLabel label = new JLabel(labelText);
        color = !option.isLegendLabelBlack() ? rc.getInheritedLabelColor() : Color.BLACK;
        label.setFont(font);
        label.setForeground(color);
        this.add(label);
        this.setToolTipText(rc.getDescription());
        this.addItemListener(this);
        this.addMouseListener(this);
    }

    public void addItemListener(ItemListener listener) {
        if (this.m_checkbox != null) {
            this.m_checkbox.addItemListener(listener);
        }
    }

    public boolean isSelected() {
        if (this.m_checkbox == null) {
            return false;
        }
        return this.m_checkbox.isSelected();
    }

    public void doClick() {
        if (this.m_checkbox != null) {
            this.m_checkbox.doClick();
        }
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isActive() {
        return this.m_erBox.getFlag(this.m_rc, this.m_direction);
    }

    public void setActive(boolean value) {
        Option option = Options.getDiagramOptions();
        ERBox erBox = this.m_erBox;
        RelationClass rc = this.m_rc;
        if (erBox.getFlag(rc, this.m_direction) != value) {
            LandscapeEditorCore ls = erBox.getLs();
            if (erBox.setFlag(this.m_rc, this.m_direction, value, option.isShowInheritance()) == -1) {
                erBox.syncRelationClasses();
            }
            ls.refillDiagram();
        }
    }

    public void sync() {
        if (this.m_checkbox != null) {
            this.m_checkbox.setSelected(this.isActive());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        this.setActive(ev.getStateChange() == 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isMetaDown()) {
            JPopupMenu popup;
            ERBox erBox = this.m_erBox;
            LandscapeEditorCore ls = erBox.getLs();
            Diagram diagram = ls.getDiagram();
            int x = ev.getX();
            int y = ev.getY();
            RelationClass rc = this.m_rc;
            this.m_popup = popup = new JPopupMenu("Relation menu");
            JMenuItem mi = new JMenuItem("Edit inheritance rules");
            mi.addActionListener(new DisplayClassHierarchy(ls, rc, x, y));
            popup.add(mi);
            mi = new JMenuItem("Edit Class Attributes");
            mi.addActionListener(new EditRelationClassAttributes(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Edit relation constraints");
            mi.addActionListener(new ShowConstraintsMatrix(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Edit Elision Rules");
            mi.addActionListener(new DisplayEditElisions(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Show Elision Icons");
            mi.addActionListener(new ShowElisionIcons(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Closure of constraints");
            mi.addActionListener(new ShowConstraintsClosure(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Show valid attributes");
            mi.addActionListener(new ShowValidAttributes(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Validate relations");
            mi.addActionListener(new CheckRelations(ls, rc));
            popup.add(mi);
            mi = new JMenuItem("Validate attributes");
            mi.addActionListener(new CheckRelationAttributes(ls, rc));
            popup.add(mi);
            if (rc.getContainsClassOffset() < 0) {
                if (rc != diagram.m_relationBaseClass) {
                    mi = new JMenuItem("Delete relation class " + rc.getLabel());
                    mi.addActionListener(new DeleteRelationClass(ls, rc));
                    popup.add(mi);
                }
                mi = new JMenuItem("Create relations of this class");
                mi.addActionListener(new SetDefaultRelationClass(ls, rc));
                popup.add(mi);
            }
            erBox.customRelationOptions(popup, rc);
            FontCache.setMenuTreeFont(popup);
            erBox.add(popup);
            popup.show(this, x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }
}

