/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.CheckEntityAttributes;
import lsedit.DeleteEntityClass;
import lsedit.Diagram;
import lsedit.DisplayClassHierarchy;
import lsedit.DisplayEditElisions;
import lsedit.ERBox;
import lsedit.EditClassAttributes;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Option;
import lsedit.Options;
import lsedit.SetDefaultEntityClass;
import lsedit.ShowValidAttributes;

class ShownEntityChkBox
extends JComponent
implements ItemListener,
MouseListener {
    protected static final int GAP = 5;
    protected static final int WIDTH = 45;
    protected static final int HEIGHT = 20;
    protected ERBox m_erBox;
    protected JCheckBox m_checkbox;
    protected EntityClass m_ec;
    protected EntityInstance m_e;
    protected int m_index;
    protected JLabel m_label;
    protected JPopupMenu m_popup = null;

    public ShownEntityChkBox(ERBox erBox, EntityClass ec, int index, int count, int height, Font font) {
        JLabel label;
        JCheckBox checkbox;
        int bh = height * 2;
        int bw = bh * 4 / 3;
        Option option = Options.getDiagramOptions();
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(5);
        this.setLayout(new FlowLayout(0));
        this.m_erBox = erBox;
        this.m_ec = ec;
        this.m_index = index;
        this.m_checkbox = checkbox = new JCheckBox();
        checkbox.setBorderPaintedFlat(false);
        checkbox.setSelected(erBox.getFlag(ec));
        checkbox.setEnabled(true);
        checkbox.setVisible(true);
        this.add(checkbox);
        this.m_e = ec.newEntity("");
        this.m_e.orMark(128);
        ec.decrementMembers();
        EntityComponent entityComponent = this.m_e.neededPlainComponent();
        entityComponent.setSize(bw, bh);
        entityComponent.setLocation(0, 0);
        entityComponent.setPreferredSize(new Dimension(bw, bh));
        this.add(entityComponent);
        String string = ec.getLabel();
        if (count >= 0) {
            string = String.valueOf(string) + " [" + count + "]";
        }
        this.m_label = label = new JLabel(string);
        Color color = !option.isLegendLabelBlack() ? ec.getInheritedLabelColor() : Color.BLACK;
        label.setForeground(color);
        this.add(label);
        this.setToolTipText(ec.getDescription());
        this.setFont(font);
        this.addItemListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void setFont(Font font) {
        this.m_label.setFont(font);
    }

    public void addItemListener(ItemListener listener) {
        this.m_checkbox.addItemListener(listener);
    }

    public boolean isSelected() {
        return this.m_checkbox.isSelected();
    }

    public void doClick() {
        this.m_checkbox.doClick();
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isActive() {
        return this.m_erBox.getFlag(this.m_ec);
    }

    public void setActive(boolean value) {
        Option option = Options.getDiagramOptions();
        ERBox erBox = this.m_erBox;
        EntityClass ec = this.m_ec;
        if (erBox.getFlag(ec) != value) {
            LandscapeEditorCore ls = erBox.getLs();
            if (erBox.setFlag(ec, value, option.isShowInheritance()) == -1) {
                erBox.syncEntityClasses();
            }
            ls.refillDiagram();
        }
    }

    public void sync() {
        this.m_checkbox.setSelected(this.isActive());
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        this.setActive(ev.getStateChange() == 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isMetaDown()) {
            int x = ev.getX();
            int y = ev.getY();
            JPopupMenu popup = this.m_popup;
            if (popup == null) {
                ERBox erBox = this.m_erBox;
                LandscapeEditorCore ls = erBox.getLs();
                Diagram diagram = ls.getDiagram();
                EntityClass ec = this.m_ec;
                this.m_popup = popup = new JPopupMenu("Class menu");
                JMenuItem mi = new JMenuItem("Edit inheritance rules");
                mi.addActionListener(new DisplayClassHierarchy(ls, ec, x, y));
                popup.add(mi);
                mi = new JMenuItem("Edit Class Attributes");
                mi.addActionListener(new EditClassAttributes(ls, ec));
                popup.add(mi);
                mi = new JMenuItem("Edit Elision Rules");
                mi.addActionListener(new DisplayEditElisions(ls, ec));
                popup.add(mi);
                mi = new JMenuItem("Show valid attributes");
                mi.addActionListener(new ShowValidAttributes(ls, ec));
                popup.add(mi);
                mi = new JMenuItem("Validate attributes");
                mi.addActionListener(new CheckEntityAttributes(ls, ec));
                popup.add(mi);
                mi = new JMenuItem("Create entities of this class");
                mi.addActionListener(new SetDefaultEntityClass(ls, ec));
                popup.add(mi);
                if (this.m_ec != diagram.m_entityBaseClass) {
                    mi = new JMenuItem("Delete entity class " + ec.getLabel());
                    mi.addActionListener(new DeleteEntityClass(ls, ec));
                    popup.add(mi);
                }
                erBox.add(popup);
            }
            FontCache.setMenuTreeFont(this.m_popup);
            popup.show(this, x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public String toString() {
        return "EntityChkBox " + this.m_label.getText();
    }
}

