/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import lsedit.Options;
import lsedit.ToolBarButton;
import lsedit.Util;

class SelectedElisions
extends JLabel
implements TableCellRenderer,
Icon {
    public static final int DST = 1;
    public static final int SRC = 2;
    public static final int ENTERS = 4;
    public static final int EXITS = 8;
    public static final int INTERNAL = 16;
    public static final int CONTAINS = 32;
    public static final int CHANGE = 64;
    public static final int BOX = 128;
    public static final int ALL_ROW = 256;
    public static final int ALL_COL = 512;
    public static final int ELIDED = 31;
    public static final int ALL_ELIDED = 63;
    public static final int SUMMARY = 768;
    public static final int AND_ELISIONS = 4096;
    public static final int OR_ELISIONS = 8192;
    public static final int NAND_ELISIONS = 16384;
    public static final int MODE = 28672;
    private static final int GAP = 4;
    private int m_elisions = 0;

    public SelectedElisions(int elisions) {
        Font font = Options.getTargetFont(1);
        Font bold = font.deriveFont(1);
        this.setFont(font);
        this.setIcon(this);
        this.m_elisions = elisions;
        this.setSize(80, 48);
    }

    public int getElisions() {
        return this.m_elisions;
    }

    public void setElisions(int elisions) {
        this.m_elisions = elisions & 0xFFFFFC7F | this.m_elisions & 0x380;
        this.setToolTipText(this.toString());
    }

    public void updateElisions(int elisions, int mode) {
        int elisions1 = elisions;
        if (mode == 4096) {
            elisions1 &= this.m_elisions;
        } else if (mode == 8192) {
            elisions1 |= this.m_elisions;
        } else if (mode == 16384) {
            elisions1 ^= 0xFFFFFFFF;
            elisions1 &= this.m_elisions;
        }
        this.setElisions(elisions1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this;
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        String text;
        int w = this.getWidth();
        int h = this.getHeight();
        int x1 = x + 4;
        int y1 = y + h / 3;
        int width1 = w - 8;
        int height1 = h * 2 / 3 - 4;
        int elisions = this.m_elisions;
        if ((elisions & 0x40) == 0) {
            if ((elisions & 0x300) == 0) {
                g.setColor(Color.RED);
                g.drawString("OK", x, y + h / 2);
            }
        } else {
            int y3;
            int y2;
            int x2;
            if ((elisions & 0x20) == 0) {
                g.setColor(Color.cyan);
                g.fillRect(x1, y1, width1, height1);
            }
            g.setColor(Color.black);
            g.drawRect(x1, y1, width1, height1);
            if ((elisions & 0x10) == 0) {
                x2 = x1 + width1 / 3;
                y2 = y1 + height1 / 2;
                int x3 = x1 + width1 * 2 / 3;
                ToolBarButton.drawEdge(g, x2, y2, x3, y2);
            }
            if ((elisions & 2) == 0) {
                x2 = x1 + width1 / 5;
                y3 = y + 4;
                ToolBarButton.drawEdge(g, x2, y1, x2, y3);
            }
            if ((elisions & 8) == 0) {
                x2 = x1 + 2 * width1 / 5;
                y2 = y1 + height1 / 3;
                y3 = y + 4;
                ToolBarButton.drawEdge(g, x2, y2, x2, y3);
            }
            if ((elisions & 4) == 0) {
                x2 = x1 + 3 * width1 / 5;
                y2 = y1 + height1 / 3;
                y3 = y + 4;
                ToolBarButton.drawEdge(g, x2, y3, x2, y2);
            }
            if ((elisions & 1) == 0) {
                x2 = x1 + 4 * width1 / 5;
                y3 = y + 4;
                ToolBarButton.drawEdge(g, x2, y3, x2, y1);
            }
        }
        if ((elisions & 0x80) != 0) {
            Util.drawOutlineBox(g, x + 1, y + 1, w - 2, h - 2);
        }
        if ((text = this.getText()) != null) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int heightText = fm.getHeight();
            Util.drawStringClipped(g, text, x1, y1 + height1 - heightText, width1, height1, false, false, true);
        }
    }

    @Override
    public String toString() {
        String tip = "";
        int elisions = this.m_elisions;
        String text = this.getText();
        if ((elisions & 0x40) == 0) {
            tip = "No change";
        } else {
            if ((elisions & 0x1F) == 0) {
                tip = " all";
            } else if ((elisions & 0x1F) == 31) {
                tip = " no";
            } else {
                if ((elisions & 2) == 0) {
                    tip = ", +source";
                }
                if ((elisions & 8) == 0) {
                    tip = String.valueOf(tip) + ", +exits";
                }
                if ((elisions & 4) == 0) {
                    tip = String.valueOf(tip) + ", +enters";
                }
                if ((elisions & 1) == 0) {
                    tip = String.valueOf(tip) + ", +destination";
                }
                if ((elisions & 0x10) == 0) {
                    tip = String.valueOf(tip) + ", +internal";
                }
            }
            if (text != null) {
                tip = String.valueOf(tip) + " " + text;
            }
            tip = String.valueOf(tip) + " relations permitted";
            tip = (elisions & 0x20) == 0 ? "Closed" + tip : "Open" + tip;
        }
        return tip;
    }
}

