/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.ResultBox;

class ResultBoxConfigure
extends JDialog
implements ActionListener {
    protected ResultBox m_resultBox;
    protected JSpinner m_left_show;
    protected JSpinner m_right_show;
    protected JSpinner m_max_size;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help"};
    protected JButton[] m_buttons;

    public ResultBoxConfigure(ResultBox resultBox, String title) {
        super(resultBox.getLs().getFrame(), title, true);
        this.m_resultBox = resultBox;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        JTabbedPane tabbedPane = resultBox.getTabbedPane();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel centerPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        centerPanel.setLayout(gridBagLayout);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel("Left show ancestors");
        this.m_left_show = new JSpinner(new SpinnerNumberModel(resultBox.getLeftShowAncestors(), 0, Integer.MAX_VALUE, 1));
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        centerPanel.add(label);
        c.gridx = 1;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_left_show, c);
        centerPanel.add(this.m_left_show);
        label = new JLabel("Right show ancestors");
        this.m_right_show = new JSpinner(new SpinnerNumberModel(resultBox.getRightShowAncestors(), 0, Integer.MAX_VALUE, 1));
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        centerPanel.add(label);
        c.gridx = 1;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_right_show, c);
        centerPanel.add(this.m_right_show);
        label = new JLabel("Maximum report size");
        this.m_max_size = new JSpinner(new SpinnerNumberModel(resultBox.getMaxSize(), 0, Integer.MAX_VALUE, 1));
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        centerPanel.add(label);
        c.gridx = 1;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_max_size, c);
        centerPanel.add(this.m_max_size);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.m_buttons = new JButton[m_button_titles.length];
        int i = 0;
        while (i < m_button_titles.length) {
            JButton button;
            String string = m_button_titles[i];
            this.m_buttons[i] = button = new JButton(string);
            button.setFont(bold);
            button.addActionListener(this);
            buttonPanel.add(button);
            ++i;
        }
        contentPane.add("Center", centerPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setLocation(tabbedPane.getX(), tabbedPane.getY());
        this.setVisible(true);
    }

    private int getSpinnerValue(JSpinner spinner) {
        Number value = (Number)spinner.getValue();
        return value.intValue();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        int state = -1;
        int i = 0;
        while (i < m_button_titles.length) {
            if (source == this.m_buttons[i]) {
                state = i;
                break;
            }
            ++i;
        }
        switch (state) {
            case 2: {
                JOptionPane.showMessageDialog(this.m_resultBox.getLs().getFrame(), "The permitted options are:\n1) Left show ancestors.\n   The number of ancestors to be shown as part of left component names.\n2) Right show ancestors.\n   The number of ancestors to be shown as part of right component names.\n3) Maximum lines.\n   The maximum number of lines in this report.", "Help", 0);
                return;
            }
            case 0: {
                this.m_resultBox.setShowAncestors(this.getSpinnerValue(this.m_left_show), this.getSpinnerValue(this.m_right_show));
                this.m_resultBox.setMaxSize(this.getSpinnerValue(this.m_max_size));
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }
}

