/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBoxConfigure;
import lsedit.TaListener;
import lsedit.TabBox;

public final class ResultBox
extends TabBox
implements ChangeListener,
TaListener,
Scrollable,
MouseListener {
    protected static final Color m_titleColor = Color.red.darker();
    protected static Font m_titleFont = null;
    protected static Font m_textFont = null;
    protected static final String m_indent = "    ";
    protected static final int horizontal_margin = 10;
    protected static final int vertical_indent = 10;
    public static final String m_helpStr = "This box shows the results of queries, and groupings";
    protected BoxLayout m_boxLayout;
    private boolean m_refill = false;
    protected int m_left_show = 0;
    protected int m_right_show = 0;
    protected int m_max_size = 500;
    protected int m_lines = 0;

    @Override
    public String toString() {
        int cnt = this.getComponentCount();
        String string = "";
        int i = 0;
        while (i < cnt) {
            Component component = this.getComponent(i);
            string = String.valueOf(string) + component.toString() + "\n---\n";
            ++i;
        }
        return string;
    }

    public ResultBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Results", m_helpStr);
        if (m_titleFont == null) {
            m_titleFont = Options.getTargetFont(6);
        }
        if (m_textFont == null) {
            m_textFont = Options.getTargetFont(7);
        }
        this.m_boxLayout = new BoxLayout(this, 1);
        this.setLayout(this.m_boxLayout);
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_tabbedPane;
    }

    public int getLeftShowAncestors() {
        return this.m_left_show;
    }

    public int getRightShowAncestors() {
        return this.m_right_show;
    }

    public void setShowAncestors(int left, int right) {
        this.m_left_show = left;
        this.m_right_show = right;
    }

    public int getMaxSize() {
        return this.m_max_size;
    }

    public void setMaxSize(int value) {
        this.m_max_size = value;
    }

    public boolean maxSize() {
        if (this.m_lines > this.m_max_size) {
            return true;
        }
        if (this.m_lines == this.m_max_size) {
            this.showAll();
            ResultBoxConfigure configure = new ResultBoxConfigure(this, "Maximum lines observed");
            configure.dispose();
            if (this.m_lines >= this.m_max_size) {
                this.m_lines = -1;
                this.done("Report truncated at " + this.m_max_size + " lines");
                this.m_lines = this.m_max_size + 1;
                return true;
            }
        }
        ++this.m_lines;
        return false;
    }

    public void clear() {
        this.m_lines = 0;
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void addResultTitle(String title) {
        if (title != null && !this.maxSize()) {
            ResultTitleLabel label = new ResultTitleLabel();
            label.setText(title);
            label.setHorizontalAlignment(2);
            label.setFont(m_titleFont);
            label.setForeground(m_titleColor);
            this.add(label);
            this.add(Box.createVerticalStrut(5));
        }
    }

    public void setResultTitle(String title) {
        this.clear();
        this.addResultTitle(title);
    }

    public void addResultEntity(EntityInstance e, int showAncestors) {
        if (!this.maxSize()) {
            this.add(new ResultEntity("", e, showAncestors, false));
        }
    }

    public void addResultAttribute(Attribute attribute) {
        if (!this.maxSize()) {
            this.add(new ResultAttribute("  ", attribute));
        }
    }

    public void addRelation(RelationInstance r) {
        if (!this.maxSize()) {
            this.add(new ResultRelation("", r, false));
        }
    }

    public void addRelation(String indent, RelationInstance r) {
        if (!this.maxSize()) {
            this.add(new ResultRelation(indent, r, false));
        }
    }

    public void addRelations(EntityInstance e, RelationClass rc, Vector list, boolean isForwards, boolean withClosure) {
        if (!this.maxSize()) {
            this.add(new ResultSet(e, rc, list, isForwards, withClosure));
        }
    }

    protected void addContents(EntityInstance e, Vector list) {
        if (!this.maxSize()) {
            this.add(new ResultContents(e, list));
        }
    }

    public void addText(String message) {
        if (message != null && !this.maxSize()) {
            ResultLabel label = new ResultLabel();
            label.setText(message);
            label.setHorizontalAlignment(2);
            label.setForeground(Color.black);
            this.add(label);
        }
    }

    private void sizeIt() {
        JScrollPane scrollPane = this.m_scrollPane;
        Insets insets = scrollPane.getInsets();
        Dimension d = this.m_boxLayout.preferredLayoutSize(this);
        int w1 = scrollPane.getWidth() - insets.left - insets.right;
        int h1 = scrollPane.getHeight() - insets.top - insets.bottom;
        if (w1 > d.width) {
            d.width = w1;
        }
        if (h1 > d.height) {
            d.height = h1;
        }
        this.setPreferredSize(d);
        this.setBounds(0, 0, d.width, d.height);
    }

    private void showAll() {
        this.sizeIt();
        this.validate();
        this.m_scrollPane.revalidate();
    }

    public void done(String footer) {
        if (!this.maxSize()) {
            if (footer != null) {
                this.add(Box.createVerticalStrut(10));
                this.addText(footer);
            }
            this.showAll();
        }
    }

    public void showResults(String title, Vector v, String footer) {
        this.setResultTitle(title);
        if (v.size() > 0) {
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.addResultEntity(e, this.getLeftShowAncestors());
            }
        } else {
            footer = "No entities";
        }
        this.done(footer);
    }

    public void fontChanged() {
        Font titleFont = m_titleFont;
        Font textFont = m_textFont;
        int i = this.getComponentCount();
        while (--i >= 0) {
            Component component = this.getComponent(i);
            Font font = component instanceof ResultTitleLabel ? titleFont : textFont;
            component.setFont(font);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isActive()) {
            this.sizeIt();
            this.repaint();
        }
    }

    @Override
    public void diagramChanging(Diagram diagram) {
        this.clear();
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
        if (this.m_refill) {
            this.m_refill = false;
            this.repaint();
        }
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        this.m_refill = true;
    }

    public void entityCut(EntityInstance e) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.isMetaDown()) {
            ResultBoxConfigure configure = new ResultBoxConfigure(this, "Configure resultBox");
            configure.dispose();
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    class HorizontalResult
    extends JComponent {
        public HorizontalResult() {
            this.setAlignmentX(0.0f);
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public String toString() {
            int cnt = this.getComponentCount();
            String string = "";
            int i = 0;
            while (i < cnt) {
                Component component = this.getComponent(i);
                string = String.valueOf(string) + component.toString();
                ++i;
            }
            return string;
        }
    }

    class ResultAttribute
    extends ResultLabel {
        public ResultAttribute(String indent, Attribute attribute) {
            String text = String.valueOf(indent) + attribute.toString();
            this.setText(text);
        }
    }

    class ResultContents
    extends VerticalResult {
        public ResultContents(EntityInstance entity, Vector entities) {
            this.add(new ResultSetHeader(entity, entities));
            Enumeration en = entities.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                ResultEntity resultEntity = new ResultEntity(ResultBox.m_indent, e, ResultBox.this.getRightShowAncestors(), true);
                this.add(resultEntity);
            }
        }
    }

    class ResultEntity
    extends ResultLabel
    implements MouseListener {
        protected EntityInstance m_entity;

        public ResultEntity(String indent, EntityInstance entity, int depth, boolean showClass) {
            this.m_entity = entity;
            this.setToolTipText(entity.getDescription());
            String text = entity.getEntityLabel();
            if (showClass) {
                text = String.valueOf(text) + " {" + entity.getClassLabel() + "}";
            }
            while (--depth >= 0) {
                if ((entity = entity.getContainedBy()) == null) break;
                text = String.valueOf(entity.getEntityLabel()) + "." + text;
            }
            text = String.valueOf(indent) + text;
            this.setText(text);
            this.setForeground(Color.blue);
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            Color color = this.m_entity.isMarked(0x2000000) ? Color.black : Color.blue;
            this.setForeground(color);
            super.paintComponent(g);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.m_entity.isMarked(0x2000000)) {
                this.setForeground(Color.red);
                this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.m_entity.isMarked(0x2000000)) {
                this.setForeground(Color.blue);
                this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            EntityInstance e;
            if (ev.isAltDown() && !(e = this.m_entity).isMarked(0x2000000)) {
                e.startHover();
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            EntityInstance e = this.m_entity;
            if (!e.isMarked(0x2000000) && !e.endHover()) {
                this.setForeground(Color.blue);
                ResultBox.this.m_ls.followLink(e, true);
            }
        }
    }

    class ResultLabel
    extends JLabel {
        public ResultLabel() {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            this.setFont(m_textFont);
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }

    class ResultRelation
    extends HorizontalResult {
        protected RelationInstance m_relation;

        public ResultRelation(String indent, RelationInstance relation, boolean hideRc) {
            this.m_relation = relation;
            ResultEntity resultEntity = new ResultEntity(indent, relation.getSrc(), ResultBox.this.getLeftShowAncestors(), false);
            this.add(resultEntity);
            if (!hideRc) {
                ResultLabel rc = new ResultLabel();
                rc.setText(" " + relation.getClassLabel());
                rc.setHorizontalAlignment(0);
                this.add(rc);
            }
            resultEntity = new ResultEntity(" ", relation.getDst(), ResultBox.this.getRightShowAncestors(), false);
            this.add(resultEntity);
        }

        public boolean matches(RelationInstance relation) {
            return this.m_relation.matches(relation);
        }
    }

    class ResultSet
    extends VerticalResult {
        public ResultSet(EntityInstance entity, RelationClass relationClass, Vector entities, boolean forward, boolean closure) {
            boolean hideRelation = relationClass != null;
            this.add(new ResultSetHeader(entity, relationClass, forward, closure));
            Enumeration en = entities.elements();
            while (en.hasMoreElements()) {
                Object object = en.nextElement();
                if (object instanceof EntityInstance) {
                    EntityInstance e = (EntityInstance)object;
                    ResultEntity resultEntity = new ResultEntity(ResultBox.m_indent, e, ResultBox.this.getRightShowAncestors(), false);
                    this.add(resultEntity);
                    continue;
                }
                RelationInstance r = (RelationInstance)object;
                ResultRelation resultRelation = new ResultRelation(ResultBox.m_indent, r, hideRelation);
                this.add(resultRelation);
            }
        }
    }

    class ResultSetHeader
    extends HorizontalResult {
        public ResultSetHeader(EntityInstance entity, RelationClass relationClass, boolean forward, boolean closure) {
            ResultLabel rc;
            String type = closure ? "*" : "?";
            if (relationClass == null) {
                rc = null;
            } else {
                rc = new ResultLabel();
                rc.setText(" " + relationClass.getLabel());
                rc.setHorizontalAlignment(0);
            }
            ResultLabel label = new ResultLabel();
            label.setHorizontalAlignment(2);
            if (forward) {
                ResultEntity resultEntity = new ResultEntity("", entity, ResultBox.this.getLeftShowAncestors(), false);
                this.add(resultEntity);
                if (rc != null) {
                    this.add(rc);
                }
                label.setText(" " + type);
                this.add(label);
            } else {
                label.setText(type);
                this.add(label);
                if (rc != null) {
                    this.add(rc);
                }
                ResultEntity resultEntity = new ResultEntity(" ", entity, ResultBox.this.getRightShowAncestors(), false);
                this.add(resultEntity);
            }
        }

        public ResultSetHeader(EntityInstance entity, Vector list) {
            ResultEntity resultEntity = new ResultEntity("", entity, ResultBox.this.getLeftShowAncestors(), false);
            ResultLabel label = new ResultLabel();
            label.setText(" contains (" + list.size() + " items):");
            this.add(resultEntity);
            this.add(label);
        }
    }

    class ResultTitleLabel
    extends ResultLabel {
        ResultTitleLabel() {
        }
    }

    class VerticalResult
    extends JComponent {
        public VerticalResult() {
            this.setLayout(new BoxLayout(this, 1));
        }

        @Override
        public String toString() {
            int cnt = this.getComponentCount();
            String string = "";
            int i = 0;
            while (i < cnt) {
                Component component = this.getComponent(i);
                string = String.valueOf(string) + component.toString() + "\n";
                ++i;
            }
            return string;
        }
    }
}

