/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import javax.swing.undo.UndoableEdit;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeLayouter;
import lsedit.MyUndoableEdit;

class RelayoutSubtree
extends MyUndoableEdit
implements UndoableEdit {
    Diagram m_diagram;
    EntityInstance[] m_entities;
    double[] m_xRel;
    double[] m_yRel;
    double[] m_widthRel;
    double[] m_heightRel;
    LandscapeLayouter m_layouter;
    boolean m_compute;

    protected void saveInfo(EntityInstance e, int basePreorder) {
        int index = e.getPreorder() - basePreorder;
        this.m_entities[index] = e;
        this.m_xRel[index] = e.xRelLocal();
        this.m_yRel[index] = e.yRelLocal();
        this.m_widthRel[index] = e.widthRelLocal();
        this.m_heightRel[index] = e.heightRelLocal();
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e1 = (EntityInstance)en.nextElement();
            this.saveInfo(e1, basePreorder);
        }
    }

    RelayoutSubtree(Diagram diagram, EntityInstance container, boolean compute) {
        int need = container.nodesInSubtree();
        this.m_diagram = diagram;
        this.m_entities = new EntityInstance[need];
        this.m_xRel = new double[need];
        this.m_yRel = new double[need];
        this.m_widthRel = new double[need];
        this.m_heightRel = new double[need];
        this.m_layouter = diagram.getLs().getLayouter();
        this.m_compute = compute;
        this.saveInfo(container, container.getPreorder());
    }

    @Override
    public String getPresentationName() {
        return "Relayout subtree " + this.m_entities[0];
    }

    @Override
    public void undo() {
        Diagram diagram = this.m_diagram;
        EntityInstance[] entities = this.m_entities;
        double[] xRel = this.m_xRel;
        double[] yRel = this.m_yRel;
        double[] widthRel = this.m_widthRel;
        double[] heightRel = this.m_heightRel;
        int length = entities.length;
        int i = 1;
        while (i < length) {
            EntityInstance e = entities[i];
            if (e != null) {
                e.setRelLocal(xRel[i], yRel[i], widthRel[i], heightRel[i]);
            }
            ++i;
        }
        diagram.getLs().setLayouter(this.m_layouter);
    }

    @Override
    public void redo() {
        Diagram diagram = this.m_diagram;
        EntityInstance[] entities = this.m_entities;
        double[] xRel = this.m_xRel;
        double[] yRel = this.m_yRel;
        double[] widthRel = this.m_widthRel;
        double[] heightRel = this.m_heightRel;
        int length = entities.length;
        int i = 1;
        while (i < length) {
            EntityInstance e = entities[i];
            if (e != null) {
                e.setRelLocal(-1.0, -1.0, widthRel[i], heightRel[i]);
            }
            ++i;
        }
        diagram.getLs().setLayouter(this.m_layouter);
    }
}

