/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import lsedit.ColorCache;
import lsedit.Option;
import lsedit.Options;

class RelationLabel
extends JComponent {
    protected static final int LABEL_SPACE = 10;
    protected static Font m_labelFont = null;
    protected static FontMetrics m_fm = null;
    protected static int[] m_xs = new int[4];
    protected static int[] m_ys = new int[4];
    protected String m_text;
    protected AffineTransform m_transform;
    protected int m_x;
    protected int m_y;

    public RelationLabel(String text, Color foreground) {
        Font labelFont = m_labelFont;
        if (labelFont == null) {
            m_labelFont = labelFont = Options.getTargetFont(23);
        }
        this.m_text = text;
        if (foreground != null) {
            this.setForeground(foreground);
        }
        this.setFont(labelFont);
    }

    public static Font getEdgeLabelFont() {
        return m_labelFont;
    }

    public static void setEdgeLabelFont(Font font) {
        if (font != m_labelFont) {
            m_labelFont = font;
            m_fm = null;
        }
    }

    public void place(int srcX, int srcY, int dstX, int dstY) {
        int lwidth;
        int lheight;
        String text = this.m_text;
        Font font = m_labelFont;
        FontMetrics fm = m_fm;
        if (text == null || font == null || text == "") {
            lheight = 0;
            lwidth = 0;
        } else {
            if (fm == null) {
                m_fm = fm = this.getFontMetrics(font);
            }
            lwidth = fm.stringWidth(text) + 10;
            lheight = fm.getHeight();
        }
        if (lwidth == 0 || lheight == 0) {
            return;
        }
        int rwidth = dstX - srcX;
        int rheight = dstY - srcY;
        Option option = Options.getDiagramOptions();
        double angle = option.getLabelAngle();
        if (option.isRotateEdgeLabels()) {
            if (rwidth == 0) {
                angle = rheight >= 0 ? (angle += 1.5707963267948966) : (angle -= 1.5707963267948966);
            } else {
                double tan = (double)rheight / (double)rwidth;
                angle += Math.atan(tan);
                while (angle < 0.0) {
                    angle += Math.PI * 2;
                }
                if (angle > 1.5707963267948966 && angle < 4.71238898038469) {
                    angle += Math.PI;
                }
            }
        }
        int xc = srcX + (dstX - srcX) / 3;
        int yc = srcY + (dstY - srcY) / 3;
        int lx = xc - lwidth / 2;
        int ly = yc - lheight / 2;
        this.m_x = 5;
        this.m_y = fm.getAscent();
        if (angle == 0.0) {
            this.m_transform = null;
        } else {
            AffineTransform transform = this.m_transform;
            if (transform == null) {
                this.m_transform = transform = new AffineTransform();
            }
            double sina = Math.sin(angle);
            double cosa = Math.cos(angle);
            int x1 = Integer.MAX_VALUE;
            int x2 = Integer.MIN_VALUE;
            int y1 = Integer.MAX_VALUE;
            int y2 = Integer.MIN_VALUE;
            int w = 0;
            while (w <= lwidth) {
                int h = 0;
                while (h <= lheight) {
                    double wd = w;
                    double hd = h;
                    int x = (int)(wd * cosa - hd * sina);
                    int y = (int)(wd * sina + hd * cosa);
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                    h += lheight;
                }
                w += lwidth;
            }
            int newWidth = x2 - x1;
            int newHeight = y2 - y1;
            int extra = (newWidth - lwidth) / 2;
            lx -= extra;
            this.m_x += extra;
            extra = (newHeight - lheight) / 2;
            this.m_y += extra;
            lwidth = newWidth;
            lheight = newHeight;
            double xcd = xc -= lx;
            double ycd = yc -= (ly -= extra);
            double m02 = xcd * (1.0 - cosa) + sina * ycd;
            double m12 = ycd * (1.0 - cosa) - sina * xcd;
            transform.setTransform(cosa, sina, -sina, cosa, m02, m12);
        }
        if (lx != this.getX() || ly != this.getY() || lwidth != this.getWidth() || lheight != this.getHeight()) {
            this.setBounds(lx, ly, lwidth, lheight);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Option option = Options.getDiagramOptions();
        AffineTransform save = null;
        AffineTransform transform = this.m_transform;
        if (option.isInvertEdgeLabelBackground()) {
            Color color = g.getColor();
            g.setColor(ColorCache.getInverse(color.getRGB()));
            if (transform == null) {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                FontMetrics fm = m_fm;
                if (fm == null) {
                    m_fm = fm = this.getFontMetrics(m_labelFont);
                }
                double left = this.m_x - 5;
                double right = left + (double)(fm.stringWidth(this.m_text) + 10);
                double top = this.m_y - fm.getAscent();
                double bottom = this.m_y + fm.getDescent();
                double m00 = transform.getScaleX();
                double m01 = transform.getShearX();
                double m02 = transform.getTranslateX();
                double m10 = transform.getShearY();
                double m11 = transform.getScaleY();
                double m12 = transform.getTranslateY();
                RelationLabel.m_xs[0] = (int)(left * m00 + top * m01 + m02);
                RelationLabel.m_ys[0] = (int)(left * m10 + top * m11 + m12);
                RelationLabel.m_xs[1] = (int)(right * m00 + top * m01 + m02);
                RelationLabel.m_ys[1] = (int)(right * m10 + top * m11 + m12);
                RelationLabel.m_xs[2] = (int)(right * m00 + bottom * m01 + m02);
                RelationLabel.m_ys[2] = (int)(right * m10 + bottom * m11 + m12);
                RelationLabel.m_xs[3] = (int)(left * m00 + bottom * m01 + m02);
                RelationLabel.m_ys[3] = (int)(left * m10 + bottom * m11 + m12);
                g.fillPolygon(m_xs, m_ys, 4);
            }
            g.setColor(color);
        }
        if (transform != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            save = g2d.getTransform();
            g2d.transform(transform);
        }
        g.drawString(this.m_text, this.m_x, this.m_y);
        if (save != null) {
            ((Graphics2D)g).setTransform(save);
        }
    }

    @Override
    public String toString() {
        return "RelationLabel=" + this.m_text;
    }
}

