/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.JComponent;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.ResultBox;
import lsedit.Util;

public final class RelationInstance
extends LandscapeObject {
    protected static final int NEAR_PIXEL_SIZE = 6;
    public static final String LABEL_ID = "label";
    public static final String RLABEL_ID = "rlabel";
    public static final String DESC_ID = "description";
    public static final int STYLE_BITS = 7;
    protected static final int LOOP_MARK = 16;
    protected static final int NORMAL_MARK = 32;
    protected static final int ELISION_MARK = 64;
    protected static final int OUT_ELIDED_MARK = 256;
    protected static final int IN_ELIDED_MARK = 512;
    protected static final int IN_DIAGRAM_MARK = 1024;
    protected static final int TRACED_MARK = 2048;
    public static final int DIFFERENT_REAL_SRC_MARK = 4096;
    public static final int DIFFERENT_REAL_DST_MARK = 8192;
    public static final int VALIDATED_MARK = 16384;
    public static final int LIFTED_MARK = 32768;
    public static final int GROUP_FLAG_MARK = 65536;
    public static final int VALID_MARK = 131072;
    public static final int HIGHLIGHT_FLAG_MARK = 262144;
    public static final int FILLED_MARK = 524288;
    public static final int SPANNING_MARK = 0x100000;
    public static final int REVERSED_MARK = 0x200000;
    public static final int IN_SET_MARK = 0x8000000;
    public static final int PERMANENT_MARKS = 0x300007;
    public static final int IN_OUT_ELIDED = 768;
    public static final int VARIOUS_TYPE_MARKS = 816;
    public static final int PRESENTATION_MARKS = 329728;
    public static final int CLASS_ATTR = 0;
    public static final int COLOR_ATTR = 1;
    public static final int STYLE_ATTR = 2;
    protected EntityInstance m_src;
    protected EntityInstance m_dst;
    protected RelationComponent m_relationComponent = null;
    protected int m_mark = 7;

    public String toString() {
        return this.drawSrc() + (this.drawSrc() == this.m_src ? "" : "{" + this.m_src + "}") + "->" + this.getRelationClass() + "->" + this.drawDst() + (this.drawDst() == this.m_dst ? "" : "{" + this.m_dst + "}");
    }

    public JComponent getSwingObject() {
        return this.m_relationComponent;
    }

    public EntityInstance drawSrc() {
        return this.m_src.getDrawEntity();
    }

    public EntityInstance drawDst() {
        return this.m_dst.getDrawEntity();
    }

    public RelationComponent neededComponent() {
        RelationComponent relationComponent = this.m_relationComponent;
        if (relationComponent == null) {
            this.m_relationComponent = relationComponent = new RelationComponent(this);
        }
        return relationComponent;
    }

    public void orEmbellished(int value) {
        RelationComponent relationComponent = this.m_relationComponent;
        if (relationComponent != null) {
            relationComponent.orEmbellished(value);
        }
    }

    public void nandEmbellished(int value) {
        RelationComponent relationComponent = this.m_relationComponent;
        if (relationComponent != null) {
            relationComponent.nandEmbellished(value);
        }
    }

    public void repaint() {
        RelationComponent relationComponent = this.m_relationComponent;
        if (relationComponent != null) {
            relationComponent.repaint();
        }
    }

    public void validate() {
        RelationComponent relationComponent = this.m_relationComponent;
        if (relationComponent != null) {
            relationComponent.validate();
        }
    }

    public int getFrequency() {
        RelationComponent component = this.m_relationComponent;
        if (component != null) {
            return component.getFrequency();
        }
        return -1;
    }

    @Override
    public boolean processFirstOrder(String id, String value) {
        if (id.equals("style")) {
            if (value != null) {
                this.setStyle(Attribute.parseIntValue(value));
            }
            return true;
        }
        return super.processFirstOrder(id, value);
    }

    public static void reportFirstOrderAttributes(ResultBox resultBox) {
        resultBox.addText("color");
        resultBox.addText("style");
    }

    public RelationInstance(RelationClass parentClass, EntityInstance src, EntityInstance dst) {
        this.setParentClass(parentClass);
        this.m_src = src;
        this.m_dst = dst;
    }

    public void reverseRelation() {
        EntityInstance src = this.m_src;
        EntityInstance dst = this.m_dst;
        if (src != dst) {
            src.removeSrcRelation(this);
            dst.removeDstRelation(this);
            src.addDstRelation(this);
            dst.addSrcRelation(this);
            this.m_src = dst;
            this.m_dst = src;
        }
    }

    public RelationComponent getRelationComponent() {
        return this.m_relationComponent;
    }

    public void setRelationComponent(RelationComponent relationComponent) {
        this.m_relationComponent = relationComponent;
    }

    public boolean isRelationShown() {
        if (this.isMarked(0x100000)) {
            return false;
        }
        return this.getRelationClass().isShown();
    }

    @Override
    public int getStyle() {
        int ret = this.m_mark & 7;
        if (ret == 7) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public void setStyle(int value) {
        this.m_mark &= 0xFFFFFFF8;
        this.m_mark |= value & 7;
    }

    public String getRelationLabel() {
        String ret;
        RelationClass rc = this.getRelationClass();
        if (rc.getShown() != 2) {
            Attribute attribute = this.getLsAttribute(LABEL_ID);
            if (attribute != null && (ret = attribute.parseString()) != null) {
                return ret;
            }
            ret = rc.getLabel();
        } else {
            Attribute attribute = this.getLsAttribute(RLABEL_ID);
            if (attribute != null && (ret = attribute.parseString()) != null) {
                return ret;
            }
            attribute = this.getLsAttribute(LABEL_ID);
            if (attribute != null && (ret = attribute.parseString()) != null) {
                return String.valueOf(ret) + " (r)";
            }
            ret = rc.getReversedLabel();
            if (ret != null) {
                return ret;
            }
            ret = rc.getLabel();
            if (ret != null) {
                ret = String.valueOf(ret) + " (r)";
            }
        }
        return ret;
    }

    public String getRelationTooltip() {
        Option option = Options.getDiagramOptions();
        String id = option.isShowEdgeLabels() ? DESC_ID : LABEL_ID;
        Attribute attribute = this.getLsAttribute(id);
        if (attribute != null) {
            return attribute.parseString();
        }
        return null;
    }

    public String getClassLabel() {
        return this.getRelationClass().getLabel();
    }

    @Override
    public String getStyleName(int style) {
        return Util.getLineStyleName(style);
    }

    public void clearRelationMark() {
        this.andMark(3475463);
        this.m_relationComponent = null;
    }

    public void initFrequency() {
        RelationComponent component = this.neededComponent();
        component.initFrequency();
    }

    public void incrementFrequency(RelationInstance ri) {
        RelationComponent component = this.m_relationComponent;
        if (component != null) {
            component.incrementFrequency();
        }
        if (ri.m_src != this.m_src) {
            this.orMark(4096);
        }
        if (ri.m_dst != this.m_dst) {
            this.orMark(8192);
        }
    }

    public void orMark(int value) {
        this.m_mark |= value;
    }

    public void nandMark(int value) {
        this.m_mark &= ~value;
    }

    public void andMark(int value) {
        this.m_mark &= value;
    }

    public boolean isMarked(int value) {
        return (this.m_mark & value) != 0;
    }

    public boolean isSrcVisible() {
        return this.m_src == this.drawSrc();
    }

    public boolean isDstVisible() {
        return this.m_dst == this.drawDst();
    }

    public void invalidateEdge() {
        this.nandMark(131072);
    }

    public boolean getHighlightFlag() {
        return this.isMarked(262144);
    }

    public boolean getGroupFlag() {
        return this.isMarked(65536);
    }

    public void drawRelation(Diagram diagram, boolean allowElision) {
        RelationComponent relationComponent;
        if (this.isMarked(131072)) {
            return;
        }
        int marks = 0;
        if (!allowElision || this.isRelationShown()) {
            EntityInstance src = this.drawSrc();
            EntityInstance dst = this.drawDst();
            if (src.isMarked(8) || dst.isMarked(8)) {
                marks = 0;
            } else {
                marks = 32;
                if (allowElision) {
                    EntityInstance ancestor = src.commonAncestor(dst);
                    RelationClass parentClass = this.getRelationClass();
                    int direction = parentClass.getShown();
                    int nid = parentClass.getNid();
                    if (ancestor != null && ancestor.isMarked(1) && ancestor.getElision(4, nid)) {
                        marks = 0;
                    } else if (src.getElision(1, nid)) {
                        marks |= 0x100;
                    } else if (src != this.m_src && src != dst && src.getElision(3, nid)) {
                        marks |= 0x100;
                    } else {
                        ancestor = src.getContainedBy();
                        while (ancestor != null && ancestor.isMarked(7) && !ancestor.hasDescendantOrSelf(dst)) {
                            if (ancestor.getElision(3, nid)) {
                                marks |= 0x100;
                                break;
                            }
                            ancestor = ancestor.getContainedBy();
                        }
                    }
                    if (dst.getElision(0, nid)) {
                        marks |= 0x200;
                    } else if (dst != this.m_dst && src != dst && dst.getElision(2, nid)) {
                        marks |= 0x200;
                    } else {
                        ancestor = dst.getContainedBy();
                        while (ancestor != null && ancestor.isMarked(7) && !ancestor.hasDescendantOrSelf(src)) {
                            if (ancestor.getElision(2, nid)) {
                                marks |= 0x200;
                                break;
                            }
                            ancestor = ancestor.getContainedBy();
                        }
                    }
                }
                if (src == dst && (marks & 0x20) != 0) {
                    marks |= 0x10;
                }
            }
        }
        if (marks == 0) {
            if (this.isMarked(1024)) {
                relationComponent = this.m_relationComponent;
                if (relationComponent != null) {
                    diagram.remove(relationComponent);
                    this.m_relationComponent = null;
                }
                this.nandMark(1024);
            }
        } else {
            relationComponent = this.neededComponent();
            marks |= 0x20000;
            if (allowElision) {
                marks |= 0x40;
            }
            if (!this.isMarked(1024)) {
                this.orMark(marks |= 0x400);
                diagram.add(relationComponent);
                relationComponent.setVisible(true);
            } else {
                this.orMark(marks);
            }
            relationComponent.validate();
        }
    }

    public void writeRelation(PrintWriter ps) {
        String src = this.m_src.getId();
        String dst = this.m_dst.getId();
        if (this.isMarked(0x200000)) {
            String temp = src;
            src = dst;
            dst = temp;
        }
        ps.println(String.valueOf(this.getParentClass().getId()) + " " + src + " " + dst);
    }

    public void writeAttributes(PrintWriter ps) {
        RelationClass parentClass = this.getRelationClass();
        String src = this.m_src.getId();
        String dst = this.m_dst.getId();
        if (this.isMarked(0x200000)) {
            String temp = src;
            src = dst;
            dst = temp;
        }
        String nodeId = "(" + parentClass.getId() + " " + src + " " + dst + ")";
        int style = this.getStyle();
        if (style >= 0 && (parentClass == null || parentClass.getInheritedStyle() != style)) {
            nodeId = RelationInstance.writeAttribute(ps, nodeId, "style", style);
        }
        if ((nodeId = super.writeAttributes(ps, nodeId, parentClass, false)) == null) {
            ps.println("}");
        }
    }

    public EntityInstance getSrc() {
        return this.m_src;
    }

    public void setSrc(EntityInstance src) {
        this.m_src = src;
    }

    public EntityInstance getDst() {
        return this.m_dst;
    }

    public void setDst(EntityInstance dst) {
        this.m_dst = dst;
    }

    public EntityInstance getDrawSrc() {
        return this.drawSrc();
    }

    public EntityInstance getCurrentSrc() {
        if (this.drawSrc() != null) {
            return this.drawSrc();
        }
        return this.m_src;
    }

    public EntityInstance getDrawDst() {
        return this.drawDst();
    }

    public EntityInstance getCurrentDst() {
        if (this.drawDst() != null) {
            return this.drawDst();
        }
        return this.m_dst;
    }

    public RelationClass getRelationClass() {
        return (RelationClass)this.getParentClass();
    }

    public boolean matches(RelationInstance other) {
        return this.drawSrc() == other.drawSrc() && this.drawDst() == other.drawDst();
    }

    protected void removeEdge() {
        this.getSrc().removeSrcRelation(this);
        this.getDst().removeDstRelation(this);
    }

    @Override
    public int getPrimaryAttributeCount() {
        return 3;
    }

    @Override
    public String getLsAttributeNameAt(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "class";
                break;
            }
            case 1: {
                name = "color";
                break;
            }
            case 2: {
                name = "style";
                break;
            }
            default: {
                name = super.getLsAttributeNameAt(index);
            }
        }
        return name;
    }

    @Override
    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                LandscapeClassObject parentClass = this.getParentClass();
                if (parentClass == null) {
                    value = null;
                    break;
                }
                value = parentClass.getLabelId();
                break;
            }
            case 1: {
                value = this.getObjectColor();
                break;
            }
            case 2: {
                value = new Integer(this.getStyle());
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    @Override
    public int getLsAttributeTypeAt(int index) {
        int ret;
        switch (index) {
            case 0: {
                ret = 16;
                break;
            }
            case 1: {
                ret = 8;
                break;
            }
            case 2: {
                ret = 14;
                break;
            }
            default: {
                ret = super.getLsAttributeTypeAt(index);
            }
        }
        return ret;
    }

    public LandscapeEditorCore getLs() {
        return this.getDiagram().getLs();
    }

    public void mouseEntered() {
        this.getLs().setCursor(12);
    }

    public void mouseExited() {
        this.getLs().setCursor(0);
    }

    public void mousePressed(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationPressed(ev, this, diagramX, diagramY);
    }

    public void mouseReleased(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationReleased(ev, this, diagramX, diagramY);
    }

    public void mouseDragged(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationDragged(ev, this, diagramX, diagramY);
    }

    public void mouseMoved(MouseEvent ev, int diagramX, int diagramY) {
        Diagram diagram = this.getDiagram();
        if (this != g_infoShown) {
            String message;
            LandscapeEditorCore ls = diagram.getLs();
            int freq = this.getFrequency();
            int modifiers = ev.getModifiers();
            if ((modifiers & 1) == 0) {
                ls.infoShown(this);
            }
            this.repaint();
            if (this.m_src == this.drawSrc()) {
                message = "";
            } else {
                message = Util.quoted(this.m_src.getEntityLabel());
                if (this.isMarked(4096)) {
                    message = String.valueOf(message) + " et. al.";
                }
                message = String.valueOf(message) + "->";
            }
            message = String.valueOf(message) + Util.quoted(this.drawSrc().getEntityLabel()) + " " + this.getClassLabel() + " " + Util.quoted(this.drawDst().getEntityLabel());
            if (this.m_dst != this.drawDst()) {
                message = String.valueOf(message) + "->" + Util.quoted(this.m_dst.getEntityLabel());
                if (this.isMarked(8192)) {
                    message = String.valueOf(message) + " et. al.";
                }
            }
            if (freq != 1) {
                message = String.valueOf(message) + " (" + freq + " edges)";
            }
            this.getLs().showInfo(message);
        }
        diagram.movedOverThing(ev, this, diagramX, diagramY);
    }
}

