/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.LandscapeClassObject;
import lsedit.ResultBox;
import lsedit.Ta;
import lsedit.Util;

public final class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String HIERARCHY_ID = "class_hierarchy";
    protected static final String ISCONTAINS_ID = "class_iscontains";
    protected static final String CLASSRLABEL_ID = "class_rlabel";
    public static final int ID_ATTR = 0;
    public static final int CLASSLABEL_ATTR = 1;
    public static final int CLASSRLABEL_ATTR = 2;
    public static final int CLASSDESC_ATTR = 3;
    public static final int CLASSSTYLE_ATTR = 4;
    public static final int COLOR_ATTR = 5;
    public static final int LABEL_COLOR_ATTR = 6;
    public static final int FACTOR_ATTR = 7;
    public static final int ARROWCOLOR_ATTR = 8;
    public static final int ATTRS = 9;
    public static final String[] attributeName = new String[]{"id", "class_label", "class_rlabel", "class_description", "class_style", "color", "labelcolor", "class_iofactor", "arrowcolor"};
    public static final int[] attributeType = new int[]{3, 3, 3, 12, 14, 8, 7, 2, 8};
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected int m_containsOffset = -1;
    protected short m_iofactor = Util.undefined();
    protected int m_cIndex = -1;
    protected int m_weight = 1;
    protected Color m_arrowColor = null;
    protected String m_reversedLabel = null;
    private Vector m_relationList = new Vector();
    protected int m_ordinal;

    @Override
    public int setShown(int value, boolean applyToSubclassesTo) {
        int shown = this.m_shown;
        int ret = 0;
        if (shown != value) {
            Diagram diagram = this.getDiagram();
            if (value == 3) {
                diagram.clearRelationClassGroupFlags(this);
                this.m_weight = 0;
                diagram.invalidateVisibleRelationClasses();
            } else if (shown == 3) {
                this.m_weight = this.m_containsOffset == 0 ? 0 : 1;
                diagram.invalidateVisibleRelationClasses();
            }
            if (value == 2) {
                diagram.reverseRelations(this, true);
            } else if (shown == 2) {
                diagram.reverseRelations(this, false);
            }
            ret = 1;
        }
        if (super.setShown(value, applyToSubclassesTo) != 0) {
            ret = -1;
        }
        return ret;
    }

    public RelationClass(String id, int nid, Ta ta) {
        super(ta);
        this.setId(id);
        this.setNid(nid);
        this.setLabel(id);
    }

    public String getReversedLabel() {
        return this.m_reversedLabel;
    }

    public void setReversedLabel(String value) {
        this.m_reversedLabel = value;
    }

    public RelationClass getView() {
        RelationClass rc = new RelationClass(this.getId(), this.getNid(), this.getTa());
        rc.setShown(this.getShown(), false);
        rc.setActive(this.getActive(), false);
        rc.setContainsClassOffset(this.getContainsClassOffset());
        return rc;
    }

    public boolean setView() {
        Ta ta = this.getTa();
        RelationClass rc = ta.getRelationClass(this.getId());
        if (rc != null) {
            rc.setShown(this.getShown(), false);
            rc.setActive(this.getActive(), false);
            if (rc.getContainsClassOffset() != this.getContainsClassOffset()) {
                rc.setContainsClassOffset(this.getContainsClassOffset());
                return true;
            }
        }
        return false;
    }

    public int getCIndex() {
        return this.m_cIndex;
    }

    public int computeCIndex() {
        int cindex = this.m_cIndex;
        if (cindex < 0) {
            Diagram diagram = this.getDiagram();
            this.m_cIndex = cindex = diagram.getMaxCIndex() + 1;
        }
        return cindex;
    }

    public void setCIndex(int value) {
        this.m_cIndex = value;
    }

    public int getWeight() {
        return this.m_weight;
    }

    public void setWeight(int value) {
        this.m_weight = value;
    }

    @Override
    public String getStyleName(int style) {
        return Util.getLineStyleName(style);
    }

    public void setContainsClassOffset(int containsOffset) {
        if (this.m_containsOffset != containsOffset) {
            this.m_containsOffset = containsOffset;
            this.m_weight = containsOffset == 0 || this.m_shown == 0 ? 0 : 1;
        }
    }

    @Override
    public Color getArrowColor() {
        return this.m_arrowColor;
    }

    public void setArrowColor(Color arrowColor) {
        this.m_arrowColor = arrowColor;
    }

    public int getContainsClassOffset() {
        return this.m_containsOffset;
    }

    @Override
    public boolean processFirstOrder(String id, String value) {
        if (id.equals(CLASSRLABEL_ID)) {
            String s = Attribute.parseStringValue(value);
            if (s != null) {
                this.setReversedLabel(s);
            }
            return true;
        }
        if (id.equals("arrowcolor")) {
            this.setArrowColor(Attribute.parseColorValue(value, this, "arrowcolor"));
            return true;
        }
        if (id.equals(HIERARCHY_ID)) {
            if (value != null) {
                this.m_cIndex = Attribute.parseIntValue(value, this.m_cIndex);
            }
            return true;
        }
        if (id.equals(FACTOR_ID)) {
            short iofactor;
            if (value != null && Util.defined(iofactor = Util.parseRelativeValue(value))) {
                this.m_iofactor = iofactor;
            }
            return true;
        }
        if (id.equals(ISCONTAINS_ID)) {
            if (value != null) {
                int containsClassOffset = value.startsWith("f") ? -1 : (value.startsWith("t") ? 0 : Util.parseInt(value, -1));
                this.setContainsClassOffset(containsClassOffset);
            }
            return true;
        }
        return super.processFirstOrder(id, value);
    }

    @Override
    public void reportClassAttributes(ResultBox resultBox) {
        resultBox.addText(HIERARCHY_ID);
        resultBox.addText(CLASSRLABEL_ID);
        resultBox.addText(FACTOR_ID);
        resultBox.addText("class_active");
        resultBox.addText("class_visible");
        resultBox.addText(ISCONTAINS_ID);
        super.reportClassAttributes(resultBox);
    }

    public Vector getRelationList() {
        return this.m_relationList;
    }

    public void addRelationConstraint(EntityClassPair ep) {
        this.m_relationList.addElement(ep);
    }

    public void addRelationConstraint(EntityClass ec1, EntityClass ec2) {
        if (this.m_relationList == null) {
            this.m_relationList = new Vector();
        } else {
            Enumeration en = this.m_relationList.elements();
            while (en.hasMoreElements()) {
                EntityClassPair ep = (EntityClassPair)en.nextElement();
                if (!ep.equals(ec1, ec2)) continue;
                return;
            }
        }
        this.addRelationConstraint(new EntityClassPair(ec1, this, ec2));
    }

    public void removeRelation(EntityClassPair ep) {
        Vector relationList = this.m_relationList;
        if (relationList != null) {
            relationList.remove(ep);
        }
    }

    public boolean[][] getInheritedRelationArray() {
        EntityClass src1;
        Ta ta = this.getTa();
        int i = 0;
        Enumeration en = ta.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            src1 = (EntityClass)en.nextElement();
            src1.setOrderedId(i);
            ++i;
        }
        int size = i;
        boolean[][] array = new boolean[size][];
        i = 0;
        while (i < size) {
            boolean[] row = new boolean[size];
            array[i] = row;
            int j = 0;
            while (j < size) {
                row[j] = false;
                ++j;
            }
            ++i;
        }
        Vector rcs = this.getClassAndSuperclasses();
        en = rcs.elements();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            Enumeration en1 = rc.m_relationList.elements();
            while (en1.hasMoreElements()) {
                EntityClassPair ep = (EntityClassPair)en1.nextElement();
                Vector srcs = ta.getClassAndSubclasses(ep.m_entityClass1);
                Vector dsts = ta.getClassAndSubclasses(ep.m_entityClass2);
                Enumeration en2 = srcs.elements();
                while (en2.hasMoreElements()) {
                    src1 = (EntityClass)en2.nextElement();
                    int from = src1.getOrderedId();
                    Enumeration en3 = dsts.elements();
                    while (en3.hasMoreElements()) {
                        EntityClass dst1 = (EntityClass)en3.nextElement();
                        int to = dst1.getOrderedId();
                        array[from][to] = true;
                    }
                }
            }
        }
        return array;
    }

    public void writeEntityClassPairs(PrintWriter ps) {
        Enumeration en = this.m_relationList.elements();
        while (en.hasMoreElements()) {
            EntityClassPair ep = (EntityClassPair)en.nextElement();
            ps.println(String.valueOf(RelationClass.qt(this.getId())) + " " + RelationClass.qt(ep.m_entityClass1.getId()) + " " + RelationClass.qt(ep.m_entityClass2.getId()));
        }
    }

    public void writeAttributes(PrintWriter ps) {
        Color color;
        String nodeId = "(" + this.getId() + ")";
        if (this.m_cIndex >= 0) {
            nodeId = RelationClass.writeAttribute(ps, nodeId, HIERARCHY_ID, this.m_cIndex);
        }
        if (this.m_reversedLabel != null) {
            nodeId = RelationClass.writeAttribute(ps, nodeId, CLASSRLABEL_ID, this.m_reversedLabel);
        }
        if (Util.defined(this.m_iofactor)) {
            nodeId = RelationClass.writeAttribute(ps, nodeId, FACTOR_ID, this.m_iofactor);
        }
        if (this.m_containsOffset >= 0) {
            nodeId = RelationClass.writeAttribute(ps, nodeId, ISCONTAINS_ID, this.m_containsOffset);
        }
        if ((color = this.getArrowColor()) != null) {
            nodeId = RelationClass.writeAttribute(ps, nodeId, "arrowcolor", Util.taColor(color));
        }
        if ((nodeId = super.writeAttributes(ps, nodeId)) == null) {
            ps.println("}");
            ps.println();
        }
    }

    public int getOrdinal() {
        return this.m_ordinal;
    }

    public void setOrdinal(int ord) {
        this.m_ordinal = ord;
    }

    public short getIOfactor() {
        short iofactor = this.m_iofactor;
        if (!Util.defined(iofactor)) {
            iofactor = Util.relativeToShort(this.getRelativeIOfactor());
        }
        return iofactor;
    }

    public double getRelativeIOfactor() {
        if (Util.defined(this.m_iofactor)) {
            return Util.shortToRelative(this.m_iofactor);
        }
        Diagram diagram = this.getDiagram();
        if (diagram.allowElision()) {
            double num = diagram.numVisibleRelationClasses();
            return (double)(this.m_ordinal + 1) / (num + 1.0);
        }
        double num = diagram.numRelationClasses();
        return num > 2.0 ? (double)(this.getNid() - 1) / (num - 1.0) : 0.5;
    }

    public void setIOfactor(short value) {
        this.m_iofactor = value;
    }

    @Override
    public int getPrimaryAttributeCount() {
        return 9;
    }

    @Override
    public String getLsAttributeNameAt(int index) {
        String name = index < 9 ? attributeName[index] : super.getLsAttributeNameAt(index);
        return name;
    }

    @Override
    public int getLsAttributeTypeAt(int index) {
        int ret = index < 9 ? attributeType[index] : super.getLsAttributeTypeAt(index);
        return ret;
    }

    @Override
    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                value = this.getLabel();
                break;
            }
            case 2: {
                value = this.getReversedLabel();
                break;
            }
            case 3: {
                value = this.getDescription();
                break;
            }
            case 4: {
                value = new Integer(this.getStyle());
                break;
            }
            case 5: {
                value = this.getObjectColor();
                break;
            }
            case 6: {
                value = this.getLabelColor();
                break;
            }
            case 7: {
                value = new Double(Util.shortToRelative(this.m_iofactor));
                break;
            }
            case 8: {
                value = this.getArrowColor();
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }
}

