/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;

class ReclusterConfigure
extends JDialog
implements ActionListener {
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final String[] m_parameters = new String[]{"Scope of redistribution", "Type of edge to consider", "Bias towards moving"};
    protected static final String[] g_button_titles = new String[]{"Ok", "Cancel", "Help"};
    protected static final String[] g_edge_modes = new String[]{"All", "Incoming", "Outgoing"};
    protected static final String[] g_shift = new String[]{"Don't move if equal", "Move if equal", "Move if possible"};
    protected LandscapeEditorCore m_ls;
    protected EntityInstance m_e;
    protected JComboBox m_scope;
    protected JComboBox m_edge_mode;
    protected JComboBox m_shift;
    protected JButton[] m_buttons;
    protected boolean m_ret;

    public ReclusterConfigure(LandscapeEditorCore ls, EntityInstance e) {
        super(ls.getFrame(), "ReCluster Configuration", true);
        this.m_ls = ls;
        this.m_e = e;
        this.m_ret = false;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel labelPanel = new JPanel();
        JPanel valuePanel = new JPanel();
        GridLayout gridLayout = new GridLayout(m_parameters.length, 1, 0, 10);
        labelPanel.setLayout(gridLayout);
        gridLayout = new GridLayout(m_parameters.length, 1, 0, 10);
        valuePanel.setLayout(gridLayout);
        int i = 0;
        while (i < m_parameters.length) {
            JLabel label = new JLabel(m_parameters[i], 4);
            label.setFont(bold);
            labelPanel.add(label);
            ++i;
        }
        EntityInstance parent = e;
        this.m_scope = new JComboBox();
        while ((parent = parent.getContainedBy()) != null) {
            this.m_scope.addItem(parent.getFullEntityLabel());
        }
        this.m_scope.setFont(bold);
        valuePanel.add(this.m_scope);
        this.m_edge_mode = new JComboBox<String>(g_edge_modes);
        valuePanel.add(this.m_edge_mode);
        this.m_shift = new JComboBox<String>(g_shift);
        valuePanel.add(this.m_shift);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add("West", labelPanel);
        topPanel.add("East", valuePanel);
        Container contentPane = this.getContentPane();
        contentPane.add("North", topPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_buttons = new JButton[g_button_titles.length];
        i = 0;
        while (i < g_button_titles.length) {
            JButton button;
            String string = g_button_titles[i];
            this.m_buttons[i] = button = new JButton(string);
            button.setFont(bold);
            button.addActionListener(this);
            bottomPanel.add(button);
            ++i;
        }
        contentPane.add("South", bottomPanel);
        this.pack();
        this.setVisible(true);
    }

    public boolean ok() {
        return this.m_ret;
    }

    public EntityInstance scope() {
        int index = this.m_scope.getSelectedIndex();
        EntityInstance parent = this.m_e;
        if (index >= 0) {
            while ((parent = parent.getContainedBy()) != null) {
                if (index == 0) {
                    return parent;
                }
                --index;
            }
        }
        return null;
    }

    public int edgemode() {
        return this.m_edge_mode.getSelectedIndex();
    }

    public int shift() {
        return this.m_shift.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        int state = -1;
        int i = 0;
        while (i < g_button_titles.length) {
            if (source == this.m_buttons[i]) {
                state = i;
                break;
            }
            ++i;
        }
        switch (state) {
            case 2: {
                JOptionPane.showMessageDialog(this.m_ls.getFrame(), "Redistribution selectively moves nodes under the selected nodes\nand/or those nodes associated with selected edges to other target\nparents, in a manner that maximizes internal edges.\nThis operation is constrained by:\n1) The target parent must be within the specified scope.\n2) Considering only edges of the specified type.\n3) If the total number of internal edges remains unchanged by\n   moving nodes, nodes are move only if the bias is towards\n   moving.  However nodes are always moved if possible if the\n   option 'always move' is selected.", "Help", -1);
                return;
            }
            case 0: {
                this.m_ret = true;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }
}

