/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.HashEntry;
import lsedit.LandscapeEditorCore;
import lsedit.ReclusterConfigure;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.Util;

public class Recluster {
    public static String layout(Diagram diagram) {
        EntityInstance e1;
        Enumeration en;
        EntityInstance e;
        boolean outgoing;
        boolean incoming;
        Vector v = diagram.getReclusterGroup();
        if (v == null) {
            Util.beep();
            return "No group selected";
        }
        LandscapeEditorCore ls = diagram.getLs();
        ReclusterConfigure configure = new ReclusterConfigure(ls, (EntityInstance)v.elementAt(0));
        if (!configure.ok()) {
            return "Action cancelled";
        }
        EntityInstance scope = configure.scope();
        if (scope == null) {
            return "Scope not specified";
        }
        switch (configure.edgemode()) {
            case 1: {
                incoming = true;
                outgoing = false;
                break;
            }
            case 2: {
                incoming = false;
                outgoing = true;
                break;
            }
            default: {
                incoming = true;
                outgoing = true;
            }
        }
        int i = 0;
        while (i < v.size()) {
            e = (EntityInstance)v.elementAt(i);
            en = e.getChildrenShown();
            while (en.hasMoreElements()) {
                e1 = (EntityInstance)en.nextElement();
                v.addElement(e1);
            }
            ++i;
        }
        int shift = configure.shift();
        ResultBox resultBox = ls.getResultBox();
        resultBox.clear();
        resultBox.activate();
        resultBox.setResultTitle("Moved nodes");
        Hashtable<String, HashEntry> hashtable = new Hashtable<String, HashEntry>();
        int moves = 0;
        EntityInstance lastparent = null;
        int size = v.size();
        int iteration = 0;
        while (iteration < 10) {
            boolean ret = false;
            i = 0;
            while (i < size) {
                HashEntry entry;
                String id;
                EntityInstance parent;
                RelationInstance ri;
                e = (EntityInstance)v.elementAt(i);
                EntityInstance old = e.getContainedBy();
                hashtable.clear();
                if (outgoing && (en = e.srcRelationElements()) != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || (e1 = ri.getDst()) == e || !scope.hasDescendant(e1)) continue;
                        parent = e1.getContainedBy();
                        if (shift == 2 && parent == old) continue;
                        id = parent.getId();
                        entry = (HashEntry)hashtable.get(id);
                        if (entry == null) {
                            entry = new HashEntry(parent);
                            hashtable.put(id, entry);
                            continue;
                        }
                        entry.increment();
                    }
                }
                if (incoming && (en = e.dstRelationElements()) != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || (e1 = ri.getSrc()) == e || !scope.hasDescendant(e1)) continue;
                        parent = e1.getContainedBy();
                        if (shift == 2 && parent == old) continue;
                        id = parent.getId();
                        entry = (HashEntry)hashtable.get(id);
                        if (entry == null) {
                            entry = new HashEntry(parent);
                            hashtable.put(id, entry);
                            continue;
                        }
                        entry.increment();
                    }
                }
                if (!hashtable.isEmpty()) {
                    HashEntry best = null;
                    en = hashtable.elements();
                    while (en.hasMoreElements()) {
                        entry = (HashEntry)en.nextElement();
                        if (best != null && (entry.m_cnt < best.m_cnt || entry.m_cnt == best.m_cnt && (shift == 0 ? entry.m_parent != old : entry.m_parent == old))) continue;
                        best = entry;
                    }
                    if (best.m_parent != old) {
                        diagram.updateMoveEntityContainment(best.m_parent, e);
                        if (old != lastparent) {
                            resultBox.addResultEntity(old, resultBox.getLeftShowAncestors());
                            lastparent = old;
                        }
                        resultBox.addRelation("  ", e.getContainedByRelation());
                        ++moves;
                        ret = true;
                    }
                }
                ++i;
            }
            if (!ret) break;
            ++iteration;
        }
        resultBox.done("-- End of redistribution --");
        hashtable.clear();
        return moves + " nodes moved within " + scope.getFullEntityLabel() + " in " + iteration + " iterations";
    }
}

