/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.EdgePoint;
import lsedit.ElidedInfo;
import lsedit.EntityInstance;
import lsedit.MoveModeHandler;
import lsedit.Options;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.Util;

class PeerElidedInfo
extends ElidedInfo {
    protected EntityInstance m_srcEntity;
    protected EdgePoint m_src;
    protected int m_dstX;
    protected int m_dstY;

    @Override
    public void getBounds(Rectangle r) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        this.getBounds((int)srcEntity.getEdgePointX(src), (int)srcEntity.getEdgePointY(src), this.m_dstX, this.m_dstY, r);
    }

    @Override
    public boolean contains(int x, int y) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        return PeerElidedInfo.nearLine(srcEntity.getEdgePointX(src), srcEntity.getEdgePointY(src), this.m_dstX, this.m_dstY, x, y);
    }

    @Override
    public void paintComponent(Graphics g, int shiftX, int shiftY) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        int srcX = (int)(srcEntity.getEdgePointX(src) - (double)shiftX);
        int srcY = (int)(srcEntity.getEdgePointY(src) - (double)shiftY);
        int dstX = this.m_dstX - shiftX;
        int dstY = this.m_dstY - shiftY;
        Util.drawSegment(g, this.m_style, srcX, srcY, dstX, dstY);
    }

    public PeerElidedInfo(RelationComponent component) {
        this.m_component = component;
    }

    @Override
    public void setElidedInfo(EntityInstance srcEntity, EdgePoint srcPt, EntityInstance dstEntity, EdgePoint dstPt) {
        double srcX = srcEntity.getEdgePointX(srcPt);
        double srcY = srcEntity.getEdgePointY(srcPt);
        double dx = srcX - dstEntity.getEdgePointX(dstPt);
        double dy = srcY - dstEntity.getEdgePointY(dstPt);
        double df = Math.sqrt(dx * dx + dy * dy);
        double arrowLength = Options.getArrowLength();
        if (df == 0.0) {
            this.m_dstX = (int)(srcX - 2.0 * arrowLength);
            this.m_dstY = (int)(srcY - 2.0 * arrowLength);
        } else {
            this.m_dstX = (int)(srcX - dx * 2.0 * arrowLength / df);
            this.m_dstY = (int)(srcY - dy * 2.0 * arrowLength / df);
        }
        this.m_srcEntity = srcEntity;
        this.m_src = srcPt;
    }

    @Override
    public boolean mouseOverEdgePoint(int x, int y, MoveModeHandler handler) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        if (PeerElidedInfo.nearPoint(srcEntity.getEdgePointX(src), srcEntity.getEdgePointY(src), x, y)) {
            RelationInstance ri = this.m_component.getRelationInstance();
            handler.overEdgePointCallBack(srcEntity, ri, src);
            return true;
        }
        return false;
    }

    @Override
    public void switchEdgePoint(EdgePoint oldPoint, EdgePoint newPoint) {
        if (this.m_src == oldPoint) {
            this.m_src = newPoint;
        }
    }

    public String toString() {
        return "Peer elided " + this.m_srcEntity.getLabel();
    }
}

