/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import lsedit.FontCache;
import lsedit.IconCache;
import lsedit.LandscapeEditorCore;
import lsedit.Util;

public class Option {
    public static final String DEFAULT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_MENU_FONT_NAME = "Dialog";
    public static final int DEFAULT_MENU_FONT_STYLE = 1;
    public static final int DEFAULT_MENU_FONT_SIZE = 12;
    public static final String DEFAULT_DIALOG_FONT_NAME = "Dialog";
    public static final int DEFAULT_DIALOG_FONT_STYLE = 0;
    public static final int DEFAULT_DIALOG_FONT_SIZE = 12;
    public static final String DEFAULT_OPEN_FONT_NAME = "Helvetica";
    public static final int DEFAULT_OPEN_FONT_STYLE = 0;
    public static final int DEFAULT_OPEN_FONT_SIZE = 12;
    public static final String DEFAULT_CLOSED_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLOSED_FONT_STYLE = 0;
    public static final int DEFAULT_CLOSED_FONT_SIZE = 12;
    public static final String DEFAULT_SMALL_FONT_NAME = "Helvetica";
    public static final int DEFAULT_SMALL_FONT_STYLE = 0;
    public static final int DEFAULT_SMALL_FONT_SIZE = 10;
    public static final String DEFAULT_CARDINAL_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CARDINAL_FONT_STYLE = 0;
    public static final int DEFAULT_CARDINAL_FONT_SIZE = 9;
    public static final String DEFAULT_CLIENT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLIENT_FONT_STYLE = 0;
    public static final int DEFAULT_CLIENT_FONT_SIZE = 10;
    public static final String DEFAULT_RESULT_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_RESULT_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_RESULT_TITLE_FONT_SIZE = 14;
    public static final String DEFAULT_RESULT_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_RESULT_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_RESULT_TEXT_FONT_SIZE = 11;
    public static final String DEFAULT_LEGEND_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_LEGEND_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_LEGEND_TITLE_FONT_SIZE = 12;
    public static final String DEFAULT_LEGEND_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_LEGEND_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_LEGEND_TEXT_FONT_SIZE = 11;
    public static final String DEFAULT_QUERY_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_QUERY_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_QUERY_TITLE_FONT_SIZE = 12;
    public static final String DEFAULT_QUERY_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_QUERY_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_QUERY_TEXT_FONT_SIZE = 11;
    public static final String DEFAULT_TOC_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TOC_FONT_STYLE = 0;
    public static final int DEFAULT_TOC_FONT_SIZE = 11;
    public static final String DEFAULT_UNDO_FONT_NAME = "Helvetica";
    public static final int DEFAULT_UNDO_FONT_STYLE = 0;
    public static final int DEFAULT_UNDO_FONT_SIZE = 11;
    public static final String DEFAULT_HISTORY_FONT_NAME = "Helvetica";
    public static final int DEFAULT_HISTORY_FONT_STYLE = 0;
    public static final int DEFAULT_HISTORY_FONT_SIZE = 11;
    public static final String DEFAULT_MAP_FONT_NAME = "Helvetica";
    public static final int DEFAULT_MAP_FONT_STYLE = 0;
    public static final int DEFAULT_MAP_FONT_SIZE = 10;
    public static final String DEFAULT_CLIPBOARD_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLIPBOARD_FONT_STYLE = 0;
    public static final int DEFAULT_CLIPBOARD_FONT_SIZE = 11;
    public static final String DEFAULT_TEXTBOX_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TEXTBOX_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_TEXTBOX_TITLE_FONT_SIZE = 14;
    public static final String DEFAULT_TEXTBOX_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TEXTBOX_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_TEXTBOX_TEXT_FONT_SIZE = 11;
    public static final String DEFAULT_FEEDBACK_FONT_NAME = "Helvetica";
    public static final int DEFAULT_FEEDBACK_FONT_STYLE = 0;
    public static final int DEFAULT_FEEDBACK_FONT_SIZE = 11;
    public static final String DEFAULT_ATTRIBUTE_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE = 11;
    public static final String DEFAULT_EDGE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_EDGE_FONT_STYLE = 0;
    public static final int DEFAULT_EDGE_FONT_SIZE = 11;
    public static final String DEFAULT_VIEWS_FONT_NAME = "Helvetica";
    public static final int DEFAULT_VIEWS_FONT_STYLE = 0;
    public static final int DEFAULT_VIEWS_FONT_SIZE = 11;
    public static final String DEFAULT_TABS_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TABS_FONT_STYLE = 0;
    public static final int DEFAULT_TABS_FONT_SIZE = 11;
    public static final int FONT_ALL = 0;
    public static final int FONT_CLOSED = 1;
    public static final int FONT_SMALL = 2;
    public static final int FONT_OPEN = 3;
    public static final int FONT_CLIENTS = 4;
    public static final int FONT_CARDINALS = 5;
    public static final int FONT_RESULTS_TITLE = 6;
    public static final int FONT_RESULTS_TEXT = 7;
    public static final int FONT_LEGEND_TITLE = 8;
    public static final int FONT_LEGEND_TEXT = 9;
    public static final int FONT_QUERY_TITLE = 10;
    public static final int FONT_QUERY_TEXT = 11;
    public static final int FONT_TOC = 12;
    public static final int FONT_UNDO = 13;
    public static final int FONT_HISTORY = 14;
    public static final int FONT_MAP = 15;
    public static final int FONT_TEXTBOX_TITLE = 16;
    public static final int FONT_TEXTBOX_TEXT = 17;
    public static final int FONT_FEEDBACK = 18;
    public static final int FONT_MENU = 19;
    public static final int FONT_DIALOG = 20;
    public static final int FONT_CLIPBOARD = 21;
    public static final int FONT_ATTR_TEXT = 22;
    public static final int FONT_EDGE_LABEL = 23;
    public static final int FONT_VIEWS = 24;
    public static final int FONT_TABS = 25;
    public static final int FONT_LAST = 25;
    public static final String[] m_default_fontnames = new String[]{"Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Dialog", "Dialog", "Helvetica", "Helvetica", "Helvetica", "Helvetica", "Helvetica"};
    public static final int[] m_default_fontstyles;
    public static final int[] m_default_fontsizes;
    private String m_option_name;
    private Font[] m_fonts = new Font[26];
    public static final int INFLECTION_EDGE_STATE = 0;
    public static final int TB_EDGE_STATE = 1;
    public static final int DIRECT_EDGE_STATE = 2;
    public static final int SIDE_EDGE_STATE = 3;
    public static final int ICON_RULE_NONE = 0;
    public static final int ICON_RULE_PLAIN = 1;
    public static final int ICON_RULE_CENTERED = 2;
    public static final int ICON_RULE_BOTTOM = 3;
    public static final int ICON_RULE_TOP = 4;
    public static final int ICON_RULE_EMPTY = 5;
    public static final int LOAD_RULE = 0;
    public static final int GRIDSIZE = 1;
    public static final int GRIDCOLOR = 2;
    public static final int ELISIONICON = 3;
    protected final String[] m_numeric_option_tags = new String[]{"option:load", "option:gridsize", "option:gridcolor", "option:elisionicon"};
    public static final int LOAD_YES = 0;
    public static final int LOAD_NO = 1;
    public static final int LOAD_PROMPT = 2;
    public static final int LOAD_STATE_DEFAULT = 0;
    public static final int EDGE_STATE_DEFAULT = 3;
    public static final boolean ICON_FIXED_DEFAULT = true;
    public static final int ELISION_ICON_DEFAULT = -1;
    public static final String ICONPATH_DEFAULT = ".;icons;../icons";
    public static final int GRIDPIXELS_DEFAULT = 1;
    public static final Color GRIDCOLOR_DEFAULT;
    public static final int CHASE_EDGES_DEFAULT = -1;
    public static final boolean CHASE_HIDE_DEFAULT = false;
    public static final boolean GROUP_QUERY_DEFAULT = false;
    public static final boolean QUERY_PERSISTS_DEFAULT = false;
    public static final boolean VISIBLE_SPANS_DEFAULT = true;
    protected int m_load_state = 0;
    protected int m_edge_state = 3;
    private int m_icon_rule = 0;
    private int m_elision_icon = -1;
    private String m_iconPath = ".;icons;../icons";
    private boolean m_icon_fixed_shape = true;
    protected boolean m_show_grid_state = false;
    protected boolean m_snap_to_grid_state = true;
    protected int m_gridPixels = 1;
    protected Color m_gridColor = GRIDCOLOR_DEFAULT;
    protected int m_chase_edges = -1;
    protected boolean m_chase_hide_state = false;
    protected boolean m_group_query_state = false;
    protected boolean m_query_persists_state = false;
    protected boolean m_visible_spans_state = true;
    public static final int LINE_WIDTH = 0;
    public static final int ARROW_LENGTH = 1;
    public static final int ARROW_ARC = 2;
    public static final int PIXELS_3D = 3;
    public static final int SHADOW_SIZE = 4;
    public static final int LABEL_ANGLE = 5;
    public static final int HOVER_SCALE = 6;
    public static final int ZOOM_X = 7;
    public static final int ZOOM_Y = 8;
    public static final int ICON_PATH = 9;
    public static final int EDGE_MODE = 10;
    public static final int ICON_RULE = 11;
    public static final int CHASE_EDGES = 12;
    private int m_line_width;
    private double m_arrow_length;
    private double m_arrow_arc;
    private int m_pixels_3d;
    private int m_shadow_size;
    private double m_label_angle;
    private double m_hover_scale;
    private double m_zoom_x;
    private double m_zoom_y;
    public static final String[] m_arrow_numeric_tags;
    public static final int ICON_FIXED_SHAPE = 0;
    public static final int FILL_ARROWHEAD = 1;
    public static final int CENTER_ARROWHEAD = 2;
    public static final int WEIGHTED_ARROWHEAD = 3;
    public static final int BLACKWHITE_3D = 4;
    public static final int SHOW_EDGE_LABELS = 5;
    public static final int ROTATE_EDGE_LABELS = 6;
    public static final int SHOW_EDGE_TOOLTIP = 7;
    public static final int VARIABLE_ARROW_COLOR = 8;
    public static final int INVERT_EDGE_LABEL_BACKGROUND = 9;
    public static final int LABEL_INVERT_FORE = 10;
    public static final int LABEL_INVERT_BACK = 11;
    public static final int LABEL_BLACK_WHITE = 12;
    private static final String[] m_arrow_boolean_tags;
    private boolean m_fill_arrowhead;
    private boolean m_center_arrowhead;
    private boolean m_permanently_weight;
    private boolean m_blackwhite_3d;
    private boolean m_show_edge_labels;
    private boolean m_rotate_edge_labels;
    private boolean m_show_edge_tooltip;
    private boolean m_variable_arrow_color;
    private boolean m_invert_edge_label_back;
    private boolean m_label_invert_fore;
    private boolean m_label_invert_back;
    private boolean m_entity_labels_blackwhite;
    protected final String[] m_boolean_option_tags = new String[]{"option:showdesc", "option:showfeedback", "option:lefttabbox", "option:tabsscroll", "option:fixedscrollbars", "option:sorttoc", "option:topclients", "option:showclients", "option:showsuppliers", "option:usecompaction", "option:visibleedges", "option:visibleentities", "option:liftedges", "option:dstcardinals", "option:srccardinals", "option:groupquery", "option:querypersists", "option:focusancestor", "option:hideempty", "option:membercounts", "option:inheritance", "option:legendblack", "option:showgrid", "option:snaptogrid", "option:chasehide", "option:toolbar", "option:visiblespans"};
    private static final int SHOW_DESC = 0;
    private static final int SHOW_FEEDBACK = 1;
    private static final int LEFT_TABBOX = 2;
    private static final int TABS_SCROLL = 3;
    private static final int FIXED_SCROLLBARS = 4;
    private static final int SORT_TOC = 5;
    private static final int TOP_CLIENTS = 6;
    private static final int SHOW_CLIENTS = 7;
    private static final int SHOW_SUPPLIERS = 8;
    private static final int USE_COMPACTION = 9;
    private static final int VISIBLE_EDGES = 10;
    private static final int VISIBLE_ENTITIES = 11;
    private static final int LIFT_EDGES = 12;
    private static final int SHOW_DST_CARDINALS = 13;
    private static final int SHOW_SRC_CARDINALS = 14;
    private static final int GROUP_QUERY = 15;
    private static final int QUERY_PERSISTS = 16;
    private static final int FOCUS_ANCESTOR = 17;
    private static final int HIDE_EMPTY = 18;
    private static final int MEMBER_COUNTS = 19;
    private static final int SHOW_INHERITANCE = 20;
    private static final int LEGEND_LABELS_BLACK = 21;
    private static final int SHOW_GRID = 22;
    private static final int SNAP_TO_GRID = 23;
    private static final int CHASE_HIDE = 24;
    private static final int SHOW_TOOLBAR = 25;
    private static final int VISIBLE_SPANS = 26;
    public static final boolean SHOW_DESC_DEFAULT = true;
    public static final boolean SHOW_FEEDBACK_DEFAULT = true;
    public static final boolean TOP_CLIENTS_DEFAULT = true;
    public static final boolean SHOW_CLIENTS_DEFAULT = true;
    public static final boolean SHOW_SUPPLIERS_DEFAULT = true;
    public static final boolean USE_COMPACTION_DEFAULT = true;
    public static final boolean SHOW_DST_CARDINALS_DEFAULT = false;
    public static final boolean SHOW_SRC_CARDINALS_DEFAULT = false;
    public static final boolean FIX_SCROLLBARS_DEFAULT = false;
    public static final boolean LEFT_TABBOX_DEFAULT = false;
    public static final boolean TABS_SCROLL_DEFAULT = false;
    public static final boolean LIFT_EDGES_DEFAULT = true;
    public static final boolean VISIBLE_EDGES_DEFAULT = false;
    public static final boolean VISIBLE_ENTITIES_DEFAULT = false;
    public static final boolean FOCUS_ANCESTOR_DEFAULT = false;
    public static final boolean SORT_TOC_DEFAULT = false;
    public static final boolean HIDE_EMPTY_DEFAULT = false;
    public static final boolean MEMBER_COUNTS_DEFAULT = false;
    public static final boolean INHERITANCE_DEFAULT = false;
    public static final boolean LEGEND_BLACK_DEFAULT = false;
    public static final boolean SHOW_GRID_DEFAULT = false;
    public static final boolean SNAP_TO_GRID_DEFAULT = true;
    public static final boolean SHOW_TOOLBAR_DEFAULT = true;
    protected boolean m_show_toolbar_state = true;
    protected boolean m_show_desc_state = true;
    protected boolean m_show_feedback_state = true;
    protected boolean m_top_clients_state = true;
    protected boolean m_show_clients_state = true;
    protected boolean m_show_suppliers_state = true;
    protected boolean m_use_compaction_state = true;
    protected boolean m_show_dst_cardinals_state = false;
    protected boolean m_show_src_cardinals_state = false;
    protected boolean m_fix_scrollbars_state = false;
    protected boolean m_left_tabbox_state = false;
    protected boolean m_tabs_scroll_state = false;
    protected boolean m_lift_edges_state = true;
    protected boolean m_visible_edges_state = false;
    protected boolean m_visible_entities_state = false;
    protected boolean m_focus_ancestor_state = false;
    protected boolean m_sort_toc_state = false;
    protected boolean m_hide_empty_state = false;
    protected boolean m_member_counts_state = false;
    protected boolean m_inheritance_state = false;
    protected boolean m_legend_labels_black = false;

    static {
        int[] nArray = new int[26];
        nArray[6] = 1;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[16] = 1;
        nArray[19] = 1;
        m_default_fontstyles = nArray;
        m_default_fontsizes = new int[]{12, 12, 10, 12, 10, 9, 14, 11, 12, 11, 12, 11, 11, 11, 11, 10, 14, 11, 11, 12, 12, 11, 11, 11, 11, 11};
        GRIDCOLOR_DEFAULT = Color.WHITE;
        m_arrow_numeric_tags = new String[]{"arrow:linewidth", "arrow:linelength", "arrow:arc", "arrow:3dpixels", "arrow:shadow", "arrow:labelarc", "arrow:hover", "arrow:zoomx", "arrow:zoomy", "arrow:iconpath", "arrow:edgemode", "arrow:iconrule", "arrow:chase"};
        m_arrow_boolean_tags = new String[]{"arrow:iconfixed", "arrow:fill", "arrow:center", "arrow:weighted", "arrow:blackwhite", "arrow:edgelabel", "arrow:rotate", "arrow:edgetip", "arrow:color", "arrow:invert", "arrow:labelfg", "arrow:labelbg", "arrow:labelbw"};
    }

    public void reset() {
        this.resetFonts();
        this.resetMainOptions();
        this.resetArrowOptions();
        this.resetDiagramOptions();
    }

    public Option(String option_name) {
        this.m_option_name = option_name;
        this.reset();
    }

    public static String getDefaultFontName(int target) {
        if (target >= 0 && target < m_default_fontnames.length) {
            return m_default_fontnames[target];
        }
        System.out.println("Option.getDefaultFontName() Illegal target " + target);
        return "Helvetica";
    }

    public static int getDefaultFontStyle(int target) {
        if (target >= 0 && target < m_default_fontstyles.length) {
            return m_default_fontstyles[target];
        }
        System.out.println("Option.getDefaultFontStyle() Illegal target " + target);
        return 0;
    }

    public static int getDefaultFontSize(int target) {
        if (target >= 0 && target < m_default_fontsizes.length) {
            return m_default_fontsizes[target];
        }
        System.out.println("Option.getDefaultFontSize() Illegal target " + target);
        return 12;
    }

    public static Font getDefaultFont(int target) {
        return FontCache.get(Option.getDefaultFontName(target), Option.getDefaultFontStyle(target), Option.getDefaultFontSize(target));
    }

    public Font getTargetFont(int target) {
        return this.m_fonts[target];
    }

    public void setTargetFont(int target, Font font) {
        this.m_fonts[target] = font;
    }

    public void setTargetFont(int target, Font font, boolean name_default, boolean style_default, boolean size_default) {
        if (target == 0) {
            int i = 1;
            while (i <= 25) {
                if (name_default || style_default || size_default) {
                    String name = name_default ? Option.getDefaultFontName(i) : font.getName();
                    int style = style_default ? Option.getDefaultFontStyle(i) : font.getStyle();
                    int size = size_default ? Option.getDefaultFontSize(i) : font.getSize();
                    Font font1 = FontCache.get(name, style, size);
                    this.setTargetFont(i, font1);
                } else {
                    this.setTargetFont(i, font);
                }
                ++i;
            }
        } else {
            this.setTargetFont(target, font);
        }
    }

    public void resetFonts() {
        Font[] fonts = this.m_fonts;
        int target = 0;
        while (target <= 25) {
            this.setTargetFont(target, Option.getDefaultFont(target));
            ++target;
        }
    }

    public void setFontsTo(Option other) {
        if (other == null) {
            this.resetFonts();
        } else {
            Font[] fonts = other.m_fonts;
            int target = 1;
            while (target <= 25) {
                this.setTargetFont(target, fonts[target]);
                ++target;
            }
        }
    }

    private void loadFont(String attribute, String value) {
        int target = 0;
        int style = 0;
        int size = 0;
        int lth = value.length();
        if (lth > 1 && value.charAt(0) == '\"' && value.charAt(lth - 1) == '\"') {
            value = value.substring(1, lth - 1);
        }
        try {
            char c;
            int i = 5;
            while (true) {
                if (i >= attribute.length()) {
                    return;
                }
                c = attribute.charAt(i);
                if (c == ']') break;
                if (c < '0' || c > '9') {
                    return;
                }
                target = target * 10 + (c - 48);
                ++i;
            }
            if (target <= 0 || 25 < target) {
                return;
            }
            i = 0;
            while (true) {
                if (i >= value.length()) {
                    return;
                }
                c = value.charAt(i);
                if (c == ',') break;
                ++i;
            }
            if (i == 0) {
                return;
            }
            String name = value.substring(0, i);
            while (true) {
                if (++i >= value.length()) {
                    return;
                }
                c = value.charAt(i);
                if (c == ',') break;
                if (c < '0' || c > '9') {
                    return;
                }
                style = style * 10 + (c - 48);
            }
            while (++i < value.length() && (c = value.charAt(i)) != '\r' && c != '\n' && c != ' ') {
                if (c < '0' || c > '9') {
                    return;
                }
                size = size * 10 + (c - 48);
            }
            Font font = FontCache.get(name, style, size);
            this.setTargetFont(target, font);
        }
        catch (Exception e) {
            System.out.println("Option.loadFont=" + target + " " + e.getMessage());
        }
    }

    private void saveFonts(PrintWriter ps) {
        int target = 1;
        while (target <= 25) {
            Font font = this.getTargetFont(target);
            String name = font.getName();
            int style = font.getStyle();
            int size = font.getSize();
            ps.println("font[" + target + "]=\"" + name + "," + style + "," + size + "\"");
            ++target;
        }
    }

    public int getLoadMode() {
        return this.m_load_state;
    }

    public void setLoadMode(int mode) {
        if (mode >= 0 && mode < 4) {
            this.m_load_state = mode;
        }
    }

    public void setLoadMode(String string) {
        try {
            this.m_load_state = Integer.parseInt(string);
        }
        catch (Throwable e) {
            System.out.println("Option.setLoadMode(\"" + string + "\") " + e.getMessage());
        }
    }

    public int getEdgeMode() {
        return this.m_edge_state;
    }

    public void setEdgeMode(int mode) {
        if (mode >= 0 && mode <= 3) {
            this.m_edge_state = mode;
        }
    }

    public String setEdgeMode(String string) {
        int ival;
        block3: {
            try {
                ival = Integer.parseInt(string);
                if (ival >= 0 && ival <= 3) break block3;
                return "EdgeMode must be a value between 0 and 3";
            }
            catch (Throwable e) {
                return "EdgeMode is not an integer";
            }
        }
        this.m_edge_state = ival;
        return null;
    }

    public int getIconRule() {
        return this.m_icon_rule;
    }

    public void setIconRule(int value) {
        if (value >= 0) {
            this.m_icon_rule = value;
        }
    }

    public String setIconRule(String string) {
        int ival;
        block3: {
            try {
                ival = Integer.parseInt(string);
                if (ival >= 0 && ival <= 4) break block3;
                return "IconRule must be a value between 0 and 4";
            }
            catch (Throwable e) {
                return "IconRule is not an integer";
            }
        }
        this.m_icon_rule = ival;
        return null;
    }

    public String getIconPath() {
        return this.m_iconPath;
    }

    public String setIconPath(String value) {
        this.m_iconPath = value.replace('\\', '/');
        return null;
    }

    public boolean isIconFixedShape() {
        return this.m_icon_fixed_shape;
    }

    public void setIconFixedShape(boolean value) {
        this.m_icon_fixed_shape = value;
    }

    public int getElisionIcon() {
        return this.m_elision_icon;
    }

    public void setElisionIcon(int value) {
        if (this.m_elision_icon != value) {
            IconCache.clearElisionCache();
            this.m_elision_icon = value;
        }
    }

    public void setElisionIcon(String string) {
        try {
            this.m_elision_icon = Integer.parseInt(string);
        }
        catch (Throwable e) {
            System.out.println("Option.elisionIcon(\"" + string + "\") " + e.getMessage());
        }
    }

    public int getGridSize() {
        return this.m_gridPixels;
    }

    public void setGridSize(int value) {
        this.m_gridPixels = value;
    }

    public void setGridSize(String string) {
        try {
            this.m_gridPixels = Integer.parseInt(string);
        }
        catch (Throwable e) {
            System.out.println("Option.setGridSize(\"" + string + "\") " + e.getMessage());
        }
    }

    public Color getGridColor() {
        return this.m_gridColor;
    }

    public void setGridColor(Color value) {
        this.m_gridColor = value;
    }

    public boolean isShowGrid() {
        return this.m_show_grid_state;
    }

    public boolean isSnapToGrid() {
        return this.m_snap_to_grid_state;
    }

    public void setSnapToGrid(boolean value) {
        this.m_snap_to_grid_state = value;
    }

    public void setShowGrid(boolean value) {
        this.m_show_grid_state = value;
    }

    public int getChaseEdges() {
        return this.m_chase_edges;
    }

    public void setChaseEdges(int value) {
        this.m_chase_edges = value;
    }

    public String setChaseEdges(String string) {
        try {
            int ival;
            this.m_chase_edges = ival = Integer.parseInt(string);
        }
        catch (Throwable e) {
            return "Chase edges is not an integer";
        }
        return null;
    }

    public boolean isChaseHide() {
        return this.m_chase_hide_state;
    }

    public void setChaseHide(boolean value) {
        this.m_chase_hide_state = value;
    }

    public boolean isGroupQuery() {
        return this.m_group_query_state;
    }

    public void setGroupQuery(boolean value) {
        this.m_group_query_state = value;
    }

    public boolean isQueryPersists() {
        return this.m_query_persists_state;
    }

    public void setQueryPersists(boolean value) {
        this.m_query_persists_state = value;
    }

    public boolean isVisibleSpans() {
        return this.m_visible_spans_state;
    }

    public void setVisibleSpans(boolean value) {
        this.m_visible_spans_state = value;
    }

    public void resetDiagramOptions() {
        this.m_load_state = 0;
        this.m_edge_state = 3;
        this.m_icon_rule = 0;
        this.m_iconPath = ICONPATH_DEFAULT;
        this.m_icon_fixed_shape = true;
        this.m_elision_icon = -1;
        this.m_show_grid_state = false;
        this.m_snap_to_grid_state = true;
        this.m_gridPixels = 1;
        this.m_gridColor = GRIDCOLOR_DEFAULT;
        this.m_chase_edges = -1;
        this.m_chase_hide_state = false;
        this.m_group_query_state = false;
        this.m_query_persists_state = false;
        this.m_visible_spans_state = true;
    }

    public void setDiagramOptionsTo(Option other) {
        if (other == null) {
            this.resetDiagramOptions();
        } else {
            this.m_load_state = other.m_load_state;
            this.m_edge_state = other.m_edge_state;
            this.m_icon_rule = other.m_icon_rule;
            this.m_iconPath = other.m_iconPath;
            this.m_icon_fixed_shape = other.m_icon_fixed_shape;
            this.m_elision_icon = other.m_elision_icon;
            this.m_show_grid_state = other.m_show_grid_state;
            this.m_snap_to_grid_state = other.m_snap_to_grid_state;
            this.m_gridPixels = other.m_gridPixels;
            this.m_gridColor = other.m_gridColor;
            this.m_chase_edges = other.m_chase_edges;
            this.m_chase_hide_state = other.m_chase_hide_state;
            this.m_group_query_state = other.m_group_query_state;
            this.m_query_persists_state = other.m_query_persists_state;
            this.m_visible_spans_state = other.m_visible_spans_state;
        }
    }

    public void resetArrowOptions() {
        this.m_line_width = 1;
        this.m_arrow_length = 10.0;
        this.m_arrow_arc = 0.4;
        this.m_pixels_3d = 3;
        this.m_shadow_size = 5;
        this.m_label_angle = 0.0;
        this.m_hover_scale = 1.0;
        this.m_zoom_x = 1.0;
        this.m_zoom_y = 1.0;
        this.m_fill_arrowhead = true;
        this.m_center_arrowhead = false;
        this.m_permanently_weight = true;
        this.m_blackwhite_3d = true;
        this.m_show_edge_labels = false;
        this.m_rotate_edge_labels = false;
        this.m_show_edge_tooltip = false;
        this.m_variable_arrow_color = false;
        this.m_invert_edge_label_back = false;
        this.m_label_invert_fore = false;
        this.m_label_invert_back = false;
        this.m_entity_labels_blackwhite = false;
    }

    public void setArrowOptionsTo(Option other) {
        if (other == null) {
            this.resetArrowOptions();
        } else {
            this.m_line_width = other.m_line_width;
            this.m_arrow_length = other.m_arrow_length;
            this.m_arrow_arc = other.m_arrow_arc;
            this.m_pixels_3d = other.m_pixels_3d;
            this.m_shadow_size = other.m_shadow_size;
            this.m_label_angle = other.m_label_angle;
            this.m_hover_scale = other.m_hover_scale;
            this.m_zoom_x = other.m_zoom_x;
            this.m_zoom_y = other.m_zoom_y;
            this.m_fill_arrowhead = other.m_fill_arrowhead;
            this.m_center_arrowhead = other.m_center_arrowhead;
            this.m_permanently_weight = other.m_permanently_weight;
            this.m_blackwhite_3d = other.m_blackwhite_3d;
            this.m_show_edge_labels = other.m_show_edge_labels;
            this.m_rotate_edge_labels = other.m_rotate_edge_labels;
            this.m_show_edge_tooltip = other.m_show_edge_tooltip;
            this.m_variable_arrow_color = other.m_variable_arrow_color;
            this.m_invert_edge_label_back = other.m_invert_edge_label_back;
            this.m_label_invert_fore = other.m_label_invert_fore;
            this.m_label_invert_back = other.m_label_invert_back;
            this.m_entity_labels_blackwhite = other.m_entity_labels_blackwhite;
        }
    }

    public int getLineWidth() {
        return this.m_line_width;
    }

    public String setLineWidth(String string) {
        int ival;
        block5: {
            block4: {
                try {
                    ival = Integer.parseInt(string);
                    if (ival >= 0) break block4;
                    return "LineWidth may not be negative";
                }
                catch (Throwable e) {
                    return "Line width not an integer";
                }
            }
            if (ival <= 100) break block5;
            return "LineWidth may not exceed 99";
        }
        this.m_line_width = ival;
        return null;
    }

    public double getArrowLength() {
        return this.m_arrow_length;
    }

    public String setArrowLength(String string) {
        double dval;
        block5: {
            block4: {
                try {
                    dval = Double.parseDouble(string);
                    if (!Double.isNaN(dval)) break block4;
                    return "ArrowLength not allowed to be NaN";
                }
                catch (Throwable e) {
                    return "ArrowLength is not a double";
                }
            }
            if (!(dval < 0.0)) break block5;
            return "ArrowLength may not be negative";
        }
        this.m_arrow_length = dval;
        return null;
    }

    public double getArrowArc() {
        return this.m_arrow_arc;
    }

    public String setArrowArc(String string) {
        double dval;
        block7: {
            block6: {
                block5: {
                    try {
                        dval = Double.parseDouble(string);
                        if (!Double.isNaN(dval)) break block5;
                        return "ArrowArc not allowed to be NaN";
                    }
                    catch (Throwable e) {
                        return "ArrowArc is not a double";
                    }
                }
                if (!(dval < 0.0)) break block6;
                return "ArrowArc may not be negative";
            }
            if (!(dval > 1.5)) break block7;
            return "The maximum allowed arc angle is 1.5 (very near pi/2)";
        }
        this.m_arrow_arc = dval;
        return null;
    }

    public int getPixels3D() {
        return this.m_pixels_3d;
    }

    public String setPixels3D(String string) {
        int ival;
        block5: {
            block4: {
                try {
                    ival = Integer.parseInt(string);
                    if (ival >= 0) break block4;
                    return "Pixels may not be negative";
                }
                catch (Throwable e) {
                    return "Pixels not an integer";
                }
            }
            if (ival <= 100) break block5;
            return "Pixels may not exceed 99";
        }
        this.m_pixels_3d = ival;
        return null;
    }

    public int getShadowSize() {
        return this.m_shadow_size;
    }

    public String setShadowSize(String string) {
        int ival;
        block5: {
            block4: {
                try {
                    ival = Integer.parseInt(string);
                    if (ival >= 0) break block4;
                    return "ShadowSize may not be negative";
                }
                catch (Throwable e) {
                    return "ShadowSize not an integer";
                }
            }
            if (ival <= 100) break block5;
            return "ShadowSize may not exceed 99";
        }
        this.m_shadow_size = ival;
        return null;
    }

    public double getLabelAngle() {
        return this.m_label_angle;
    }

    public String setLabelAngle(String string) {
        try {
            double dval = Double.parseDouble(string);
            this.m_label_angle = Math.toRadians(dval);
        }
        catch (Throwable e) {
            return "LabelAngle is not a double";
        }
        return null;
    }

    public double getHoverScale() {
        return this.m_hover_scale;
    }

    public String setHoverScale(String string) {
        double dval;
        block5: {
            block4: {
                try {
                    dval = Double.parseDouble(string);
                    if (!(dval < 0.0)) break block4;
                    return "HoverScale may not be negative";
                }
                catch (Throwable e) {
                    return "HoverScale is not a double";
                }
            }
            if (!(dval > 10.0)) break block5;
            return "HoverScale may not exceed 10.0";
        }
        this.m_hover_scale = dval;
        return null;
    }

    public double getZoomX() {
        return this.m_zoom_x;
    }

    public void setZoomX(double val) {
        this.m_zoom_x = val;
    }

    public String setZoomX(String string) {
        double dval;
        block3: {
            try {
                dval = Double.parseDouble(string);
                if (!(dval < 1.0)) break block3;
                return "ZoomX may not be less than 1.0";
            }
            catch (Throwable e) {
                return "ZoomX is not a double";
            }
        }
        this.m_zoom_x = dval;
        return null;
    }

    public double getZoomY() {
        return this.m_zoom_y;
    }

    public void setZoomY(double val) {
        this.m_zoom_y = val;
    }

    public String setZoomY(String string) {
        double dval;
        block3: {
            try {
                dval = Double.parseDouble(string);
                if (!(dval < 1.0)) break block3;
                return "ZoomY may not be less than 1.0";
            }
            catch (Throwable e) {
                return "ZoomY is not a double";
            }
        }
        this.m_zoom_y = dval;
        return null;
    }

    private String getArrowNumericParameter(int parameter) {
        switch (parameter) {
            case 0: {
                return "" + this.getLineWidth();
            }
            case 1: {
                return "" + this.getArrowLength();
            }
            case 2: {
                return "" + this.getArrowArc();
            }
            case 3: {
                return "" + this.getPixels3D();
            }
            case 4: {
                return "" + this.getShadowSize();
            }
            case 5: {
                return "" + this.getLabelAngle();
            }
            case 6: {
                return "" + this.getHoverScale();
            }
            case 7: {
                return "" + this.getZoomX();
            }
            case 8: {
                return "" + this.getZoomY();
            }
            case 10: {
                return "" + this.getEdgeMode();
            }
            case 9: {
                return this.getIconPath();
            }
            case 11: {
                return "" + this.getIconRule();
            }
            case 12: {
                return "" + this.getChaseEdges();
            }
        }
        return null;
    }

    private String setArrowNumericParameter(int parameter, String value) {
        String ret;
        switch (parameter) {
            case 0: {
                ret = this.setLineWidth(value);
                break;
            }
            case 1: {
                ret = this.setArrowLength(value);
                break;
            }
            case 2: {
                ret = this.setArrowArc(value);
                break;
            }
            case 3: {
                ret = this.setPixels3D(value);
                break;
            }
            case 4: {
                ret = this.setShadowSize(value);
                break;
            }
            case 5: {
                ret = this.setLabelAngle(value);
                break;
            }
            case 6: {
                ret = this.setHoverScale(value);
                break;
            }
            case 7: {
                ret = this.setZoomX(value);
                break;
            }
            case 8: {
                ret = this.setZoomY(value);
                break;
            }
            case 10: {
                ret = this.setEdgeMode(value);
                break;
            }
            case 9: {
                ret = this.setIconPath(value);
                break;
            }
            case 11: {
                ret = this.setIconRule(value);
                break;
            }
            case 12: {
                ret = this.setChaseEdges(value);
                break;
            }
            default: {
                ret = "setArrowNumericParameter has no parameter " + parameter;
            }
        }
        return ret;
    }

    public boolean isFillArrowhead() {
        return this.m_fill_arrowhead;
    }

    public void setFillArrowhead(boolean value) {
        this.m_fill_arrowhead = value;
    }

    public boolean isCenterArrowhead() {
        return this.m_center_arrowhead;
    }

    public void setCenterArrowhead(boolean value) {
        this.m_center_arrowhead = value;
    }

    public boolean isPermanentlyWeight() {
        return this.m_permanently_weight;
    }

    public void setPermanentlyWeight(boolean value) {
        this.m_permanently_weight = value;
    }

    public boolean isBlackWhite3D() {
        return this.m_blackwhite_3d;
    }

    public void setBlackWhite3D(boolean value) {
        this.m_blackwhite_3d = value;
    }

    public boolean isShowEdgeLabels() {
        return this.m_show_edge_labels;
    }

    public void setShowEdgeLabels(boolean value) {
        this.m_show_edge_labels = value;
    }

    public boolean isRotateEdgeLabels() {
        return this.m_rotate_edge_labels;
    }

    public void setRotateEdgeLabels(boolean value) {
        this.m_rotate_edge_labels = value;
    }

    public boolean isShowEdgeTooltip() {
        return this.m_show_edge_tooltip;
    }

    public void setShowEdgeTooltip(boolean value) {
        this.m_show_edge_tooltip = value;
    }

    public boolean isVariableArrowColor() {
        return this.m_variable_arrow_color;
    }

    public void setVariableArrowColor(boolean value) {
        this.m_variable_arrow_color = value;
    }

    public boolean isInvertEdgeLabelBackground() {
        return this.m_invert_edge_label_back;
    }

    public void setInvertEdgeLabelBackground(boolean value) {
        this.m_invert_edge_label_back = value;
    }

    public boolean isLabelInvertForeground() {
        return this.m_label_invert_fore;
    }

    public void setLabelInvertForeground(boolean value) {
        this.m_label_invert_fore = value;
    }

    public boolean isLabelBlackWhite() {
        return this.m_entity_labels_blackwhite;
    }

    public void setLabelBlackWhite(boolean value) {
        this.m_entity_labels_blackwhite = value;
    }

    public boolean isLabelInvertBackground() {
        return this.m_label_invert_back;
    }

    public void setLabelInvertBackground(boolean value) {
        this.m_label_invert_back = value;
    }

    private boolean getArrowBooleanParameter(int parameter) {
        boolean bool = false;
        switch (parameter) {
            case 0: {
                bool = this.isIconFixedShape();
                break;
            }
            case 1: {
                bool = this.isFillArrowhead();
                break;
            }
            case 2: {
                bool = this.isCenterArrowhead();
                break;
            }
            case 3: {
                bool = this.isPermanentlyWeight();
                break;
            }
            case 4: {
                bool = this.isBlackWhite3D();
                break;
            }
            case 5: {
                bool = this.isShowEdgeLabels();
                break;
            }
            case 6: {
                bool = this.isRotateEdgeLabels();
                break;
            }
            case 7: {
                bool = this.isShowEdgeTooltip();
                break;
            }
            case 8: {
                bool = this.isVariableArrowColor();
                break;
            }
            case 9: {
                bool = this.isInvertEdgeLabelBackground();
                break;
            }
            case 10: {
                bool = this.isLabelInvertForeground();
                break;
            }
            case 11: {
                bool = this.isLabelInvertBackground();
                break;
            }
            case 12: {
                bool = this.isLabelBlackWhite();
            }
        }
        return bool;
    }

    private void setArrowBooleanParameter(int parameter, boolean bool) {
        switch (parameter) {
            case 0: {
                this.setIconFixedShape(bool);
                break;
            }
            case 1: {
                this.setFillArrowhead(bool);
                break;
            }
            case 2: {
                this.setCenterArrowhead(bool);
                break;
            }
            case 3: {
                this.setPermanentlyWeight(bool);
                break;
            }
            case 4: {
                this.setBlackWhite3D(bool);
                break;
            }
            case 5: {
                this.setShowEdgeLabels(bool);
                break;
            }
            case 6: {
                this.setRotateEdgeLabels(bool);
                break;
            }
            case 7: {
                this.setShowEdgeTooltip(bool);
                break;
            }
            case 8: {
                this.setVariableArrowColor(bool);
                break;
            }
            case 9: {
                this.setInvertEdgeLabelBackground(bool);
                break;
            }
            case 21: {
                this.setLegendLabelBlack(bool);
                break;
            }
            case 10: {
                this.setLabelInvertForeground(bool);
                break;
            }
            case 11: {
                this.setLabelInvertBackground(bool);
                break;
            }
            case 12: {
                this.setLabelBlackWhite(bool);
            }
        }
    }

    private void setArrowBooleanParameter(int parameter, String value) {
        boolean bool = value.charAt(0) == 't';
        this.setArrowBooleanParameter(parameter, bool);
    }

    public void loadArrowOption(String attribute, String value) {
        String[] arrow_numeric_tags = m_arrow_numeric_tags;
        int i = 0;
        while (i < arrow_numeric_tags.length) {
            if (attribute.equals(arrow_numeric_tags[i])) {
                this.setArrowNumericParameter(i, value);
                return;
            }
            ++i;
        }
        String[] arrow_boolean_tags = m_arrow_boolean_tags;
        i = 0;
        while (i < arrow_boolean_tags.length) {
            if (attribute.equals(arrow_boolean_tags[i])) {
                this.setArrowBooleanParameter(i, value);
                return;
            }
            ++i;
        }
    }

    private void saveArrowOptions(PrintWriter ps, boolean toTa) {
        String[] arrow_numeric_tags = m_arrow_numeric_tags;
        String[] arrow_boolean_tags = m_arrow_boolean_tags;
        int i = 0;
        while (i < arrow_numeric_tags.length) {
            if (i != 9 || !toTa) {
                ps.println(String.valueOf(arrow_numeric_tags[i]) + "=" + this.getArrowNumericParameter(i));
            } else {
                ps.println(String.valueOf(arrow_numeric_tags[i]) + "=\"" + this.m_iconPath + "\"");
            }
            ++i;
        }
        i = 0;
        while (i < arrow_boolean_tags.length) {
            ps.println(String.valueOf(arrow_boolean_tags[i]) + "=" + (this.getArrowBooleanParameter(i) ? "true" : "false"));
            ++i;
        }
    }

    public void resetMainOptions() {
        this.m_top_clients_state = true;
        this.m_show_desc_state = true;
        this.m_show_feedback_state = true;
        this.m_show_clients_state = true;
        this.m_show_suppliers_state = true;
        this.m_show_dst_cardinals_state = false;
        this.m_show_src_cardinals_state = false;
        this.m_use_compaction_state = true;
        this.m_fix_scrollbars_state = false;
        this.m_left_tabbox_state = false;
        this.m_tabs_scroll_state = false;
        this.m_lift_edges_state = true;
        this.m_visible_edges_state = false;
        this.m_visible_entities_state = false;
        this.m_focus_ancestor_state = false;
        this.m_sort_toc_state = false;
        this.m_hide_empty_state = false;
        this.m_member_counts_state = false;
        this.m_inheritance_state = false;
        this.m_legend_labels_black = false;
        this.m_show_toolbar_state = true;
    }

    public void setMainOptionsTo(Option other) {
        if (other == null) {
            this.resetMainOptions();
        } else {
            this.m_top_clients_state = other.m_top_clients_state;
            this.m_show_desc_state = other.m_show_desc_state;
            this.m_show_feedback_state = other.m_show_feedback_state;
            this.m_show_clients_state = other.m_show_clients_state;
            this.m_show_suppliers_state = other.m_show_suppliers_state;
            this.m_show_dst_cardinals_state = other.m_show_dst_cardinals_state;
            this.m_show_src_cardinals_state = other.m_show_src_cardinals_state;
            this.m_use_compaction_state = other.m_use_compaction_state;
            this.m_fix_scrollbars_state = other.m_fix_scrollbars_state;
            this.m_left_tabbox_state = other.m_left_tabbox_state;
            this.m_tabs_scroll_state = other.m_tabs_scroll_state;
            this.m_lift_edges_state = other.m_lift_edges_state;
            this.m_visible_edges_state = other.m_visible_edges_state;
            this.m_visible_entities_state = other.m_visible_entities_state;
            this.m_focus_ancestor_state = other.m_focus_ancestor_state;
            this.m_sort_toc_state = other.m_sort_toc_state;
            this.m_hide_empty_state = other.m_hide_empty_state;
            this.m_member_counts_state = other.m_member_counts_state;
            this.m_inheritance_state = other.m_inheritance_state;
            this.m_legend_labels_black = other.m_legend_labels_black;
            this.m_show_toolbar_state = other.m_show_toolbar_state;
        }
    }

    public boolean isShowToolbar() {
        return this.m_show_toolbar_state;
    }

    public void setShowToolbar(boolean value) {
        this.m_show_toolbar_state = value;
    }

    public boolean isTopClients() {
        return this.m_top_clients_state;
    }

    public void setTopClients(boolean value) {
        this.m_top_clients_state = value;
    }

    public boolean isShowDesc() {
        return this.m_show_desc_state;
    }

    public void setShowDesc(boolean value) {
        this.m_show_desc_state = value;
    }

    public boolean isShowFeedback() {
        return this.m_show_feedback_state;
    }

    public void setShowFeedback(boolean value) {
        this.m_show_feedback_state = value;
    }

    public boolean isShowClients() {
        return this.m_show_clients_state;
    }

    public void setShowClients(boolean value) {
        this.m_show_clients_state = value;
    }

    public boolean isShowSuppliers() {
        return this.m_show_suppliers_state;
    }

    public void setShowSuppliers(boolean value) {
        this.m_show_suppliers_state = value;
    }

    public boolean isShowDstCardinals() {
        return this.m_show_dst_cardinals_state;
    }

    public void setShowDstCardinals(boolean value) {
        this.m_show_dst_cardinals_state = value;
    }

    public boolean isShowSrcCardinals() {
        return this.m_show_src_cardinals_state;
    }

    public void setShowSrcCardinals(boolean value) {
        this.m_show_src_cardinals_state = value;
    }

    public boolean isUseCompaction() {
        return this.m_use_compaction_state;
    }

    public void setUseCompaction(boolean value) {
        this.m_use_compaction_state = value;
    }

    public boolean isFixScrollBars() {
        return this.m_fix_scrollbars_state;
    }

    public void setFixScrollBars(boolean value) {
        this.m_fix_scrollbars_state = value;
    }

    public boolean isLeftTabbox() {
        return this.m_left_tabbox_state;
    }

    public void setLeftTabbox(boolean value) {
        this.m_left_tabbox_state = value;
    }

    public boolean isTabsScroll() {
        return this.m_tabs_scroll_state;
    }

    public void setTabsScroll(boolean value) {
        this.m_tabs_scroll_state = value;
    }

    public boolean isLiftEdges() {
        return this.m_lift_edges_state;
    }

    public void setLiftEdges(boolean value) {
        this.m_lift_edges_state = value;
    }

    public boolean isVisibleEdges() {
        return this.m_visible_edges_state;
    }

    public void setVisibleEdges(boolean value) {
        this.m_visible_edges_state = value;
    }

    public boolean isVisibleEntities() {
        return this.m_visible_entities_state;
    }

    public void setVisibleEntities(boolean value) {
        this.m_visible_entities_state = value;
    }

    public boolean isHideEmpty() {
        return this.m_hide_empty_state;
    }

    public void setHideEmpty(boolean value) {
        this.m_hide_empty_state = value;
    }

    public boolean isMemberCounts() {
        return this.m_member_counts_state;
    }

    public void setMemberCounts(boolean value) {
        this.m_member_counts_state = value;
    }

    public boolean isShowInheritance() {
        return this.m_inheritance_state;
    }

    public void setShowInheritance(boolean value) {
        this.m_inheritance_state = value;
    }

    public boolean isLegendLabelBlack() {
        return this.m_legend_labels_black;
    }

    public void setLegendLabelBlack(boolean value) {
        this.m_legend_labels_black = value;
    }

    public boolean isFocusAncestor() {
        return this.m_focus_ancestor_state;
    }

    public void setFocusAncestor(boolean value) {
        this.m_focus_ancestor_state = value;
    }

    public boolean isSortTOC() {
        return this.m_sort_toc_state;
    }

    public void setSortTOC(boolean value) {
        this.m_sort_toc_state = value;
    }

    public String getMainNumericParameter(int parameter) {
        switch (parameter) {
            case 0: {
                return "" + this.getLoadMode();
            }
            case 1: {
                return "" + this.getGridSize();
            }
            case 2: {
                return Util.taColor(this.getGridColor());
            }
            case 3: {
                return "" + this.getElisionIcon();
            }
        }
        return null;
    }

    public void setMainNumericParameter(int parameter, String value) {
        switch (parameter) {
            case 0: {
                this.setLoadMode(value);
                break;
            }
            case 1: {
                this.setGridSize(value);
                break;
            }
            case 2: {
                this.setGridColor(Util.colorTa(value));
                break;
            }
            case 3: {
                this.setElisionIcon(value);
            }
        }
    }

    private boolean getMainBooleanParameter(int i) {
        switch (i) {
            case 0: {
                return this.m_show_desc_state;
            }
            case 1: {
                return this.m_show_feedback_state;
            }
            case 6: {
                return this.m_top_clients_state;
            }
            case 7: {
                return this.m_show_clients_state;
            }
            case 8: {
                return this.m_show_suppliers_state;
            }
            case 9: {
                return this.m_use_compaction_state;
            }
            case 13: {
                return this.m_show_dst_cardinals_state;
            }
            case 14: {
                return this.m_show_src_cardinals_state;
            }
            case 4: {
                return this.m_fix_scrollbars_state;
            }
            case 2: {
                return this.m_left_tabbox_state;
            }
            case 3: {
                return this.m_tabs_scroll_state;
            }
            case 12: {
                return this.m_lift_edges_state;
            }
            case 10: {
                return this.m_visible_edges_state;
            }
            case 11: {
                return this.m_visible_entities_state;
            }
            case 15: {
                return this.m_group_query_state;
            }
            case 16: {
                return this.m_query_persists_state;
            }
            case 26: {
                return this.m_visible_spans_state;
            }
            case 17: {
                return this.m_focus_ancestor_state;
            }
            case 5: {
                return this.m_sort_toc_state;
            }
            case 18: {
                return this.m_hide_empty_state;
            }
            case 19: {
                return this.m_member_counts_state;
            }
            case 20: {
                return this.m_inheritance_state;
            }
            case 21: {
                return this.m_legend_labels_black;
            }
            case 22: {
                return this.m_show_grid_state;
            }
            case 23: {
                return this.m_snap_to_grid_state;
            }
            case 24: {
                return this.m_chase_hide_state;
            }
            case 25: {
                return this.m_show_toolbar_state;
            }
        }
        return false;
    }

    public void setMainBooleanParameter(int parameter, boolean bool) {
        switch (parameter) {
            case 0: {
                this.setShowDesc(bool);
                break;
            }
            case 1: {
                this.setShowFeedback(bool);
                break;
            }
            case 6: {
                this.m_top_clients_state = bool;
                break;
            }
            case 7: {
                this.m_show_clients_state = bool;
                break;
            }
            case 8: {
                this.m_show_suppliers_state = bool;
                break;
            }
            case 9: {
                this.m_use_compaction_state = bool;
                break;
            }
            case 13: {
                this.m_show_dst_cardinals_state = bool;
                break;
            }
            case 14: {
                this.m_show_src_cardinals_state = bool;
                break;
            }
            case 4: {
                this.m_fix_scrollbars_state = bool;
                break;
            }
            case 2: {
                this.m_left_tabbox_state = bool;
                break;
            }
            case 3: {
                this.m_tabs_scroll_state = bool;
                break;
            }
            case 12: {
                this.m_lift_edges_state = bool;
                break;
            }
            case 10: {
                this.m_visible_edges_state = bool;
                break;
            }
            case 11: {
                this.m_visible_entities_state = bool;
                break;
            }
            case 15: {
                this.m_group_query_state = bool;
                break;
            }
            case 16: {
                this.m_query_persists_state = bool;
                break;
            }
            case 26: {
                this.m_visible_spans_state = bool;
                break;
            }
            case 17: {
                this.m_focus_ancestor_state = bool;
                break;
            }
            case 5: {
                this.m_sort_toc_state = bool;
                break;
            }
            case 18: {
                this.m_hide_empty_state = bool;
                break;
            }
            case 19: {
                this.m_member_counts_state = bool;
                break;
            }
            case 20: {
                this.m_inheritance_state = bool;
                break;
            }
            case 21: {
                this.m_legend_labels_black = bool;
                break;
            }
            case 22: {
                this.m_show_grid_state = bool;
                break;
            }
            case 23: {
                this.m_snap_to_grid_state = bool;
                break;
            }
            case 24: {
                this.m_chase_hide_state = bool;
                break;
            }
            case 25: {
                this.m_show_toolbar_state = bool;
            }
        }
    }

    public void setMainBooleanParameter(int parameter, String value) {
        boolean bool = value.charAt(0) == 't';
        this.setMainBooleanParameter(parameter, bool);
    }

    public void optionsChanged(LandscapeEditorCore ls, Option other) {
        boolean change1 = false;
        boolean change2 = false;
        boolean change3 = false;
        if (this.m_show_toolbar_state != other.m_show_toolbar_state) {
            ls.showToolbarChanged();
        }
        change1 = this.m_line_width != other.m_line_width || this.m_arrow_length != other.m_arrow_length || this.m_arrow_arc != other.m_arrow_arc;
        boolean bl = change2 = this.m_icon_rule != other.m_icon_rule;
        if (this.m_elision_icon != other.m_elision_icon) {
            IconCache.clearElisionCache();
        }
        if (this.m_icon_fixed_shape != other.m_icon_fixed_shape) {
            change2 = true;
            ls.iconFixedChanged();
        }
        if (!this.m_iconPath.equals(other.m_iconPath)) {
            change1 = true;
            ls.iconPathChanged();
        }
        change3 = this.m_variable_arrow_color ^ other.m_variable_arrow_color;
        if (this.m_left_tabbox_state != other.m_left_tabbox_state) {
            ls.changeLeftTabbox(this.m_left_tabbox_state);
        }
        if (this.m_fix_scrollbars_state != other.m_fix_scrollbars_state) {
            ls.changeFixScrollbars(this.m_fix_scrollbars_state);
        }
        if (this.m_show_desc_state != other.m_show_desc_state) {
            ls.changeShowDesc(this.m_show_desc_state);
        }
        if (this.m_show_feedback_state != other.m_show_feedback_state) {
            ls.changeShowFeedback(this.m_show_feedback_state);
        }
        if (this.m_tabs_scroll_state != other.m_tabs_scroll_state) {
            ls.changeTabsScroll(this.m_tabs_scroll_state);
        }
        if (change1 || change2 || change3 || this.m_hide_empty_state != other.m_hide_empty_state || this.m_member_counts_state != other.m_member_counts_state || this.m_inheritance_state != other.m_inheritance_state || this.m_legend_labels_black != other.m_legend_labels_black) {
            ls.changeLegendQuery();
        }
        if (this.m_group_query_state != other.m_group_query_state) {
            ls.changeGroupQuery(this.m_group_query_state);
        }
        if (this.m_query_persists_state != other.m_query_persists_state) {
            ls.changeQueryPersists(this.m_query_persists_state);
        }
        if (this.m_sort_toc_state != other.m_sort_toc_state) {
            ls.changeTOC();
        } else if (change2) {
            ls.repaintTOC();
        }
        if (this.m_zoom_x != other.m_zoom_x || this.m_zoom_y != other.m_zoom_y) {
            ls.zoomChanged();
            return;
        }
        if (change1 || this.m_edge_state != other.m_edge_state || this.m_pixels_3d != other.m_pixels_3d || this.m_shadow_size != other.m_shadow_size || this.m_center_arrowhead != other.m_center_arrowhead || this.m_show_edge_labels != other.m_show_edge_labels || this.m_show_edge_tooltip != other.m_show_edge_tooltip || this.m_show_edge_labels && (this.m_label_angle != other.m_label_angle || this.m_rotate_edge_labels != other.m_rotate_edge_labels) || this.m_zoom_x != other.m_zoom_x || this.m_zoom_y != other.m_zoom_y) {
            ls.refillDiagram();
            return;
        }
        if (this.m_show_clients_state != other.m_show_clients_state || this.m_show_suppliers_state != other.m_show_suppliers_state || this.m_show_dst_cardinals_state != other.m_show_dst_cardinals_state || this.m_show_src_cardinals_state != other.m_show_src_cardinals_state || this.m_lift_edges_state != other.m_lift_edges_state) {
            ls.refillDiagram();
            return;
        }
        if ((this.m_show_clients_state || this.m_show_suppliers_state) && (this.m_top_clients_state != other.m_top_clients_state || this.m_use_compaction_state != other.m_use_compaction_state || this.m_visible_edges_state != other.m_visible_edges_state || this.m_visible_entities_state != other.m_visible_entities_state)) {
            ls.refillDiagram();
            return;
        }
        if (this.m_chase_edges != other.m_chase_edges) {
            ls.refillDiagram();
            return;
        }
        if (change2 || change3 || this.m_fill_arrowhead != other.m_fill_arrowhead || this.m_permanently_weight != other.m_permanently_weight || this.m_blackwhite_3d != other.m_blackwhite_3d || this.m_invert_edge_label_back != other.m_invert_edge_label_back || this.m_label_invert_fore != other.m_label_invert_fore || this.m_label_invert_back != other.m_label_invert_back || this.m_entity_labels_blackwhite != other.m_entity_labels_blackwhite || this.m_elision_icon != other.m_elision_icon || this.m_show_grid_state != other.m_show_grid_state || this.m_show_grid_state && (this.m_gridPixels != other.m_gridPixels || this.m_gridColor != other.m_gridColor)) {
            ls.repaintDiagram();
        }
    }

    public void loadMainOption(String attribute, String value) {
        String[] numeric_option_tags = this.m_numeric_option_tags;
        String[] boolean_option_tags = this.m_boolean_option_tags;
        int i = 0;
        while (i < numeric_option_tags.length) {
            if (attribute.equals(numeric_option_tags[i])) {
                this.setMainNumericParameter(i, value);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < boolean_option_tags.length) {
            if (attribute.equals(boolean_option_tags[i])) {
                this.setMainBooleanParameter(i, value);
                return;
            }
            ++i;
        }
    }

    private void saveMainOptions(PrintWriter ps, boolean toTA) {
        String[] numeric_option_tags = this.m_numeric_option_tags;
        String[] boolean_option_tags = this.m_boolean_option_tags;
        int i = toTA ? 1 : 0;
        while (i < numeric_option_tags.length) {
            ps.println(String.valueOf(numeric_option_tags[i]) + "=" + this.getMainNumericParameter(i));
            ++i;
        }
        i = 0;
        while (i < boolean_option_tags.length) {
            ps.println(String.valueOf(boolean_option_tags[i]) + "=" + (this.getMainBooleanParameter(i) ? "true" : "false"));
            ++i;
        }
    }

    public void loadOption(String attribute, String value) {
        if (attribute.startsWith("font[")) {
            this.loadFont(attribute, value);
            return;
        }
        if (attribute.startsWith("option:")) {
            this.loadMainOption(attribute, value);
            return;
        }
        if (attribute.startsWith("arrow:")) {
            this.loadArrowOption(attribute, value);
            return;
        }
    }

    public void saveOptions(PrintWriter ps, boolean toTa) {
        this.saveFonts(ps);
        this.saveMainOptions(ps, toTa);
        this.saveArrowOptions(ps, toTa);
    }

    public void setTo(Option other) {
        this.setFontsTo(other);
        this.setMainOptionsTo(other);
        this.setArrowOptionsTo(other);
        this.setDiagramOptionsTo(other);
    }

    public String toString() {
        return String.valueOf(this.m_option_name) + " option";
    }
}

