/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lsedit.RelationClass;
import lsedit.Ta;

class MyTableModel
extends AbstractTableModel {
    Ta m_ta;
    Vector m_classes;
    int m_cnt_spanning;

    private void restart1() {
        RelationClass[] containsClasses = this.m_ta.getContainsClasses();
        Vector classes = this.m_classes;
        classes.clear();
        int i = 0;
        while (i < containsClasses.length) {
            classes.add(containsClasses[i]);
            ++i;
        }
        this.m_cnt_spanning = i;
        Enumeration en = this.m_ta.enumRelationClassesInOrder();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (classes.contains(rc)) continue;
            classes.add(rc);
        }
    }

    public void restart() {
        this.restart1();
        this.fireTableDataChanged();
    }

    public MyTableModel(Ta ta) {
        this.m_ta = ta;
        this.m_classes = new Vector();
        this.restart1();
    }

    public void clearSpanningClasses() {
        this.m_cnt_spanning = 0;
    }

    public Vector getClasses() {
        return this.m_classes;
    }

    public int getCntSpanning() {
        return this.m_cnt_spanning;
    }

    @Override
    public int getRowCount() {
        return this.m_classes.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.m_classes.size()) {
            return this.m_classes.elementAt(row);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public void forceNotEmpty() {
        if (this.m_cnt_spanning == 0) {
            RelationClass rc = this.m_ta.getRelationBaseClass();
            this.m_classes.remove(rc);
            this.m_classes.insertElementAt(rc, 0);
            this.m_cnt_spanning = 1;
        }
    }

    public void add(int[] rows) {
        boolean ret = false;
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            if (this.m_cnt_spanning <= row) {
                Object rc = this.m_classes.elementAt(row);
                this.m_classes.remove(row);
                this.m_classes.insertElementAt(rc, this.m_cnt_spanning);
                ++this.m_cnt_spanning;
                ret = true;
            }
            ++i;
        }
        if (ret) {
            this.fireTableDataChanged();
        }
    }

    public void remove(int[] rows) {
        boolean ret = false;
        int at = this.m_classes.size() - 1;
        int i = rows.length;
        while (--i >= 0) {
            int row = rows[i];
            if (row >= this.m_cnt_spanning) continue;
            Object rc = this.m_classes.elementAt(row);
            this.m_classes.remove(row);
            this.m_classes.insertElementAt(rc, at);
            --at;
            --this.m_cnt_spanning;
            ret = true;
        }
        this.forceNotEmpty();
        if (ret) {
            this.fireTableDataChanged();
        }
    }

    public void up(int[] rows) {
        boolean ret = false;
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            if (this.m_cnt_spanning == row) {
                ++this.m_cnt_spanning;
                ret = true;
            } else if (row > 0) {
                Object rc = this.m_classes.elementAt(row);
                this.m_classes.remove(row);
                this.m_classes.insertElementAt(rc, row - 1);
                ret = true;
            }
            ++i;
        }
        if (ret) {
            this.fireTableDataChanged();
        }
    }

    public void down(int[] rows) {
        boolean ret = false;
        int i = rows.length;
        while (--i >= 0) {
            int row = rows[i];
            if (row == this.m_cnt_spanning - 1) {
                --this.m_cnt_spanning;
                ret = true;
                continue;
            }
            if (row >= this.m_classes.size() - 1) continue;
            Object rc = this.m_classes.elementAt(row);
            this.m_classes.remove(row);
            this.m_classes.insertElementAt(rc, row + 1);
            ret = true;
        }
        this.forceNotEmpty();
        if (ret) {
            this.fireTableDataChanged();
        }
    }
}

