/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import lsedit.ToolBarEventHandler;

class MyCheckBoxMenuItem
extends JCheckBoxMenuItem
implements ActionListener {
    ToolBarEventHandler m_handler;
    int m_modifiers;
    int m_key;

    MyCheckBoxMenuItem(JComponent menu, String label, boolean state, ToolBarEventHandler handler, int modifiers, int key, String tooltipHelp) {
        super(label);
        this.setSelected(state);
        this.m_handler = handler;
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(this);
        } else {
            ((JPopupMenu)menu).add(this);
        }
        if (key <= 90) {
            if (key >= 65) {
                modifiers |= 1;
            }
        } else if (key <= 122) {
            if (key >= 97) {
                modifiers &= 0xFFFFFFFE;
                key -= 32;
            }
        } else if (key >= 1024) {
            key -= 1024;
        }
        this.m_modifiers = modifiers;
        this.m_key = key;
        if (tooltipHelp != null) {
            this.setToolTipText(tooltipHelp);
        }
        this.setAccelerator(KeyStroke.getKeyStroke(key, modifiers));
        this.addActionListener(this);
    }

    public int getKey() {
        return this.m_key;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if ((ev.getModifiers() & 4) != 0 && this.m_handler.processMetaKeyEvent(this.getText())) {
            return;
        }
        this.m_handler.processKeyEvent(this.m_key, this.m_modifiers, null);
    }
}

