/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class MatrixLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int BORDER = 0;
    protected static final int XGAP = 1;
    protected static final int YGAP = 2;
    protected static final int FITFRACTION = 3;
    protected static final String[] m_textfield_tags = new String[]{"matrix:border", "matrix:xgap", "matrix:ygap", "matrix:fit"};
    protected static final String[] m_textfield_titles = new String[]{"Border fraction of total:", "Horizontal whitespace fraction of grid:", "Vertical whitespace fraction of grid:", "Fraction of entities that fit width"};
    protected static final String[] m_textfield_resets = new String[]{"0.0333", "0.2", "0.2", "1.0"};
    protected static String[] m_textfield_defaults = new String[]{"0.0333", "0.2", "0.2", "1.0"};
    protected static String[] m_textfield_currents = new String[]{"0.0333", "0.2", "0.2", "1.0"};
    protected double m_border = 0.0333;
    protected double m_xgap = 0.2;
    protected double m_ygap = 0.2;
    protected double m_fit = 1.0;
    protected static final int DIRECTION = 0;
    protected static final String[] m_checkbox_tags = new String[]{"matrix:direction"};
    protected static final String[] m_checkbox_titles = new String[]{"Order vertically"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_DEFAULT = 3;
    protected static final int BUTTON_SET = 4;
    protected static final int BUTTON_RESET = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips;

    static {
        String[] stringArray = new String[6];
        stringArray[3] = "Use remembered default";
        stringArray[4] = "Set default to current";
        stringArray[5] = "Set default to initial";
        m_button_tips = stringArray;
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            double dval = Double.parseDouble(string);
            switch (i) {
                case 0: {
                    this.m_border = dval;
                    break;
                }
                case 1: {
                    this.m_xgap = dval;
                    break;
                }
                case 2: {
                    this.m_ygap = dval;
                    break;
                }
                case 3: {
                    this.m_fit = dval;
                }
            }
            MatrixLayout.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getTag() {
        return "matrix:";
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        int i = 0;
        while (i < textfield_resets.length) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
            ++i;
        }
        i = 0;
        while (i < checkbox_resets.length) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
            ++i;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        int i = 0;
        while (i < textfield_tags.length) {
            if (attribute.equals(textfield_tags[i])) {
                switch (mode) {
                    case 0: {
                        MatrixLayout.m_textfield_defaults[i] = value;
                    }
                    case 1: {
                        this.setParameter(i, value);
                    }
                }
                return;
            }
            ++i;
        }
        String[] checkbox_tags = m_checkbox_tags;
        i = 0;
        while (i < checkbox_tags.length) {
            if (attribute.equals(checkbox_tags[i])) {
                boolean bool = value.charAt(0) == 't';
                switch (mode) {
                    case 0: {
                        MatrixLayout.m_checkbox_defaults[i] = bool;
                    }
                    case 1: {
                        MatrixLayout.m_checkbox_currents[i] = bool;
                    }
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < m_textfield_tags.length) {
            String string = emit_strings[i];
            if (!string.equals(prior_strings[i])) {
                ps.println(String.valueOf(m_textfield_tags[i]) + "=" + string);
            }
            ++i;
        }
        i = 0;
        while (i < m_checkbox_tags.length) {
            boolean bool = emit_booleans[i];
            if (bool != prior_booleans[i]) {
                ps.println(String.valueOf(m_checkbox_tags[i]) + "=" + (bool ? "true" : "false"));
            }
            ++i;
        }
    }

    public MatrixLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Matrix";
    }

    @Override
    public String getMenuLabel() {
        return "Layout in a matrix";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        MatrixConfigure configure = new MatrixConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        double widthrel;
        double gapw;
        double heightrel;
        double gaph;
        EntityInstance e;
        int rows;
        Diagram diagram = this.m_ls.getDiagram();
        double border = this.m_border;
        double xgap = this.m_xgap;
        double ygap = this.m_ygap;
        boolean vertical = MatrixLayout.parameterBoolean(0);
        int size = selectedBoxes.size();
        int badwidth = (int)((double)size * (1.0 - this.m_fit));
        if (border < 0.0 || xgap < 0.0 || ygap < 0.0) {
            this.m_ls.error("MatrixLayout: some parameters -ve");
            return false;
        }
        if (xgap >= 1.0 || ygap >= 1.0 || border >= 1.0) {
            this.m_ls.error("MatrixLayout: no parameter may have a value 1.0");
            return false;
        }
        double xmarginrel = border / 2.0;
        double ymarginrel = border / 2.0;
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                rows = 1;
                break;
            }
            default: {
                rows = (int)Math.ceil(Math.sqrt(size));
            }
        }
        int columns = rows;
        EntityInstance parent = null;
        int i = 0;
        while (i < size) {
            e = (EntityInstance)selectedBoxes.elementAt(i);
            EntityInstance parent1 = e.getContainedBy();
            if (parent1 == null) {
                System.out.println("MatrixLayout: Entity " + e + " has no parent");
            } else if (parent == null) {
                parent = parent1;
            } else if (parent != parent1) {
                System.out.println("MatrixLayout: Entity " + e + " has different parent from other entities being laid out");
            }
            ++i;
        }
        if (parent == null) {
            return false;
        }
        double parentWidth = parent.getWidth();
        Graphics graphics = this.m_ls.getGraphics();
        block5: while (true) {
            if (rows == 1) {
                gaph = 0.0;
                heightrel = 1.0 - border;
            } else {
                heightrel = (1.0 - border) * (1.0 - ygap) / (double)rows;
                gaph = (1.0 - border - heightrel * (double)rows) / (double)(rows - 1);
            }
            if (columns == 1) {
                gapw = 0.0;
                widthrel = 1.0 - border;
                break;
            }
            widthrel = (1.0 - border) * (1.0 - xgap) / (double)columns;
            gapw = (1.0 - border - widthrel * (double)columns) / (double)(columns - 1);
            if (parentWidth <= 0.0) break;
            int cnt = 0;
            i = 0;
            while (i < size) {
                int actualWidth = (int)(widthrel * parentWidth);
                e = (EntityInstance)selectedBoxes.elementAt(i);
                int minWidth = e.getMinFitWidth(graphics);
                if (actualWidth < minWidth && ++cnt > badwidth) break;
                ++i;
            }
            if (i == size) break;
            --columns;
            while (true) {
                if (rows * columns >= size) continue block5;
                ++rows;
            }
            break;
        }
        SortVector.byString(selectedBoxes, true);
        int col = 0;
        int row = 0;
        i = 0;
        while (i < size) {
            e = (EntityInstance)selectedBoxes.elementAt(i);
            double xrel = xmarginrel;
            if (col != 0) {
                xrel += (double)col * (widthrel + gapw);
            }
            double yrel = ymarginrel;
            if (row != 0) {
                yrel += (double)row * (heightrel + gaph);
            }
            diagram.updateRelLocal(e, xrel, yrel, widthrel, heightrel);
            if (vertical) {
                if (++row == rows) {
                    ++col;
                    row = 0;
                }
            } else if (++col == columns) {
                ++row;
                col = 0;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        ls.setLayouter(this);
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Matrix layouter requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return "Graph redrawn using Matrix Layout";
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class MatrixConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected LayoutImage m_layoutImage;
        protected JLabel m_message;
        protected JButton[] m_buttons;
        protected boolean m_ret;

        public MatrixConfigure() {
            JLabel label;
            super(MatrixLayout.this.getLs().getFrame(), "Matrix Whitespace", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel = new JPanel();
            JPanel valuePanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            int i = 0;
            while (i < m_textfield_tags.length) {
                JTextField textfield;
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.addActionListener(this);
                textfield.setFont(font);
                valuePanel.add(textfield);
                ++i;
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            i = 0;
            while (i < m_checkbox_tags.length) {
                JCheckBox checkbox;
                label = new JLabel(m_checkbox_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_checkboxes[i] = checkbox = new JCheckBox("", m_checkbox_currents[i]);
                checkbox.setFont(font);
                valuePanel.add(checkbox);
                ++i;
            }
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new BorderLayout());
            this.m_layoutImage = new LayoutImage();
            centerPanel.add("North", this.m_layoutImage);
            this.m_layoutImage.validate();
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            centerPanel.add("South", this.m_message);
            contentPane.add("Center", centerPanel);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            i = 0;
            while (i < m_button_titles.length) {
                JButton button;
                this.m_buttons[i] = button = new JButton(m_button_titles[i]);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
                ++i;
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            int state = -1;
            int i = 0;
            while (i < m_button_titles.length) {
                if (source == this.m_buttons[i]) {
                    state = i;
                    break;
                }
                ++i;
            }
            switch (state) {
                case 5: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        MatrixLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                        ++i;
                    }
                }
                case 3: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                        ++i;
                    }
                    break;
                }
                case 4: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        MatrixLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(MatrixLayout.this.m_ls.getFrame(), "Border\n  Fraction of diagram to reserve for border\n  Must be a value between 0 and 1\nGap\n  Fraction of diagram to reserve for whitespace", "Help", 0);
                    return;
                }
                default: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        JTextField textfield = this.m_textfields[i];
                        if (source == textfield || state == 0) {
                            String string = textfield.getText();
                            string = string.trim();
                            String name = m_textfield_titles[i];
                            switch (i) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    try {
                                        double dval = Double.parseDouble(string);
                                        if (dval < 0.0) {
                                            this.m_message.setText(String.valueOf(name) + " may not be negative");
                                            return;
                                        }
                                        if (dval > 1.0) {
                                            this.m_message.setText(String.valueOf(name) + " must not be greater than 1.0");
                                            return;
                                        }
                                        if (dval != 1.0 || i == 3) break;
                                        this.m_message.setText(String.valueOf(name) + " must be less than 1.0");
                                        return;
                                    }
                                    catch (Throwable exception) {
                                        this.m_message.setText(String.valueOf(name) + " not a double precision value");
                                        return;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    break block1;
                }
            }
            switch (state) {
                case 0: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        MatrixLayout.this.setParameter(i, this.m_textfields[i].getText());
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        MatrixLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                        ++i;
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    this.m_layoutImage.validate();
                    this.m_layoutImage.repaint();
                    return;
                }
            }
            this.setVisible(false);
        }

        class LayoutImage
        extends JComponent
        implements MouseListener {
            Rectangle[] m_boxs;
            int m_rows = 2;
            boolean m_validated;

            public LayoutImage() {
                Dimension dimension = new Dimension(400, 240);
                this.setLayout(null);
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension);
                this.setSize(dimension);
                this.m_boxs = new Rectangle[25];
                this.m_validated = false;
                this.addMouseListener(this);
                this.setVisible(true);
            }

            @Override
            public void validate() {
                Rectangle[] boxs = this.m_boxs;
                int cnt = boxs.length;
                int dimension = this.m_rows;
                int width = this.getWidth();
                int height = this.getHeight();
                double new_border = ((MatrixConfigure)MatrixConfigure.this).MatrixLayout.this.m_border;
                double new_xgap = ((MatrixConfigure)MatrixConfigure.this).MatrixLayout.this.m_xgap;
                double new_ygap = ((MatrixConfigure)MatrixConfigure.this).MatrixLayout.this.m_ygap;
                int x = (int)((double)width * new_border / 2.0);
                int y = (int)((double)height * new_border / 2.0);
                int w = width - 2 * x;
                int h = height - 2 * y;
                this.m_validated = false;
                if (w < 1 || h < 1) {
                    return;
                }
                int gaps = dimension - 1;
                double dgaps = gaps;
                int gapw = (int)(new_xgap * (double)w / dgaps);
                int gaph = (int)(new_ygap * (double)h / dgaps);
                int w1 = (w - gapw * gaps) / dimension;
                int h1 = (h - gaph * gaps) / dimension;
                if (w1 < 1 || h1 < 1) {
                    return;
                }
                int col = 0;
                int row = 0;
                cnt = dimension * dimension;
                int i = 0;
                while (i < cnt) {
                    Rectangle rectangle = boxs[i];
                    if (rectangle == null) {
                        boxs[i] = rectangle = new Rectangle();
                    }
                    rectangle.x = x;
                    if (col != 0) {
                        rectangle.x += col * (w1 + gapw);
                    }
                    rectangle.y = y;
                    if (row != 0) {
                        rectangle.y += row * (h1 + gaph);
                    }
                    rectangle.width = w1;
                    rectangle.height = h1;
                    if (++col == dimension) {
                        ++row;
                        col = 0;
                    }
                    ++i;
                }
                this.m_validated = true;
            }

            @Override
            public void paintComponent(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(Color.black);
                g.drawRect(0, 0, w - 1, h - 1);
                if (this.m_validated) {
                    Rectangle[] boxs = this.m_boxs;
                    g.setColor(Color.blue);
                    int dimension = this.m_rows;
                    int col = 0;
                    int row = 0;
                    int cnt = dimension * dimension;
                    int i = 0;
                    while (i < cnt) {
                        Rectangle rectangle = boxs[i];
                        g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        if (++col == dimension) {
                            ++row;
                            col = 0;
                        }
                        ++i;
                    }
                    if (dimension == 2) {
                        String s = "Click to change dimensions";
                        FontMetrics fm = g.getFontMetrics();
                        int width = fm.stringWidth(s);
                        g.setColor(Color.black);
                        g.drawString(s, (w - width) / 2, h / 2);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
            }

            @Override
            public void mouseExited(MouseEvent ev) {
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.isMetaDown()) {
                    --this.m_rows;
                    if (this.m_rows < 2) {
                        this.m_rows = 5;
                    }
                } else {
                    ++this.m_rows;
                    if (this.m_rows > 5) {
                        this.m_rows = 2;
                    }
                }
                this.validate();
                this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
            }
        }
    }
}

