/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import lsedit.Distance;
import lsedit.EditableTa;
import lsedit.EntityInstance;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.TaFeedback;
import lsedit.Util;

public class LsClusterer
implements TaFeedback {
    protected static final double default_attractive_force = 0.05;
    protected static final double default_sparse_factor = 1.0;
    protected static final double default_repulsive_force = 0.01;
    protected static final double default_repulsive_diameter = 0.75;
    protected static final int default_iterations = 1000;
    protected static final int default_timeout = 60;
    protected static final double default_separation_factor = 2.5;
    protected static final double default_margin = 0.05;
    protected static final double default_gap = 0.4;
    protected static final int default_form_clusters = 0;
    protected static final boolean default_remove_contains = true;
    protected static final boolean default_mustbe_related = true;
    protected static final boolean default_feedback = true;
    protected double m_attractive_force = 0.05;
    protected double m_sparse_factor = 1.0;
    protected double m_repulsive_force = 0.01;
    protected double m_repulsive_diameter = 0.75;
    protected int m_iterations = 1000;
    protected int m_timeout = 60;
    protected boolean m_remove_contains = true;
    protected boolean m_mustbe_related = true;
    protected boolean m_feedback = true;
    protected double m_separation_factor = 2.5;
    protected double m_margin = 0.05;
    protected double m_gap = 0.4;
    protected int m_form_clusters = 0;

    protected static void die() {
        System.exit(1);
    }

    protected void log(String message) {
        if (this.m_feedback) {
            System.err.println(String.valueOf(Util.toLocaleString()) + ": LSClusterer : " + message);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void layout(EditableTa ta) {
        block40: {
            rootInstance = ta.getRootInstance();
            selectedBoxes = new Vector<E>();
            rootInstance.gatherLeaves(selectedBoxes);
            size = selectedBoxes.size();
            if (size < 3) {
                return;
            }
            this.log("Clustering " + size + " items");
            clusterNodes = new ClusterNode[size];
            related = new boolean[size][];
            i = 0;
            while (i < size) {
                clusterNodes[i] = clusterNode = new ClusterNode();
                related[i] = new boolean[size - i];
                clusterNode.m_e = e = (EntityInstance)selectedBoxes.elementAt(i);
                clusterNode.m_x = e.xRelLocal();
                clusterNode.m_y = e.yRelLocal();
                clusterNode.m_cluster = i++;
                clusterNode.m_next = null;
                e.orMark(0x4000000);
            }
            ideal_length = 0.0;
            i = 0;
            while (i < size) {
                clusterNode = clusterNodes[i];
                e = clusterNode.m_e;
                en = e.srcRelationElements();
                if (en != null) {
                    block2: while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                        j = i + 1;
                        while (j < size) {
                            if (e1 == clusterNodes[j].m_e) {
                                related[i][j - i] = true;
                                continue block2;
                            }
                            ++j;
                        }
                    }
                }
                if ((en = e.dstRelationElements()) != null) {
                    block4: while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                        j = i + 1;
                        while (j < size) {
                            if (e1 == clusterNodes[j].m_e) {
                                related[i][j - i] = true;
                                continue block4;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                clusterNode = clusterNodes[i];
                e = clusterNode.m_e;
                width = e.widthRelLocal();
                height = e.heightRelLocal();
                j = i + 1;
                while (j < size) {
                    if (related[i][j - i]) {
                        clusterNode1 = clusterNodes[j];
                        e1 = clusterNode1.m_e;
                        width1 = e1.widthRelLocal();
                        height1 = e1.heightRelLocal();
                        xdiff = width + width1;
                        if (xdiff > ideal_length) {
                            ideal_length = xdiff;
                        }
                        if ((ydiff = height + height1) > ideal_length) {
                            ideal_length = ydiff;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ideal_length *= this.m_sparse_factor;
            this.log("Iterating over these " + size + " items");
            timeout = System.currentTimeMillis() + (long)(this.m_timeout * 1000);
            iteration = this.m_iterations;
            while (iteration > 0) {
                i = 0;
                while (i < size) {
                    clusterNode = clusterNodes[i];
                    x = clusterNode.m_x;
                    y = clusterNode.m_y;
                    j = i + 1;
                    while (j < size) {
                        clusterNode1 = clusterNodes[j];
                        x1 = clusterNode1.m_x;
                        y1 = clusterNode1.m_y;
                        xdiff = x1 - x;
                        ydiff = y1 - y;
                        if (xdiff == 0.0 && ydiff == 0.0) {
                            xdiff = i % 3 - 1;
                            ydiff = xdiff == 0.0 ? (double)(j % 2 * 2 - 1) : (double)(j % 3 - 1);
                        }
                        length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                        f = related[i][j - i] != false ? (length - ideal_length) * this.m_attractive_force : (length - this.m_repulsive_diameter) * this.m_repulsive_force;
                        x += f * xdiff / length;
                        y += f * ydiff / length;
                        clusterNode1.m_x = x1 -= f * xdiff / length;
                        clusterNode1.m_y = y1 -= f * ydiff / length;
                        ++j;
                    }
                    clusterNode.m_x = x;
                    clusterNode.m_y = y;
                    ++i;
                }
                if (System.currentTimeMillis() > timeout) {
                    this.log("Timeout after " + (this.m_iterations - iteration) + " iterations");
                    break;
                }
                --iteration;
            }
            this.log("Build graph for " + size + " items");
            clusters = size;
            if (this.m_form_clusters != 1 && this.m_form_clusters < clusters) {
                distances = new Vector<Distance>();
                i = 0;
                while (i < size) {
                    clusterNode = clusterNodes[i];
                    x = clusterNode.m_x;
                    y = clusterNode.m_y;
                    j = i + 1;
                    while (j < size) {
                        if (!this.m_mustbe_related || related[i][j - i]) {
                            clusterNode1 = clusterNodes[j];
                            xdiff = clusterNode1.m_x - x;
                            ydiff = clusterNode1.m_y - y;
                            length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                            distances.add(new Distance(length, i, j));
                        }
                        ++j;
                    }
                    ++i;
                }
                pairs = distances.size();
                this.log("Sorting " + pairs + " of distances");
                SortVector.byDistance(distances);
                ideal_length = -1.0;
                i = 0;
                while (i < pairs) {
                    distance = (Distance)distances.elementAt(i);
                    length = distance.m_length;
                    if (length > ideal_length * this.m_separation_factor && this.m_form_clusters == 0 && ideal_length >= 0.0) break;
                    ideal_length = length;
                    clusterNode = clusterNodes[distance.m_i];
                    clusterNode1 = clusterNodes[distance.m_j];
                    if (clusterNode.m_cluster != clusterNode1.m_cluster) {
                        j = clusterNode.m_cluster;
                        clusterNode = clusterNodes[j];
                        tail = clusterNode1 = clusterNodes[clusterNode1.m_cluster];
                        while (tail.m_next != null) {
                            tail.m_cluster = j;
                            tail = tail.m_next;
                        }
                        tail.m_cluster = j;
                        tail.m_next = clusterNode.m_next;
                        clusterNode.m_next = clusterNode1;
                        if (--clusters <= this.m_form_clusters || clusters < 3) break;
                    }
                    ++i;
                }
            }
            size1 = size - 1;
            utilities = null;
            if (clusters <= this.m_form_clusters) break block40;
            this.log("Identifying utilities");
            size1 = -1;
            clusters = 0;
            i = 0;
            while (i < size) {
                block41: {
                    clusterNode = clusterNodes[i];
                    if (clusterNode.m_cluster != i) break block41;
                    if (clusterNode.m_next != null) ** GOTO lbl177
                    if (utilities != null) {
                        clusterNode.m_cluster = utilities.m_cluster;
                        clusterNode.m_next = utilities.m_next;
                        utilities.m_next = clusterNode;
                    } else {
                        utilities = clusterNode;
lbl177:
                        // 2 sources

                        ++clusters;
                        size1 = i;
                    }
                }
                ++i;
            }
        }
        this.log("Reorganising " + size + " items into " + clusters + " selected clusters");
        clusters = 0;
        e1 = null;
        i = 0;
        while (i <= size1) {
            clusterNode = clusterNodes[i];
            if (clusterNode.m_cluster == i) {
                e1 = ta.getNewEntity(null, rootInstance);
                text = "Cluster" + ++clusters;
                if (clusterNode == utilities) {
                    text = this.m_form_clusters == 1 ? String.valueOf(text) + " (Layout)" : String.valueOf(text) + " (Utilities)";
                }
                e1.setLabel(text);
                cnt = 0;
                x = xmax = clusterNode.m_x;
                y = ymax = clusterNode.m_y;
                tail = clusterNode;
                while (tail != null) {
                    if (tail.m_x < x) {
                        x = tail.m_x;
                    }
                    if (tail.m_y < y) {
                        y = tail.m_y;
                    }
                    if (tail.m_x > xmax) {
                        xmax = tail.m_x;
                    }
                    if (tail.m_y > ymax) {
                        ymax = tail.m_y;
                    }
                    ++cnt;
                    tail = tail.m_next;
                }
                e1.setDescription("Cluster of " + cnt + " items");
                cnt = (int)Math.ceil(Math.sqrt(cnt));
                width = (1.0 - this.m_margin) * (1.0 - this.m_gap) / (double)cnt;
                xdiff = xmax - x;
                xm = xdiff == 0.0 ? 0.0 : (1.0 - this.m_margin - width) / xdiff;
                xc = this.m_margin * 0.5 - xm * x;
                ydiff = ymax - y;
                ym = ydiff == 0.0 ? 0.0 : (1.0 - this.m_margin - width) / ydiff;
                yc = this.m_margin * 0.5 - ym * y;
                while (clusterNode != null) {
                    e = clusterNode.m_e;
                    x = clusterNode.m_x * xm + xc;
                    y = clusterNode.m_y * ym + yc;
                    e.setRelLocal(x, y, width, width);
                    ta.moveEntityContainment(e1, e);
                    e.orMark(0x4000000);
                    clusterNode = clusterNode.m_next;
                }
            }
            ++i;
        }
        this.log("Finished forming " + clusters + " clusters");
    }

    public LsClusterer(String input, String output) {
        EditableTa ta = new EditableTa(this);
        String ret = ta.loadTA(input, System.in);
        if (ret != null) {
            this.error(ret);
        }
        this.layout(ta);
        ret = ta.saveByFile(output);
        if (ret != null) {
            this.error(ret);
        }
        System.exit(0);
    }

    @Override
    public void showProgress(String message) {
        if (this.m_feedback) {
            System.err.println("Progress: " + message + "\n");
        }
    }

    @Override
    public void doFeedback(String message) {
        if (this.m_feedback) {
            System.err.println("Feedback: " + message + "\n");
        }
    }

    @Override
    public void showInfo(String message) {
        if (this.m_feedback) {
            System.err.println("    Info: " + message + "\n");
        }
    }

    @Override
    public void error(String message) {
        System.err.println("   Error: " + message + "\n");
        LsClusterer.die();
    }

    @Override
    public void showCycle(RelationInstance ri) {
        System.err.println("Cycle detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    @Override
    public void noContainRelation(String taPath) {
        System.err.println("No contains relation defined in the input TA\n");
        LsClusterer.die();
    }

    @Override
    public void hasMultipleParents(RelationClass rc, EntityInstance e) {
        System.err.println("Multiple parents detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    public static void main(String[] args) {
        String input = "";
        String output = "";
        switch (args.length) {
            case 2: {
                output = args[1];
            }
            case 1: {
                input = args[0];
            }
            case 0: {
                break;
            }
            default: {
                System.err.println("usage: java lsedit.LsClusterer [<input> [<output>]]\n");
                LsClusterer.die();
            }
        }
        new LsClusterer(input, output);
    }

    class ClusterNode {
        public EntityInstance m_e;
        double m_x;
        double m_y;
        int m_cluster;
        ClusterNode m_next;

        ClusterNode() {
        }
    }
}

