/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import lsedit.Do;
import lsedit.ERBox;
import lsedit.EntityClass;
import lsedit.LandscapeEditorCore;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.TaListener;

public final class LegendBox
extends ERBox
implements ChangeListener,
TaListener,
MouseListener {
    public static final String m_helpStr = "This box shows the types of entities and relations that are present in the current landscape.";
    protected static Font m_titleFont = null;
    protected static Font m_textFont = null;

    public LegendBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Legend", m_helpStr);
        Font titleFont = m_titleFont;
        Font textFont = m_textFont;
        if (titleFont == null) {
            m_titleFont = titleFont = Options.getTargetFont(8);
        }
        if (textFont == null) {
            m_textFont = textFont = Options.getTargetFont(9);
        }
        this.m_ulabel = new JLabel("Entity Classes");
        this.m_ulabel.setForeground(Color.red);
        this.m_elabel1 = new JLabel("Pass cursor over entity for description.");
        this.m_elabel1.setForeground(Color.black);
        this.m_elabel2 = new JLabel("Right click for menu.");
        this.m_elabel2.setForeground(Color.black);
        this.m_rlabel = new JLabel("Relation Classes");
        this.m_rlabel.setForeground(Color.red);
        this.m_rlabel2 = new JLabel("Reversed Relation Classes");
        this.m_rlabel2.setForeground(Color.red);
        this.m_clabel.setForeground(Color.red);
        this.m_footer1 = new JLabel("Checkboxes select visible entities/relations.");
        this.m_footer1.setForeground(Color.black);
        this.m_footer2 = new JLabel("Right click for menu.");
        this.m_footer2.setForeground(Color.black);
        this.setComponentsTitleFont(titleFont);
        this.setComponentsTextFont(textFont);
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
    }

    @Override
    public Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    @Override
    protected boolean getFlag(EntityClass ec) {
        return ec.isShown();
    }

    @Override
    protected int setFlag(EntityClass ec, boolean value, boolean applyToSubclasses) {
        return ec.setShown(value, applyToSubclasses);
    }

    @Override
    protected boolean getFlag(RelationClass rc, int direction) {
        return rc.isShown(direction);
    }

    @Override
    protected int setFlag(RelationClass rc, int direction, boolean value, boolean applyToSubclasses) {
        return rc.setShown(direction, value, applyToSubclasses);
    }

    @Override
    protected String getFlagName() {
        return "Shown";
    }

    @Override
    protected void customOptions(JPopupMenu popupMenu) {
        Do.createClassMenuItem(popupMenu, this.m_ls);
    }
}

