/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.LandscapeObject3D;
import lsedit.ResultBox;
import lsedit.Ta;
import lsedit.Util;

public abstract class LandscapeClassObject
extends LandscapeObject3D {
    protected static final String CLASSLABEL_ID = "class_label";
    protected static final String CLASSSTYLE_ID = "class_style";
    protected static final String CLASSDESC_ID = "class_description";
    protected static final String ACTIVE_ID = "class_active";
    protected static final String VISIBLE_ID = "class_visible";
    public static final int DIRECTION_NORMAL = 1;
    public static final int DIRECTION_REVERSED = 2;
    public static final int DIRECTION_NONE = 3;
    private Diagram m_dg;
    private Ta m_ta;
    protected int m_shown = 1;
    protected int m_active = 1;
    private Vector m_inheritsFrom = new Vector();
    private Vector m_inheritedBy = null;
    private int m_nid = -1;
    private int m_style = -1;
    private int m_members = 0;

    public LandscapeClassObject(Ta ta) {
        this.m_ta = ta;
        this.m_dg = ta.getDiagram();
    }

    public boolean isShown() {
        return this.m_shown != 0;
    }

    public boolean isShown(int direction) {
        return (this.m_shown & direction) != 0;
    }

    public int getShown() {
        return this.m_shown;
    }

    public int setShown(int value, boolean applyToSubclassesTo) {
        Vector inheritedBy;
        int ret = 0;
        if (value != this.m_shown) {
            this.m_shown = value;
            ret = 1;
        }
        if (applyToSubclassesTo && (inheritedBy = this.m_inheritedBy) != null) {
            int size = inheritedBy.size();
            int i = 0;
            while (i < size) {
                LandscapeClassObject child = (LandscapeClassObject)inheritedBy.elementAt(i);
                if (this == child.getPrimaryInheritance() && child.setShown(value, true) != 0) {
                    ret = -1;
                }
                ++i;
            }
        }
        return ret;
    }

    public int setShown(boolean value, boolean applyToSubclassesTo) {
        return this.setShown(value ? 1 : 0, applyToSubclassesTo);
    }

    public int setShown(int direction, boolean value, boolean applyToSubclassesTo) {
        int value1 = this.m_shown & ~direction;
        if (value) {
            value1 |= direction;
        }
        return this.setShown(value1, applyToSubclassesTo);
    }

    public boolean isActive() {
        return this.m_active != 0;
    }

    public boolean isActive(int direction) {
        return (this.m_active & direction) != 0;
    }

    public int getActive() {
        return this.m_active;
    }

    public int setActive(int value, boolean applyToSubclassesTo) {
        Vector inheritedBy;
        int ret = 0;
        if (this.m_active != value) {
            this.m_active = value;
            ret = 1;
        }
        if (applyToSubclassesTo && (inheritedBy = this.m_inheritedBy) != null) {
            int size = inheritedBy.size();
            int i = 0;
            while (i < size) {
                LandscapeClassObject child = (LandscapeClassObject)inheritedBy.elementAt(i);
                if (this == child.getPrimaryInheritance() && child.setActive(value, true) != 0) {
                    ret = -1;
                }
                ++i;
            }
        }
        return ret;
    }

    public int setActive(boolean value, boolean applyToSubclassesTo) {
        return this.setActive(value ? 1 : 0, applyToSubclassesTo);
    }

    public int setActive(int direction, boolean value, boolean applyToSubclassesTo) {
        int value1 = this.m_active & ~direction;
        if (value) {
            value1 |= direction;
        }
        return this.setActive(value1, applyToSubclassesTo);
    }

    void noMembers() {
        this.m_members = 0;
    }

    void incrementMembers() {
        ++this.m_members;
    }

    void decrementMembers() {
        --this.m_members;
    }

    public int countMembers() {
        return this.m_members;
    }

    @Override
    public int getStyle() {
        return this.m_style;
    }

    @Override
    public void setStyle(int value) {
        this.m_style = value;
    }

    public Enumeration enumInheritsFrom() {
        return this.m_inheritsFrom.elements();
    }

    public Enumeration enumInheritedBy() {
        return this.m_inheritedBy.elements();
    }

    private void enumMyHierarchy(Vector to, boolean hideEmpty) {
        Vector inheritedBy = this.m_inheritedBy;
        to.add(this);
        int size1 = to.size();
        if (inheritedBy != null) {
            int size = inheritedBy.size();
            int i = 0;
            while (i < size) {
                LandscapeClassObject child = (LandscapeClassObject)inheritedBy.elementAt(i);
                if (this == child.getPrimaryInheritance()) {
                    child.enumMyHierarchy(to, hideEmpty);
                }
                ++i;
            }
        }
        if (hideEmpty && size1 == to.size() && this.countMembers() == 0) {
            to.removeElementAt(--size1);
        }
    }

    public Enumeration enumHierarchy(boolean hideEmpty, int size) {
        Vector to = new Vector(size);
        this.enumMyHierarchy(to, hideEmpty);
        return to.elements();
    }

    public int getInheritsFromCnt() {
        return this.m_inheritsFrom.size();
    }

    public Vector getInheritsFrom() {
        return this.m_inheritsFrom;
    }

    public Object getPrimaryInheritance() {
        if (this.m_inheritsFrom == null || this.m_inheritsFrom.size() == 0) {
            return null;
        }
        return this.m_inheritsFrom.elementAt(0);
    }

    public int getInheritanceDepth() {
        int depth = 0;
        LandscapeClassObject at = this;
        while ((at = (LandscapeClassObject)at.getPrimaryInheritance()) != null) {
            ++depth;
        }
        return depth;
    }

    private void removeInheritedBy(LandscapeClassObject child) {
        this.m_inheritedBy.remove(child);
    }

    protected void addInheritedBy(LandscapeClassObject child) {
        if (this.m_inheritedBy == null) {
            this.m_inheritedBy = new Vector();
        }
        this.m_inheritedBy.addElement(child);
    }

    public void setInherits(Vector inheritsFrom) {
        Vector old = this.m_inheritsFrom;
        if (old != inheritsFrom) {
            LandscapeClassObject classObject;
            int i;
            if (old != null) {
                i = 0;
                while (i < old.size()) {
                    classObject = (LandscapeClassObject)old.elementAt(i);
                    classObject.removeInheritedBy(this);
                    ++i;
                }
            }
            this.m_inheritsFrom = inheritsFrom;
            i = 0;
            while (i < inheritsFrom.size()) {
                classObject = (LandscapeClassObject)inheritsFrom.elementAt(i);
                classObject.addInheritedBy(this);
                ++i;
            }
            if (this.m_dg != null) {
                this.m_dg.getLs().repaint();
            }
        }
    }

    public boolean directlyInheritsFrom(Object thing) {
        return this.m_inheritsFrom.contains(thing);
    }

    public boolean subclassOf(LandscapeClassObject lco) {
        Enumeration en = this.enumInheritsFrom();
        while (en.hasMoreElements()) {
            LandscapeClassObject parent = (LandscapeClassObject)en.nextElement();
            if (parent != lco && !parent.subclassOf(lco)) continue;
            return true;
        }
        return false;
    }

    public Vector getClassAndSubclasses(Hashtable classes) {
        boolean seen;
        Vector<LandscapeClassObject> v = new Vector<LandscapeClassObject>();
        v.add(this);
        do {
            seen = false;
            Enumeration en = classes.elements();
            block1: while (en.hasMoreElements()) {
                LandscapeClassObject o = (LandscapeClassObject)en.nextElement();
                if (v.contains(o)) continue;
                Vector inherits = o.getInheritsFrom();
                int size = inherits.size();
                int i = 0;
                while (i < size) {
                    if (v.contains(inherits.elementAt(i))) {
                        v.add(o);
                        seen = true;
                        continue block1;
                    }
                    ++i;
                }
            }
        } while (seen);
        return v;
    }

    public Vector getClassAndSuperclasses() {
        boolean seen;
        Vector<LandscapeClassObject> v = new Vector<LandscapeClassObject>();
        v.add(this);
        do {
            seen = false;
            int i = 0;
            while (i < v.size()) {
                LandscapeClassObject o = (LandscapeClassObject)v.elementAt(i);
                Vector inherits = o.getInheritsFrom();
                int j = 0;
                while (j < inherits.size()) {
                    LandscapeClassObject o1 = (LandscapeClassObject)inherits.elementAt(j);
                    if (!v.contains(o1)) {
                        v.add(o1);
                        seen = true;
                    }
                    ++j;
                }
                ++i;
            }
        } while (seen);
        return v;
    }

    public Vector getValidAttributes() {
        Vector v1 = this.getClassAndSuperclasses();
        int size = v1.size();
        Vector<Attribute> v = new Vector<Attribute>();
        int i = 0;
        while (i < size) {
            LandscapeClassObject o = (LandscapeClassObject)v1.elementAt(i);
            Attribute[] attributes = o.m_attributes;
            if (attributes != null) {
                int attributes_length = attributes.length;
                int j = 0;
                while (j < attributes_length) {
                    Attribute attribute = attributes[j];
                    if (attribute != null) {
                        Attribute attribute1;
                        String id = attribute.m_id;
                        int k = v.size();
                        do {
                            if (--k < 0) {
                                v.add(attribute);
                                break;
                            }
                            attribute1 = (Attribute)v.elementAt(k);
                        } while (!id.equals(attribute1.m_id));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    public String addParentClass(LandscapeClassObject lco) {
        if (lco == null) {
            return "Can't inherit from null class";
        }
        if (this.subclassOf(lco)) {
            return "Already inherits from " + lco.getId();
        }
        int i = this.m_inheritsFrom.size();
        while (--i >= 0) {
            LandscapeClassObject o = (LandscapeClassObject)this.m_inheritsFrom.elementAt(i);
            if (!lco.subclassOf(o)) continue;
            this.m_inheritsFrom.remove(i);
            o.removeInheritedBy(this);
        }
        this.m_inheritsFrom.addElement(lco);
        lco.addInheritedBy(this);
        return null;
    }

    @Override
    public boolean processFirstOrder(String id, String value) {
        if (id.equals(CLASSLABEL_ID)) {
            String s = Attribute.parseStringValue(value);
            if (s != null) {
                this.setLabel(s);
            }
            return true;
        }
        if (id.equals(CLASSSTYLE_ID)) {
            if (value != null) {
                this.setStyle(Attribute.parseIntValue(value));
            }
            return true;
        }
        if (id.equals(CLASSDESC_ID)) {
            String s = Attribute.parseStringValue(value);
            if (s != null) {
                this.setDescription(s);
            }
            return true;
        }
        if (id.equals(ACTIVE_ID)) {
            if (value != null) {
                int val = value.startsWith("f") ? 0 : (value.startsWith("t") ? 1 : Util.parseInt(value));
                this.setActive(val, false);
            }
            return true;
        }
        if (id.equals(VISIBLE_ID)) {
            if (value != null) {
                int val = value.startsWith("f") ? 0 : (value.startsWith("t") ? 1 : Util.parseInt(value));
                this.setShown(val, false);
            }
            return true;
        }
        return super.processFirstOrder(id, value);
    }

    public void reportClassAttributes(ResultBox resultBox) {
        resultBox.addText(CLASSLABEL_ID);
        resultBox.addText(CLASSSTYLE_ID);
        resultBox.addText(CLASSDESC_ID);
        resultBox.addText("color");
        resultBox.addText("labelcolor");
        resultBox.addText("opencolor");
    }

    @Override
    public Ta getTa() {
        return this.m_ta;
    }

    @Override
    public Diagram getDiagram() {
        return this.m_dg;
    }

    public int getNid() {
        return this.m_nid;
    }

    public void setNid(int nid) {
        this.m_nid = nid;
    }

    public String getLabelId() {
        return "(" + this.m_nid + ") " + this.getLabel();
    }

    @Override
    public LandscapeClassObject derivedFrom(int i) {
        return i < this.m_inheritsFrom.size() ? (LandscapeClassObject)this.m_inheritsFrom.elementAt(i) : null;
    }

    @Override
    public Attribute getLsAttribute(String id) {
        Attribute attr = super.getLsAttribute(id);
        if (attr != null) {
            return attr;
        }
        Enumeration en = this.enumInheritsFrom();
        while (en.hasMoreElements()) {
            LandscapeClassObject lco = (LandscapeClassObject)en.nextElement();
            attr = lco.getLsAttribute(id);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    public String writeAttributes(PrintWriter ps, String nodeId) {
        String description;
        int style;
        nodeId = super.writeAttributes(ps, nodeId, null, true);
        String label = this.getLabel();
        if (!this.getId().equals(label)) {
            nodeId = LandscapeClassObject.writeAttribute(ps, nodeId, CLASSLABEL_ID, LandscapeClassObject.qt(label));
        }
        if ((style = this.getStyle()) >= 0) {
            nodeId = LandscapeClassObject.writeAttribute(ps, nodeId, CLASSSTYLE_ID, style);
        }
        if ((description = this.getDescription()) != null) {
            nodeId = LandscapeClassObject.writeAttribute(ps, nodeId, CLASSDESC_ID, LandscapeClassObject.qt(description));
        }
        if (this.m_active != 1) {
            nodeId = LandscapeClassObject.writeAttribute(ps, nodeId, ACTIVE_ID, this.m_active);
        }
        if (this.m_shown != 1) {
            nodeId = LandscapeClassObject.writeAttribute(ps, nodeId, VISIBLE_ID, this.m_shown);
        }
        return nodeId;
    }
}

