/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.FontCache;
import lsedit.ImageCheckBox;

class ImageChooser
extends JDialog
implements ActionListener,
ItemListener {
    protected ImageCheckBox[] m_checkboxes;
    protected LayoutImage m_layoutImage;
    protected JButton m_ok;
    protected JButton m_cancel;
    protected Integer m_result;

    private int getNewImageValue() {
        ImageCheckBox[] checkboxes = this.m_checkboxes;
        int images = checkboxes.length;
        int image = 0;
        int i = 0;
        while (i < images) {
            ImageCheckBox checkbox = checkboxes[i];
            if (checkbox.isSelected()) {
                image |= 1 << i;
            }
            ++i;
        }
        return image;
    }

    public ImageChooser(JFrame frame, Integer integer) {
        super(frame, "Select image properties", true);
        int images = EntityClass.imageName.length;
        this.m_result = integer;
        int image = integer;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel topPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(images, 1, 0, 0);
        topPanel.setLayout(gridLayout);
        this.m_checkboxes = new ImageCheckBox[images];
        int mask = 1;
        int i = 0;
        while (i < images) {
            ImageCheckBox checkBox;
            this.m_checkboxes[i] = checkBox = new ImageCheckBox(EntityClass.imageName[i], (image & mask) != 0, mask);
            checkBox.setFont(bold);
            topPanel.add(checkBox);
            checkBox.addItemListener(this);
            mask <<= 1;
            ++i;
        }
        Container contentPane = this.getContentPane();
        contentPane.add("North", topPanel);
        this.m_layoutImage = new LayoutImage();
        this.m_layoutImage.validate();
        contentPane.add("Center", this.m_layoutImage);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        bottomPanel.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(bold);
        bottomPanel.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        contentPane.add("South", bottomPanel);
        this.pack();
        this.setVisible(true);
    }

    public Integer getImage() {
        return this.m_result;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof ImageCheckBox) {
            this.m_layoutImage.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_ok) {
            int newvalue = this.getNewImageValue();
            if (newvalue != this.m_result) {
                this.m_result = new Integer(newvalue);
            }
        } else if (source != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }

    class LayoutImage
    extends JComponent {
        public LayoutImage() {
            Dimension dimension = new Dimension(240, 240);
            this.setLayout(null);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
            this.setVisible(true);
        }

        @Override
        public void paintComponent(Graphics g) {
            int image = ImageChooser.this.getNewImageValue();
            g.setColor(Color.black);
            EntityComponent.paintImage(g, image, 20, 20, 200, 200);
        }
    }
}

