/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.TaListener;
import lsedit.TabBox;
import lsedit.ToolBarEventHandler;

public final class HistoryBox
extends TabBox
implements ChangeListener,
TaListener,
ToolBarEventHandler,
MouseListener,
MouseMotionListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    public static Dimension m_preferredSize = new Dimension(0, 0);
    public static int m_disable_history = 0;
    public static final String m_helpStr = "This box shows the history of navigation within the current diagram.";
    protected static Font m_textFont = null;
    protected static FontMetrics m_fm = null;
    protected static int m_fontheight;
    protected static int m_baseline;
    protected Vector m_history = new Vector(1000);
    protected int m_style;
    protected int m_over = -1;
    protected int m_at = -1;
    protected EntityInstance m_hover = null;
    protected boolean m_refill = false;

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        Vector v = this.m_history;
        if (v != null) {
            int fontheight = m_fontheight;
            int baseline = m_baseline;
            int height = fontheight;
            int at = this.m_at;
            int over = this.m_over;
            g.setFont(m_textFont);
            int i = this.m_history.size();
            while (i > 0) {
                EntityInstance e;
                if ((e = (EntityInstance)this.m_history.elementAt(--i)).isMarked(0x2000000)) {
                    g.setColor(Color.BLACK);
                } else {
                    if (i == over && this.m_style != 0) {
                        Color color = g.getColor();
                        g.setColor(Color.BLACK);
                        g.draw3DRect(0, height, HistoryBox.m_preferredSize.width - 1, fontheight - 2, this.m_style == 1);
                        g.setColor(color);
                    }
                    if (i == at) {
                        g.setColor(Color.RED);
                    } else {
                        g.setColor(Color.BLUE);
                    }
                }
                String label = e.getEntityLabel();
                g.drawString(label, 5, height + baseline);
                height += fontheight;
            }
        }
    }

    public HistoryBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "History", m_helpStr);
        if (m_textFont == null) {
            m_textFont = Options.getTargetFont(14);
        }
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void fill() {
        if (this.isActive()) {
            this.repaint();
        }
    }

    protected void navigateTo(EntityInstance e) {
        ++m_disable_history;
        this.m_ls.navigateTo(e, false);
        --m_disable_history;
        this.fill();
    }

    public void clear() {
        this.m_history.removeAllElements();
        this.m_at = -1;
        this.m_over = -1;
        this.m_ls.setHistoryButtons(this);
        this.fill();
    }

    public static void setTextFont(Font font) {
        if (font != m_textFont) {
            m_textFont = font;
            m_fm = null;
        }
    }

    public void textFontChanged(Font font) {
        HistoryBox.setTextFont(font);
        this.fill();
    }

    public void setNewPreferredSize() {
        this.setPreferredSize(m_preferredSize);
        this.setSize(m_preferredSize);
        this.m_scrollPane.revalidate();
    }

    public void addEntity(EntityInstance e) {
        Vector history = this.m_history;
        if (m_disable_history == 0) {
            this.m_at = history.size();
            history.addElement(e);
            FontMetrics fm = m_fm;
            if (fm == null) {
                m_fm = fm = this.getFontMetrics(m_textFont);
                m_fontheight = fm.getHeight();
                m_baseline = m_fontheight - fm.getDescent();
            }
            int w = fm.stringWidth(e.getEntityLabel()) + 10;
            int h = history.size() * m_fontheight + 15;
            if (w > HistoryBox.m_preferredSize.width || h > HistoryBox.m_preferredSize.height) {
                if (w > HistoryBox.m_preferredSize.width) {
                    HistoryBox.m_preferredSize.width = w;
                }
                if (h > HistoryBox.m_preferredSize.height) {
                    HistoryBox.m_preferredSize.height = h;
                }
                this.setNewPreferredSize();
            }
            this.fill();
        }
    }

    public boolean hasPrevious() {
        if (this.m_history.size() > 1) {
            int at = this.m_at;
            if (at == -1) {
                at = this.m_history.size() - 1;
            }
            while (--at >= 0) {
                if (!(this.m_history.elementAt(at) instanceof EntityInstance)) continue;
                return true;
            }
        }
        return false;
    }

    public void navigatePrevious() {
        if (this.m_history.size() > 1) {
            int at = this.m_at;
            if (at == -1) {
                at = this.m_history.size() - 1;
            }
            while (--at >= 0) {
                Object object = this.m_history.elementAt(at);
                if (!(object instanceof EntityInstance)) continue;
                this.m_over = -1;
                this.m_at = at;
                this.navigateTo((EntityInstance)object);
                return;
            }
        }
    }

    public boolean hasNext() {
        int at = this.m_at;
        if (at >= 0) {
            while (++at < this.m_history.size()) {
                if (!(this.m_history.elementAt(at) instanceof EntityInstance)) continue;
                return true;
            }
        }
        return false;
    }

    public void navigateNext() {
        int at = this.m_at;
        if (at >= 0) {
            while (++at < this.m_history.size()) {
                Object object = this.m_history.elementAt(at);
                if (!(object instanceof EntityInstance)) continue;
                this.m_over = -1;
                this.m_at = at;
                this.navigateTo((EntityInstance)object);
                return;
            }
        }
    }

    protected void mouseAt(int y) {
        int size = this.m_history.size();
        if (size > 0) {
            int style;
            int over = size - y / m_fontheight;
            if (over < 0) {
                style = 0;
                over = -1;
            } else if (over >= size) {
                style = 0;
                over = size;
            } else {
                style = 1;
            }
            if (style != this.m_style || over != this.m_over) {
                this.m_style = style;
                this.m_over = over;
                this.repaint();
            }
        }
    }

    @Override
    public void diagramChanging(Diagram diagram) {
        this.clear();
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
        if (this.m_refill) {
            this.m_refill = false;
            this.fill();
        }
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        switch (signal) {
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                this.repaint();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isActive()) {
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        this.m_style = 0;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        int size = this.m_history.size();
        if (size > 0) {
            int over;
            Vector history = this.m_history;
            if (ev.isMetaDown()) {
                JPopupMenu m = new JPopupMenu("History options");
                new MyMenuItem(m, "Dispose History", this, -1, 127, "Discard the history");
                FontCache.setMenuTreeFont(m);
                m.show(this, ev.getX(), ev.getY());
                return;
            }
            this.m_over = over = size - ev.getY() / m_fontheight;
            this.m_style = 2;
            if (over >= 0 && over < size) {
                EntityInstance e = (EntityInstance)history.elementAt(over);
                this.m_at = over;
                if (!e.isMarked(0x2000000)) {
                    if (ev.isAltDown()) {
                        this.m_hover = e;
                        e.startHover();
                    } else {
                        this.navigateTo(e);
                    }
                }
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.m_hover != null) {
            this.m_hover.endHover();
            this.m_hover = null;
        }
        this.m_style = 0;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        return this.m_ls.processMetaKeyEvent(name);
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        switch (key) {
            case 127: {
                int ret = JOptionPane.showConfirmDialog(this.m_ls.getFrame(), "Confirm deletion?", "Delete History", 2);
                if (ret != 0) break;
                this.clear();
            }
        }
    }

    @Override
    public void showInfo(String msg) {
    }
}

