/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.RelationClass;
import lsedit.SimplexLayout;
import lsedit.SortVector;

class HiRow {
    HiRow() {
    }

    static HiGraph[][] buildBoard(HiGraph node) {
        HiGraph dst;
        int j;
        Vector outArcs;
        HiGraph child;
        HiArc arc;
        int[] count = new int[node.m_sink_rank - node.m_rank + 1];
        int[] ranks = new int[node.m_sink_rank - node.m_rank + 1];
        Vector children = node.m_children;
        int size = children.size();
        boolean planar = true;
        int i = 0;
        while (i < size) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            int n = child.m_rank - node.m_rank;
            count[n] = count[n] + 1;
            child.m_position = 0;
            ++i;
        }
        i = 0;
        while (i < size) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            if (child.m_object != null) {
                outArcs = child.m_out;
                j = outArcs.size();
                while (j > 0) {
                    arc = (HiArc)outArcs.elementAt(--j);
                    dst = arc.to();
                    if (dst.m_object == null || dst.m_rank != child.m_rank || (arc = dst.m_parent) == null || arc.from() != node) continue;
                    ++dst.m_position;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            HiArc firstArc;
            HiArc bestArc = firstArc = (HiArc)children.elementAt(i);
            HiGraph best = bestArc.to();
            int at = i;
            j = i + 1;
            while (j < size) {
                arc = (HiArc)children.elementAt(j);
                dst = arc.to();
                if (best.m_object == null || dst.m_object != null && dst.m_rank <= best.m_rank && (dst.m_rank != best.m_rank || dst.m_position < best.m_position)) {
                    bestArc = arc;
                    best = dst;
                    at = j;
                }
                ++j;
            }
            if (at != i) {
                children.set(at, firstArc);
                children.set(i, bestArc);
            }
            if (best.m_object == null) {
                ++i;
                continue;
            }
            int tail = i;
            while (i <= tail) {
                arc = (HiArc)children.elementAt(i);
                child = arc.to();
                outArcs = child.m_out;
                int arcs = outArcs.size();
                j = 0;
                while (j < arcs) {
                    arc = (HiArc)outArcs.elementAt(j);
                    dst = arc.to();
                    arc = dst.m_parent;
                    if (arc != null && arc.from() == node && dst.m_object != null) {
                        at = tail + 1;
                        while (at < size) {
                            bestArc = (HiArc)children.elementAt(at);
                            HiGraph other = bestArc.to();
                            if (other == dst) break;
                            ++at;
                        }
                        if (at == size) {
                            planar = false;
                        } else if (++tail != at) {
                            arc = (HiArc)children.elementAt(tail);
                            children.set(at, arc);
                            children.set(tail, bestArc);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        j = 0;
        i = 0;
        while (i < count.length) {
            ranks[i] = j++;
            if (count[i] != 0) {
                // empty if block
            }
            ++i;
        }
        HiGraph[][] board = new HiGraph[j][];
        j = 0;
        i = 0;
        while (i < count.length) {
            if (count[i] != 0) {
                board[j++] = new HiGraph[count[i]];
                count[i] = 0;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            int position;
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            int rank = ranks[child.m_rank - node.m_rank];
            child.m_position = position = count[rank];
            board[rank][position] = child;
            int n = rank;
            count[n] = count[n] + 1;
            ++i;
        }
        node.m_rowweight = planar ? 0.0 : 1.0;
        return board;
    }

    static void dumpRow(int number, HiGraph[] row) {
        System.out.print(String.valueOf(number) + ":");
        int j = 0;
        while (j < row.length) {
            System.out.print(String.valueOf(row[j].m_position) + ":" + row[j] + " ");
            ++j;
        }
        System.out.println("");
    }

    static void dumpBoard(HiGraph[][] board) {
        int i = 0;
        while (i < board.length) {
            HiRow.dumpRow(i, board[i]);
            ++i;
        }
    }

    private static void rowWeight(HiGraph higraph) {
        int in_size;
        HiGraph other;
        HiArc arc;
        int out_size;
        int weight = 0;
        Vector arcs = higraph.m_out;
        int i = out_size = arcs.size();
        while (i > 0) {
            arc = (HiArc)arcs.elementAt(--i);
            other = arc.to();
            weight += other.m_position;
        }
        arcs = higraph.m_in;
        i = in_size = arcs.size();
        while (i > 0) {
            arc = (HiArc)arcs.elementAt(--i);
            other = arc.from();
            weight += other.m_position;
        }
        higraph.m_rowweight = (in_size += out_size) == 0 ? -1.0 : (double)(weight += in_size) / (double)in_size;
    }

    private static boolean shake(HiGraph[] row) {
        HiGraph higraph;
        boolean ret = false;
        int i = row.length;
        while (i > 0) {
            higraph = row[--i];
            HiRow.rowWeight(higraph);
        }
        int position = row.length;
        block1: while (true) {
            double max = -2.0;
            i = row.length;
            while (i > 0) {
                higraph = row[--i];
                if (!(max < higraph.m_rowweight)) continue;
                max = higraph.m_rowweight;
            }
            i = 0;
            while (true) {
                if (i >= row.length) continue block1;
                higraph = row[i];
                if (higraph.m_rowweight == max) {
                    if (higraph.m_position != --position) {
                        higraph.m_position = position;
                        ret = true;
                    }
                    higraph.m_rowweight = -3.0;
                    if (position == 0) {
                        return ret;
                    }
                }
                ++i;
            }
            break;
        }
    }

    private static void designated(HiGraph[][] board, RelationClass rc) {
        HiGraph dst;
        int j;
        HiGraph[] row;
        int i = 0;
        while (i < board.length) {
            row = board[i];
            j = 0;
            while (j < row.length) {
                dst = row[j];
                dst.m_visited = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < board.length) {
            row = board[i];
            j = 0;
            while (j < row.length) {
                dst = row[j];
                if (dst.m_visited == 0) {
                    Enumeration en = dst.m_in.elements();
                    while (en.hasMoreElements()) {
                        int position;
                        EntityInstance e;
                        EntityInstance e1;
                        HiArc arc = (HiArc)en.nextElement();
                        if (arc.getMinlength() != 0) continue;
                        HiGraph src = arc.from();
                        int rank = src.m_rank;
                        if (rank != dst.m_rank || src == dst || (e1 = src.m_object).getRelationTo(rc, e = dst.m_object) == null || dst.m_position == (position = src.m_position + 1)) continue;
                        int j1 = 0;
                        while (j1 < row.length) {
                            HiGraph other = row[j1];
                            if (other.m_position >= position) {
                                ++other.m_position;
                            }
                            ++j1;
                        }
                        dst.m_position = position;
                        dst.m_visited = 1;
                        j = -1;
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean orderchildren(SimplexLayout options, HiGraph node) throws HiGraphException {
        RelationClass rc;
        Vector children = node.m_children;
        int size = children.size();
        boolean ret = false;
        node.m_position = 0;
        if (size == 0) {
            return ret;
        }
        int i = 0;
        while (i < size) {
            HiArc arc = (HiArc)children.elementAt(i);
            HiGraph child = arc.to();
            ret |= HiRow.orderchildren(options, child);
            ++i;
        }
        if (ret) {
            return ret;
        }
        if (node.dontReorder()) {
            return true;
        }
        HiGraph[][] board = HiRow.buildBoard(node);
        int cycles = SimplexLayout.crossing();
        if (node.m_rowweight != 0.0) {
            int to = board.length;
            int direction = 1;
            boolean improved = false;
            i = 0;
            while (true) {
                improved |= HiRow.shake(board[i]);
                if ((cycles -= to) < 0) break;
                if ((i += direction) >= 0 && i < to) continue;
                if (!improved) break;
                improved = false;
                direction = -direction;
                i += 2 * direction;
            }
        }
        if ((rc = SimplexLayout.getDesignatedClass()) != null) {
            HiRow.designated(board, rc);
        }
        SortVector.byPosition(children);
        return true;
    }

    static void order(SimplexLayout options, HiGraph root) throws HiGraphException {
        HiRow.orderchildren(options, root);
    }
}

