/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.HiSimplex;
import lsedit.RelationClass;

public class HiRank {
    private static boolean designated(HiArc arc, RelationClass designatedClass) {
        if (designatedClass != null) {
            HiGraph src = arc.from();
            HiGraph dst = arc.to();
            EntityInstance e = src.m_object;
            EntityInstance e1 = dst.m_object;
            if (e != null && e1 != null && e.getRelationTo(designatedClass, e1) != null) {
                return true;
            }
        }
        return false;
    }

    private static void assignWeights(HiGraph node, RelationClass designatedClass) throws HiGraphException {
        HiArc arc;
        HiGraph sink = node.m_sink;
        if (sink != null) {
            sink.dispose();
            sink = null;
            node.m_sink = null;
        }
        if (node.m_children.size() != 0) {
            node.m_sink = sink = node.newChild(2);
        }
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            arc.setWeight(0);
            arc.setMinlength(1);
            if (child == sink) continue;
            HiRank.assignWeights(child, designatedClass);
            if (child.m_sink != null) {
                child = child.m_sink;
            }
            arc = sink.newInputArc(child);
            arc.setWeight(0);
            arc.setMinlength(1);
        }
        e = node.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            if (arc.getWeight() == 0) {
                arc.setWeight(1);
            }
            if (HiRank.designated(arc, designatedClass)) {
                arc.setMinlength(0);
                continue;
            }
            if (arc.getMinlength() != 0) continue;
            arc.setMinlength(1);
        }
    }

    static void removesinks(HiGraph node) throws HiGraphException {
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiRank.removesinks(arc.to());
        }
        HiGraph sink = node.m_sink;
        if (sink == null) {
            node.m_sink_rank = node.m_rank;
        } else {
            node.m_sink_rank = sink.m_rank;
            node.m_sink = null;
            sink.dispose();
        }
    }

    private static void balance(HiGraph node, int[] local) throws HiGraphException {
        int diff1;
        HiGraph child;
        int i;
        HiArc arc = node.m_parent;
        int min = arc != null ? arc.from().m_rank + 1 : 0;
        int max = node.m_sink_rank - 1;
        int[] below = new int[max + 2];
        Vector arcs = node.m_children;
        int size = arcs.size();
        if (node.horizontalArray()) {
            i = size - 1;
            while (i >= 0) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                child.m_rank = node.m_rank + 1;
                --i;
            }
        }
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            int n = child.m_rank;
            below[n] = below[n] + 1;
            --i;
        }
        int child_sink_rank = Integer.MIN_VALUE;
        if (size > 0) {
            int child_rank = Integer.MAX_VALUE;
            i = size - 1;
            while (i >= 0) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                HiRank.balance(child, below);
                if (child.m_rank < child_rank) {
                    child_rank = child.m_rank;
                }
                if (child.m_sink_rank > child_sink_rank) {
                    child_sink_rank = child.m_sink_rank;
                }
                --i;
            }
            if (max >= child_rank) {
                max = child_rank - 1;
            }
            node.m_sink_rank = child_sink_rank + 1;
            min = node.m_rank;
        }
        below = null;
        if (max <= min || node.m_weight != 0) {
            return;
        }
        arcs = node.m_in;
        size = arcs.size();
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.from();
            if (child.m_rank >= min && max <= (min = child.m_rank + 1)) {
                return;
            }
            --i;
        }
        arcs = node.m_out;
        size = arcs.size();
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            if (child.m_rank <= max && (max = child.m_rank - 1) <= min) {
                return;
            }
            --i;
        }
        if (child_sink_rank > 0) {
            node.m_rank = max;
            return;
        }
        int choice = node.m_rank;
        int mid = max + min;
        i = min;
        while (i <= max) {
            if (local[i] < local[choice]) {
                choice = i;
            } else if (local[i] == local[choice]) {
                int diff2;
                diff1 = mid - choice * 2;
                if (diff1 < 0) {
                    diff1 = -diff1;
                }
                if ((diff2 = mid - i * 2) < 0) {
                    diff2 = -diff2;
                }
                if (diff2 < diff1) {
                    choice = i;
                }
            }
            ++i;
        }
        diff1 = choice - node.m_rank;
        if (diff1 != 0) {
            System.out.println("Moving " + node + " from rank=" + node.m_rank + " to " + choice);
            int n = node.m_rank;
            local[n] = local[n] - 1;
            int n2 = choice;
            local[n2] = local[n2] + 1;
            node.m_rank += diff1;
        }
    }

    public static void compute(HiGraph root, int pivots, RelationClass designatedClass) throws HiGraphException {
        HiRank.assignWeights(root, designatedClass);
        HiSimplex.simplex(root, pivots);
        HiRank.removesinks(root);
    }
}

