/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.HiSimplex;
import lsedit.SimplexLayout;

class HiGraphCoordinates {
    static final boolean debug = false;

    HiGraphCoordinates() {
    }

    private static void postorder(HiGraph node, int min) {
        int max = min;
        node.m_minbeneath = min;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph down = arc.to();
            HiGraphCoordinates.postorder(down, max);
            max = down.m_postorder + 1;
        }
        node.m_postorder = max;
    }

    private static HiGraph auxGraph(SimplexLayout options, HiGraph node) throws HiGraphException {
        HiGraph other;
        int j;
        int arcs_size;
        Vector arcs;
        HiGraph child;
        HiArc arc;
        int xweight;
        int outside_bias = SimplexLayout.outside_bias();
        int weight_1dummy = SimplexLayout.weight_1dummy();
        int weight_2dummy = SimplexLayout.weight_2dummy();
        boolean hasBends = SimplexLayout.hasBends();
        int xgap = node.m_xGap;
        if (xgap < 0) {
            xgap = SimplexLayout.xgap();
        }
        int n = xweight = node.m_horizontalArray ? 100 : 0;
        if (outside_bias < 0) {
            outside_bias = 0;
        }
        if (xgap < 0) {
            xgap = 0;
        }
        if (weight_1dummy < 0) {
            weight_1dummy = 0;
        }
        if (weight_2dummy < 0) {
            weight_2dummy = 0;
        }
        HiGraph container = new HiGraph(null, node.label(), 0, node.height());
        Vector children = node.m_children;
        int children_size = children.size();
        boolean right_edges = false;
        boolean left_edges = false;
        boolean nodes_adjacent = false;
        int i = 0;
        while (i < children_size) {
            HiGraph duplicate;
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            child.m_duplicate = duplicate = container.newChild(child.getReferencedObject(), child.label(), child.width(), child.height());
            duplicate.m_duplicate = child;
            if (child.m_outside > 0) {
                right_edges = true;
            } else if (child.m_outside < 0) {
                left_edges = true;
            }
            ++i;
        }
        i = 0;
        while (i < children_size) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            arcs = child.m_duplicate.m_out;
            arcs_size = 0;
            j = i + 1;
            while (j < children_size) {
                block34: {
                    arc = (HiArc)children.elementAt(j);
                    other = arc.to();
                    if (!(child.m_rank < other.m_rank ? child.m_sink_rank <= other.m_rank : child.m_rank > other.m_sink_rank || child.m_rank == other.m_sink_rank && other.m_children.size() > 0)) {
                        int k = 0;
                        while (k < arcs_size) {
                            arc = (HiArc)arcs.elementAt(k);
                            HiGraph prev = arc.to().m_duplicate;
                            if (prev.m_rank < other.m_rank ? prev.m_sink_rank <= other.m_rank : prev.m_rank > other.m_sink_rank || prev.m_rank == other.m_sink_rank && other.m_children.size() > 0) {
                                ++k;
                                continue;
                            }
                            break block34;
                        }
                        nodes_adjacent = true;
                        arc = other.m_duplicate.newInputArc(child.m_duplicate);
                        int minlength = xgap + (other.m_width + child.m_width) / 2;
                        if (!hasBends) {
                            if (other.dummyNode() != 0 && child.dummyNode() != 0) {
                                minlength = 0;
                            } else if (other.dummyNode() != 0) {
                                minlength = xgap + child.m_width / 2;
                            } else if (child.dummyNode() != 0) {
                                minlength = other.m_width / 2;
                            }
                        }
                        if (minlength < 0) {
                            throw new HiGraphException("Negative distance between nodes " + child + " and " + other);
                        }
                        arc.setMinlength(minlength);
                        arc.setWeight(xweight);
                        ++arcs_size;
                    }
                }
                ++j;
            }
            ++i;
        }
        HiGraph left = null;
        HiGraph right = null;
        if (outside_bias != 0 && (left_edges || right_edges) && nodes_adjacent) {
            if (right_edges) {
                right = container.newChild(null, "right", 0, 0);
            }
            if (left_edges) {
                left = container.newChild(null, "left", 0, 0);
            }
        }
        i = 0;
        while (i < children_size) {
            HiGraph fork;
            int weight;
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            if (left != null && child.m_duplicate.m_in.size() == 0) {
                arc = child.m_duplicate.newInputArc(left);
                arc.setMinlength(0);
                arc.setWeight(0);
            }
            if (right != null && child.m_duplicate.m_out.size() == 0) {
                arc = right.newInputArc(child.m_duplicate);
                arc.setMinlength(0);
                arc.setWeight(0);
            }
            if (child.m_outside > 0) {
                other = right;
                weight = child.m_outside;
            } else if (child.m_outside < 0) {
                other = left;
                weight = 0 - child.m_outside;
            } else {
                other = null;
                weight = 0;
            }
            if (other != null) {
                fork = container.newChild(null, "fork1", 0, 0);
                arc = child.m_duplicate.newInputArc(fork);
                arc.setMinlength(0);
                arc.setWeight(weight *= outside_bias);
                arc = other.newInputArc(fork);
                arc.setMinlength(0);
                arc.setWeight(weight);
            }
            arcs = child.m_out;
            arcs_size = arcs.size();
            j = 0;
            while (j < arcs_size) {
                arc = (HiArc)arcs.elementAt(j);
                other = arc.to();
                if (other.m_parent != null && other.m_parent.from() == node) {
                    fork = container.newChild(null, "fork2", 0, 0);
                    weight = child.m_dummy_node != 0 && other.m_dummy_node != 0 ? weight_2dummy : (child.m_dummy_node == 0 && other.m_dummy_node == 0 ? 1 : weight_1dummy);
                    arc = child.m_duplicate.newInputArc(fork);
                    arc.setMinlength(0);
                    arc.setWeight(weight);
                    arc = other.m_duplicate.newInputArc(fork);
                    arc.setMinlength(0);
                    arc.setWeight(weight);
                }
                ++j;
            }
            ++i;
        }
        return container;
    }

    private static void balance(HiGraph real, HiGraph node) {
        int temp;
        HiGraph child;
        HiArc arc;
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        Vector arcs = node.m_in;
        int size = arcs.size();
        int i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            if (arc.getWeight() == 0 && (child = arc.to()) == node) {
                child = arc.from();
                temp = child.m_rank + arc.getMinlength();
                if (temp > min) {
                    min = temp;
                }
            }
            --i;
        }
        arcs = node.m_out;
        size = arcs.size();
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            if (arc.getWeight() == 0 && (child = arc.from()) == node) {
                child = arc.to();
                temp = child.m_rank - arc.getMinlength();
                if (temp < max) {
                    max = temp;
                }
            }
            --i;
        }
        if (max <= min) {
            return;
        }
        arcs = real.m_in;
        size = arcs.size();
        int best = 0;
        int count = 0;
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.from();
            if (child.m_duplicate != null) {
                best += child.m_duplicate.m_rank;
                ++count;
            }
            --i;
        }
        arcs = real.m_out;
        size = arcs.size();
        i = size - 1;
        while (i >= 0) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            if (child.m_duplicate != null) {
                best += child.m_duplicate.m_rank;
                ++count;
            }
            --i;
        }
        if (count != 0) {
            node.m_rank = (best /= count) < min ? min : (best > max ? max : best);
        }
    }

    private static void local_xlayout(SimplexLayout options, HiGraph node) throws HiGraphException {
        int width;
        HiGraph child;
        HiArc arc;
        int xgap = SimplexLayout.xgap();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        Vector arcs = node.m_children;
        int size = arcs.size();
        int i = 0;
        while (i < size) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            HiGraphCoordinates.local_xlayout(options, child);
            ++i;
        }
        if (node.m_uniformWidth) {
            width = 0;
            i = 0;
            while (i < size) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                if (width < child.m_width) {
                    width = child.m_width;
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                child.m_width = width;
                ++i;
            }
        }
        width = node.m_dummy_node != 0 ? 0 : node.width();
        max = 0;
        min = 0;
        if (size != 0) {
            HiGraph aux = HiGraphCoordinates.auxGraph(options, node);
            HiSimplex.simplex(aux, SimplexLayout.simplex());
            i = size - 1;
            while (i >= 0) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                HiGraph duplicate = child.m_duplicate;
                if (child.m_in.size() == 0 || child.m_out.size() == 0) {
                    HiGraphCoordinates.balance(child, duplicate);
                }
                child.m_x = duplicate.m_rank;
                int temp = child.m_x - child.m_width / 2;
                if (temp < min) {
                    min = temp;
                }
                if ((temp += child.m_width) > max) {
                    max = temp;
                }
                --i;
            }
            i = size - 1;
            while (i >= 0) {
                arc = (HiArc)arcs.elementAt(i);
                child = arc.to();
                child.m_duplicate = null;
                --i;
            }
            if ((max += xgap) - (min -= xgap) > width) {
                width = max - min;
            }
            aux.dispose();
        }
        node.m_x = 0;
        node.m_width = width;
    }

    private static void global_xlayout(HiGraph node, int x_shift) {
        HiGraph child;
        HiArc arc;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        node.m_x += x_shift;
        Vector arcs = node.m_children;
        int size = arcs.size();
        int i = 0;
        while (i < size) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            int temp = child.m_x - child.m_width / 2;
            if (temp < min) {
                min = temp;
            }
            if ((temp += child.m_width) > max) {
                max = temp;
            }
            ++i;
        }
        x_shift = node.m_x - (max + min) / 2;
        i = 0;
        while (i < size) {
            arc = (HiArc)arcs.elementAt(i);
            child = arc.to();
            HiGraphCoordinates.global_xlayout(child, x_shift);
            ++i;
        }
    }

    private static void local_ylayout(SimplexLayout options, HiGraph node) {
        HiGraph child;
        HiArc arc;
        int height = node.height();
        int ygap = SimplexLayout.ygap();
        int separation = height + ygap;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            child = arc.to();
            HiGraphCoordinates.local_ylayout(options, child);
        }
        if (node.m_dummy_node == 1) {
            int displace = 0;
            node.m_height = 0;
            arc = (HiArc)node.m_out.elementAt(0);
            child = arc.to();
            arc = (HiArc)node.m_in.elementAt(0);
            HiGraph parent = arc.from();
            if (child.m_dummy_node == parent.m_dummy_node) {
                if (child.m_dummy_node == 1) {
                    displace = height / 2;
                } else {
                    node.width(0);
                    node.height(separation - ygap);
                    displace = node.height() / 2;
                }
            } else if (child.m_dummy_node != 1) {
                displace = height;
            }
            node.m_y = node.m_rank * separation + displace;
        } else {
            int textheight;
            int ranks = node.m_sink_rank - node.m_rank + 1;
            if (ranks < 0) {
                System.out.println("Caution: " + node + " has " + ranks + " ranks " + node.m_rank + "-" + node.m_sink_rank);
            }
            node.m_height = ranks * separation - ygap;
            if (ranks != 1) {
                node.m_height -= height + ygap / 2;
            }
            if ((textheight = node.height()) > node.m_height) {
                node.m_height = textheight;
            }
            node.m_y = node.m_rank * separation;
        }
    }

    private static void global_ylayout(HiGraph node, int y_shift) {
        HiGraph child;
        HiArc arc;
        Vector children = node.m_children;
        int size = children.size();
        int i = 0;
        while (i < size) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            HiGraphCoordinates.global_ylayout(child, y_shift);
            ++i;
        }
        node.m_y += y_shift;
        if (node.uniformDepth()) {
            i = 0;
            while (i < size) {
                int bottom1;
                int top1;
                HiGraph child1;
                arc = (HiArc)children.elementAt(i);
                child = arc.to();
                int top = child.m_y - child.m_height / 2;
                int bottom = child.m_y + child.m_height / 2;
                boolean flag = false;
                int j = i + 1;
                while (j < size) {
                    arc = (HiArc)children.elementAt(j);
                    child1 = arc.to();
                    top1 = child1.m_y - child1.m_height / 2;
                    bottom1 = child1.m_y + child1.m_height / 2;
                    switch (top - top1) {
                        case -1: 
                        case 0: 
                        case 1: {
                            if (bottom == bottom1) break;
                            flag = true;
                            if (bottom >= bottom1) break;
                            bottom = bottom1;
                        }
                    }
                    ++j;
                }
                if (flag) {
                    j = i;
                    while (j < size) {
                        arc = (HiArc)children.elementAt(j);
                        child1 = arc.to();
                        top1 = child1.m_y - child1.m_height / 2;
                        bottom1 = child1.m_y + child1.m_height / 2;
                        switch (top - top1) {
                            case -1: 
                            case 0: 
                            case 1: {
                                int height = bottom - top;
                                int y = top + height / 2;
                                int k = 0;
                                while (k < size) {
                                    if (k != j) {
                                        arc = (HiArc)children.elementAt(k);
                                        HiGraph child2 = arc.to();
                                        int diff = child2.m_y - y;
                                        if (diff < 0) {
                                            diff = 0 - diff;
                                        }
                                        if (diff < (height + child2.m_height) / 2) {
                                            diff = child2.m_x - child1.m_x;
                                            if (diff < 0) {
                                                diff = 0 - diff;
                                            }
                                            if (diff < (child1.m_width + child2.m_width) / 2) break;
                                        }
                                    }
                                    ++k;
                                }
                                if (k != size) break;
                                child1.m_height = height;
                                child1.m_y = y;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static int clip(int position, int border) {
        if (position > border) {
            return border;
        }
        if (position < -border) {
            return -border;
        }
        return position;
    }

    static void arc_layout(HiArc arc) {
        int fromX;
        int toX;
        int toY;
        int fromY;
        HiGraph from = arc.from();
        HiGraph to = arc.to();
        int half_from_width = from.m_width / 2;
        int half_from_height = from.m_height / 2;
        int half_to_width = to.m_width / 2;
        int half_to_height = to.m_height / 2;
        int from_centre_x = from.m_x;
        int from_centre_y = from.m_y;
        int to_centre_x = to.m_x;
        int to_centre_y = to.m_y;
        int opposite = to_centre_y - from_centre_y;
        int adjacent = to_centre_x - from_centre_x;
        if (adjacent < 2 && adjacent > -2) {
            fromY = from_centre_y;
            toY = to_centre_y;
            fromX = toX = to_centre_x;
            if (opposite > 0) {
                fromY += half_from_height;
                toY -= half_to_height;
            } else {
                fromY -= half_from_height;
                toY += half_to_height;
            }
        } else if (opposite < 2 && opposite > -2) {
            fromX = from_centre_x;
            toX = to_centre_x;
            fromY = toY = to_centre_y;
            if (adjacent > 0) {
                fromX += half_from_width;
                toX -= half_to_width;
            } else {
                fromX -= half_from_width;
                toX += half_to_width;
            }
        } else {
            double slope = (double)opposite / (double)adjacent;
            fromX = (int)((double)half_from_height / slope);
            fromY = (int)((double)half_from_width * slope);
            fromX = HiGraphCoordinates.clip(fromX, half_from_width);
            fromY = HiGraphCoordinates.clip(fromY, half_from_height);
            toX = (int)((double)half_to_height / slope);
            toY = (int)((double)half_to_width * slope);
            toX = HiGraphCoordinates.clip(toX, half_to_width);
            toY = HiGraphCoordinates.clip(toY, half_to_height);
            if (slope < 0.0) {
                fromY = 0 - fromY;
                toY = 0 - toY;
            }
            int length1 = to_centre_x + toX - (from_centre_x + fromX);
            int length2 = to_centre_y + toY - (from_centre_y + fromY);
            length1 = to_centre_x - toX - (from_centre_x + fromX);
            length2 = to_centre_y - toY - (from_centre_y + fromY);
            int choice2 = length1 * length1 + length2 * length2;
            int choice1 = length1 * length1 + length2 * length2;
            if (choice2 < choice1) {
                choice1 = choice2;
                toX = -toX;
                toY = -toY;
            }
            if ((choice2 = (length1 = to_centre_x + toX - (from_centre_x - fromX)) * length1 + (length2 = to_centre_y + toY - (from_centre_y - fromY)) * length2) < choice1) {
                fromX = -fromX;
                fromY = -fromY;
            }
            fromX += from_centre_x;
            fromY += from_centre_y;
            toX += to_centre_x;
            toY += to_centre_y;
        }
        if (from.m_children.size() > 0) {
            int diff = fromX - from_centre_x;
            if (diff < 0) {
                diff = 0 - diff;
            }
            if (diff == half_from_width) {
                fromY = to.m_rank < from.m_sink_rank ? from_centre_y - half_from_height + from.height() : from_centre_y + half_from_height - from.height();
            }
        } else if (from.m_width == 0) {
            fromY = from.m_y + half_from_height;
        }
        if (to.m_children.size() > 0) {
            int diff = toX - to_centre_x;
            if (diff < 0) {
                diff = 0 - diff;
            }
            if (diff == half_to_width) {
                toY = to_centre_y - half_to_height + to.height();
            }
        } else if (to.m_width == 0) {
            toY = to.m_y - half_to_height;
        }
        if (arc.reversed()) {
            int temp = fromX;
            fromX = toX;
            toX = temp;
            temp = fromY;
            fromY = toY;
            toY = temp;
        }
        arc.m_fromX = fromX;
        arc.m_toX = toX;
        arc.m_fromY = fromY;
        arc.m_toY = toY;
    }

    private static void arc_layout(HiGraph node, HiArc arc, int repeat) {
        arc.m_fromX = node.m_x;
        arc.m_fromY = node.m_y;
        arc.m_fromX = (repeat & 1) == 0 ? (arc.m_fromX += node.m_width / 2) : (arc.m_fromX -= node.m_width / 2);
        arc.m_fromY = (repeat >> 1 & 1) == 0 ? (arc.m_fromY -= node.m_height / 2) : (arc.m_fromY += node.m_height / 2);
        arc.m_toX = node.m_height < node.m_width ? node.m_height : node.m_width;
        arc.m_toX -= (repeat >> 2) * 4;
        if (arc.m_toX < 4) {
            arc.m_toX = 4;
        }
        int shift = arc.m_toX >> 1;
        switch (repeat & 3) {
            case 1: {
                arc.m_fromX -= shift;
                arc.m_fromY -= shift;
                arc.m_toY = 0;
                break;
            }
            case 2: {
                arc.m_fromX -= shift;
                arc.m_fromY -= shift;
                arc.m_toY = 180;
                break;
            }
            case 3: {
                arc.m_fromX -= shift;
                arc.m_fromY -= shift;
                arc.m_toY = 90;
                break;
            }
            default: {
                arc.m_fromX -= shift;
                arc.m_fromY -= shift;
                arc.m_toY = 270;
            }
        }
    }

    private static void layout(HiGraph node, boolean all, boolean consider_inputs) {
        HiArc arc;
        Enumeration e;
        if (all) {
            e = node.m_children.elements();
            while (e.hasMoreElements()) {
                arc = (HiArc)e.nextElement();
                HiGraph child = arc.to();
                HiGraphCoordinates.layout(child, all, consider_inputs);
            }
        }
        if (consider_inputs) {
            e = node.m_in.elements();
            while (e.hasMoreElements()) {
                arc = (HiArc)e.nextElement();
                HiGraphCoordinates.arc_layout(arc);
            }
        }
        e = node.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraphCoordinates.arc_layout(arc);
        }
        int i = 0;
        e = node.m_self.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraphCoordinates.arc_layout(node, arc, i);
            ++i;
        }
    }

    static void layout(HiGraph node, boolean all) {
        HiGraphCoordinates.layout(node, all, true);
    }

    public static void coordinates(SimplexLayout options, HiGraph root) throws HiGraphException {
        HiGraphCoordinates.local_xlayout(options, root);
        HiGraphCoordinates.local_ylayout(options, root);
        HiGraphCoordinates.global_xlayout(root, SimplexLayout.xmargin() - (root.m_x - root.m_width / 2));
        HiGraphCoordinates.global_ylayout(root, SimplexLayout.ymargin() - (root.m_y - root.m_height / 2));
        HiGraphCoordinates.layout(root, true, false);
    }
}

