/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;

class HiChildren {
    static final boolean debug = false;

    HiChildren() {
    }

    private static void addDummyNodes(HiGraph node) throws HiGraphException {
        HiArc arc;
        node.m_visited = 0;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiChildren.addDummyNodes(child);
        }
        HiGraph parent = node.m_parent == null ? null : node.m_parent.from();
        int nodes = node.m_out.size();
        int i = 0;
        while (i < nodes) {
            int slack;
            arc = (HiArc)node.m_out.elementAt(i);
            HiGraph to = arc.to();
            if (to.m_parent != null && to.m_parent.from() == parent && (slack = to.m_rank - node.m_rank - 1) > 0) {
                int minslack = node.m_sink_rank - node.m_rank;
                if (slack < minslack - 1 || arc.onSide()) {
                    minslack = 0;
                }
                boolean reversed = arc.reversed();
                HiGraph dummy = null;
                while (slack > minslack) {
                    dummy = parent.newChild();
                    dummy.m_rank = node.m_rank + slack;
                    dummy.sinkrank(dummy.m_rank);
                    dummy.newOutputArc(arc);
                    arc = new HiArc(node, dummy);
                    arc.reverse(reversed);
                    dummy.newInputArc(arc);
                    --slack;
                }
                node.m_out.setElementAt(arc, i);
            }
            ++i;
        }
    }

    private static void postorderlevel(HiGraph node) {
        int min = node.m_minbeneath;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            int beneath = child.m_postorder - child.m_minbeneath;
            child.m_minbeneath = min;
            child.m_postorder = min + beneath;
            min += beneath + 1;
        }
    }

    private static int postorder(HiGraph node, int min) {
        int max = min;
        node.m_minbeneath = min;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            max = HiChildren.postorder(child, max);
        }
        node.m_postorder = max;
        return max + 1;
    }

    private static void fillMatrix(HiGraph[] queue, int[][][] matrices) {
        int i = queue.length - 1;
        while (i >= 0) {
            HiGraph node1 = queue[i];
            Enumeration e = node1.m_in.elements();
            block1: while (e.hasMoreElements()) {
                node1 = queue[i];
                HiArc arc = (HiArc)e.nextElement();
                HiGraph node2 = arc.from();
                while (true) {
                    int depth;
                    if ((depth = node1.m_depth) == node2.m_depth) {
                        int id1 = node1.m_position;
                        int id2 = node2.m_position;
                        if (id1 == id2) continue block1;
                        int[][] matrix = matrices[depth];
                        if (id2 < id1) {
                            int[] nArray = matrix[id1];
                            int n = id2;
                            nArray[n] = nArray[n] + 1;
                        } else {
                            int[] nArray = matrix[id2];
                            int n = id1;
                            nArray[n] = nArray[n] + 1;
                        }
                        node1 = node1.m_parent.from();
                        node2 = node2.m_parent.from();
                        continue;
                    }
                    if (node2.m_depth > depth) {
                        node2 = node2.m_parent.from();
                        continue;
                    }
                    node1 = node1.m_parent.from();
                }
            }
            --i;
        }
    }

    private static void dumpMatrix(HiGraph[] queue, int[][][] matrices) {
        System.out.println("\nAdjacency matrix\n");
        int i = 0;
        while (i < matrices.length) {
            System.out.println("At depth " + i);
            int[][] matrix = matrices[i];
            int j = 0;
            while (j < matrix.length) {
                int[] row = matrix[j];
                int k = 0;
                while (k < row.length) {
                    System.out.print("\t" + row[k]);
                    ++k;
                }
                System.out.print("\n");
                ++j;
            }
            ++i;
        }
    }

    private static int[][][] buildMatrices(HiGraph[] queue) {
        int j;
        int[][] matrix;
        int width;
        int nodes = queue.length;
        int last = nodes - 1;
        HiGraph node = queue[last];
        int[][][] matrices = new int[node.m_depth + 1][][];
        int start = 0;
        node = queue[0];
        int last_depth = node.m_depth;
        int i = 1;
        while (i < nodes) {
            node = queue[i];
            if (node.m_depth != last_depth) {
                width = i - start;
                matrix = new int[width][];
                matrices[last_depth] = matrix;
                j = 0;
                while (j < width) {
                    matrix[j] = new int[j + 1];
                    ++j;
                }
                start = i;
                last_depth = node.m_depth;
            }
            ++i;
        }
        width = i - start;
        matrix = new int[width][];
        matrices[last_depth] = matrix;
        j = 0;
        while (j < width) {
            matrix[j] = new int[j + 1];
            ++j;
        }
        return matrices;
    }

    private static void computeOutside(HiGraph[] queue, int head, int[][][] matrices) {
        HiGraph node1;
        HiGraph node = queue[head];
        Vector children = node.m_children;
        if (children.size() == 0) {
            return;
        }
        node = queue[head];
        int depth = node.m_depth;
        int lth = queue.length;
        int start_level = head + 1;
        while (start_level < lth) {
            node1 = queue[start_level];
            if (node1.m_depth != depth) {
                depth = node1.m_depth;
                break;
            }
            ++start_level;
        }
        int end_level = start_level;
        while (end_level < lth) {
            node1 = queue[end_level];
            if (node1.m_depth != depth) break;
            ++end_level;
        }
        int[][] matrix = matrices[depth];
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            int position = child.m_position;
            int outside = 0;
            int i = start_level;
            while (i < end_level) {
                HiGraph child1 = queue[i];
                HiGraph parent1 = child1.m_parent.from();
                if (parent1 != node) {
                    int position1 = child1.m_position;
                    int edges = position1 > position ? matrix[position1][position] : matrix[position][position1];
                    outside = parent1.m_postorder > node.m_postorder ? (outside += edges) : (outside -= edges);
                }
                ++i;
            }
            child.m_outside = outside;
        }
    }

    private static boolean reorder(HiGraph node, int[][][] matrices, int outside_bias) {
        int j;
        int val;
        int[] row;
        int position1;
        HiGraph child1;
        HiArc arc1;
        Vector children = node.m_children;
        int size = children.size();
        boolean ret = false;
        int i = 0;
        while (i < size) {
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            if (child1.m_children.size() != 0) {
                ret = true;
                break;
            }
            ++i;
        }
        if (!ret) {
            return ret;
        }
        ret = false;
        if (node.dontReorder()) {
            return ret;
        }
        int[][] matrix = matrices[node.m_depth + 1];
        i = 0;
        while (i < size) {
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            position1 = child1.m_position;
            row = matrix[position1];
            val = child1.m_outside * outside_bias;
            j = 0;
            while (j < position1) {
                val += row[j];
                ++j;
            }
            row[position1] = val;
            ++i;
        }
        i = 0;
        while (i < size) {
            int position2;
            HiGraph child2;
            HiArc arc2;
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            position1 = child1.m_position;
            int best = i;
            int min1 = matrix[position1][position1];
            j = i + 1;
            while (j < size) {
                arc2 = (HiArc)children.elementAt(j);
                child2 = arc2.to();
                position2 = child2.m_position;
                int min2 = matrix[position2][position2];
                if (min2 < min1) {
                    best = j;
                    min1 = min2;
                }
                ++j;
            }
            arc2 = (HiArc)children.elementAt(best);
            child2 = arc2.to();
            if (best != i) {
                children.setElementAt(arc2, i);
                children.setElementAt(arc1, best);
                ret = true;
            }
            position1 = child2.m_position;
            j = i + 1;
            while (j < size) {
                arc2 = (HiArc)children.elementAt(j);
                child2 = arc1.to();
                position2 = child2.m_position;
                row = matrix[position2];
                val = position1 < position2 ? row[position1] : matrix[position1][position2];
                int n = position2;
                row[n] = row[n] - (val << 1);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    static void order(HiGraph root, int outside_bias) throws HiGraphException {
        HiGraph node;
        HiChildren.addDummyNodes(root);
        int nodes = HiChildren.postorder(root, 1) - 1;
        HiGraph[] queue = new HiGraph[nodes];
        int head = 0;
        int tail = 0;
        queue[tail] = root;
        int position = 0;
        int last_depth = root.m_depth;
        root.m_position = 0;
        ++tail;
        while (head < tail) {
            node = queue[head];
            if (node.m_depth != last_depth) {
                last_depth = node.m_depth;
                position = 0;
            }
            node.m_position = position++;
            Vector children = node.m_children;
            int size = children.size();
            int i = 0;
            while (i < size) {
                HiArc arc = (HiArc)children.elementAt(i);
                queue[tail++] = arc.to();
                ++i;
            }
            ++head;
        }
        int[][][] matrices = HiChildren.buildMatrices(queue);
        HiChildren.fillMatrix(queue, matrices);
        head = 0;
        while (head < tail) {
            HiChildren.computeOutside(queue, head, matrices);
            node = queue[head];
            if (HiChildren.reorder(node, matrices, outside_bias)) {
                HiChildren.postorderlevel(node);
            }
            ++head;
        }
    }
}

