/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.HorizontalLine;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeModeHandler;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.VerticalLine;

public class FrameModeHandler
extends LandscapeModeHandler {
    protected Diagram m_diagram = null;
    protected HorizontalLine m_top = new HorizontalLine();
    protected HorizontalLine m_bottom = new HorizontalLine();
    protected VerticalLine m_left = new VerticalLine();
    protected VerticalLine m_right = new VerticalLine();
    protected Rectangle m_frame = null;
    protected boolean m_shift_down;
    protected boolean m_control_down;
    protected int m_start_x;
    protected int m_start_y;
    protected EditModeHandler m_parent;

    public FrameModeHandler(EditModeHandler parent) {
        super(parent.m_ls);
        this.m_parent = parent;
    }

    private void frameRelation(RelationInstance ri, Rectangle frame, boolean clear_flag) {
        RelationComponent relationComponent;
        if (ri.isRelationShown() && (relationComponent = ri.getRelationComponent()) != null && relationComponent.isFramedBy(frame)) {
            if (clear_flag) {
                this.m_diagram.clearRelationGroupFlag(ri);
            } else {
                this.m_diagram.setGroupAndHighlightFlag(ri);
            }
        }
    }

    private void frameRelations(EntityInstance e, Rectangle frame, boolean clear_flag) {
        Enumeration en;
        int i = 0;
        while (i < 2) {
            Vector v;
            switch (i) {
                case 0: {
                    v = e.getSrcLiftedList();
                    break;
                }
                default: {
                    v = e.getDstLiftedList();
                }
            }
            if (v != null) {
                en = v.elements();
                while (en.hasMoreElements()) {
                    RelationInstance ri = (RelationInstance)en.nextElement();
                    this.frameRelation(ri, frame, clear_flag);
                }
            }
            ++i;
        }
        if (e.isOpen()) {
            en = e.getChildrenShown();
            while (en.hasMoreElements()) {
                EntityInstance child = (EntityInstance)en.nextElement();
                this.frameRelations(child, frame, clear_flag);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.m_diagram != null) {
            Diagram diagram = this.m_diagram;
            diagram.remove(this.m_top);
            diagram.remove(this.m_bottom);
            diagram.remove(this.m_left);
            diagram.remove(this.m_right);
            this.m_diagram = null;
            this.m_ls.setCursor(0);
        }
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance drawRoot, int x, int y) {
        Diagram diagram;
        LandscapeEditorCore ls = this.m_ls;
        this.m_diagram = diagram = ls.getDiagram();
        this.m_shift_down = ev.isShiftDown();
        this.m_control_down = ev.isControlDown();
        this.m_start_x = x;
        this.m_start_y = y;
        this.m_top.setBounds(x, y, 0, 0);
        this.m_bottom.setBounds(x, y, 0, 0);
        this.m_left.setBounds(x, y, 0, 0);
        this.m_right.setBounds(x, y, 0, 0);
        diagram.add((Component)this.m_top, 0);
        diagram.add((Component)this.m_bottom, 0);
        diagram.add((Component)this.m_left, 0);
        diagram.add((Component)this.m_right, 0);
        this.m_parent.setSubHandler(this);
    }

    @Override
    public void entityDragged(MouseEvent ev, EntityInstance drawRoot, int x, int y) {
        int width = x - this.m_start_x;
        int height = y - this.m_start_y;
        if (width > 0) {
            x = this.m_start_x;
        } else {
            width = -width;
        }
        if (height > 0) {
            y = this.m_start_y;
        } else {
            height = -height;
        }
        this.m_top.setBounds(x, y, width, 1);
        this.m_bottom.setBounds(x, y + height - 1, width, 1);
        this.m_left.setBounds(x, y, 1, height);
        this.m_right.setBounds(x + width - 1, y, 1, height);
    }

    @Override
    public void entityReleased(MouseEvent ev, EntityInstance drawRoot, int x, int y) {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            int frameX = this.m_start_x;
            int frameWidth = x - frameX;
            int frameY = this.m_start_y;
            int frameHeight = y - frameY;
            this.m_top.setBounds(frameX, frameY, 0, 0);
            this.m_bottom.setBounds(frameX, frameY, 0, 0);
            this.m_left.setBounds(frameX, frameY, 0, 0);
            this.m_right.setBounds(frameX, frameY, 0, 0);
            if (frameWidth < 0) {
                frameX = x;
                frameWidth = -frameWidth;
            }
            if (frameHeight < 0) {
                frameY = y;
                frameHeight = -frameHeight;
            }
            if (frameWidth == 0 || frameHeight == 0) {
                if (!this.m_shift_down) {
                    diagram.clearGroupFlags();
                }
            } else {
                Rectangle frame = this.m_frame;
                if (frame == null) {
                    frame = this.m_frame = new Rectangle(frameX, frameY, frameWidth, frameHeight);
                } else {
                    frame.setBounds(frameX, frameY, frameWidth, frameHeight);
                }
                boolean change = false;
                if (this.m_control_down) {
                    Enumeration en = drawRoot.getChildrenShown();
                    while (en.hasMoreElements()) {
                        EntityInstance e = (EntityInstance)en.nextElement();
                        if (!e.isFramedBy(frame) || !diagram.clearEntityGroupFlag(e)) continue;
                        e.repaint();
                        change = true;
                    }
                } else {
                    EntityInstance newKeyEntity;
                    EntityInstance keyEntity = this.m_diagram.getKeyEntity();
                    if (this.m_shift_down) {
                        newKeyEntity = keyEntity;
                    } else {
                        newKeyEntity = null;
                        if (keyEntity != null && keyEntity.getContainedBy() == drawRoot && keyEntity.isFramedBy(frame)) {
                            newKeyEntity = keyEntity;
                        }
                        diagram.clearGroupFlags();
                    }
                    Enumeration en = drawRoot.getChildrenShown();
                    while (en.hasMoreElements()) {
                        EntityInstance e = (EntityInstance)en.nextElement();
                        if (!e.isFramedBy(frame)) continue;
                        if (!change) {
                            if (newKeyEntity == null) {
                                newKeyEntity = e;
                            }
                            change = true;
                        }
                        if (e == newKeyEntity) {
                            if (e.getGroupKeyFlag()) continue;
                            diagram.setKeyEntity(e);
                            continue;
                        }
                        if (e.getGroupFlag()) continue;
                        diagram.setEntityGroupFlag(e);
                    }
                }
                if (change) {
                    this.m_ls.show_groupList();
                } else {
                    this.frameRelations(drawRoot, frame, this.m_control_down);
                }
            }
        }
        this.m_parent.cleanup();
    }

    @Override
    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.getDiagram().setGroupAndHighlightFlag(ri);
        this.m_parent.cleanup();
    }
}

