/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FindRules;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

public class FindBox
extends JDialog
implements ActionListener {
    protected LandscapeEditorCore m_ls;
    protected JCheckBox m_caseSensitive;
    protected JTextField m_inputField;
    protected static String m_input = "";
    protected Pattern m_pattern;
    protected JComboBox m_classes;
    protected EntityClass m_entityClass;
    protected JCheckBox m_superclasses;
    protected JCheckBox m_subclasses;
    protected JComboBox m_in_edges;
    protected JSpinner m_in_edges_min;
    protected JSpinner m_in_edges_max;
    protected JComboBox m_out_edges;
    protected JSpinner m_out_edges_min;
    protected JSpinner m_out_edges_max;
    protected JSpinner m_children_min;
    protected JSpinner m_children_max;
    protected JButton m_findButton;
    protected JButton m_helpButton;
    protected JButton m_canButton;

    public FindBox(JFrame f, LandscapeEditorCore ls, Diagram diagram) {
        super(f, "Find Landscape Entities", true);
        RelationClass containsClass = null;
        Container contentPane = this.getContentPane();
        this.m_ls = ls;
        this.m_pattern = null;
        this.m_entityClass = null;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        contentPane.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel();
        p.setLayout(gridBagLayout);
        this.setFont(font);
        JLabel label = new JLabel("Pattern.");
        label.setFont(font);
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_inputField = new JTextField(m_input, 30);
        this.m_inputField.setFont(font);
        this.m_inputField.addActionListener(this);
        c.gridx = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_inputField, c);
        p.add(this.m_inputField);
        this.m_caseSensitive = new JCheckBox("Case sensitive");
        this.m_caseSensitive.setFont(bold);
        this.m_caseSensitive.setSelected(true);
        c.gridx = 2;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_caseSensitive, c);
        p.add(this.m_caseSensitive);
        label = new JLabel("Any java.util.regex.");
        label.setFont(font);
        c.gridx = 3;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        label = new JLabel("Entity Class");
        label.setFont(font);
        c.anchor = 17;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_classes = new JComboBox();
        this.m_classes.addItem("");
        Enumeration en = diagram.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            EntityClass entityClass = (EntityClass)en.nextElement();
            this.m_classes.addItem(entityClass);
        }
        c.gridx = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_classes, c);
        p.add(this.m_classes);
        this.m_subclasses = new JCheckBox("plus subclasses");
        this.m_subclasses.setFont(bold);
        this.m_subclasses.setSelected(false);
        c.gridx = 2;
        c.anchor = 10;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_subclasses, c);
        p.add(this.m_subclasses);
        label = new JLabel("");
        label.setFont(font);
        c.gridx = 3;
        c.anchor = 10;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_superclasses = new JCheckBox("plus superclasses");
        this.m_superclasses.setFont(bold);
        this.m_superclasses.setSelected(false);
        c.gridx = 4;
        c.anchor = 10;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_superclasses, c);
        p.add(this.m_superclasses);
        this.m_in_edges = new JComboBox();
        this.m_out_edges = new JComboBox();
        this.m_in_edges.addItem("");
        this.m_out_edges.addItem("");
        en = diagram.enumRelationClassesInOrder();
        while (en.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)en.nextElement();
            if (relationClass.getContainsClassOffset() == 0) {
                containsClass = relationClass;
                continue;
            }
            this.m_in_edges.addItem(relationClass);
            this.m_out_edges.addItem(relationClass);
        }
        label = new JLabel("Destination Edges");
        label.setFont(font);
        c.anchor = 10;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        c.anchor = 17;
        c.gridx = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_in_edges, c);
        p.add(this.m_in_edges);
        this.m_in_edges_min = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        c.anchor = 13;
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.5;
        gridBagLayout.setConstraints(this.m_in_edges_min, c);
        p.add(this.m_in_edges_min);
        label = new JLabel(" \u2264 active edges \u2264 ");
        label.setFont(font);
        c.gridx = 3;
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_in_edges_max = new JSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        c.gridx = 4;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 0.5;
        gridBagLayout.setConstraints(this.m_in_edges_max, c);
        p.add(this.m_in_edges_max);
        label = new JLabel("Source Edges");
        label.setFont(font);
        c.anchor = 10;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        c.anchor = 17;
        c.gridx = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_out_edges, c);
        p.add(this.m_out_edges);
        this.m_out_edges_min = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        c.anchor = 13;
        c.gridx = 2;
        c.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_out_edges_min, c);
        p.add(this.m_out_edges_min);
        label = new JLabel(" \u2264 active edges \u2264 ");
        label.setFont(font);
        c.gridx = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_out_edges_max = new JSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        c.gridx = 4;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 0.5;
        gridBagLayout.setConstraints(this.m_out_edges_max, c);
        p.add(this.m_out_edges_max);
        label = new JLabel("Child edges");
        label.setFont(font);
        c.anchor = 17;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        label = new JLabel(containsClass != null ? containsClass.toString() : "");
        c.anchor = 17;
        c.gridx = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_children_min = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        c.anchor = 13;
        c.gridx = 2;
        c.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_children_min, c);
        p.add(this.m_children_min);
        label = new JLabel(" \u2264 children \u2264 ");
        label.setFont(font);
        c.gridx = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        gridBagLayout.setConstraints(label, c);
        p.add(label);
        this.m_children_max = new JSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        c.gridx = 4;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 0.5;
        gridBagLayout.setConstraints(this.m_children_max, c);
        p.add(this.m_children_max);
        contentPane.add((Component)p, "Center");
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.m_findButton = new JButton("Find");
        this.m_findButton.setFont(bold);
        p.add(this.m_findButton);
        this.m_findButton.addActionListener(this);
        this.m_helpButton = new JButton("Help");
        this.m_helpButton.setFont(bold);
        p.add(this.m_helpButton);
        this.m_helpButton.addActionListener(this);
        this.m_canButton = new JButton("Cancel");
        this.m_canButton.setFont(bold);
        p.add(this.m_canButton);
        this.m_canButton.addActionListener(this);
        contentPane.add((Component)p, "South");
        this.pack();
        if (f != null) {
            this.setLocation(f.getX() + 200, f.getY() + 300);
        }
        this.setVisible(true);
    }

    private boolean parsePattern() {
        String input = m_input;
        boolean ret = true;
        Pattern pattern = null;
        if (input != null && !input.equals("") && !input.equals("*")) {
            try {
                int flags = this.m_caseSensitive.isSelected() ? 0 : 2;
                pattern = Pattern.compile(input, flags |= 0x20);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Syntax error is regular expression '" + input + "'", "Error", 0);
                pattern = null;
                ret = false;
            }
        }
        this.m_pattern = pattern;
        return ret;
    }

    private int spinnerValue(JSpinner spinner) {
        Number value = (Number)spinner.getValue();
        return value.intValue();
    }

    public FindRules getFindRules() {
        Pattern pattern = this.m_pattern;
        Vector entityClasses = null;
        EntityClass entityClass = this.m_entityClass;
        int inMin = this.spinnerValue(this.m_in_edges_min);
        int inMax = this.spinnerValue(this.m_in_edges_max);
        int outMin = this.spinnerValue(this.m_out_edges_min);
        int outMax = this.spinnerValue(this.m_out_edges_max);
        int childrenMin = this.spinnerValue(this.m_children_min);
        int childrenMax = this.spinnerValue(this.m_children_max);
        Object object_in = this.m_in_edges.getSelectedItem();
        Object object_out = this.m_out_edges.getSelectedItem();
        RelationClass in_edges = null;
        RelationClass out_edges = null;
        if (entityClass != null) {
            int mode = this.m_subclasses.isSelected() ? 1 : 0;
            if (this.m_superclasses.isSelected()) {
                mode += 2;
            }
            switch (mode) {
                case 0: {
                    entityClasses = new Vector();
                    entityClasses.addElement(entityClass);
                    break;
                }
                case 1: {
                    Diagram diagram = this.m_ls.getDiagram();
                    entityClasses = diagram.getClassAndSubclasses(entityClass);
                    break;
                }
                case 2: {
                    entityClasses = entityClass.getClassAndSuperclasses();
                    break;
                }
                default: {
                    Vector v = entityClass.getClassAndSuperclasses();
                    Diagram diagram = this.m_ls.getDiagram();
                    entityClasses = diagram.getClassAndSubclasses(entityClass);
                    int i = v.size();
                    while (--i >= 0) {
                        Object o = v.elementAt(i);
                        if (entityClasses.contains(o)) continue;
                        entityClasses.addElement(o);
                    }
                    break block0;
                }
            }
        }
        if (object_in instanceof RelationClass) {
            in_edges = (RelationClass)object_in;
        }
        if (object_out instanceof RelationClass) {
            out_edges = (RelationClass)object_out;
        }
        if (!(inMax != -1 && inMin > inMax || outMax != -1 && outMin > outMax || childrenMax != -1 && childrenMin > childrenMax || pattern == null && entityClass == null && inMin <= 0 && outMin <= 0 && childrenMin <= 0 && inMax < 0 && outMax < 0 && childrenMax < 0)) {
            return new FindRules(pattern, entityClasses, in_edges, inMin, inMax, out_edges, outMin, outMax, childrenMin, childrenMax);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_helpButton) {
            int ret = JOptionPane.showConfirmDialog(this.m_ls.getFrame(), "Entities may be located by a number of cumulative criteria:\n1.  By their name identified using an appropriate regular expression\n2.  By the class that they belong to\n3.  By membership in sub or superclasses of this class\n4.  By the cardinality of edges to them\n5.  Using a specific incoming edge class if specified\n6.  By the cardinality of edges leaving them\n7.  Using a specific outgoing edge class if specified\n8.  By the number of children such entities have\n\nFor instructions on the syntax of regular expressions select OK.", "Find Box Help", 2);
            if (ret == 0) {
                this.m_ls.showURL("http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html", 4);
            }
            return;
        }
        if (source == this.m_inputField || source == this.m_findButton || source == this.m_canButton) {
            m_input = this.m_inputField.getText();
            if (source != this.m_canButton) {
                if (!this.parsePattern()) {
                    return;
                }
                int selected = this.m_classes.getSelectedIndex();
                if (selected > 0) {
                    this.m_entityClass = (EntityClass)this.m_classes.getSelectedItem();
                }
            }
            this.setVisible(false);
        }
    }
}

