/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.LandscapeEditorCore;

class ExitFlag
extends JComponent
implements MouseListener {
    protected static final int EXIT_FLAG_DIM = 8;
    protected int m_priorcursor = -1;
    protected LandscapeEditorCore m_ls;

    public ExitFlag(LandscapeEditorCore ls) {
        this.m_ls = ls;
        this.addMouseListener(this);
    }

    @Override
    public void setLocation(int x, int y) {
        this.setBounds(x, y, 8, 8);
    }

    public void activate() {
        this.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Diagram.boxColor.darker());
        g.drawRect(0, 0, 8, 8);
        g.drawLine(2, 4, 6, 4);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        LandscapeEditorCore ls = this.m_ls;
        if (this.m_priorcursor != -1) {
            ls.setCursor(this.m_priorcursor);
            this.m_priorcursor = -1;
        }
        ls.navigateToDrawRootParent();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.m_priorcursor = this.m_ls.setCursor(12);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.m_priorcursor != -1) {
            this.m_ls.setCursor(this.m_priorcursor);
            this.m_priorcursor = -1;
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }
}

