/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.ExecuteConfigure;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Options;

class ExecuteExamples
extends JDialog
implements ActionListener {
    public static final String[] g_comments = new String[]{"To run Visual Studio Net jumping to lineno", "On Windows to run vi readonly jumping to lineno", "To run vi in a new xterm window", "To jump to lineno or definition if present", "To open up a project", "To display information in a dialog box"};
    public static final String[] g_commands = new String[]{"C:/Program Files/Microsoft Visual Studio .NET 2003/Common7/IDE/devenv.exe", "cmd.exe", "xterm", "C:/Program Files/Microsoft Visual Studio .NET 2003/Common7/IDE/devenv.exe", "C:/Program Files/Microsoft Visual Studio .NET 2003/Common7/IDE/devenv.exe", ">"};
    public static final String[] g_parameters = new String[]{"/command\nEdit.Goto [$(lineno)|1]\n\"$(file)\"\n", "/C\nstart; vi.exe -R [+$(lineno)] $(file)\n", "-e\nvi\n[+$(lineno)]\n[\"$(file)\"]\n", "/command\n [Edit.GoToDefinition $(function) | Edit.Goto [$(lineno)|0]]\n\"$(file)\"\n", "$(project).sln\n", "Information about $(label)\nfile   = $(file)\nlineno = $(lineno)\n"};
    protected static final int BUTTON_PREV = 0;
    protected static final int BUTTON_NEXT = 1;
    protected static final int BUTTON_SET = 2;
    protected static final int BUTTON_OK = 3;
    protected static final String[] m_button_titles = new String[]{"Prev", "Next", "Set", "Ok"};
    protected LandscapeEditorCore m_ls;
    protected ExecuteConfigure m_executeConfigure;
    protected JLabel m_comment;
    protected JTextArea m_parameters;
    protected int m_index;
    protected JButton[] m_buttons;

    protected void fill() {
        this.m_comment.setText(g_comments[this.m_index]);
        this.m_parameters.setText(String.valueOf(g_commands[this.m_index]) + "\n" + g_parameters[this.m_index]);
    }

    public ExecuteExamples(LandscapeEditorCore ls, ExecuteConfigure executeConfigure) {
        super(ls.getFrame(), "Execution Configuration Examples", true);
        JTextArea textArea;
        JLabel comment;
        this.m_ls = ls;
        this.m_executeConfigure = executeConfigure;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        this.m_comment = comment = new JLabel("", 2);
        contentPane.add("North", comment);
        this.m_parameters = textArea = new JTextArea();
        textArea.setBackground(Diagram.boxColor);
        textArea.setFont(Options.getTargetFont(17));
        textArea.setEditable(false);
        textArea.setLineWrap(false);
        textArea.setRows(10);
        this.m_index = 0;
        this.fill();
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        contentPane.add("Center", scrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_buttons = new JButton[m_button_titles.length];
        int i = 0;
        while (i < m_button_titles.length) {
            JButton button;
            this.m_buttons[i] = button = new JButton(m_button_titles[i]);
            button.setFont(bold);
            button.addActionListener(this);
            buttonPanel.add(button);
            ++i;
        }
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        int state = -1;
        int i = 0;
        while (i < m_button_titles.length) {
            if (source == this.m_buttons[i]) {
                state = i;
                break;
            }
            ++i;
        }
        switch (state) {
            case 1: {
                if (++this.m_index >= g_comments.length) {
                    this.m_index = 0;
                }
                this.fill();
                return;
            }
            case 0: {
                if (--this.m_index < 0) {
                    this.m_index = g_comments.length - 1;
                }
                this.fill();
                return;
            }
            case 2: {
                JComboBox comboBox = this.m_executeConfigure.m_program;
                int items = comboBox.getItemCount();
                String command = g_commands[this.m_index];
                i = 0;
                while (true) {
                    if (i == items) {
                        comboBox.addItem(command);
                        break;
                    }
                    String item = (String)comboBox.getItemAt(i);
                    if (command.equals(item)) break;
                    ++i;
                }
                comboBox.setSelectedIndex(i);
                this.m_executeConfigure.m_parameters.setText(g_parameters[this.m_index]);
            }
            case 3: {
                break;
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }
}

