/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import lsedit.BrowserLauncher;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.ExecuteAction;
import lsedit.ExecuteExamples;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Options;

class ExecuteConfigure
extends JDialog
implements ActionListener {
    public static final String[] g_mac_programs = new String[]{">", "vi", "xterm"};
    public static final String[] g_unix_programs = new String[]{">", "vi", "pico", "emacs", "xterm"};
    public static final String[] g_windows_programs = new String[]{">", "cmd.exe", "notepad.exe", "C:/Program Files/Microsoft Visual Studio/Common/MSDev98/Bin/MSDEV.EXE", "C:/Program Files/Microsoft Visual Studio .NET 2003/Common7/IDE/devenv.exe"};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_CLEAR = 2;
    protected static final int BUTTON_BROWSE = 3;
    protected static final int BUTTON_HELP = 4;
    protected static final int BUTTON_EXAMPLES = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Clear", "Browse", "Help", "Examples"};
    protected LandscapeEditorCore m_ls;
    protected String[] m_os_programs;
    public JComboBox m_program;
    public JTextArea m_parameters;
    protected JButton[] m_buttons;
    protected int m_index;
    protected static final String[] g_choose_index = new String[]{"h", "F4", "F5", "F6", "F7", "F8", "F9", "F10"};
    protected JComboBox m_choose_index;

    protected void browse() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        String defaultFilename = null;
        String viewer = null;
        defaultFilename = (String)this.m_program.getItemAt(0);
        File defaultfile = defaultFilename != null ? new File(defaultFilename) : null;
        fileChooser.setDialogTitle("Identify program to execute");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setApproveButtonText("Select");
        if (defaultfile != null) {
            fileChooser.setSelectedFile(defaultfile);
        }
        if ((ret = fileChooser.showOpenDialog(this)) == 0) {
            File file = fileChooser.getSelectedFile();
            viewer = file.getAbsolutePath();
            this.m_program.setSelectedIndex(0);
            this.m_program.setSelectedItem(viewer);
        }
    }

    protected void fill(int index) {
        this.m_index = index;
        if (this.m_index < 0) {
            this.m_index = 0;
        }
        JComboBox comboBox = this.m_program;
        comboBox.removeAllItems();
        String command = ExecuteAction.m_commands[this.m_index];
        if (command != null) {
            comboBox.addItem(command);
        }
        String[] programs = this.m_os_programs;
        int i = 0;
        while (i < programs.length) {
            String program = programs[i];
            if (!program.equals(command)) {
                comboBox.addItem(program);
            }
            ++i;
        }
        comboBox.addItem("");
        comboBox.setSelectedIndex(0);
        String rules = ExecuteAction.m_rules[this.m_index];
        if (rules == null) {
            rules = "";
        }
        this.m_parameters.setText(rules);
    }

    protected static boolean empty(String string) {
        int lth = string.length();
        int i = 0;
        while (i < lth) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void doOk() {
        String command = (String)this.m_program.getSelectedItem();
        if (ExecuteConfigure.empty(command)) {
            command = null;
        }
        ExecuteAction.m_commands[this.m_index] = command;
        String rule = this.m_parameters.getText();
        if (ExecuteConfigure.empty(rule)) {
            rule = null;
        }
        ExecuteAction.m_rules[this.m_index] = rule;
    }

    public ExecuteConfigure(LandscapeEditorCore ls, int index) {
        super(ls.getFrame(), "External Execution Configuration", true);
        JTextArea textArea;
        JComboBox comboBox;
        this.m_ls = ls;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        int jvm = BrowserLauncher.getJVM();
        switch (jvm) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.m_os_programs = g_mac_programs;
                break;
            }
            case 5: 
            case 6: {
                this.m_os_programs = g_windows_programs;
                break;
            }
            default: {
                this.m_os_programs = g_unix_programs;
            }
        }
        this.m_program = comboBox = new JComboBox();
        this.m_parameters = textArea = new JTextArea();
        this.fill(index);
        comboBox.setEditable(true);
        comboBox.addActionListener(this);
        contentPane.add("North", comboBox);
        textArea.setToolTipText("Command parameters - press [help] for details");
        textArea.setBackground(Diagram.boxColor);
        textArea.setFont(Options.getTargetFont(17));
        textArea.setEditable(true);
        textArea.setLineWrap(false);
        textArea.setRows(10);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        contentPane.add("Center", scrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_buttons = new JButton[m_button_titles.length];
        int i = 0;
        while (i < m_button_titles.length) {
            JButton button;
            String title = m_button_titles[i];
            this.m_buttons[i] = button = new JButton(title);
            button.setFont(bold);
            button.addActionListener(this);
            buttonPanel.add(button);
            ++i;
        }
        if (index >= 0) {
            this.m_choose_index = null;
        } else {
            this.m_choose_index = new JComboBox<String>(g_choose_index);
            this.m_choose_index.setFont(bold);
            this.m_choose_index.addActionListener(this);
            buttonPanel.add(this.m_choose_index);
        }
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_choose_index) {
            int i = this.m_choose_index.getSelectedIndex();
            if (i >= 0 && i != this.m_index) {
                this.doOk();
                this.fill(i);
            }
            return;
        }
        int state = -1;
        int i = 0;
        while (i < m_button_titles.length) {
            if (source == this.m_buttons[i]) {
                state = i;
                break;
            }
            ++i;
        }
        switch (state) {
            case 2: {
                this.m_parameters.setText("");
                return;
            }
            case 3: {
                this.browse();
                return;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.m_ls.getFrame(), "The initial editable combo box allows an arbitrary program to be specified.\nEach line in the subsequent text area identifies a single parameter to be\npassed to the specified program in the specified order.  Within a parameter\nthe macro ${name} is replaced by the attribute value of this named attribute.\nTo handle optional occurances of attribute values, parameters may also contain\nrules of the form [ rule1 | rule2 | ... ].  This expands to rule1 if all of\nthe attribute values (if any) required to form rule1 exist, or to the first\nsuch rule within the list (if any) that does.  If no such rule exists then\nthis material is removed from the parameter.  If a parameter as a consequence\ncontains only white space it is ignored during command invocation.\n\nIf the command specified is '>' then a dialog box appears showing the expanded\nrules, with the first such rule becoming the title of the dialog box.", "Help", 1);
                return;
            }
            case 5: {
                new ExecuteExamples(this.m_ls, this);
                return;
            }
            case 0: {
                this.doOk();
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }
}

