/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import lsedit.ElisionChooser;
import lsedit.SelectedElisions;

class ElisionEditor
extends DefaultCellEditor
implements ActionListener {
    JFrame m_frame;
    JTable m_table;
    AbstractTableModel m_tableModel;
    SelectedElisions m_selectedElisions;
    JButton m_button;
    int m_row;
    int m_column;

    public ElisionEditor(JFrame frame, AbstractTableModel tableModel) {
        super(new JCheckBox());
        this.m_frame = frame;
        this.m_tableModel = tableModel;
        this.m_button = new JButton("EDITING");
        this.m_button.setBackground(Color.white);
        this.m_button.setBorderPainted(false);
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.editorComponent = this.m_button;
        this.setClickCountToStart(1);
        this.m_button.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_selectedElisions;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_table = table;
        this.m_selectedElisions = (SelectedElisions)value;
        this.m_row = row;
        this.m_column = column;
        return this.editorComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectedElisions selectedElisions = this.m_selectedElisions;
        ElisionChooser elisionChooser = new ElisionChooser(this.m_frame, selectedElisions.getElisions());
        int elisions = elisionChooser.getElisions();
        if (elisions >= 0) {
            selectedElisions.setElisions(elisions);
            this.m_tableModel.setValueAt(selectedElisions, this.m_row, this.m_table.convertColumnIndexToModel(this.m_column));
        }
        this.fireEditingStopped();
        elisionChooser.dispose();
    }
}

