/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.Elision_CS_Button;
import lsedit.Elision_CU_Button;
import lsedit.Elision_I_Button;
import lsedit.Elision_c_Button;
import lsedit.Elision_s_Button;
import lsedit.Elision_u_Button;
import lsedit.FontCache;
import lsedit.ToolBarButton;

class ElisionChooser
extends JDialog
implements ItemListener,
ActionListener {
    private JCheckBox[] m_checkboxes;
    private JButton m_ok;
    private JButton m_and = null;
    private JButton m_or = null;
    private JButton m_nand = null;
    private JButton m_cancel;
    private int m_result = -1;

    public ElisionChooser(JFrame frame, int elisions) {
        super(frame, "Select desired elisions", true);
        int mask = elisions;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        JPanel topPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        topPanel.setLayout(gridBagLayout);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        this.m_checkboxes = new JCheckBox[7];
        int i = 0;
        while (i <= 6) {
            JCheckBox checkBox;
            String desc;
            ToolBarButton icon;
            String state;
            boolean flag1 = (mask & 1) != 0;
            boolean flag = flag1;
            switch (i) {
                case 6: {
                    state = "";
                    break;
                }
                case 5: {
                    flag1 = !flag;
                }
                default: {
                    state = flag1 ? "Hide" : "Show";
                }
            }
            switch (i) {
                case 0: {
                    icon = new Elision_u_Button(null);
                    desc = " destination edges";
                    break;
                }
                case 1: {
                    icon = new Elision_s_Button(null);
                    desc = " source edges";
                    break;
                }
                case 2: {
                    icon = new Elision_CU_Button(null);
                    desc = " entering edges";
                    break;
                }
                case 3: {
                    icon = new Elision_CS_Button(null);
                    desc = " exiting edges";
                    break;
                }
                case 4: {
                    icon = new Elision_I_Button(null);
                    desc = " internal edges";
                    break;
                }
                case 5: {
                    icon = new Elision_c_Button(null);
                    desc = " children";
                    break;
                }
                default: {
                    icon = null;
                    desc = flag ? "Set above elisions" : "Preserve elisions unchanged";
                }
            }
            if (i != 6) {
                desc = String.valueOf(state) + desc;
            }
            c.anchor = 13;
            if (icon != null) {
                c.gridx = 0;
                gridBagLayout.setConstraints(icon, c);
                topPanel.add(icon);
                c.gridx = 1;
            } else {
                c.gridx = 0;
                c.gridwidth = 2;
            }
            this.m_checkboxes[i] = checkBox = new JCheckBox(desc, flag);
            c.anchor = 17;
            c.gridwidth = 0;
            gridBagLayout.setConstraints(checkBox, c);
            topPanel.add(checkBox);
            checkBox.addItemListener(this);
            c.weightx = 0.0;
            c.gridwidth = -1;
            mask >>= 1;
            ++i;
        }
        Container contentPane = this.getContentPane();
        contentPane.add("North", topPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Set");
        this.m_ok.setFont(bold);
        bottomPanel.add(this.m_ok);
        this.m_ok.addActionListener(this);
        if ((elisions & 0x300) != 0) {
            this.m_and = new JButton("And");
            this.m_and.setFont(bold);
            bottomPanel.add(this.m_and);
            this.m_and.addActionListener(this);
            this.m_or = new JButton("Or");
            this.m_or.setFont(bold);
            bottomPanel.add(this.m_or);
            this.m_or.addActionListener(this);
            this.m_nand = new JButton("Nand");
            this.m_nand.setFont(bold);
            bottomPanel.add(this.m_nand);
            this.m_nand.addActionListener(this);
        }
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(bold);
        bottomPanel.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        contentPane.add("South", bottomPanel);
        this.pack();
        this.setVisible(true);
    }

    private int getNewElisionValue() {
        JCheckBox[] checkboxes = this.m_checkboxes;
        int elisions = checkboxes.length;
        int ret = 0;
        int mask = 1;
        int i = 0;
        while (i < elisions) {
            JCheckBox checkbox = checkboxes[i];
            if (checkbox != null && checkbox.isSelected()) {
                ret |= mask;
            }
            mask <<= 1;
            ++i;
        }
        return ret;
    }

    public int getElisions() {
        return this.m_result;
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        boolean state;
        JCheckBox[] checkboxes = this.m_checkboxes;
        JCheckBox checkBox = (JCheckBox)ev.getItem();
        JCheckBox unchangedBox = checkboxes[6];
        boolean bl = state = ev.getStateChange() == 1;
        if (checkBox != unchangedBox) {
            String text = checkBox.getText();
            String text1 = text.substring(4);
            boolean state1 = state;
            if (checkBox == checkboxes[5]) {
                state1 = !state1;
            }
            checkBox.setText(String.valueOf(state1 ? "Hide" : "Show") + text1);
            checkBox = unchangedBox;
            state = true;
            checkBox.setSelected(state);
        }
        String desc = state ? "Set above elisions" : "Preserve elisions unchanged";
        checkBox.setText(desc);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        int action = -2;
        if (source == this.m_ok) {
            action = 0;
        } else if (source == this.m_cancel) {
            action = -1;
        } else if (source == this.m_and) {
            action = 4096;
        } else if (source == this.m_or) {
            action = 8192;
        } else if (source == this.m_nand) {
            action = 16384;
        } else {
            return;
        }
        if (action >= 0) {
            this.m_result = this.getNewElisionValue();
            this.m_result |= action;
        }
        this.setVisible(false);
    }
}

