/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.FrameModeHandler;
import lsedit.GroupModeHandler;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeModeHandler;
import lsedit.MoveModeHandler;
import lsedit.MyMenuItem;
import lsedit.NewEdgeModeHandler;
import lsedit.RelationInstance;
import lsedit.ResizeModeHandler;

public class EditModeHandler
extends LandscapeModeHandler {
    protected MoveModeHandler m_moveHandler = new MoveModeHandler(this);
    protected ResizeModeHandler m_resizeHandler = new ResizeModeHandler(this);
    protected GroupModeHandler m_groupingHandler = new GroupModeHandler(this);
    protected NewEdgeModeHandler m_newEdgeModeHandler;
    protected FrameModeHandler m_frameHandler = new FrameModeHandler(this);
    private LandscapeModeHandler m_handler = null;
    private long m_lastUp;
    private boolean m_mouseIsDown = false;
    protected JPopupMenu m_entityPopup;
    protected JPopupMenu m_relationPopup;

    protected JPopupMenu buildEntityPopup() {
        JPopupMenu m = new JPopupMenu("Entity options");
        this.m_ls.entityPopupMenuItem(m, this.m_ls, this.m_ls.isApplet());
        return m;
    }

    protected JPopupMenu buildRelationPopup() {
        JPopupMenu m = new JPopupMenu("Edge options");
        Do.edgePopupMenuItem(m, this.m_ls, this.m_ls.isApplet());
        return m;
    }

    public EditModeHandler(LandscapeEditorCore ls) {
        super(ls);
    }

    public boolean mouseIsDown() {
        return this.m_mouseIsDown;
    }

    public LandscapeModeHandler getSubHandler() {
        return this.m_handler;
    }

    public void setSubHandler(LandscapeModeHandler handler) {
        if (this.m_handler != null) {
            this.m_handler.cleanup();
        }
        this.m_handler = handler;
    }

    @Override
    public void cleanup() {
        this.setSubHandler(null);
        this.m_mouseIsDown = false;
    }

    protected static void usesObject(Object c, Object object) {
        if (c instanceof MyMenuItem) {
            ((MyMenuItem)c).setObject(object);
            return;
        }
        if (c instanceof JMenu) {
            JMenu c1 = (JMenu)c;
            int i = c1.getItemCount();
            while (i > 0) {
                JMenuItem item;
                if ((item = c1.getItem(--i)) == null) continue;
                EditModeHandler.usesObject(item, object);
            }
            return;
        }
        if (c instanceof Container) {
            Container c1 = (Container)c;
            int i = c1.getComponentCount();
            while (i > 0) {
                EditModeHandler.usesObject(c1.getComponent(--i), object);
            }
            return;
        }
    }

    public void moveGroup(int key) {
        this.m_groupingHandler.moveGroup(key);
    }

    public void newEdge(Object object) {
        if (this.m_newEdgeModeHandler == null) {
            this.m_newEdgeModeHandler = new NewEdgeModeHandler(this);
        }
        this.m_newEdgeModeHandler.activate(object);
    }

    public void rightClickEntity(MouseEvent ev, EntityInstance e, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        Point shift = ls.getDiagramViewPosition();
        JPopupMenu m = this.m_entityPopup;
        if (m == null) {
            this.m_entityPopup = m = this.buildEntityPopup();
        }
        EditModeHandler.usesObject(m, e);
        FontCache.setMenuTreeFont(m);
        ls.add(m);
        m.show(ls.getContentPane(), ls.getDiagramX() + x - shift.x, ls.getDiagramY() + y - shift.y);
    }

    public void rightClickRelation(MouseEvent ev, RelationInstance ri, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        Point shift = ls.getDiagramViewPosition();
        JPopupMenu m = this.m_relationPopup;
        if (m == null) {
            this.m_relationPopup = m = this.buildRelationPopup();
        }
        EditModeHandler.usesObject(m, ri);
        FontCache.setMenuTreeFont(m);
        ls.add(m);
        m.show(ls.getContentPane(), ls.getDiagramX() + x - shift.x, ls.getDiagramY() + y - shift.y);
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        if (ev.isMetaDown()) {
            this.rightClickEntity(ev, e, x, y);
            return;
        }
        this.m_mouseIsDown = true;
        if (this.m_handler != null) {
            this.m_handler.entityPressed(ev, e, x, y);
            return;
        }
        if (e.isDrawRoot()) {
            this.m_frameHandler.entityPressed(ev, e, x, y);
            return;
        }
        if (ev.isShiftDown()) {
            this.m_groupingHandler.entityPressed(ev, e, x, y);
            return;
        }
        this.m_resizeHandler.entityPressed(ev, e, x, y);
        if (this.m_handler != null) {
            return;
        }
        this.m_moveHandler.entityPressed(ev, e, x, y);
        if (this.m_handler != null) {
            return;
        }
        this.m_groupingHandler.entityPressed(ev, e, x, y);
    }

    @Override
    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_mouseIsDown) {
            long newUp = ev.getWhen();
            if (newUp - this.m_lastUp < 300L) {
                this.m_ls.setCursor(0);
                this.mouseDoubleClick(ev, e);
                this.m_lastUp = 0L;
            } else if (this.m_handler != null) {
                this.m_handler.entityReleased(ev, e, x, y);
            }
            this.m_lastUp = newUp;
            this.m_mouseIsDown = false;
        }
    }

    @Override
    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (ev.isMetaDown()) {
            this.rightClickRelation(ev, ri, x, y);
            return;
        }
        this.m_mouseIsDown = true;
        if (this.m_handler != null) {
            this.m_handler.relationPressed(ev, ri, x, y);
            return;
        }
        if (!ev.isControlDown()) {
            if (ev.isShiftDown()) {
                this.m_groupingHandler.relationPressed(ev, ri, x, y);
                return;
            }
            Diagram diagram = this.m_ls.getDiagram();
            boolean cleared = diagram.clearFlags(false);
            this.m_moveHandler.relationPressed(ev, ri, x, y);
            if (this.m_handler == null) {
                this.m_groupingHandler.relationPressed(ev, ri, x, y);
            }
            if (cleared) {
                diagram.revalidate();
            }
        }
    }

    @Override
    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.m_mouseIsDown) {
            long newUp = ev.getWhen();
            if (newUp - this.m_lastUp < 300L) {
                this.m_ls.setCursor(0);
                this.mouseDoubleClick(ev, ri);
                this.m_lastUp = 0L;
            } else {
                this.m_lastUp = newUp;
                if (this.m_handler != null) {
                    this.m_handler.relationReleased(ev, ri, x, y);
                }
            }
        }
        this.m_mouseIsDown = false;
    }

    public void mouseDoubleClick(MouseEvent ev, Object object) {
        this.m_ls.processKey(10, ev.getModifiers() & 0xF, object);
    }

    @Override
    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        if (this.m_handler != null) {
            this.m_handler.movedOverThing(ev, thing, x, y);
            return;
        }
        this.m_resizeHandler.movedOverThing(ev, thing, x, y);
        if (this.m_handler == null) {
            this.m_moveHandler.movedOverThing(ev, thing, x, y);
        }
    }

    @Override
    public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_handler != null) {
            this.m_handler.entityDragged(ev, e, x, y);
        }
    }

    @Override
    public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.m_handler != null) {
            this.m_handler.relationDragged(ev, ri, x, y);
        }
    }
}

