/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.EntityClass;
import lsedit.RelationClass;
import lsedit.Util;

public class EdgePoint {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int SIDES = 4;
    private short m_wf;
    private short m_hf;
    private short m_adjusted_wf;
    private short m_adjusted_hf;

    public double getWidthFactor() {
        return Util.shortToRelative(this.m_wf);
    }

    public double getHeightFactor() {
        return Util.shortToRelative(this.m_hf);
    }

    public double getAdjustedWidthFactor() {
        return Util.shortToRelative(this.m_adjusted_wf);
    }

    public double getAdjustedHeightFactor() {
        return Util.shortToRelative(this.m_adjusted_hf);
    }

    public void adjustEdgePoint(EntityClass ec) {
        double diff;
        int regular_dimension = 0;
        boolean correct_x = false;
        boolean correct_y = false;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        this.m_adjusted_wf = this.m_wf;
        this.m_adjusted_hf = this.m_hf;
        double wf = Util.shortToRelative(this.m_wf);
        double hf = Util.shortToRelative(this.m_hf);
        int style = ec.getInheritedStyle();
        int direction = ec.getDirection();
        switch (style) {
            case 5: {
                if (hf == 0.0 || hf == 1.0) {
                    double wf1 = wf - 0.5;
                    double d = Math.sqrt(1.0 - 4.0 * wf1 * wf1) / 2.0;
                    if (hf == 0.0) {
                        d = -d;
                    }
                    this.m_adjusted_hf = Util.relativeToShort(0.5 + d);
                } else if (wf == 0.0 || wf == 1.0) {
                    double hf1 = hf - 0.5;
                    double d = Math.sqrt(1.0 - 4.0 * hf1 * hf1) / 2.0;
                    if (wf == 0.0) {
                        d = -d;
                    }
                    this.m_adjusted_wf = Util.relativeToShort(0.5 + d);
                }
                return;
            }
            case 23: {
                if (hf == 0.0 || wf == 0.0) {
                    return;
                }
                if (hf == 1.0) {
                    if (wf < 0.375) {
                        return;
                    }
                    if (wf < 0.6666666666666666) {
                        x1 = 0.375;
                        y1 = 0.965;
                        x2 = 0.6666666666666666;
                        y2 = 0.8;
                    } else {
                        x1 = 0.6666666666666666;
                        y1 = 0.8;
                        x2 = 1.0;
                        y2 = y1;
                    }
                    correct_y = true;
                    break;
                }
                if (wf != 1.0) break;
                if (hf < 0.8) {
                    return;
                }
                x1 = 0.375;
                y1 = 0.965;
                x2 = 0.6666666666666666;
                y2 = 0.8;
                correct_x = true;
                break;
            }
            case 9: {
                if (hf == 0.0 || hf == 1.0) {
                    switch (direction) {
                        case 0: {
                            if (hf == 1.0) {
                                return;
                            }
                            x1 = wf < 0.5 ? 0.0 : 1.0;
                            y1 = 1.0;
                            x2 = 0.5;
                            y2 = 0.0;
                            break;
                        }
                        case 1: {
                            x1 = 0.0;
                            y1 = hf == 0.0 ? 0.0 : 1.0;
                            x2 = 1.0;
                            y2 = 0.5;
                            break;
                        }
                        case 2: {
                            if (hf == 0.0) {
                                return;
                            }
                            x1 = wf < 0.5 ? 0.0 : 1.0;
                            y1 = 0.0;
                            x2 = 0.5;
                            y2 = 1.0;
                            break;
                        }
                        case 3: {
                            x1 = 1.0;
                            y1 = hf == 0.0 ? 0.0 : 1.0;
                            x2 = 0.0;
                            y2 = 0.5;
                        }
                    }
                    correct_y = true;
                    break;
                }
                if (wf != 0.0 && wf != 1.0) break;
                switch (direction) {
                    case 0: {
                        x1 = wf == 0.0 ? 0.0 : 1.0;
                        y1 = 1.0;
                        x2 = 0.5;
                        y2 = 0.0;
                        break;
                    }
                    case 1: {
                        if (wf == 0.0) {
                            return;
                        }
                        x1 = 0.0;
                        y1 = hf < 0.5 ? 0.0 : 1.0;
                        x2 = 1.0;
                        y2 = 0.5;
                        break;
                    }
                    case 2: {
                        x1 = wf == 0.0 ? 0.0 : 1.0;
                        y1 = 0.0;
                        x2 = 0.5;
                        y2 = 1.0;
                        break;
                    }
                    case 3: {
                        if (wf == 1.0) {
                            return;
                        }
                        x1 = 1.0;
                        y1 = hf < 0.5 ? 0.0 : 1.0;
                        x2 = 0.0;
                        y2 = 0.5;
                    }
                }
                correct_x = true;
                break;
            }
            case 10: {
                if (hf == 0.0 || hf == 1.0) {
                    switch (direction) {
                        case 0: {
                            if (hf == 0.0 ? wf > 0.2 : wf < 0.8) {
                                return;
                            }
                            x1 = 0.0;
                            y1 = 1.0;
                            x2 = 0.2;
                            y2 = 0.0;
                            if (hf == 0.0) break;
                            x1 += 0.8;
                            x2 += 0.8;
                            break;
                        }
                        case 1: {
                            x1 = 0.0;
                            y1 = 0.0;
                            x2 = 1.0;
                            y2 = 0.2;
                            if (hf == 0.0) break;
                            y1 += 0.8;
                            y2 += 0.8;
                            break;
                        }
                        case 2: {
                            if (hf == 0.0 ? wf < 0.8 : wf > 0.2) {
                                return;
                            }
                            x1 = 0.0;
                            y1 = 0.0;
                            x2 = 0.2;
                            y2 = 1.0;
                            if (hf != 0.0) break;
                            x1 += 0.8;
                            x2 += 0.8;
                            break;
                        }
                        case 3: {
                            x1 = 0.0;
                            y1 = 0.2;
                            x2 = 1.0;
                            y2 = 0.0;
                            if (hf == 0.0) break;
                            y1 += 0.8;
                            y2 += 0.8;
                        }
                    }
                    correct_y = true;
                    break;
                }
                if (wf != 0.0 && wf != 1.0) break;
                switch (direction) {
                    case 0: {
                        x1 = 0.2;
                        y1 = 0.0;
                        x2 = 0.0;
                        y2 = 1.0;
                        if (wf == 0.0) break;
                        x1 += 0.8;
                        x2 += 0.8;
                        break;
                    }
                    case 1: {
                        if (wf == 0.0 ? hf < 0.8 : hf > 0.2) {
                            return;
                        }
                        x1 = 0.0;
                        y1 = 0.0;
                        x2 = 1.0;
                        y2 = 0.2;
                        if (wf != 0.0) break;
                        y1 += 0.8;
                        y2 += 0.8;
                        break;
                    }
                    case 2: {
                        x1 = 0.0;
                        y1 = 0.0;
                        x2 = 0.2;
                        y2 = 1.0;
                        if (wf == 0.0) break;
                        x1 += 0.8;
                        x2 += 0.8;
                        break;
                    }
                    case 3: {
                        if (wf == 0.0 ? hf > 0.2 : hf < 0.8) {
                            return;
                        }
                        x1 = 0.0;
                        y1 = 0.2;
                        x2 = 1.0;
                        y2 = 0.0;
                        if (wf == 0.0) break;
                        y1 += 0.8;
                        y2 += 0.8;
                    }
                }
                correct_x = true;
                break;
            }
            case 11: {
                if (hf == 0.0 || hf == 1.0) {
                    switch (direction) {
                        case 0: {
                            if (hf == 1.0) {
                                return;
                            }
                            if (wf < 0.2) {
                                x1 = 0.0;
                                x2 = 0.2;
                            } else if (wf > 0.8) {
                                x1 = 1.0;
                                x2 = 0.8;
                            } else {
                                return;
                            }
                            y1 = 1.0;
                            y2 = 0.0;
                            break;
                        }
                        case 1: {
                            x1 = 0.0;
                            x2 = 1.0;
                            if (hf == 0.0) {
                                y1 = 0.0;
                                y2 = 0.2;
                                break;
                            }
                            y1 = 1.0;
                            y2 = 0.8;
                            break;
                        }
                        case 2: {
                            if (hf == 0.0) {
                                return;
                            }
                            if (wf < 0.2) {
                                x1 = 0.0;
                                x2 = 0.2;
                            } else if (wf > 0.8) {
                                x1 = 1.0;
                                x2 = 0.8;
                            } else {
                                return;
                            }
                            y1 = 0.0;
                            y2 = 1.0;
                            break;
                        }
                        case 3: {
                            x1 = 0.0;
                            x2 = 1.0;
                            if (hf == 0.0) {
                                y1 = 0.2;
                                y2 = 0.0;
                                break;
                            }
                            y1 = 0.8;
                            y2 = 1.0;
                        }
                    }
                    correct_y = true;
                    break;
                }
                if (wf != 0.0 && wf != 1.0) break;
                switch (direction) {
                    case 0: {
                        y1 = 0.0;
                        y2 = 1.0;
                        if (wf == 0.0) {
                            x1 = 0.2;
                            x2 = 0.0;
                            break;
                        }
                        x1 = 0.8;
                        x2 = 1.0;
                        break;
                    }
                    case 1: {
                        if (wf == 0.0) {
                            return;
                        }
                        if (hf < 0.2) {
                            y1 = 0.0;
                            y2 = 0.2;
                        } else if (hf > 0.8) {
                            y1 = 1.0;
                            y2 = 0.8;
                        } else {
                            return;
                        }
                        x1 = 0.0;
                        x2 = 1.0;
                        break;
                    }
                    case 2: {
                        y1 = 0.0;
                        y2 = 1.0;
                        if (wf == 0.0) {
                            x1 = 0.0;
                            x2 = 0.2;
                            break;
                        }
                        x1 = 1.0;
                        x2 = 0.8;
                        break;
                    }
                    case 3: {
                        if (hf < 0.2) {
                            y1 = 0.2;
                            y2 = 0.0;
                        } else if (hf > 0.8) {
                            y1 = 0.8;
                            y2 = 1.0;
                        } else {
                            return;
                        }
                        x1 = 0.0;
                        x2 = 1.0;
                    }
                }
                correct_x = true;
                break;
            }
            case 12: {
                regular_dimension = 3;
                break;
            }
            case 13: {
                regular_dimension = 4;
                break;
            }
            case 14: {
                regular_dimension = 5;
                break;
            }
            case 15: {
                regular_dimension = 6;
                break;
            }
            case 16: {
                regular_dimension = 8;
                break;
            }
            case 17: {
                regular_dimension = 10;
                break;
            }
            case 18: {
                regular_dimension = 12;
                break;
            }
            case 19: {
                regular_dimension = 14;
                break;
            }
            case 20: {
                regular_dimension = 16;
                break;
            }
            case 21: {
                regular_dimension = 18;
                break;
            }
            case 22: {
                regular_dimension = 20;
                break;
            }
            default: {
                return;
            }
        }
        if (regular_dimension != 0) {
            double wf1 = wf - 0.5;
            double hf1 = hf - 0.5;
            double myangle = Util.degrees(wf1, hf1);
            double angle = ec.getAngle() - 90.0;
            double shift = 360.0 / (double)regular_dimension;
            while (angle >= 360.0) {
                angle -= 360.0;
            }
            if (angle < 0.0) {
                angle += 360.0;
            }
            int i = 0;
            while (i <= regular_dimension) {
                double last_angle = angle;
                if ((angle -= shift) < 0.0) {
                    angle += 360.0;
                }
                if ((diff = angle - myangle) < 0.0) {
                    diff = -diff;
                }
                if (diff > 180.0) {
                    diff = 360.0 - diff;
                }
                if (!(diff > shift)) {
                    diff = last_angle - myangle;
                    if (diff < 0.0) {
                        diff = -diff;
                    }
                    if (diff > 180.0) {
                        diff = 360.0 - diff;
                    }
                    if (!(diff > shift)) {
                        double y;
                        double x;
                        angle = Math.toRadians(angle);
                        last_angle = Math.toRadians(last_angle);
                        x1 = Math.cos(angle) * 0.5;
                        y1 = Math.sin(angle) * 0.5;
                        x2 = Math.cos(last_angle) * 0.5;
                        y2 = Math.sin(last_angle) * 0.5;
                        if (myangle == 90.0 || myangle == 270.0) {
                            if (x1 != x2) {
                                x = 0.0;
                                y = y1 - x1 * (y2 - y1) / (x2 - x1);
                            } else {
                                if (x1 != 0.0) {
                                    return;
                                }
                                x = 0.0;
                                y = 0.0;
                            }
                        } else {
                            double tana = Math.tan(Math.toRadians(myangle));
                            if (x1 != x2) {
                                diff = y2 - y1 + (x1 - x2) * tana;
                                if (diff == 0.0) {
                                    return;
                                }
                                x = (x1 * y2 - y1 * x2) / diff;
                            } else {
                                x = x1;
                            }
                            y = x * tana;
                        }
                        this.m_adjusted_wf = Util.relativeToShort(x + 0.5);
                        this.m_adjusted_hf = Util.relativeToShort(y + 0.5);
                        return;
                    }
                }
                ++i;
            }
        }
        if (correct_y) {
            diff = x1 - x2;
            if (diff == 0.0) {
                return;
            }
            this.m_adjusted_hf = Util.relativeToShort(((x1 - wf) * y2 - (x2 - wf) * y1) / diff);
        }
        if (correct_x) {
            diff = y1 - y2;
            if (diff == 0.0) {
                return;
            }
            this.m_adjusted_wf = Util.relativeToShort(((y1 - hf) * x2 - (y2 - hf) * x1) / diff);
        }
    }

    public void setFactors(EntityClass ec, short wf, short hf) {
        this.m_wf = wf;
        this.m_hf = hf;
        this.adjustEdgePoint(ec);
    }

    public void setFactors(EntityClass ec, double wf, double hf) {
        this.m_wf = Util.relativeToShort(wf);
        this.m_hf = Util.relativeToShort(hf);
        this.adjustEdgePoint(ec);
    }

    public void setFactors(EntityClass ec, RelationClass rc, int side) {
        short f = rc.getIOfactor();
        short wf = -32767;
        short hf = -32767;
        switch (side) {
            case 0: {
                wf = f;
                break;
            }
            case 1: {
                wf = f;
                hf = Short.MAX_VALUE;
                break;
            }
            case 2: {
                hf = f;
                break;
            }
            default: {
                wf = Short.MAX_VALUE;
                hf = f;
            }
        }
        this.setFactors(ec, wf, hf);
    }

    public boolean isDefault(RelationClass rc) {
        short f = rc.getIOfactor();
        short wf = this.m_wf;
        short hf = this.m_hf;
        return wf == -32767 || wf == Short.MAX_VALUE ? hf == f : (hf == -32767 || hf == Short.MAX_VALUE) && wf == f;
    }

    public String getString(RelationClass rc) {
        return "(" + rc.getId() + " " + this.m_wf + " " + this.m_hf + ") ";
    }

    private String EdgeSide() {
        short wf = this.m_wf;
        short hf = this.m_hf;
        if (hf == -32767) {
            if (wf == -32767) {
                return "TOP LEFT";
            }
            if (wf == Short.MAX_VALUE) {
                return "TOP RIGHT";
            }
            return "TOP";
        }
        if (hf == Short.MAX_VALUE) {
            if (wf == -32767) {
                return "BOTTOM LEFT";
            }
            if (wf == Short.MAX_VALUE) {
                return "BOTTOM RIGHT";
            }
            return "BOTTOM";
        }
        if (wf == -32767) {
            return "LEFT";
        }
        if (wf == Short.MAX_VALUE) {
            return "RIGHT";
        }
        return "EDGE POINT";
    }

    public String toString() {
        String ret = String.valueOf(this.EdgeSide()) + " (" + this.m_wf;
        if (this.m_wf != this.m_adjusted_wf) {
            ret = String.valueOf(ret) + "->" + this.m_adjusted_wf;
        }
        ret = String.valueOf(ret) + ", " + this.m_hf;
        if (this.m_hf != this.m_adjusted_hf) {
            ret = String.valueOf(ret) + "->" + this.m_adjusted_hf;
        }
        ret = String.valueOf(ret) + ")";
        return ret;
    }
}

