/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import lsedit.Diagram;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

class DeleteRelationClass
implements ActionListener {
    private LandscapeEditorCore m_ls;
    private RelationClass m_rc;

    public DeleteRelationClass(LandscapeEditorCore ls, RelationClass rc) {
        this.m_ls = ls;
        this.m_rc = rc;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        LandscapeEditorCore ls = this.m_ls;
        if ((ev.getModifiers() & 4) != 0 && ls.processMetaKeyEvent("Delete Relation Class")) {
            return;
        }
        RelationClass rc = this.m_rc;
        Diagram diagram = ls.getDiagram();
        String message = null;
        Enumeration en = diagram.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc1 = (RelationClass)en.nextElement();
            if (rc == rc1 || !rc1.directlyInheritsFrom(rc)) continue;
            message = message != null ? String.valueOf(message) + ", " : "";
            message = String.valueOf(message) + rc1.getLabel();
        }
        if (message != null) {
            message = String.valueOf(message) + " inherit from " + rc.getLabel();
        } else {
            diagram.recomputeCounts();
            int cnt = rc.countMembers();
            if (cnt != 0) {
                message = String.valueOf(rc.getLabel()) + " has " + cnt + " instantiations";
            }
        }
        if (message != null) {
            JOptionPane.showConfirmDialog(null, message, "Can't delete relation class", -1);
            return;
        }
        switch (JOptionPane.showConfirmDialog(null, "Delete class " + rc.getLabel(), "Delete all " + rc.getLabel() + " edges", 1)) {
            case 0: {
                diagram.doUpdateRemoveRelationClass(rc);
                break;
            }
            case 1: {
                return;
            }
            default: {
                return;
            }
        }
    }
}

